// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.quicksight.model.*
import aws.sdk.kotlin.services.quicksight.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "QuickSight"
public const val ServiceApiVersion: String = "2018-04-01"
public const val SdkVersion: String = "0.17.7-beta"

internal class DefaultQuickSightClient(override val config: QuickSightClient.Config) : QuickSightClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Cancels an ongoing ingestion of data into SPICE.
     */
    override suspend fun cancelIngestion(input: CancelIngestionRequest): CancelIngestionResponse {
        val op = SdkHttpOperation.build<CancelIngestionRequest, CancelIngestionResponse> {
            serializer = CancelIngestionOperationSerializer()
            deserializer = CancelIngestionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelIngestion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a custom default theme by using the `CreateAccountCustomization` or `UpdateAccountCustomization` API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see [Customizing Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html) in the *Amazon QuickSight User Guide.*
     *
     * You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
     *
     * Before you use the `CreateAccountCustomization` API operation to add a theme as the namespace default, make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the current permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> ` API operation. To share the theme, grant permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> ` API operation.
     */
    override suspend fun createAccountCustomization(input: CreateAccountCustomizationRequest): CreateAccountCustomizationResponse {
        val op = SdkHttpOperation.build<CreateAccountCustomizationRequest, CreateAccountCustomizationResponse> {
            serializer = CreateAccountCustomizationOperationSerializer()
            deserializer = CreateAccountCustomizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAccountCustomization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.
     *
     * The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK. This operation isn't supported in the US East (Ohio) Region, South America (Sao Paulo) Region, or Asia Pacific (Singapore) Region.
     *
     * Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you don't have an Amazon Web Services account, see [Sign up for Amazon Web Services](https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html) in the *Amazon QuickSight User Guide*. The person who signs up for Amazon QuickSight needs to have the correct Identity and Access Management (IAM) permissions. For more information, see [IAM Policy Examples for Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html) in the *Amazon QuickSight User Guide*.
     *
     * If your IAM policy includes both the `Subscribe` and `CreateAccountSubscription` actions, make sure that both actions are set to `Allow`. If either action is set to `Deny`, the `Deny` action prevails and your API call fails.
     *
     * You can't pass an existing IAM role to access other Amazon Web Services services using this API operation. To pass your existing IAM role to Amazon QuickSight, see [Passing IAM roles to Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role) in the *Amazon QuickSight User Guide*.
     *
     * You can't set default resource access on the new account from the Amazon QuickSight API. Instead, add default resource access from the Amazon QuickSight console. For more information about setting default resource access to Amazon Web Services services, see [Setting default resource access to Amazon Web Services services](https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html) in the *Amazon QuickSight User Guide*.
     */
    override suspend fun createAccountSubscription(input: CreateAccountSubscriptionRequest): CreateAccountSubscriptionResponse {
        val op = SdkHttpOperation.build<CreateAccountSubscriptionRequest, CreateAccountSubscriptionResponse> {
            serializer = CreateAccountSubscriptionOperationSerializer()
            deserializer = CreateAccountSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAccountSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an analysis in Amazon QuickSight.
     */
    override suspend fun createAnalysis(input: CreateAnalysisRequest): CreateAnalysisResponse {
        val op = SdkHttpOperation.build<CreateAnalysisRequest, CreateAnalysisResponse> {
            serializer = CreateAnalysisOperationSerializer()
            deserializer = CreateAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a dashboard from a template. To first create a template, see the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> ` API operation.
     *
     * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different Amazon Web Services account.
     */
    override suspend fun createDashboard(input: CreateDashboardRequest): CreateDashboardResponse {
        val op = SdkHttpOperation.build<CreateDashboardRequest, CreateDashboardResponse> {
            serializer = CreateDashboardOperationSerializer()
            deserializer = CreateDashboardOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDashboard"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
     */
    override suspend fun createDataSet(input: CreateDataSetRequest): CreateDataSetResponse {
        val op = SdkHttpOperation.build<CreateDataSetRequest, CreateDataSetResponse> {
            serializer = CreateDataSetOperationSerializer()
            deserializer = CreateDataSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDataSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a data source.
     */
    override suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse {
        val op = SdkHttpOperation.build<CreateDataSourceRequest, CreateDataSourceResponse> {
            serializer = CreateDataSourceOperationSerializer()
            deserializer = CreateDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an empty shared folder.
     */
    override suspend fun createFolder(input: CreateFolderRequest): CreateFolderResponse {
        val op = SdkHttpOperation.build<CreateFolderRequest, CreateFolderResponse> {
            serializer = CreateFolderOperationSerializer()
            deserializer = CreateFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds an asset, such as a dashboard, analysis, or dataset into a folder.
     */
    override suspend fun createFolderMembership(input: CreateFolderMembershipRequest): CreateFolderMembershipResponse {
        val op = SdkHttpOperation.build<CreateFolderMembershipRequest, CreateFolderMembershipResponse> {
            serializer = CreateFolderMembershipOperationSerializer()
            deserializer = CreateFolderMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFolderMembership"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use the `CreateGroup` operation to create a group in Amazon QuickSight. You can create up to 10,000 groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact AWS Support.
     *
     * The permissions resource is `arn:aws:quicksight:<your-region>:<i><relevant-aws-account-id></i>:group/default/<i><group-name></i> `.
     *
     * The response is a group object.
     */
    override suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse {
        val op = SdkHttpOperation.build<CreateGroupRequest, CreateGroupResponse> {
            serializer = CreateGroupOperationSerializer()
            deserializer = CreateGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     */
    override suspend fun createGroupMembership(input: CreateGroupMembershipRequest): CreateGroupMembershipResponse {
        val op = SdkHttpOperation.build<CreateGroupMembershipRequest, CreateGroupMembershipResponse> {
            serializer = CreateGroupMembershipOperationSerializer()
            deserializer = CreateGroupMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateGroupMembership"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.
     */
    override suspend fun createIamPolicyAssignment(input: CreateIamPolicyAssignmentRequest): CreateIamPolicyAssignmentResponse {
        val op = SdkHttpOperation.build<CreateIamPolicyAssignmentRequest, CreateIamPolicyAssignmentResponse> {
            serializer = CreateIAMPolicyAssignmentOperationSerializer()
            deserializer = CreateIAMPolicyAssignmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIAMPolicyAssignment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8 times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
     *
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see [How do I create an IAM policy to control access to Amazon EC2 resources using tags?](http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/) in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.
     */
    override suspend fun createIngestion(input: CreateIngestionRequest): CreateIngestionResponse {
        val op = SdkHttpOperation.build<CreateIngestionRequest, CreateIngestionResponse> {
            serializer = CreateIngestionOperationSerializer()
            deserializer = CreateIngestionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateIngestion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
     *
     * A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with Amazon Web Services Support.
     */
    override suspend fun createNamespace(input: CreateNamespaceRequest): CreateNamespaceResponse {
        val op = SdkHttpOperation.build<CreateNamespaceRequest, CreateNamespaceResponse> {
            serializer = CreateNamespaceOperationSerializer()
            deserializer = CreateNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to create a dashboard.
     *
     * A *template* is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.
     */
    override suspend fun createTemplate(input: CreateTemplateRequest): CreateTemplateResponse {
        val op = SdkHttpOperation.build<CreateTemplateRequest, CreateTemplateResponse> {
            serializer = CreateTemplateOperationSerializer()
            deserializer = CreateTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a template alias for a template.
     */
    override suspend fun createTemplateAlias(input: CreateTemplateAliasRequest): CreateTemplateAliasResponse {
        val op = SdkHttpOperation.build<CreateTemplateAliasRequest, CreateTemplateAliasResponse> {
            serializer = CreateTemplateAliasOperationSerializer()
            deserializer = CreateTemplateAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTemplateAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a theme.
     *
     * A *theme* is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see [Using Themes in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html) in the *Amazon QuickSight User Guide*.
     */
    override suspend fun createTheme(input: CreateThemeRequest): CreateThemeResponse {
        val op = SdkHttpOperation.build<CreateThemeRequest, CreateThemeResponse> {
            serializer = CreateThemeOperationSerializer()
            deserializer = CreateThemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateTheme"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a theme alias for a theme.
     */
    override suspend fun createThemeAlias(input: CreateThemeAliasRequest): CreateThemeAliasResponse {
        val op = SdkHttpOperation.build<CreateThemeAliasRequest, CreateThemeAliasResponse> {
            serializer = CreateThemeAliasOperationSerializer()
            deserializer = CreateThemeAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateThemeAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web Services account and Amazon QuickSight namespace.
     */
    override suspend fun deleteAccountCustomization(input: DeleteAccountCustomizationRequest): DeleteAccountCustomizationResponse {
        val op = SdkHttpOperation.build<DeleteAccountCustomizationRequest, DeleteAccountCustomizationResponse> {
            serializer = DeleteAccountCustomizationOperationSerializer()
            deserializer = DeleteAccountCustomizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAccountCustomization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon QuickSight attaches a `DeletionTime` stamp to the response that specifies the end of the recovery window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.
     *
     * At any time before recovery window ends, you can use the `RestoreAnalysis` API operation to remove the `DeletionTime` stamp and cancel the deletion of the analysis. The analysis remains visible in the API until it's deleted, so you can describe it but you can't make a template from it.
     *
     * An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console. To access it in the console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
     */
    override suspend fun deleteAnalysis(input: DeleteAnalysisRequest): DeleteAnalysisResponse {
        val op = SdkHttpOperation.build<DeleteAnalysisRequest, DeleteAnalysisResponse> {
            serializer = DeleteAnalysisOperationSerializer()
            deserializer = DeleteAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a dashboard.
     */
    override suspend fun deleteDashboard(input: DeleteDashboardRequest): DeleteDashboardResponse {
        val op = SdkHttpOperation.build<DeleteDashboardRequest, DeleteDashboardResponse> {
            serializer = DeleteDashboardOperationSerializer()
            deserializer = DeleteDashboardOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDashboard"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a dataset.
     */
    override suspend fun deleteDataSet(input: DeleteDataSetRequest): DeleteDataSetResponse {
        val op = SdkHttpOperation.build<DeleteDataSetRequest, DeleteDataSetResponse> {
            serializer = DeleteDataSetOperationSerializer()
            deserializer = DeleteDataSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDataSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.
     */
    override suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse {
        val op = SdkHttpOperation.build<DeleteDataSourceRequest, DeleteDataSourceResponse> {
            serializer = DeleteDataSourceOperationSerializer()
            deserializer = DeleteDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an empty folder.
     */
    override suspend fun deleteFolder(input: DeleteFolderRequest): DeleteFolderResponse {
        val op = SdkHttpOperation.build<DeleteFolderRequest, DeleteFolderResponse> {
            serializer = DeleteFolderOperationSerializer()
            deserializer = DeleteFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
     */
    override suspend fun deleteFolderMembership(input: DeleteFolderMembershipRequest): DeleteFolderMembershipResponse {
        val op = SdkHttpOperation.build<DeleteFolderMembershipRequest, DeleteFolderMembershipResponse> {
            serializer = DeleteFolderMembershipOperationSerializer()
            deserializer = DeleteFolderMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFolderMembership"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a user group from Amazon QuickSight.
     */
    override suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse {
        val op = SdkHttpOperation.build<DeleteGroupRequest, DeleteGroupResponse> {
            serializer = DeleteGroupOperationSerializer()
            deserializer = DeleteGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a user from a group so that the user is no longer a member of the group.
     */
    override suspend fun deleteGroupMembership(input: DeleteGroupMembershipRequest): DeleteGroupMembershipResponse {
        val op = SdkHttpOperation.build<DeleteGroupMembershipRequest, DeleteGroupMembershipResponse> {
            serializer = DeleteGroupMembershipOperationSerializer()
            deserializer = DeleteGroupMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteGroupMembership"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing IAM policy assignment.
     */
    override suspend fun deleteIamPolicyAssignment(input: DeleteIamPolicyAssignmentRequest): DeleteIamPolicyAssignmentResponse {
        val op = SdkHttpOperation.build<DeleteIamPolicyAssignmentRequest, DeleteIamPolicyAssignmentResponse> {
            serializer = DeleteIAMPolicyAssignmentOperationSerializer()
            deserializer = DeleteIAMPolicyAssignmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteIAMPolicyAssignment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset.
     */
    override suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse {
        val op = SdkHttpOperation.build<DeleteNamespaceRequest, DeleteNamespaceResponse> {
            serializer = DeleteNamespaceOperationSerializer()
            deserializer = DeleteNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a template.
     */
    override suspend fun deleteTemplate(input: DeleteTemplateRequest): DeleteTemplateResponse {
        val op = SdkHttpOperation.build<DeleteTemplateRequest, DeleteTemplateResponse> {
            serializer = DeleteTemplateOperationSerializer()
            deserializer = DeleteTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.
     */
    override suspend fun deleteTemplateAlias(input: DeleteTemplateAliasRequest): DeleteTemplateAliasResponse {
        val op = SdkHttpOperation.build<DeleteTemplateAliasRequest, DeleteTemplateAliasResponse> {
            serializer = DeleteTemplateAliasOperationSerializer()
            deserializer = DeleteTemplateAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTemplateAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a theme.
     */
    override suspend fun deleteTheme(input: DeleteThemeRequest): DeleteThemeResponse {
        val op = SdkHttpOperation.build<DeleteThemeRequest, DeleteThemeResponse> {
            serializer = DeleteThemeOperationSerializer()
            deserializer = DeleteThemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteTheme"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.
     */
    override suspend fun deleteThemeAlias(input: DeleteThemeAliasRequest): DeleteThemeAliasResponse {
        val op = SdkHttpOperation.build<DeleteThemeAliasRequest, DeleteThemeAliasResponse> {
            serializer = DeleteThemeAliasOperationSerializer()
            deserializer = DeleteThemeAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteThemeAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the Amazon QuickSight user that is associated with the identity of the Identity and Access Management (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     */
    override suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse {
        val op = SdkHttpOperation.build<DeleteUserRequest, DeleteUserResponse> {
            serializer = DeleteUserOperationSerializer()
            deserializer = DeleteUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a user identified by its principal ID.
     */
    override suspend fun deleteUserByPrincipalId(input: DeleteUserByPrincipalIdRequest): DeleteUserByPrincipalIdResponse {
        val op = SdkHttpOperation.build<DeleteUserByPrincipalIdRequest, DeleteUserByPrincipalIdResponse> {
            serializer = DeleteUserByPrincipalIdOperationSerializer()
            deserializer = DeleteUserByPrincipalIdOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteUserByPrincipalId"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the `Resolved` flag included.
     *
     * To determine what customizations display when you run this command, it can help to visualize the relationship of the entities involved.
     * + `Amazon Web Services account` - The Amazon Web Services account exists at the top of the hierarchy. It has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That's where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services Region.
     * + `Amazon Web Services Region` - In each Amazon Web Services Region where you sign in to Amazon QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace. To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using the CLI, you can use one of the following options:
     *    + Use [command line options](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html).
     *    + Use [named profiles](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html).
     *    + Run `aws configure` to change your default Amazon Web Services Region. Use Enter to key the same settings for your keys. For more information, see [Configuring the CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html).
     * + `Namespace` - A QuickSight namespace is a partition that contains users and assets (data sources, datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also be part of the same namespace. People who share a namespace are completely isolated from users and assets in other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.
     * + `Applied customizations` - Within an Amazon Web Services Region, a set of Amazon QuickSight customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the `CreateAccountCustomization` command in each Amazon Web Services Region where you want to apply the same customizations.
     */
    override suspend fun describeAccountCustomization(input: DescribeAccountCustomizationRequest): DescribeAccountCustomizationResponse {
        val op = SdkHttpOperation.build<DescribeAccountCustomizationRequest, DescribeAccountCustomizationResponse> {
            serializer = DescribeAccountCustomizationOperationSerializer()
            deserializer = DescribeAccountCustomizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountCustomization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon Web Services account.
     */
    override suspend fun describeAccountSettings(input: DescribeAccountSettingsRequest): DescribeAccountSettingsResponse {
        val op = SdkHttpOperation.build<DescribeAccountSettingsRequest, DescribeAccountSettingsResponse> {
            serializer = DescribeAccountSettingsOperationSerializer()
            deserializer = DescribeAccountSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use the DescribeAccountSubscription operation to receive a description of a Amazon QuickSight account's subscription. A successful API call returns an `AccountInfo` object that includes an account's name, subscription status, authentication type, edition, and notification email address.
     */
    override suspend fun describeAccountSubscription(input: DescribeAccountSubscriptionRequest): DescribeAccountSubscriptionResponse {
        val op = SdkHttpOperation.build<DescribeAccountSubscriptionRequest, DescribeAccountSubscriptionResponse> {
            serializer = DescribeAccountSubscriptionOperationSerializer()
            deserializer = DescribeAccountSubscriptionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountSubscription"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a summary of the metadata for an analysis.
     */
    override suspend fun describeAnalysis(input: DescribeAnalysisRequest): DescribeAnalysisResponse {
        val op = SdkHttpOperation.build<DescribeAnalysisRequest, DescribeAnalysisResponse> {
            serializer = DescribeAnalysisOperationSerializer()
            deserializer = DescribeAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides the read and write permissions for an analysis.
     */
    override suspend fun describeAnalysisPermissions(input: DescribeAnalysisPermissionsRequest): DescribeAnalysisPermissionsResponse {
        val op = SdkHttpOperation.build<DescribeAnalysisPermissionsRequest, DescribeAnalysisPermissionsResponse> {
            serializer = DescribeAnalysisPermissionsOperationSerializer()
            deserializer = DescribeAnalysisPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAnalysisPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a summary for a dashboard.
     */
    override suspend fun describeDashboard(input: DescribeDashboardRequest): DescribeDashboardResponse {
        val op = SdkHttpOperation.build<DescribeDashboardRequest, DescribeDashboardResponse> {
            serializer = DescribeDashboardOperationSerializer()
            deserializer = DescribeDashboardOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDashboard"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes read and write permissions for a dashboard.
     */
    override suspend fun describeDashboardPermissions(input: DescribeDashboardPermissionsRequest): DescribeDashboardPermissionsResponse {
        val op = SdkHttpOperation.build<DescribeDashboardPermissionsRequest, DescribeDashboardPermissionsResponse> {
            serializer = DescribeDashboardPermissionsOperationSerializer()
            deserializer = DescribeDashboardPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDashboardPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
     */
    override suspend fun describeDataSet(input: DescribeDataSetRequest): DescribeDataSetResponse {
        val op = SdkHttpOperation.build<DescribeDataSetRequest, DescribeDataSetResponse> {
            serializer = DescribeDataSetOperationSerializer()
            deserializer = DescribeDataSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the permissions on a dataset.
     *
     * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
     */
    override suspend fun describeDataSetPermissions(input: DescribeDataSetPermissionsRequest): DescribeDataSetPermissionsResponse {
        val op = SdkHttpOperation.build<DescribeDataSetPermissionsRequest, DescribeDataSetPermissionsResponse> {
            serializer = DescribeDataSetPermissionsOperationSerializer()
            deserializer = DescribeDataSetPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataSetPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a data source.
     */
    override suspend fun describeDataSource(input: DescribeDataSourceRequest): DescribeDataSourceResponse {
        val op = SdkHttpOperation.build<DescribeDataSourceRequest, DescribeDataSourceResponse> {
            serializer = DescribeDataSourceOperationSerializer()
            deserializer = DescribeDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the resource permissions for a data source.
     */
    override suspend fun describeDataSourcePermissions(input: DescribeDataSourcePermissionsRequest): DescribeDataSourcePermissionsResponse {
        val op = SdkHttpOperation.build<DescribeDataSourcePermissionsRequest, DescribeDataSourcePermissionsResponse> {
            serializer = DescribeDataSourcePermissionsOperationSerializer()
            deserializer = DescribeDataSourcePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDataSourcePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a folder.
     */
    override suspend fun describeFolder(input: DescribeFolderRequest): DescribeFolderResponse {
        val op = SdkHttpOperation.build<DescribeFolderRequest, DescribeFolderResponse> {
            serializer = DescribeFolderOperationSerializer()
            deserializer = DescribeFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes permissions for a folder.
     */
    override suspend fun describeFolderPermissions(input: DescribeFolderPermissionsRequest): DescribeFolderPermissionsResponse {
        val op = SdkHttpOperation.build<DescribeFolderPermissionsRequest, DescribeFolderPermissionsResponse> {
            serializer = DescribeFolderPermissionsOperationSerializer()
            deserializer = DescribeFolderPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFolderPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.
     */
    override suspend fun describeFolderResolvedPermissions(input: DescribeFolderResolvedPermissionsRequest): DescribeFolderResolvedPermissionsResponse {
        val op = SdkHttpOperation.build<DescribeFolderResolvedPermissionsRequest, DescribeFolderResolvedPermissionsResponse> {
            serializer = DescribeFolderResolvedPermissionsOperationSerializer()
            deserializer = DescribeFolderResolvedPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFolderResolvedPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     */
    override suspend fun describeGroup(input: DescribeGroupRequest): DescribeGroupResponse {
        val op = SdkHttpOperation.build<DescribeGroupRequest, DescribeGroupResponse> {
            serializer = DescribeGroupOperationSerializer()
            deserializer = DescribeGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use the `DescribeGroupMembership` operation to determine if a user is a member of the specified group. If the user exists and is a member of the specified group, an associated `GroupMember` object is returned.
     */
    override suspend fun describeGroupMembership(input: DescribeGroupMembershipRequest): DescribeGroupMembershipResponse {
        val op = SdkHttpOperation.build<DescribeGroupMembershipRequest, DescribeGroupMembershipResponse> {
            serializer = DescribeGroupMembershipOperationSerializer()
            deserializer = DescribeGroupMembershipOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeGroupMembership"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes an existing IAM policy assignment, as specified by the assignment name.
     */
    override suspend fun describeIamPolicyAssignment(input: DescribeIamPolicyAssignmentRequest): DescribeIamPolicyAssignmentResponse {
        val op = SdkHttpOperation.build<DescribeIamPolicyAssignmentRequest, DescribeIamPolicyAssignmentResponse> {
            serializer = DescribeIAMPolicyAssignmentOperationSerializer()
            deserializer = DescribeIAMPolicyAssignmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIAMPolicyAssignment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a SPICE ingestion.
     */
    override suspend fun describeIngestion(input: DescribeIngestionRequest): DescribeIngestionResponse {
        val op = SdkHttpOperation.build<DescribeIngestionRequest, DescribeIngestionResponse> {
            serializer = DescribeIngestionOperationSerializer()
            deserializer = DescribeIngestionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIngestion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides a summary and status of IP rules.
     */
    override suspend fun describeIpRestriction(input: DescribeIpRestrictionRequest): DescribeIpRestrictionResponse {
        val op = SdkHttpOperation.build<DescribeIpRestrictionRequest, DescribeIpRestrictionResponse> {
            serializer = DescribeIpRestrictionOperationSerializer()
            deserializer = DescribeIpRestrictionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeIpRestriction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the current namespace.
     */
    override suspend fun describeNamespace(input: DescribeNamespaceRequest): DescribeNamespaceResponse {
        val op = SdkHttpOperation.build<DescribeNamespaceRequest, DescribeNamespaceResponse> {
            serializer = DescribeNamespaceOperationSerializer()
            deserializer = DescribeNamespaceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNamespace"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a template's metadata.
     */
    override suspend fun describeTemplate(input: DescribeTemplateRequest): DescribeTemplateResponse {
        val op = SdkHttpOperation.build<DescribeTemplateRequest, DescribeTemplateResponse> {
            serializer = DescribeTemplateOperationSerializer()
            deserializer = DescribeTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the template alias for a template.
     */
    override suspend fun describeTemplateAlias(input: DescribeTemplateAliasRequest): DescribeTemplateAliasResponse {
        val op = SdkHttpOperation.build<DescribeTemplateAliasRequest, DescribeTemplateAliasResponse> {
            serializer = DescribeTemplateAliasOperationSerializer()
            deserializer = DescribeTemplateAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTemplateAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes read and write permissions on a template.
     */
    override suspend fun describeTemplatePermissions(input: DescribeTemplatePermissionsRequest): DescribeTemplatePermissionsResponse {
        val op = SdkHttpOperation.build<DescribeTemplatePermissionsRequest, DescribeTemplatePermissionsResponse> {
            serializer = DescribeTemplatePermissionsOperationSerializer()
            deserializer = DescribeTemplatePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTemplatePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes a theme.
     */
    override suspend fun describeTheme(input: DescribeThemeRequest): DescribeThemeResponse {
        val op = SdkHttpOperation.build<DescribeThemeRequest, DescribeThemeResponse> {
            serializer = DescribeThemeOperationSerializer()
            deserializer = DescribeThemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTheme"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the alias for a theme.
     */
    override suspend fun describeThemeAlias(input: DescribeThemeAliasRequest): DescribeThemeAliasResponse {
        val op = SdkHttpOperation.build<DescribeThemeAliasRequest, DescribeThemeAliasResponse> {
            serializer = DescribeThemeAliasOperationSerializer()
            deserializer = DescribeThemeAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeThemeAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the read and write permissions for a theme.
     */
    override suspend fun describeThemePermissions(input: DescribeThemePermissionsRequest): DescribeThemePermissionsResponse {
        val op = SdkHttpOperation.build<DescribeThemePermissionsRequest, DescribeThemePermissionsResponse> {
            serializer = DescribeThemePermissionsOperationSerializer()
            deserializer = DescribeThemePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeThemePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a user, given the user name.
     */
    override suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse {
        val op = SdkHttpOperation.build<DescribeUserRequest, DescribeUserResponse> {
            serializer = DescribeUserOperationSerializer()
            deserializer = DescribeUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Generates an embed URL that you can use to embed an Amazon QuickSight dashboard or visual in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.
     *
     * The following rules apply to the generated URL:
     * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
     * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter. The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
     * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     *
     * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    override suspend fun generateEmbedUrlForAnonymousUser(input: GenerateEmbedUrlForAnonymousUserRequest): GenerateEmbedUrlForAnonymousUserResponse {
        val op = SdkHttpOperation.build<GenerateEmbedUrlForAnonymousUserRequest, GenerateEmbedUrlForAnonymousUserResponse> {
            serializer = GenerateEmbedUrlForAnonymousUserOperationSerializer()
            deserializer = GenerateEmbedUrlForAnonymousUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GenerateEmbedUrlForAnonymousUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
     *
     * The following rules apply to the generated URL:
     * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
     * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter.The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
     * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     *
     * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    override suspend fun generateEmbedUrlForRegisteredUser(input: GenerateEmbedUrlForRegisteredUserRequest): GenerateEmbedUrlForRegisteredUserResponse {
        val op = SdkHttpOperation.build<GenerateEmbedUrlForRegisteredUserRequest, GenerateEmbedUrlForRegisteredUserResponse> {
            serializer = GenerateEmbedUrlForRegisteredUserOperationSerializer()
            deserializer = GenerateEmbedUrlForRegisteredUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GenerateEmbedUrlForRegisteredUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you have configured the dashboards and permissions.
     *
     * Currently, you can use `GetDashboardEmbedURL` only from the server, not from the user's browser. The following rules apply to the generated URL:
     * + They must be used together.
     * + They can be used one time only.
     * + They are valid for 5 minutes after you run this command.
     * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     * + The resulting user session is valid for 15 minutes (default) up to 10 hours (maximum). You can use the optional `SessionLifetimeInMinutes` parameter to customize session duration.
     *
     * For more information, see [Embedding Analytics Using GetDashboardEmbedUrl](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html) in the *Amazon QuickSight User Guide*.
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    override suspend fun getDashboardEmbedUrl(input: GetDashboardEmbedUrlRequest): GetDashboardEmbedUrlResponse {
        val op = SdkHttpOperation.build<GetDashboardEmbedUrlRequest, GetDashboardEmbedUrlResponse> {
            serializer = GetDashboardEmbedUrlOperationSerializer()
            deserializer = GetDashboardEmbedUrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDashboardEmbedUrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use `GetSessionEmbedUrl` where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> ` API operation. Use ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> ` API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the *Amazon QuickSight User Guide*:
     * + [Embedding Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
     * + [Customizing Access to the Amazon QuickSight Console](https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
     */
    override suspend fun getSessionEmbedUrl(input: GetSessionEmbedUrlRequest): GetSessionEmbedUrlResponse {
        val op = SdkHttpOperation.build<GetSessionEmbedUrlRequest, GetSessionEmbedUrlResponse> {
            serializer = GetSessionEmbedUrlOperationSerializer()
            deserializer = GetSessionEmbedUrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSessionEmbedUrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
     */
    override suspend fun listAnalyses(input: ListAnalysesRequest): ListAnalysesResponse {
        val op = SdkHttpOperation.build<ListAnalysesRequest, ListAnalysesResponse> {
            serializer = ListAnalysesOperationSerializer()
            deserializer = ListAnalysesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAnalyses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the versions of the dashboards in the Amazon QuickSight subscription.
     */
    override suspend fun listDashboardVersions(input: ListDashboardVersionsRequest): ListDashboardVersionsResponse {
        val op = SdkHttpOperation.build<ListDashboardVersionsRequest, ListDashboardVersionsResponse> {
            serializer = ListDashboardVersionsOperationSerializer()
            deserializer = ListDashboardVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDashboardVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists dashboards in an Amazon Web Services account.
     */
    override suspend fun listDashboards(input: ListDashboardsRequest): ListDashboardsResponse {
        val op = SdkHttpOperation.build<ListDashboardsRequest, ListDashboardsResponse> {
            serializer = ListDashboardsOperationSerializer()
            deserializer = ListDashboardsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDashboards"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
     *
     * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset&#47;*`.
     */
    override suspend fun listDataSets(input: ListDataSetsRequest): ListDataSetsResponse {
        val op = SdkHttpOperation.build<ListDataSetsRequest, ListDataSetsResponse> {
            serializer = ListDataSetsOperationSerializer()
            deserializer = ListDataSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataSets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
     */
    override suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse {
        val op = SdkHttpOperation.build<ListDataSourcesRequest, ListDataSourcesResponse> {
            serializer = ListDataSourcesOperationSerializer()
            deserializer = ListDataSourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDataSources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List all assets (`DASHBOARD`, `ANALYSIS`, and `DATASET`) in a folder.
     */
    override suspend fun listFolderMembers(input: ListFolderMembersRequest): ListFolderMembersResponse {
        val op = SdkHttpOperation.build<ListFolderMembersRequest, ListFolderMembersResponse> {
            serializer = ListFolderMembersOperationSerializer()
            deserializer = ListFolderMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFolderMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all folders in an account.
     */
    override suspend fun listFolders(input: ListFoldersRequest): ListFoldersResponse {
        val op = SdkHttpOperation.build<ListFoldersRequest, ListFoldersResponse> {
            serializer = ListFoldersOperationSerializer()
            deserializer = ListFoldersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFolders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists member users in a group.
     */
    override suspend fun listGroupMemberships(input: ListGroupMembershipsRequest): ListGroupMembershipsResponse {
        val op = SdkHttpOperation.build<ListGroupMembershipsRequest, ListGroupMembershipsResponse> {
            serializer = ListGroupMembershipsOperationSerializer()
            deserializer = ListGroupMembershipsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGroupMemberships"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all user groups in Amazon QuickSight.
     */
    override suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse {
        val op = SdkHttpOperation.build<ListGroupsRequest, ListGroupsResponse> {
            serializer = ListGroupsOperationSerializer()
            deserializer = ListGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists IAM policy assignments in the current Amazon QuickSight account.
     */
    override suspend fun listIamPolicyAssignments(input: ListIamPolicyAssignmentsRequest): ListIamPolicyAssignmentsResponse {
        val op = SdkHttpOperation.build<ListIamPolicyAssignmentsRequest, ListIamPolicyAssignmentsResponse> {
            serializer = ListIAMPolicyAssignmentsOperationSerializer()
            deserializer = ListIAMPolicyAssignmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIAMPolicyAssignments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to the specified user and group or groups that the user belongs to.
     */
    override suspend fun listIamPolicyAssignmentsForUser(input: ListIamPolicyAssignmentsForUserRequest): ListIamPolicyAssignmentsForUserResponse {
        val op = SdkHttpOperation.build<ListIamPolicyAssignmentsForUserRequest, ListIamPolicyAssignmentsForUserResponse> {
            serializer = ListIAMPolicyAssignmentsForUserOperationSerializer()
            deserializer = ListIAMPolicyAssignmentsForUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIAMPolicyAssignmentsForUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the history of SPICE ingestions for a dataset.
     */
    override suspend fun listIngestions(input: ListIngestionsRequest): ListIngestionsResponse {
        val op = SdkHttpOperation.build<ListIngestionsRequest, ListIngestionsResponse> {
            serializer = ListIngestionsOperationSerializer()
            deserializer = ListIngestionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListIngestions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted namespaces.
     */
    override suspend fun listNamespaces(input: ListNamespacesRequest): ListNamespacesResponse {
        val op = SdkHttpOperation.build<ListNamespacesRequest, ListNamespacesResponse> {
            serializer = ListNamespacesOperationSerializer()
            deserializer = ListNamespacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListNamespaces"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags assigned to a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the aliases of a template.
     */
    override suspend fun listTemplateAliases(input: ListTemplateAliasesRequest): ListTemplateAliasesResponse {
        val op = SdkHttpOperation.build<ListTemplateAliasesRequest, ListTemplateAliasesResponse> {
            serializer = ListTemplateAliasesOperationSerializer()
            deserializer = ListTemplateAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTemplateAliases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     */
    override suspend fun listTemplateVersions(input: ListTemplateVersionsRequest): ListTemplateVersionsResponse {
        val op = SdkHttpOperation.build<ListTemplateVersionsRequest, ListTemplateVersionsResponse> {
            serializer = ListTemplateVersionsOperationSerializer()
            deserializer = ListTemplateVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTemplateVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the templates in the current Amazon QuickSight account.
     */
    override suspend fun listTemplates(input: ListTemplatesRequest): ListTemplatesResponse {
        val op = SdkHttpOperation.build<ListTemplatesRequest, ListTemplatesResponse> {
            serializer = ListTemplatesOperationSerializer()
            deserializer = ListTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the aliases of a theme.
     */
    override suspend fun listThemeAliases(input: ListThemeAliasesRequest): ListThemeAliasesResponse {
        val op = SdkHttpOperation.build<ListThemeAliasesRequest, ListThemeAliasesResponse> {
            serializer = ListThemeAliasesOperationSerializer()
            deserializer = ListThemeAliasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThemeAliases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the versions of the themes in the current Amazon Web Services account.
     */
    override suspend fun listThemeVersions(input: ListThemeVersionsRequest): ListThemeVersionsResponse {
        val op = SdkHttpOperation.build<ListThemeVersionsRequest, ListThemeVersionsResponse> {
            serializer = ListThemeVersionsOperationSerializer()
            deserializer = ListThemeVersionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThemeVersions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the themes in the current Amazon Web Services account.
     */
    override suspend fun listThemes(input: ListThemesRequest): ListThemesResponse {
        val op = SdkHttpOperation.build<ListThemesRequest, ListThemesResponse> {
            serializer = ListThemesOperationSerializer()
            deserializer = ListThemesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThemes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
     */
    override suspend fun listUserGroups(input: ListUserGroupsRequest): ListUserGroupsResponse {
        val op = SdkHttpOperation.build<ListUserGroupsRequest, ListUserGroupsResponse> {
            serializer = ListUserGroupsOperationSerializer()
            deserializer = ListUserGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUserGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     */
    override suspend fun listUsers(input: ListUsersRequest): ListUsersResponse {
        val op = SdkHttpOperation.build<ListUsersRequest, ListUsersResponse> {
            serializer = ListUsersOperationSerializer()
            deserializer = ListUsersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListUsers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Amazon QuickSight user, whose identity is associated with the Identity and Access Management (IAM) identity or role specified in the request.
     */
    override suspend fun registerUser(input: RegisterUserRequest): RegisterUserResponse {
        val op = SdkHttpOperation.build<RegisterUserRequest, RegisterUserResponse> {
            serializer = RegisterUserOperationSerializer()
            deserializer = RegisterUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Restores an analysis.
     */
    override suspend fun restoreAnalysis(input: RestoreAnalysisRequest): RestoreAnalysisResponse {
        val op = SdkHttpOperation.build<RestoreAnalysisRequest, RestoreAnalysisResponse> {
            serializer = RestoreAnalysisOperationSerializer()
            deserializer = RestoreAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestoreAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for analyses that belong to the user specified in the filter.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    override suspend fun searchAnalyses(input: SearchAnalysesRequest): SearchAnalysesResponse {
        val op = SdkHttpOperation.build<SearchAnalysesRequest, SearchAnalysesResponse> {
            serializer = SearchAnalysesOperationSerializer()
            deserializer = SearchAnalysesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchAnalyses"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches for dashboards that belong to a user.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    override suspend fun searchDashboards(input: SearchDashboardsRequest): SearchDashboardsResponse {
        val op = SdkHttpOperation.build<SearchDashboardsRequest, SearchDashboardsResponse> {
            serializer = SearchDashboardsOperationSerializer()
            deserializer = SearchDashboardsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchDashboards"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Searches the subfolders in a folder.
     */
    override suspend fun searchFolders(input: SearchFoldersRequest): SearchFoldersResponse {
        val op = SdkHttpOperation.build<SearchFoldersRequest, SearchFoldersResponse> {
            serializer = SearchFoldersOperationSerializer()
            deserializer = SearchFoldersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchFolders"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use the `SearchGroups` operation to search groups in a specified Amazon QuickSight namespace using the supplied filters.
     */
    override suspend fun searchGroups(input: SearchGroupsRequest): SearchGroupsResponse {
        val op = SdkHttpOperation.build<SearchGroupsRequest, SearchGroupsResponse> {
            serializer = SearchGroupsOperationSerializer()
            deserializer = SearchGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the `TagResource` operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data source, dashboard, and template.
     *
     * Tagging for Amazon QuickSight works in a similar way to tagging for other Amazon Web Services services, except for the following:
     * + You can't use tags to track costs for Amazon QuickSight. This isn't possible because you can't tag the resources that Amazon QuickSight costs are based on, for example Amazon QuickSight storage capacity (SPICE), number of users, type of users, and usage metrics.
     * + Amazon QuickSight doesn't currently support the tag editor for Resource Groups.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a tag or tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, the only customization that you can use is a theme.
     *
     * You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
     */
    override suspend fun updateAccountCustomization(input: UpdateAccountCustomizationRequest): UpdateAccountCustomizationResponse {
        val op = SdkHttpOperation.build<UpdateAccountCustomizationRequest, UpdateAccountCustomizationResponse> {
            serializer = UpdateAccountCustomizationOperationSerializer()
            deserializer = UpdateAccountCustomizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccountCustomization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the Amazon QuickSight settings in your Amazon Web Services account.
     */
    override suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest): UpdateAccountSettingsResponse {
        val op = SdkHttpOperation.build<UpdateAccountSettingsRequest, UpdateAccountSettingsResponse> {
            serializer = UpdateAccountSettingsOperationSerializer()
            deserializer = UpdateAccountSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccountSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an analysis in Amazon QuickSight
     */
    override suspend fun updateAnalysis(input: UpdateAnalysisRequest): UpdateAnalysisResponse {
        val op = SdkHttpOperation.build<UpdateAnalysisRequest, UpdateAnalysisResponse> {
            serializer = UpdateAnalysisOperationSerializer()
            deserializer = UpdateAnalysisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAnalysis"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the read and write permissions for an analysis.
     */
    override suspend fun updateAnalysisPermissions(input: UpdateAnalysisPermissionsRequest): UpdateAnalysisPermissionsResponse {
        val op = SdkHttpOperation.build<UpdateAnalysisPermissionsRequest, UpdateAnalysisPermissionsResponse> {
            serializer = UpdateAnalysisPermissionsOperationSerializer()
            deserializer = UpdateAnalysisPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAnalysisPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a dashboard in an Amazon Web Services account.
     *
     * Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can update the published version of a dashboard by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html">UpdateDashboardPublishedVersion</a> ` API operation.
     */
    override suspend fun updateDashboard(input: UpdateDashboardRequest): UpdateDashboardResponse {
        val op = SdkHttpOperation.build<UpdateDashboardRequest, UpdateDashboardResponse> {
            serializer = UpdateDashboardOperationSerializer()
            deserializer = UpdateDashboardOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDashboard"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates read and write permissions on a dashboard.
     */
    override suspend fun updateDashboardPermissions(input: UpdateDashboardPermissionsRequest): UpdateDashboardPermissionsResponse {
        val op = SdkHttpOperation.build<UpdateDashboardPermissionsRequest, UpdateDashboardPermissionsResponse> {
            serializer = UpdateDashboardPermissionsOperationSerializer()
            deserializer = UpdateDashboardPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDashboardPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the published version of a dashboard.
     */
    override suspend fun updateDashboardPublishedVersion(input: UpdateDashboardPublishedVersionRequest): UpdateDashboardPublishedVersionResponse {
        val op = SdkHttpOperation.build<UpdateDashboardPublishedVersionRequest, UpdateDashboardPublishedVersionResponse> {
            serializer = UpdateDashboardPublishedVersionOperationSerializer()
            deserializer = UpdateDashboardPublishedVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDashboardPublishedVersion"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a dataset. This operation doesn't support datasets that include uploaded files as a source.
     */
    override suspend fun updateDataSet(input: UpdateDataSetRequest): UpdateDataSetResponse {
        val op = SdkHttpOperation.build<UpdateDataSetRequest, UpdateDataSetResponse> {
            serializer = UpdateDataSetOperationSerializer()
            deserializer = UpdateDataSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the permissions on a dataset.
     *
     * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
     */
    override suspend fun updateDataSetPermissions(input: UpdateDataSetPermissionsRequest): UpdateDataSetPermissionsResponse {
        val op = SdkHttpOperation.build<UpdateDataSetPermissionsRequest, UpdateDataSetPermissionsResponse> {
            serializer = UpdateDataSetPermissionsOperationSerializer()
            deserializer = UpdateDataSetPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataSetPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a data source.
     */
    override suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse {
        val op = SdkHttpOperation.build<UpdateDataSourceRequest, UpdateDataSourceResponse> {
            serializer = UpdateDataSourceOperationSerializer()
            deserializer = UpdateDataSourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataSource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the permissions to a data source.
     */
    override suspend fun updateDataSourcePermissions(input: UpdateDataSourcePermissionsRequest): UpdateDataSourcePermissionsResponse {
        val op = SdkHttpOperation.build<UpdateDataSourcePermissionsRequest, UpdateDataSourcePermissionsResponse> {
            serializer = UpdateDataSourcePermissionsOperationSerializer()
            deserializer = UpdateDataSourcePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataSourcePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the name of a folder.
     */
    override suspend fun updateFolder(input: UpdateFolderRequest): UpdateFolderResponse {
        val op = SdkHttpOperation.build<UpdateFolderRequest, UpdateFolderResponse> {
            serializer = UpdateFolderOperationSerializer()
            deserializer = UpdateFolderOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFolder"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates permissions of a folder.
     */
    override suspend fun updateFolderPermissions(input: UpdateFolderPermissionsRequest): UpdateFolderPermissionsResponse {
        val op = SdkHttpOperation.build<UpdateFolderPermissionsRequest, UpdateFolderPermissionsResponse> {
            serializer = UpdateFolderPermissionsOperationSerializer()
            deserializer = UpdateFolderPermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFolderPermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Changes a group description.
     */
    override suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse {
        val op = SdkHttpOperation.build<UpdateGroupRequest, UpdateGroupResponse> {
            serializer = UpdateGroupOperationSerializer()
            deserializer = UpdateGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in `Identities`.
     */
    override suspend fun updateIamPolicyAssignment(input: UpdateIamPolicyAssignmentRequest): UpdateIamPolicyAssignmentResponse {
        val op = SdkHttpOperation.build<UpdateIamPolicyAssignmentRequest, UpdateIamPolicyAssignmentResponse> {
            serializer = UpdateIAMPolicyAssignmentOperationSerializer()
            deserializer = UpdateIAMPolicyAssignmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIAMPolicyAssignment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the content and status of IP rules. To use this operation, you need to provide the entire map of rules. You can use the `DescribeIpRestriction` operation to get the current rule map.
     */
    override suspend fun updateIpRestriction(input: UpdateIpRestrictionRequest): UpdateIpRestrictionResponse {
        val op = SdkHttpOperation.build<UpdateIpRestrictionRequest, UpdateIpRestrictionResponse> {
            serializer = UpdateIpRestrictionOperationSerializer()
            deserializer = UpdateIpRestrictionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateIpRestriction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use the `UpdatePublicSharingSettings` operation to turn on or turn off the public sharing settings of an Amazon QuickSight dashboard.
     *
     * To use this operation, turn on session capacity pricing for your Amazon QuickSight account.
     *
     * Before you can turn on public sharing on your account, make sure to give public sharing permissions to an administrative user in the Identity and Access Management (IAM) console. For more information on using IAM with Amazon QuickSight, see [Using Amazon QuickSight with IAM](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html) in the *Amazon QuickSight User Guide*.
     */
    override suspend fun updatePublicSharingSettings(input: UpdatePublicSharingSettingsRequest): UpdatePublicSharingSettingsResponse {
        val op = SdkHttpOperation.build<UpdatePublicSharingSettingsRequest, UpdatePublicSharingSettingsResponse> {
            serializer = UpdatePublicSharingSettingsOperationSerializer()
            deserializer = UpdatePublicSharingSettingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePublicSharingSettings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a template from an existing Amazon QuickSight analysis or another template.
     */
    override suspend fun updateTemplate(input: UpdateTemplateRequest): UpdateTemplateResponse {
        val op = SdkHttpOperation.build<UpdateTemplateRequest, UpdateTemplateResponse> {
            serializer = UpdateTemplateOperationSerializer()
            deserializer = UpdateTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the template alias of a template.
     */
    override suspend fun updateTemplateAlias(input: UpdateTemplateAliasRequest): UpdateTemplateAliasResponse {
        val op = SdkHttpOperation.build<UpdateTemplateAliasRequest, UpdateTemplateAliasResponse> {
            serializer = UpdateTemplateAliasOperationSerializer()
            deserializer = UpdateTemplateAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTemplateAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the resource permissions for a template.
     */
    override suspend fun updateTemplatePermissions(input: UpdateTemplatePermissionsRequest): UpdateTemplatePermissionsResponse {
        val op = SdkHttpOperation.build<UpdateTemplatePermissionsRequest, UpdateTemplatePermissionsResponse> {
            serializer = UpdateTemplatePermissionsOperationSerializer()
            deserializer = UpdateTemplatePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTemplatePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a theme.
     */
    override suspend fun updateTheme(input: UpdateThemeRequest): UpdateThemeResponse {
        val op = SdkHttpOperation.build<UpdateThemeRequest, UpdateThemeResponse> {
            serializer = UpdateThemeOperationSerializer()
            deserializer = UpdateThemeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateTheme"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an alias of a theme.
     */
    override suspend fun updateThemeAlias(input: UpdateThemeAliasRequest): UpdateThemeAliasResponse {
        val op = SdkHttpOperation.build<UpdateThemeAliasRequest, UpdateThemeAliasResponse> {
            serializer = UpdateThemeAliasOperationSerializer()
            deserializer = UpdateThemeAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateThemeAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example `"quicksight:DescribeTheme"`.
     *
     * Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions:
     * + User
     *    + `"quicksight:DescribeTheme"`
     *    + `"quicksight:DescribeThemeAlias"`
     *    + `"quicksight:ListThemeAliases"`
     *    + `"quicksight:ListThemeVersions"`
     * + Owner
     *    + `"quicksight:DescribeTheme"`
     *    + `"quicksight:DescribeThemeAlias"`
     *    + `"quicksight:ListThemeAliases"`
     *    + `"quicksight:ListThemeVersions"`
     *    + `"quicksight:DeleteTheme"`
     *    + `"quicksight:UpdateTheme"`
     *    + `"quicksight:CreateThemeAlias"`
     *    + `"quicksight:DeleteThemeAlias"`
     *    + `"quicksight:UpdateThemeAlias"`
     *    + `"quicksight:UpdateThemePermissions"`
     *    + `"quicksight:DescribeThemePermissions"`
     * + To specify no permissions, omit the permissions list.
     */
    override suspend fun updateThemePermissions(input: UpdateThemePermissionsRequest): UpdateThemePermissionsResponse {
        val op = SdkHttpOperation.build<UpdateThemePermissionsRequest, UpdateThemePermissionsResponse> {
            serializer = UpdateThemePermissionsOperationSerializer()
            deserializer = UpdateThemePermissionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateThemePermissions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an Amazon QuickSight user.
     */
    override suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse {
        val op = SdkHttpOperation.build<UpdateUserRequest, UpdateUserResponse> {
            serializer = UpdateUserOperationSerializer()
            deserializer = UpdateUserOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateUser"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "quicksight"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "quicksight")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
