// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.quicksight.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.quicksight.model.*
import aws.sdk.kotlin.services.quicksight.model.CancelIngestionRequest
import aws.sdk.kotlin.services.quicksight.model.CancelIngestionResponse
import aws.sdk.kotlin.services.quicksight.model.CreateAccountCustomizationRequest
import aws.sdk.kotlin.services.quicksight.model.CreateAccountCustomizationResponse
import aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest
import aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionResponse
import aws.sdk.kotlin.services.quicksight.model.CreateAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.CreateAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.CreateDashboardRequest
import aws.sdk.kotlin.services.quicksight.model.CreateDashboardResponse
import aws.sdk.kotlin.services.quicksight.model.CreateDataSetRequest
import aws.sdk.kotlin.services.quicksight.model.CreateDataSetResponse
import aws.sdk.kotlin.services.quicksight.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.CreateDataSourceResponse
import aws.sdk.kotlin.services.quicksight.model.CreateFolderMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.CreateFolderMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.CreateFolderRequest
import aws.sdk.kotlin.services.quicksight.model.CreateFolderResponse
import aws.sdk.kotlin.services.quicksight.model.CreateGroupMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.CreateGroupMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.CreateGroupRequest
import aws.sdk.kotlin.services.quicksight.model.CreateGroupResponse
import aws.sdk.kotlin.services.quicksight.model.CreateIamPolicyAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.CreateIamPolicyAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.CreateIngestionRequest
import aws.sdk.kotlin.services.quicksight.model.CreateIngestionResponse
import aws.sdk.kotlin.services.quicksight.model.CreateNamespaceRequest
import aws.sdk.kotlin.services.quicksight.model.CreateNamespaceResponse
import aws.sdk.kotlin.services.quicksight.model.CreateTemplateAliasRequest
import aws.sdk.kotlin.services.quicksight.model.CreateTemplateAliasResponse
import aws.sdk.kotlin.services.quicksight.model.CreateTemplateRequest
import aws.sdk.kotlin.services.quicksight.model.CreateTemplateResponse
import aws.sdk.kotlin.services.quicksight.model.CreateThemeAliasRequest
import aws.sdk.kotlin.services.quicksight.model.CreateThemeAliasResponse
import aws.sdk.kotlin.services.quicksight.model.CreateThemeRequest
import aws.sdk.kotlin.services.quicksight.model.CreateThemeResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteAccountCustomizationRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteAccountCustomizationResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteDashboardRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteDashboardResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSetRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSetResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteFolderMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteFolderMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteFolderRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteFolderResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteGroupMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteGroupMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteGroupRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteGroupResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteIamPolicyAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteIamPolicyAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteNamespaceRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteNamespaceResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteTemplateAliasRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteTemplateAliasResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteTemplateRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteTemplateResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteThemeAliasRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteThemeAliasResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteThemeRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteThemeResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteUserByPrincipalIdRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteUserByPrincipalIdResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteUserRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteUserResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountCustomizationRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountCustomizationResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountSettingsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountSettingsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountSubscriptionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountSubscriptionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSourcePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSourcePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSourceResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderResolvedPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderResolvedPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeGroupMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeGroupMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeGroupRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeGroupResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeIamPolicyAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeIamPolicyAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeIngestionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeIngestionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeIpRestrictionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeIpRestrictionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeNamespaceRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeNamespaceResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateAliasRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateAliasResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplatePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplatePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeThemeAliasRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeThemeAliasResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeThemePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeThemePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeThemeRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeThemeResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeUserRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeUserResponse
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForAnonymousUserResponse
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserResponse
import aws.sdk.kotlin.services.quicksight.model.GetDashboardEmbedUrlRequest
import aws.sdk.kotlin.services.quicksight.model.GetDashboardEmbedUrlResponse
import aws.sdk.kotlin.services.quicksight.model.GetSessionEmbedUrlRequest
import aws.sdk.kotlin.services.quicksight.model.GetSessionEmbedUrlResponse
import aws.sdk.kotlin.services.quicksight.model.ListAnalysesRequest
import aws.sdk.kotlin.services.quicksight.model.ListAnalysesResponse
import aws.sdk.kotlin.services.quicksight.model.ListDashboardVersionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListDashboardVersionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDashboardsRequest
import aws.sdk.kotlin.services.quicksight.model.ListDashboardsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDataSetsRequest
import aws.sdk.kotlin.services.quicksight.model.ListDataSetsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.quicksight.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.quicksight.model.ListFolderMembersRequest
import aws.sdk.kotlin.services.quicksight.model.ListFolderMembersResponse
import aws.sdk.kotlin.services.quicksight.model.ListFoldersRequest
import aws.sdk.kotlin.services.quicksight.model.ListFoldersResponse
import aws.sdk.kotlin.services.quicksight.model.ListGroupMembershipsRequest
import aws.sdk.kotlin.services.quicksight.model.ListGroupMembershipsResponse
import aws.sdk.kotlin.services.quicksight.model.ListGroupsRequest
import aws.sdk.kotlin.services.quicksight.model.ListGroupsResponse
import aws.sdk.kotlin.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest
import aws.sdk.kotlin.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse
import aws.sdk.kotlin.services.quicksight.model.ListIamPolicyAssignmentsRequest
import aws.sdk.kotlin.services.quicksight.model.ListIamPolicyAssignmentsResponse
import aws.sdk.kotlin.services.quicksight.model.ListIngestionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListIngestionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListNamespacesRequest
import aws.sdk.kotlin.services.quicksight.model.ListNamespacesResponse
import aws.sdk.kotlin.services.quicksight.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.quicksight.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.quicksight.model.ListTemplateAliasesRequest
import aws.sdk.kotlin.services.quicksight.model.ListTemplateAliasesResponse
import aws.sdk.kotlin.services.quicksight.model.ListTemplateVersionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListTemplateVersionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListTemplatesRequest
import aws.sdk.kotlin.services.quicksight.model.ListTemplatesResponse
import aws.sdk.kotlin.services.quicksight.model.ListThemeAliasesRequest
import aws.sdk.kotlin.services.quicksight.model.ListThemeAliasesResponse
import aws.sdk.kotlin.services.quicksight.model.ListThemeVersionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListThemeVersionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListThemesRequest
import aws.sdk.kotlin.services.quicksight.model.ListThemesResponse
import aws.sdk.kotlin.services.quicksight.model.ListUserGroupsRequest
import aws.sdk.kotlin.services.quicksight.model.ListUserGroupsResponse
import aws.sdk.kotlin.services.quicksight.model.ListUsersRequest
import aws.sdk.kotlin.services.quicksight.model.ListUsersResponse
import aws.sdk.kotlin.services.quicksight.model.RegisterUserRequest
import aws.sdk.kotlin.services.quicksight.model.RegisterUserResponse
import aws.sdk.kotlin.services.quicksight.model.RestoreAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.RestoreAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.SearchAnalysesRequest
import aws.sdk.kotlin.services.quicksight.model.SearchAnalysesResponse
import aws.sdk.kotlin.services.quicksight.model.SearchDashboardsRequest
import aws.sdk.kotlin.services.quicksight.model.SearchDashboardsResponse
import aws.sdk.kotlin.services.quicksight.model.SearchFoldersRequest
import aws.sdk.kotlin.services.quicksight.model.SearchFoldersResponse
import aws.sdk.kotlin.services.quicksight.model.SearchGroupsRequest
import aws.sdk.kotlin.services.quicksight.model.SearchGroupsResponse
import aws.sdk.kotlin.services.quicksight.model.TagResourceRequest
import aws.sdk.kotlin.services.quicksight.model.TagResourceResponse
import aws.sdk.kotlin.services.quicksight.model.UntagResourceRequest
import aws.sdk.kotlin.services.quicksight.model.UntagResourceResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateAccountCustomizationRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateAccountCustomizationResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardPublishedVersionRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardPublishedVersionResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSetPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSetPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSetRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSetResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSourcePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSourcePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateFolderPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateFolderPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateFolderRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateFolderResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateGroupRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateGroupResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateIamPolicyAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateIamPolicyAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateIpRestrictionRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateIpRestrictionResponse
import aws.sdk.kotlin.services.quicksight.model.UpdatePublicSharingSettingsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdatePublicSharingSettingsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplateAliasRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplateAliasResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplatePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplatePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplateRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplateResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateThemeAliasRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateThemeAliasResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateThemePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateThemePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateThemeRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateThemeResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateUserRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateUserResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon QuickSight API Reference
 * Amazon QuickSight is a fully managed, serverless business intelligence service for the Amazon Web Services Cloud that makes it easy to extend data and insights to every user in your organization. This API reference contains documentation for a programming interface that you can use to manage Amazon QuickSight.
 */
public interface QuickSightClient : SdkClient {

    override val serviceName: String
        get() = "QuickSight"
    /**
     * QuickSightClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): QuickSightClient {
            val config = Config.Builder().apply(block).build()
            return DefaultQuickSightClient(config)
        }

        public operator fun invoke(config: Config): QuickSightClient = DefaultQuickSightClient(config)

        /**
         * Construct a [QuickSightClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): QuickSightClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultQuickSightClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels an ongoing ingestion of data into SPICE.
     */
    public suspend fun cancelIngestion(input: CancelIngestionRequest): CancelIngestionResponse

    /**
     * Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a custom default theme by using the `CreateAccountCustomization` or `UpdateAccountCustomization` API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see [Customizing Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html) in the *Amazon QuickSight User Guide.*
     *
     * You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
     *
     * Before you use the `CreateAccountCustomization` API operation to add a theme as the namespace default, make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the current permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> ` API operation. To share the theme, grant permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> ` API operation.
     */
    public suspend fun createAccountCustomization(input: CreateAccountCustomizationRequest): CreateAccountCustomizationResponse

    /**
     * Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.
     *
     * The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK. This operation isn't supported in the US East (Ohio) Region, South America (Sao Paulo) Region, or Asia Pacific (Singapore) Region.
     *
     * Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you don't have an Amazon Web Services account, see [Sign up for Amazon Web Services](https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html) in the *Amazon QuickSight User Guide*. The person who signs up for Amazon QuickSight needs to have the correct Identity and Access Management (IAM) permissions. For more information, see [IAM Policy Examples for Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html) in the *Amazon QuickSight User Guide*.
     *
     * If your IAM policy includes both the `Subscribe` and `CreateAccountSubscription` actions, make sure that both actions are set to `Allow`. If either action is set to `Deny`, the `Deny` action prevails and your API call fails.
     *
     * You can't pass an existing IAM role to access other Amazon Web Services services using this API operation. To pass your existing IAM role to Amazon QuickSight, see [Passing IAM roles to Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role) in the *Amazon QuickSight User Guide*.
     *
     * You can't set default resource access on the new account from the Amazon QuickSight API. Instead, add default resource access from the Amazon QuickSight console. For more information about setting default resource access to Amazon Web Services services, see [Setting default resource access to Amazon Web Services services](https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html) in the *Amazon QuickSight User Guide*.
     */
    public suspend fun createAccountSubscription(input: CreateAccountSubscriptionRequest): CreateAccountSubscriptionResponse

    /**
     * Creates an analysis in Amazon QuickSight.
     */
    public suspend fun createAnalysis(input: CreateAnalysisRequest): CreateAnalysisResponse

    /**
     * Creates a dashboard from a template. To first create a template, see the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> ` API operation.
     *
     * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different Amazon Web Services account.
     */
    public suspend fun createDashboard(input: CreateDashboardRequest): CreateDashboardResponse

    /**
     * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
     */
    public suspend fun createDataSet(input: CreateDataSetRequest): CreateDataSetResponse

    /**
     * Creates a data source.
     */
    public suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates an empty shared folder.
     */
    public suspend fun createFolder(input: CreateFolderRequest): CreateFolderResponse

    /**
     * Adds an asset, such as a dashboard, analysis, or dataset into a folder.
     */
    public suspend fun createFolderMembership(input: CreateFolderMembershipRequest): CreateFolderMembershipResponse

    /**
     * Use the `CreateGroup` operation to create a group in Amazon QuickSight. You can create up to 10,000 groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact AWS Support.
     *
     * The permissions resource is `arn:aws:quicksight:<your-region>:<i><relevant-aws-account-id></i>:group/default/<i><group-name></i> `.
     *
     * The response is a group object.
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     */
    public suspend fun createGroupMembership(input: CreateGroupMembershipRequest): CreateGroupMembershipResponse

    /**
     * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.
     */
    public suspend fun createIamPolicyAssignment(input: CreateIamPolicyAssignmentRequest): CreateIamPolicyAssignmentResponse

    /**
     * Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8 times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
     *
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see [How do I create an IAM policy to control access to Amazon EC2 resources using tags?](http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/) in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.
     */
    public suspend fun createIngestion(input: CreateIngestionRequest): CreateIngestionResponse

    /**
     * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
     *
     * A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with Amazon Web Services Support.
     */
    public suspend fun createNamespace(input: CreateNamespaceRequest): CreateNamespaceResponse

    /**
     * Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to create a dashboard.
     *
     * A *template* is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.
     */
    public suspend fun createTemplate(input: CreateTemplateRequest): CreateTemplateResponse

    /**
     * Creates a template alias for a template.
     */
    public suspend fun createTemplateAlias(input: CreateTemplateAliasRequest): CreateTemplateAliasResponse

    /**
     * Creates a theme.
     *
     * A *theme* is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see [Using Themes in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html) in the *Amazon QuickSight User Guide*.
     */
    public suspend fun createTheme(input: CreateThemeRequest): CreateThemeResponse

    /**
     * Creates a theme alias for a theme.
     */
    public suspend fun createThemeAlias(input: CreateThemeAliasRequest): CreateThemeAliasResponse

    /**
     * Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web Services account and Amazon QuickSight namespace.
     */
    public suspend fun deleteAccountCustomization(input: DeleteAccountCustomizationRequest): DeleteAccountCustomizationResponse

    /**
     * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon QuickSight attaches a `DeletionTime` stamp to the response that specifies the end of the recovery window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.
     *
     * At any time before recovery window ends, you can use the `RestoreAnalysis` API operation to remove the `DeletionTime` stamp and cancel the deletion of the analysis. The analysis remains visible in the API until it's deleted, so you can describe it but you can't make a template from it.
     *
     * An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console. To access it in the console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
     */
    public suspend fun deleteAnalysis(input: DeleteAnalysisRequest): DeleteAnalysisResponse

    /**
     * Deletes a dashboard.
     */
    public suspend fun deleteDashboard(input: DeleteDashboardRequest): DeleteDashboardResponse

    /**
     * Deletes a dataset.
     */
    public suspend fun deleteDataSet(input: DeleteDataSetRequest): DeleteDataSetResponse

    /**
     * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes an empty folder.
     */
    public suspend fun deleteFolder(input: DeleteFolderRequest): DeleteFolderResponse

    /**
     * Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
     */
    public suspend fun deleteFolderMembership(input: DeleteFolderMembershipRequest): DeleteFolderMembershipResponse

    /**
     * Removes a user group from Amazon QuickSight.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Removes a user from a group so that the user is no longer a member of the group.
     */
    public suspend fun deleteGroupMembership(input: DeleteGroupMembershipRequest): DeleteGroupMembershipResponse

    /**
     * Deletes an existing IAM policy assignment.
     */
    public suspend fun deleteIamPolicyAssignment(input: DeleteIamPolicyAssignmentRequest): DeleteIamPolicyAssignmentResponse

    /**
     * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset.
     */
    public suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse

    /**
     * Deletes a template.
     */
    public suspend fun deleteTemplate(input: DeleteTemplateRequest): DeleteTemplateResponse

    /**
     * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.
     */
    public suspend fun deleteTemplateAlias(input: DeleteTemplateAliasRequest): DeleteTemplateAliasResponse

    /**
     * Deletes a theme.
     */
    public suspend fun deleteTheme(input: DeleteThemeRequest): DeleteThemeResponse

    /**
     * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.
     */
    public suspend fun deleteThemeAlias(input: DeleteThemeAliasRequest): DeleteThemeAliasResponse

    /**
     * Deletes the Amazon QuickSight user that is associated with the identity of the Identity and Access Management (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes a user identified by its principal ID.
     */
    public suspend fun deleteUserByPrincipalId(input: DeleteUserByPrincipalIdRequest): DeleteUserByPrincipalIdResponse

    /**
     * Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the `Resolved` flag included.
     *
     * To determine what customizations display when you run this command, it can help to visualize the relationship of the entities involved.
     * + `Amazon Web Services account` - The Amazon Web Services account exists at the top of the hierarchy. It has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That's where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services Region.
     * + `Amazon Web Services Region` - In each Amazon Web Services Region where you sign in to Amazon QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace. To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using the CLI, you can use one of the following options:
     *    + Use [command line options](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html).
     *    + Use [named profiles](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html).
     *    + Run `aws configure` to change your default Amazon Web Services Region. Use Enter to key the same settings for your keys. For more information, see [Configuring the CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html).
     * + `Namespace` - A QuickSight namespace is a partition that contains users and assets (data sources, datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also be part of the same namespace. People who share a namespace are completely isolated from users and assets in other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.
     * + `Applied customizations` - Within an Amazon Web Services Region, a set of Amazon QuickSight customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the `CreateAccountCustomization` command in each Amazon Web Services Region where you want to apply the same customizations.
     */
    public suspend fun describeAccountCustomization(input: DescribeAccountCustomizationRequest): DescribeAccountCustomizationResponse

    /**
     * Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon Web Services account.
     */
    public suspend fun describeAccountSettings(input: DescribeAccountSettingsRequest): DescribeAccountSettingsResponse

    /**
     * Use the DescribeAccountSubscription operation to receive a description of a Amazon QuickSight account's subscription. A successful API call returns an `AccountInfo` object that includes an account's name, subscription status, authentication type, edition, and notification email address.
     */
    public suspend fun describeAccountSubscription(input: DescribeAccountSubscriptionRequest): DescribeAccountSubscriptionResponse

    /**
     * Provides a summary of the metadata for an analysis.
     */
    public suspend fun describeAnalysis(input: DescribeAnalysisRequest): DescribeAnalysisResponse

    /**
     * Provides the read and write permissions for an analysis.
     */
    public suspend fun describeAnalysisPermissions(input: DescribeAnalysisPermissionsRequest): DescribeAnalysisPermissionsResponse

    /**
     * Provides a summary for a dashboard.
     */
    public suspend fun describeDashboard(input: DescribeDashboardRequest): DescribeDashboardResponse

    /**
     * Describes read and write permissions for a dashboard.
     */
    public suspend fun describeDashboardPermissions(input: DescribeDashboardPermissionsRequest): DescribeDashboardPermissionsResponse

    /**
     * Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
     */
    public suspend fun describeDataSet(input: DescribeDataSetRequest): DescribeDataSetResponse

    /**
     * Describes the permissions on a dataset.
     *
     * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
     */
    public suspend fun describeDataSetPermissions(input: DescribeDataSetPermissionsRequest): DescribeDataSetPermissionsResponse

    /**
     * Describes a data source.
     */
    public suspend fun describeDataSource(input: DescribeDataSourceRequest): DescribeDataSourceResponse

    /**
     * Describes the resource permissions for a data source.
     */
    public suspend fun describeDataSourcePermissions(input: DescribeDataSourcePermissionsRequest): DescribeDataSourcePermissionsResponse

    /**
     * Describes a folder.
     */
    public suspend fun describeFolder(input: DescribeFolderRequest): DescribeFolderResponse

    /**
     * Describes permissions for a folder.
     */
    public suspend fun describeFolderPermissions(input: DescribeFolderPermissionsRequest): DescribeFolderPermissionsResponse

    /**
     * Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.
     */
    public suspend fun describeFolderResolvedPermissions(input: DescribeFolderResolvedPermissionsRequest): DescribeFolderResolvedPermissionsResponse

    /**
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     */
    public suspend fun describeGroup(input: DescribeGroupRequest): DescribeGroupResponse

    /**
     * Use the `DescribeGroupMembership` operation to determine if a user is a member of the specified group. If the user exists and is a member of the specified group, an associated `GroupMember` object is returned.
     */
    public suspend fun describeGroupMembership(input: DescribeGroupMembershipRequest): DescribeGroupMembershipResponse

    /**
     * Describes an existing IAM policy assignment, as specified by the assignment name.
     */
    public suspend fun describeIamPolicyAssignment(input: DescribeIamPolicyAssignmentRequest): DescribeIamPolicyAssignmentResponse

    /**
     * Describes a SPICE ingestion.
     */
    public suspend fun describeIngestion(input: DescribeIngestionRequest): DescribeIngestionResponse

    /**
     * Provides a summary and status of IP rules.
     */
    public suspend fun describeIpRestriction(input: DescribeIpRestrictionRequest): DescribeIpRestrictionResponse

    /**
     * Describes the current namespace.
     */
    public suspend fun describeNamespace(input: DescribeNamespaceRequest): DescribeNamespaceResponse

    /**
     * Describes a template's metadata.
     */
    public suspend fun describeTemplate(input: DescribeTemplateRequest): DescribeTemplateResponse

    /**
     * Describes the template alias for a template.
     */
    public suspend fun describeTemplateAlias(input: DescribeTemplateAliasRequest): DescribeTemplateAliasResponse

    /**
     * Describes read and write permissions on a template.
     */
    public suspend fun describeTemplatePermissions(input: DescribeTemplatePermissionsRequest): DescribeTemplatePermissionsResponse

    /**
     * Describes a theme.
     */
    public suspend fun describeTheme(input: DescribeThemeRequest): DescribeThemeResponse

    /**
     * Describes the alias for a theme.
     */
    public suspend fun describeThemeAlias(input: DescribeThemeAliasRequest): DescribeThemeAliasResponse

    /**
     * Describes the read and write permissions for a theme.
     */
    public suspend fun describeThemePermissions(input: DescribeThemePermissionsRequest): DescribeThemePermissionsResponse

    /**
     * Returns information about a user, given the user name.
     */
    public suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Generates an embed URL that you can use to embed an Amazon QuickSight dashboard or visual in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.
     *
     * The following rules apply to the generated URL:
     * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
     * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter. The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
     * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     *
     * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    public suspend fun generateEmbedUrlForAnonymousUser(input: GenerateEmbedUrlForAnonymousUserRequest): GenerateEmbedUrlForAnonymousUserResponse

    /**
     * Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
     *
     * The following rules apply to the generated URL:
     * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
     * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter.The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
     * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     *
     * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    public suspend fun generateEmbedUrlForRegisteredUser(input: GenerateEmbedUrlForRegisteredUserRequest): GenerateEmbedUrlForRegisteredUserResponse

    /**
     * Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you have configured the dashboards and permissions.
     *
     * Currently, you can use `GetDashboardEmbedURL` only from the server, not from the user's browser. The following rules apply to the generated URL:
     * + They must be used together.
     * + They can be used one time only.
     * + They are valid for 5 minutes after you run this command.
     * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     * + The resulting user session is valid for 15 minutes (default) up to 10 hours (maximum). You can use the optional `SessionLifetimeInMinutes` parameter to customize session duration.
     *
     * For more information, see [Embedding Analytics Using GetDashboardEmbedUrl](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html) in the *Amazon QuickSight User Guide*.
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    public suspend fun getDashboardEmbedUrl(input: GetDashboardEmbedUrlRequest): GetDashboardEmbedUrlResponse

    /**
     * Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use `GetSessionEmbedUrl` where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> ` API operation. Use ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> ` API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the *Amazon QuickSight User Guide*:
     * + [Embedding Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
     * + [Customizing Access to the Amazon QuickSight Console](https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
     */
    public suspend fun getSessionEmbedUrl(input: GetSessionEmbedUrlRequest): GetSessionEmbedUrlResponse

    /**
     * Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
     */
    public suspend fun listAnalyses(input: ListAnalysesRequest): ListAnalysesResponse

    /**
     * Lists all the versions of the dashboards in the Amazon QuickSight subscription.
     */
    public suspend fun listDashboardVersions(input: ListDashboardVersionsRequest): ListDashboardVersionsResponse

    /**
     * Lists dashboards in an Amazon Web Services account.
     */
    public suspend fun listDashboards(input: ListDashboardsRequest): ListDashboardsResponse

    /**
     * Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
     *
     * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset&#47;*`.
     */
    public suspend fun listDataSets(input: ListDataSetsRequest): ListDataSetsResponse

    /**
     * Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
     */
    public suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * List all assets (`DASHBOARD`, `ANALYSIS`, and `DATASET`) in a folder.
     */
    public suspend fun listFolderMembers(input: ListFolderMembersRequest): ListFolderMembersResponse

    /**
     * Lists all folders in an account.
     */
    public suspend fun listFolders(input: ListFoldersRequest): ListFoldersResponse

    /**
     * Lists member users in a group.
     */
    public suspend fun listGroupMemberships(input: ListGroupMembershipsRequest): ListGroupMembershipsResponse

    /**
     * Lists all user groups in Amazon QuickSight.
     */
    public suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Lists IAM policy assignments in the current Amazon QuickSight account.
     */
    public suspend fun listIamPolicyAssignments(input: ListIamPolicyAssignmentsRequest): ListIamPolicyAssignmentsResponse

    /**
     * Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to the specified user and group or groups that the user belongs to.
     */
    public suspend fun listIamPolicyAssignmentsForUser(input: ListIamPolicyAssignmentsForUserRequest): ListIamPolicyAssignmentsForUserResponse

    /**
     * Lists the history of SPICE ingestions for a dataset.
     */
    public suspend fun listIngestions(input: ListIngestionsRequest): ListIngestionsResponse

    /**
     * Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted namespaces.
     */
    public suspend fun listNamespaces(input: ListNamespacesRequest): ListNamespacesResponse

    /**
     * Lists the tags assigned to a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all the aliases of a template.
     */
    public suspend fun listTemplateAliases(input: ListTemplateAliasesRequest): ListTemplateAliasesResponse

    /**
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     */
    public suspend fun listTemplateVersions(input: ListTemplateVersionsRequest): ListTemplateVersionsResponse

    /**
     * Lists all the templates in the current Amazon QuickSight account.
     */
    public suspend fun listTemplates(input: ListTemplatesRequest): ListTemplatesResponse

    /**
     * Lists all the aliases of a theme.
     */
    public suspend fun listThemeAliases(input: ListThemeAliasesRequest): ListThemeAliasesResponse

    /**
     * Lists all the versions of the themes in the current Amazon Web Services account.
     */
    public suspend fun listThemeVersions(input: ListThemeVersionsRequest): ListThemeVersionsResponse

    /**
     * Lists all the themes in the current Amazon Web Services account.
     */
    public suspend fun listThemes(input: ListThemesRequest): ListThemesResponse

    /**
     * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
     */
    public suspend fun listUserGroups(input: ListUserGroupsRequest): ListUserGroupsResponse

    /**
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Creates an Amazon QuickSight user, whose identity is associated with the Identity and Access Management (IAM) identity or role specified in the request.
     */
    public suspend fun registerUser(input: RegisterUserRequest): RegisterUserResponse

    /**
     * Restores an analysis.
     */
    public suspend fun restoreAnalysis(input: RestoreAnalysisRequest): RestoreAnalysisResponse

    /**
     * Searches for analyses that belong to the user specified in the filter.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun searchAnalyses(input: SearchAnalysesRequest): SearchAnalysesResponse

    /**
     * Searches for dashboards that belong to a user.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun searchDashboards(input: SearchDashboardsRequest): SearchDashboardsResponse

    /**
     * Searches the subfolders in a folder.
     */
    public suspend fun searchFolders(input: SearchFoldersRequest): SearchFoldersResponse

    /**
     * Use the `SearchGroups` operation to search groups in a specified Amazon QuickSight namespace using the supplied filters.
     */
    public suspend fun searchGroups(input: SearchGroupsRequest): SearchGroupsResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the `TagResource` operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data source, dashboard, and template.
     *
     * Tagging for Amazon QuickSight works in a similar way to tagging for other Amazon Web Services services, except for the following:
     * + You can't use tags to track costs for Amazon QuickSight. This isn't possible because you can't tag the resources that Amazon QuickSight costs are based on, for example Amazon QuickSight storage capacity (SPICE), number of users, type of users, and usage metrics.
     * + Amazon QuickSight doesn't currently support the tag editor for Resource Groups.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag or tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, the only customization that you can use is a theme.
     *
     * You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
     */
    public suspend fun updateAccountCustomization(input: UpdateAccountCustomizationRequest): UpdateAccountCustomizationResponse

    /**
     * Updates the Amazon QuickSight settings in your Amazon Web Services account.
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest): UpdateAccountSettingsResponse

    /**
     * Updates an analysis in Amazon QuickSight
     */
    public suspend fun updateAnalysis(input: UpdateAnalysisRequest): UpdateAnalysisResponse

    /**
     * Updates the read and write permissions for an analysis.
     */
    public suspend fun updateAnalysisPermissions(input: UpdateAnalysisPermissionsRequest): UpdateAnalysisPermissionsResponse

    /**
     * Updates a dashboard in an Amazon Web Services account.
     *
     * Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can update the published version of a dashboard by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html">UpdateDashboardPublishedVersion</a> ` API operation.
     */
    public suspend fun updateDashboard(input: UpdateDashboardRequest): UpdateDashboardResponse

    /**
     * Updates read and write permissions on a dashboard.
     */
    public suspend fun updateDashboardPermissions(input: UpdateDashboardPermissionsRequest): UpdateDashboardPermissionsResponse

    /**
     * Updates the published version of a dashboard.
     */
    public suspend fun updateDashboardPublishedVersion(input: UpdateDashboardPublishedVersionRequest): UpdateDashboardPublishedVersionResponse

    /**
     * Updates a dataset. This operation doesn't support datasets that include uploaded files as a source.
     */
    public suspend fun updateDataSet(input: UpdateDataSetRequest): UpdateDataSetResponse

    /**
     * Updates the permissions on a dataset.
     *
     * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
     */
    public suspend fun updateDataSetPermissions(input: UpdateDataSetPermissionsRequest): UpdateDataSetPermissionsResponse

    /**
     * Updates a data source.
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates the permissions to a data source.
     */
    public suspend fun updateDataSourcePermissions(input: UpdateDataSourcePermissionsRequest): UpdateDataSourcePermissionsResponse

    /**
     * Updates the name of a folder.
     */
    public suspend fun updateFolder(input: UpdateFolderRequest): UpdateFolderResponse

    /**
     * Updates permissions of a folder.
     */
    public suspend fun updateFolderPermissions(input: UpdateFolderPermissionsRequest): UpdateFolderPermissionsResponse

    /**
     * Changes a group description.
     */
    public suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse

    /**
     * Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in `Identities`.
     */
    public suspend fun updateIamPolicyAssignment(input: UpdateIamPolicyAssignmentRequest): UpdateIamPolicyAssignmentResponse

    /**
     * Updates the content and status of IP rules. To use this operation, you need to provide the entire map of rules. You can use the `DescribeIpRestriction` operation to get the current rule map.
     */
    public suspend fun updateIpRestriction(input: UpdateIpRestrictionRequest): UpdateIpRestrictionResponse

    /**
     * Use the `UpdatePublicSharingSettings` operation to turn on or turn off the public sharing settings of an Amazon QuickSight dashboard.
     *
     * To use this operation, turn on session capacity pricing for your Amazon QuickSight account.
     *
     * Before you can turn on public sharing on your account, make sure to give public sharing permissions to an administrative user in the Identity and Access Management (IAM) console. For more information on using IAM with Amazon QuickSight, see [Using Amazon QuickSight with IAM](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html) in the *Amazon QuickSight User Guide*.
     */
    public suspend fun updatePublicSharingSettings(input: UpdatePublicSharingSettingsRequest): UpdatePublicSharingSettingsResponse

    /**
     * Updates a template from an existing Amazon QuickSight analysis or another template.
     */
    public suspend fun updateTemplate(input: UpdateTemplateRequest): UpdateTemplateResponse

    /**
     * Updates the template alias of a template.
     */
    public suspend fun updateTemplateAlias(input: UpdateTemplateAliasRequest): UpdateTemplateAliasResponse

    /**
     * Updates the resource permissions for a template.
     */
    public suspend fun updateTemplatePermissions(input: UpdateTemplatePermissionsRequest): UpdateTemplatePermissionsResponse

    /**
     * Updates a theme.
     */
    public suspend fun updateTheme(input: UpdateThemeRequest): UpdateThemeResponse

    /**
     * Updates an alias of a theme.
     */
    public suspend fun updateThemeAlias(input: UpdateThemeAliasRequest): UpdateThemeAliasResponse

    /**
     * Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example `"quicksight:DescribeTheme"`.
     *
     * Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions:
     * + User
     *    + `"quicksight:DescribeTheme"`
     *    + `"quicksight:DescribeThemeAlias"`
     *    + `"quicksight:ListThemeAliases"`
     *    + `"quicksight:ListThemeVersions"`
     * + Owner
     *    + `"quicksight:DescribeTheme"`
     *    + `"quicksight:DescribeThemeAlias"`
     *    + `"quicksight:ListThemeAliases"`
     *    + `"quicksight:ListThemeVersions"`
     *    + `"quicksight:DeleteTheme"`
     *    + `"quicksight:UpdateTheme"`
     *    + `"quicksight:CreateThemeAlias"`
     *    + `"quicksight:DeleteThemeAlias"`
     *    + `"quicksight:UpdateThemeAlias"`
     *    + `"quicksight:UpdateThemePermissions"`
     *    + `"quicksight:DescribeThemePermissions"`
     * + To specify no permissions, omit the permissions list.
     */
    public suspend fun updateThemePermissions(input: UpdateThemePermissionsRequest): UpdateThemePermissionsResponse

    /**
     * Updates an Amazon QuickSight user.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse
}

/**
 * Cancels an ongoing ingestion of data into SPICE.
 */
public suspend inline fun QuickSightClient.cancelIngestion(crossinline block: CancelIngestionRequest.Builder.() -> Unit): CancelIngestionResponse = cancelIngestion(CancelIngestionRequest.Builder().apply(block).build())

/**
 * Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a custom default theme by using the `CreateAccountCustomization` or `UpdateAccountCustomization` API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see [Customizing Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html) in the *Amazon QuickSight User Guide.*
 *
 * You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
 *
 * Before you use the `CreateAccountCustomization` API operation to add a theme as the namespace default, make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the current permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> ` API operation. To share the theme, grant permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> ` API operation.
 */
public suspend inline fun QuickSightClient.createAccountCustomization(crossinline block: CreateAccountCustomizationRequest.Builder.() -> Unit): CreateAccountCustomizationResponse = createAccountCustomization(CreateAccountCustomizationRequest.Builder().apply(block).build())

/**
 * Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.
 *
 * The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK. This operation isn't supported in the US East (Ohio) Region, South America (Sao Paulo) Region, or Asia Pacific (Singapore) Region.
 *
 * Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you don't have an Amazon Web Services account, see [Sign up for Amazon Web Services](https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html) in the *Amazon QuickSight User Guide*. The person who signs up for Amazon QuickSight needs to have the correct Identity and Access Management (IAM) permissions. For more information, see [IAM Policy Examples for Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html) in the *Amazon QuickSight User Guide*.
 *
 * If your IAM policy includes both the `Subscribe` and `CreateAccountSubscription` actions, make sure that both actions are set to `Allow`. If either action is set to `Deny`, the `Deny` action prevails and your API call fails.
 *
 * You can't pass an existing IAM role to access other Amazon Web Services services using this API operation. To pass your existing IAM role to Amazon QuickSight, see [Passing IAM roles to Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role) in the *Amazon QuickSight User Guide*.
 *
 * You can't set default resource access on the new account from the Amazon QuickSight API. Instead, add default resource access from the Amazon QuickSight console. For more information about setting default resource access to Amazon Web Services services, see [Setting default resource access to Amazon Web Services services](https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html) in the *Amazon QuickSight User Guide*.
 */
public suspend inline fun QuickSightClient.createAccountSubscription(crossinline block: CreateAccountSubscriptionRequest.Builder.() -> Unit): CreateAccountSubscriptionResponse = createAccountSubscription(CreateAccountSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates an analysis in Amazon QuickSight.
 */
public suspend inline fun QuickSightClient.createAnalysis(crossinline block: CreateAnalysisRequest.Builder.() -> Unit): CreateAnalysisResponse = createAnalysis(CreateAnalysisRequest.Builder().apply(block).build())

/**
 * Creates a dashboard from a template. To first create a template, see the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> ` API operation.
 *
 * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.createDashboard(crossinline block: CreateDashboardRequest.Builder.() -> Unit): CreateDashboardResponse = createDashboard(CreateDashboardRequest.Builder().apply(block).build())

/**
 * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
 */
public suspend inline fun QuickSightClient.createDataSet(crossinline block: CreateDataSetRequest.Builder.() -> Unit): CreateDataSetResponse = createDataSet(CreateDataSetRequest.Builder().apply(block).build())

/**
 * Creates a data source.
 */
public suspend inline fun QuickSightClient.createDataSource(crossinline block: CreateDataSourceRequest.Builder.() -> Unit): CreateDataSourceResponse = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

/**
 * Creates an empty shared folder.
 */
public suspend inline fun QuickSightClient.createFolder(crossinline block: CreateFolderRequest.Builder.() -> Unit): CreateFolderResponse = createFolder(CreateFolderRequest.Builder().apply(block).build())

/**
 * Adds an asset, such as a dashboard, analysis, or dataset into a folder.
 */
public suspend inline fun QuickSightClient.createFolderMembership(crossinline block: CreateFolderMembershipRequest.Builder.() -> Unit): CreateFolderMembershipResponse = createFolderMembership(CreateFolderMembershipRequest.Builder().apply(block).build())

/**
 * Use the `CreateGroup` operation to create a group in Amazon QuickSight. You can create up to 10,000 groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact AWS Support.
 *
 * The permissions resource is `arn:aws:quicksight:<your-region>:<i><relevant-aws-account-id></i>:group/default/<i><group-name></i> `.
 *
 * The response is a group object.
 */
public suspend inline fun QuickSightClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Adds an Amazon QuickSight user to an Amazon QuickSight group.
 */
public suspend inline fun QuickSightClient.createGroupMembership(crossinline block: CreateGroupMembershipRequest.Builder.() -> Unit): CreateGroupMembershipResponse = createGroupMembership(CreateGroupMembershipRequest.Builder().apply(block).build())

/**
 * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.
 */
public suspend inline fun QuickSightClient.createIamPolicyAssignment(crossinline block: CreateIamPolicyAssignmentRequest.Builder.() -> Unit): CreateIamPolicyAssignmentResponse = createIamPolicyAssignment(CreateIamPolicyAssignmentRequest.Builder().apply(block).build())

/**
 * Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8 times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
 *
 * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see [How do I create an IAM policy to control access to Amazon EC2 resources using tags?](http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/) in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.
 */
public suspend inline fun QuickSightClient.createIngestion(crossinline block: CreateIngestionRequest.Builder.() -> Unit): CreateIngestionResponse = createIngestion(CreateIngestionRequest.Builder().apply(block).build())

/**
 * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
 *
 * A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with Amazon Web Services Support.
 */
public suspend inline fun QuickSightClient.createNamespace(crossinline block: CreateNamespaceRequest.Builder.() -> Unit): CreateNamespaceResponse = createNamespace(CreateNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to create a dashboard.
 *
 * A *template* is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.
 */
public suspend inline fun QuickSightClient.createTemplate(crossinline block: CreateTemplateRequest.Builder.() -> Unit): CreateTemplateResponse = createTemplate(CreateTemplateRequest.Builder().apply(block).build())

/**
 * Creates a template alias for a template.
 */
public suspend inline fun QuickSightClient.createTemplateAlias(crossinline block: CreateTemplateAliasRequest.Builder.() -> Unit): CreateTemplateAliasResponse = createTemplateAlias(CreateTemplateAliasRequest.Builder().apply(block).build())

/**
 * Creates a theme.
 *
 * A *theme* is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see [Using Themes in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html) in the *Amazon QuickSight User Guide*.
 */
public suspend inline fun QuickSightClient.createTheme(crossinline block: CreateThemeRequest.Builder.() -> Unit): CreateThemeResponse = createTheme(CreateThemeRequest.Builder().apply(block).build())

/**
 * Creates a theme alias for a theme.
 */
public suspend inline fun QuickSightClient.createThemeAlias(crossinline block: CreateThemeAliasRequest.Builder.() -> Unit): CreateThemeAliasResponse = createThemeAlias(CreateThemeAliasRequest.Builder().apply(block).build())

/**
 * Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web Services account and Amazon QuickSight namespace.
 */
public suspend inline fun QuickSightClient.deleteAccountCustomization(crossinline block: DeleteAccountCustomizationRequest.Builder.() -> Unit): DeleteAccountCustomizationResponse = deleteAccountCustomization(DeleteAccountCustomizationRequest.Builder().apply(block).build())

/**
 * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon QuickSight attaches a `DeletionTime` stamp to the response that specifies the end of the recovery window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.
 *
 * At any time before recovery window ends, you can use the `RestoreAnalysis` API operation to remove the `DeletionTime` stamp and cancel the deletion of the analysis. The analysis remains visible in the API until it's deleted, so you can describe it but you can't make a template from it.
 *
 * An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console. To access it in the console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
 */
public suspend inline fun QuickSightClient.deleteAnalysis(crossinline block: DeleteAnalysisRequest.Builder.() -> Unit): DeleteAnalysisResponse = deleteAnalysis(DeleteAnalysisRequest.Builder().apply(block).build())

/**
 * Deletes a dashboard.
 */
public suspend inline fun QuickSightClient.deleteDashboard(crossinline block: DeleteDashboardRequest.Builder.() -> Unit): DeleteDashboardResponse = deleteDashboard(DeleteDashboardRequest.Builder().apply(block).build())

/**
 * Deletes a dataset.
 */
public suspend inline fun QuickSightClient.deleteDataSet(crossinline block: DeleteDataSetRequest.Builder.() -> Unit): DeleteDataSetResponse = deleteDataSet(DeleteDataSetRequest.Builder().apply(block).build())

/**
 * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.
 */
public suspend inline fun QuickSightClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes an empty folder.
 */
public suspend inline fun QuickSightClient.deleteFolder(crossinline block: DeleteFolderRequest.Builder.() -> Unit): DeleteFolderResponse = deleteFolder(DeleteFolderRequest.Builder().apply(block).build())

/**
 * Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
 */
public suspend inline fun QuickSightClient.deleteFolderMembership(crossinline block: DeleteFolderMembershipRequest.Builder.() -> Unit): DeleteFolderMembershipResponse = deleteFolderMembership(DeleteFolderMembershipRequest.Builder().apply(block).build())

/**
 * Removes a user group from Amazon QuickSight.
 */
public suspend inline fun QuickSightClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Removes a user from a group so that the user is no longer a member of the group.
 */
public suspend inline fun QuickSightClient.deleteGroupMembership(crossinline block: DeleteGroupMembershipRequest.Builder.() -> Unit): DeleteGroupMembershipResponse = deleteGroupMembership(DeleteGroupMembershipRequest.Builder().apply(block).build())

/**
 * Deletes an existing IAM policy assignment.
 */
public suspend inline fun QuickSightClient.deleteIamPolicyAssignment(crossinline block: DeleteIamPolicyAssignmentRequest.Builder.() -> Unit): DeleteIamPolicyAssignmentResponse = deleteIamPolicyAssignment(DeleteIamPolicyAssignmentRequest.Builder().apply(block).build())

/**
 * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset.
 */
public suspend inline fun QuickSightClient.deleteNamespace(crossinline block: DeleteNamespaceRequest.Builder.() -> Unit): DeleteNamespaceResponse = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes a template.
 */
public suspend inline fun QuickSightClient.deleteTemplate(crossinline block: DeleteTemplateRequest.Builder.() -> Unit): DeleteTemplateResponse = deleteTemplate(DeleteTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.
 */
public suspend inline fun QuickSightClient.deleteTemplateAlias(crossinline block: DeleteTemplateAliasRequest.Builder.() -> Unit): DeleteTemplateAliasResponse = deleteTemplateAlias(DeleteTemplateAliasRequest.Builder().apply(block).build())

/**
 * Deletes a theme.
 */
public suspend inline fun QuickSightClient.deleteTheme(crossinline block: DeleteThemeRequest.Builder.() -> Unit): DeleteThemeResponse = deleteTheme(DeleteThemeRequest.Builder().apply(block).build())

/**
 * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.
 */
public suspend inline fun QuickSightClient.deleteThemeAlias(crossinline block: DeleteThemeAliasRequest.Builder.() -> Unit): DeleteThemeAliasResponse = deleteThemeAlias(DeleteThemeAliasRequest.Builder().apply(block).build())

/**
 * Deletes the Amazon QuickSight user that is associated with the identity of the Identity and Access Management (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
 */
public suspend inline fun QuickSightClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Deletes a user identified by its principal ID.
 */
public suspend inline fun QuickSightClient.deleteUserByPrincipalId(crossinline block: DeleteUserByPrincipalIdRequest.Builder.() -> Unit): DeleteUserByPrincipalIdResponse = deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest.Builder().apply(block).build())

/**
 * Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the `Resolved` flag included.
 *
 * To determine what customizations display when you run this command, it can help to visualize the relationship of the entities involved.
 * + `Amazon Web Services account` - The Amazon Web Services account exists at the top of the hierarchy. It has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That's where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services Region.
 * + `Amazon Web Services Region` - In each Amazon Web Services Region where you sign in to Amazon QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace. To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using the CLI, you can use one of the following options:
 *    + Use [command line options](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html).
 *    + Use [named profiles](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html).
 *    + Run `aws configure` to change your default Amazon Web Services Region. Use Enter to key the same settings for your keys. For more information, see [Configuring the CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html).
 * + `Namespace` - A QuickSight namespace is a partition that contains users and assets (data sources, datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also be part of the same namespace. People who share a namespace are completely isolated from users and assets in other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.
 * + `Applied customizations` - Within an Amazon Web Services Region, a set of Amazon QuickSight customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the `CreateAccountCustomization` command in each Amazon Web Services Region where you want to apply the same customizations.
 */
public suspend inline fun QuickSightClient.describeAccountCustomization(crossinline block: DescribeAccountCustomizationRequest.Builder.() -> Unit): DescribeAccountCustomizationResponse = describeAccountCustomization(DescribeAccountCustomizationRequest.Builder().apply(block).build())

/**
 * Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.describeAccountSettings(crossinline block: DescribeAccountSettingsRequest.Builder.() -> Unit): DescribeAccountSettingsResponse = describeAccountSettings(DescribeAccountSettingsRequest.Builder().apply(block).build())

/**
 * Use the DescribeAccountSubscription operation to receive a description of a Amazon QuickSight account's subscription. A successful API call returns an `AccountInfo` object that includes an account's name, subscription status, authentication type, edition, and notification email address.
 */
public suspend inline fun QuickSightClient.describeAccountSubscription(crossinline block: DescribeAccountSubscriptionRequest.Builder.() -> Unit): DescribeAccountSubscriptionResponse = describeAccountSubscription(DescribeAccountSubscriptionRequest.Builder().apply(block).build())

/**
 * Provides a summary of the metadata for an analysis.
 */
public suspend inline fun QuickSightClient.describeAnalysis(crossinline block: DescribeAnalysisRequest.Builder.() -> Unit): DescribeAnalysisResponse = describeAnalysis(DescribeAnalysisRequest.Builder().apply(block).build())

/**
 * Provides the read and write permissions for an analysis.
 */
public suspend inline fun QuickSightClient.describeAnalysisPermissions(crossinline block: DescribeAnalysisPermissionsRequest.Builder.() -> Unit): DescribeAnalysisPermissionsResponse = describeAnalysisPermissions(DescribeAnalysisPermissionsRequest.Builder().apply(block).build())

/**
 * Provides a summary for a dashboard.
 */
public suspend inline fun QuickSightClient.describeDashboard(crossinline block: DescribeDashboardRequest.Builder.() -> Unit): DescribeDashboardResponse = describeDashboard(DescribeDashboardRequest.Builder().apply(block).build())

/**
 * Describes read and write permissions for a dashboard.
 */
public suspend inline fun QuickSightClient.describeDashboardPermissions(crossinline block: DescribeDashboardPermissionsRequest.Builder.() -> Unit): DescribeDashboardPermissionsResponse = describeDashboardPermissions(DescribeDashboardPermissionsRequest.Builder().apply(block).build())

/**
 * Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
 */
public suspend inline fun QuickSightClient.describeDataSet(crossinline block: DescribeDataSetRequest.Builder.() -> Unit): DescribeDataSetResponse = describeDataSet(DescribeDataSetRequest.Builder().apply(block).build())

/**
 * Describes the permissions on a dataset.
 *
 * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
 */
public suspend inline fun QuickSightClient.describeDataSetPermissions(crossinline block: DescribeDataSetPermissionsRequest.Builder.() -> Unit): DescribeDataSetPermissionsResponse = describeDataSetPermissions(DescribeDataSetPermissionsRequest.Builder().apply(block).build())

/**
 * Describes a data source.
 */
public suspend inline fun QuickSightClient.describeDataSource(crossinline block: DescribeDataSourceRequest.Builder.() -> Unit): DescribeDataSourceResponse = describeDataSource(DescribeDataSourceRequest.Builder().apply(block).build())

/**
 * Describes the resource permissions for a data source.
 */
public suspend inline fun QuickSightClient.describeDataSourcePermissions(crossinline block: DescribeDataSourcePermissionsRequest.Builder.() -> Unit): DescribeDataSourcePermissionsResponse = describeDataSourcePermissions(DescribeDataSourcePermissionsRequest.Builder().apply(block).build())

/**
 * Describes a folder.
 */
public suspend inline fun QuickSightClient.describeFolder(crossinline block: DescribeFolderRequest.Builder.() -> Unit): DescribeFolderResponse = describeFolder(DescribeFolderRequest.Builder().apply(block).build())

/**
 * Describes permissions for a folder.
 */
public suspend inline fun QuickSightClient.describeFolderPermissions(crossinline block: DescribeFolderPermissionsRequest.Builder.() -> Unit): DescribeFolderPermissionsResponse = describeFolderPermissions(DescribeFolderPermissionsRequest.Builder().apply(block).build())

/**
 * Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.
 */
public suspend inline fun QuickSightClient.describeFolderResolvedPermissions(crossinline block: DescribeFolderResolvedPermissionsRequest.Builder.() -> Unit): DescribeFolderResolvedPermissionsResponse = describeFolderResolvedPermissions(DescribeFolderResolvedPermissionsRequest.Builder().apply(block).build())

/**
 * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
 */
public suspend inline fun QuickSightClient.describeGroup(crossinline block: DescribeGroupRequest.Builder.() -> Unit): DescribeGroupResponse = describeGroup(DescribeGroupRequest.Builder().apply(block).build())

/**
 * Use the `DescribeGroupMembership` operation to determine if a user is a member of the specified group. If the user exists and is a member of the specified group, an associated `GroupMember` object is returned.
 */
public suspend inline fun QuickSightClient.describeGroupMembership(crossinline block: DescribeGroupMembershipRequest.Builder.() -> Unit): DescribeGroupMembershipResponse = describeGroupMembership(DescribeGroupMembershipRequest.Builder().apply(block).build())

/**
 * Describes an existing IAM policy assignment, as specified by the assignment name.
 */
public suspend inline fun QuickSightClient.describeIamPolicyAssignment(crossinline block: DescribeIamPolicyAssignmentRequest.Builder.() -> Unit): DescribeIamPolicyAssignmentResponse = describeIamPolicyAssignment(DescribeIamPolicyAssignmentRequest.Builder().apply(block).build())

/**
 * Describes a SPICE ingestion.
 */
public suspend inline fun QuickSightClient.describeIngestion(crossinline block: DescribeIngestionRequest.Builder.() -> Unit): DescribeIngestionResponse = describeIngestion(DescribeIngestionRequest.Builder().apply(block).build())

/**
 * Provides a summary and status of IP rules.
 */
public suspend inline fun QuickSightClient.describeIpRestriction(crossinline block: DescribeIpRestrictionRequest.Builder.() -> Unit): DescribeIpRestrictionResponse = describeIpRestriction(DescribeIpRestrictionRequest.Builder().apply(block).build())

/**
 * Describes the current namespace.
 */
public suspend inline fun QuickSightClient.describeNamespace(crossinline block: DescribeNamespaceRequest.Builder.() -> Unit): DescribeNamespaceResponse = describeNamespace(DescribeNamespaceRequest.Builder().apply(block).build())

/**
 * Describes a template's metadata.
 */
public suspend inline fun QuickSightClient.describeTemplate(crossinline block: DescribeTemplateRequest.Builder.() -> Unit): DescribeTemplateResponse = describeTemplate(DescribeTemplateRequest.Builder().apply(block).build())

/**
 * Describes the template alias for a template.
 */
public suspend inline fun QuickSightClient.describeTemplateAlias(crossinline block: DescribeTemplateAliasRequest.Builder.() -> Unit): DescribeTemplateAliasResponse = describeTemplateAlias(DescribeTemplateAliasRequest.Builder().apply(block).build())

/**
 * Describes read and write permissions on a template.
 */
public suspend inline fun QuickSightClient.describeTemplatePermissions(crossinline block: DescribeTemplatePermissionsRequest.Builder.() -> Unit): DescribeTemplatePermissionsResponse = describeTemplatePermissions(DescribeTemplatePermissionsRequest.Builder().apply(block).build())

/**
 * Describes a theme.
 */
public suspend inline fun QuickSightClient.describeTheme(crossinline block: DescribeThemeRequest.Builder.() -> Unit): DescribeThemeResponse = describeTheme(DescribeThemeRequest.Builder().apply(block).build())

/**
 * Describes the alias for a theme.
 */
public suspend inline fun QuickSightClient.describeThemeAlias(crossinline block: DescribeThemeAliasRequest.Builder.() -> Unit): DescribeThemeAliasResponse = describeThemeAlias(DescribeThemeAliasRequest.Builder().apply(block).build())

/**
 * Describes the read and write permissions for a theme.
 */
public suspend inline fun QuickSightClient.describeThemePermissions(crossinline block: DescribeThemePermissionsRequest.Builder.() -> Unit): DescribeThemePermissionsResponse = describeThemePermissions(DescribeThemePermissionsRequest.Builder().apply(block).build())

/**
 * Returns information about a user, given the user name.
 */
public suspend inline fun QuickSightClient.describeUser(crossinline block: DescribeUserRequest.Builder.() -> Unit): DescribeUserResponse = describeUser(DescribeUserRequest.Builder().apply(block).build())

/**
 * Generates an embed URL that you can use to embed an Amazon QuickSight dashboard or visual in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.
 *
 * The following rules apply to the generated URL:
 * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
 * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter. The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
 * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
 *
 * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
 *
 * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
 */
public suspend inline fun QuickSightClient.generateEmbedUrlForAnonymousUser(crossinline block: GenerateEmbedUrlForAnonymousUserRequest.Builder.() -> Unit): GenerateEmbedUrlForAnonymousUserResponse = generateEmbedUrlForAnonymousUser(GenerateEmbedUrlForAnonymousUserRequest.Builder().apply(block).build())

/**
 * Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
 *
 * The following rules apply to the generated URL:
 * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
 * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter.The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
 * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
 *
 * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
 *
 * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
 */
public suspend inline fun QuickSightClient.generateEmbedUrlForRegisteredUser(crossinline block: GenerateEmbedUrlForRegisteredUserRequest.Builder.() -> Unit): GenerateEmbedUrlForRegisteredUserResponse = generateEmbedUrlForRegisteredUser(GenerateEmbedUrlForRegisteredUserRequest.Builder().apply(block).build())

/**
 * Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you have configured the dashboards and permissions.
 *
 * Currently, you can use `GetDashboardEmbedURL` only from the server, not from the user's browser. The following rules apply to the generated URL:
 * + They must be used together.
 * + They can be used one time only.
 * + They are valid for 5 minutes after you run this command.
 * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
 * + The resulting user session is valid for 15 minutes (default) up to 10 hours (maximum). You can use the optional `SessionLifetimeInMinutes` parameter to customize session duration.
 *
 * For more information, see [Embedding Analytics Using GetDashboardEmbedUrl](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html) in the *Amazon QuickSight User Guide*.
 *
 * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
 */
public suspend inline fun QuickSightClient.getDashboardEmbedUrl(crossinline block: GetDashboardEmbedUrlRequest.Builder.() -> Unit): GetDashboardEmbedUrlResponse = getDashboardEmbedUrl(GetDashboardEmbedUrlRequest.Builder().apply(block).build())

/**
 * Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use `GetSessionEmbedUrl` where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> ` API operation. Use ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> ` API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the *Amazon QuickSight User Guide*:
 * + [Embedding Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
 * + [Customizing Access to the Amazon QuickSight Console](https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
 */
public suspend inline fun QuickSightClient.getSessionEmbedUrl(crossinline block: GetSessionEmbedUrlRequest.Builder.() -> Unit): GetSessionEmbedUrlResponse = getSessionEmbedUrl(GetSessionEmbedUrlRequest.Builder().apply(block).build())

/**
 * Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listAnalyses(crossinline block: ListAnalysesRequest.Builder.() -> Unit): ListAnalysesResponse = listAnalyses(ListAnalysesRequest.Builder().apply(block).build())

/**
 * Lists all the versions of the dashboards in the Amazon QuickSight subscription.
 */
public suspend inline fun QuickSightClient.listDashboardVersions(crossinline block: ListDashboardVersionsRequest.Builder.() -> Unit): ListDashboardVersionsResponse = listDashboardVersions(ListDashboardVersionsRequest.Builder().apply(block).build())

/**
 * Lists dashboards in an Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listDashboards(crossinline block: ListDashboardsRequest.Builder.() -> Unit): ListDashboardsResponse = listDashboards(ListDashboardsRequest.Builder().apply(block).build())

/**
 * Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
 *
 * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset&#47;*`.
 */
public suspend inline fun QuickSightClient.listDataSets(crossinline block: ListDataSetsRequest.Builder.() -> Unit): ListDataSetsResponse = listDataSets(ListDataSetsRequest.Builder().apply(block).build())

/**
 * Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listDataSources(crossinline block: ListDataSourcesRequest.Builder.() -> Unit): ListDataSourcesResponse = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * List all assets (`DASHBOARD`, `ANALYSIS`, and `DATASET`) in a folder.
 */
public suspend inline fun QuickSightClient.listFolderMembers(crossinline block: ListFolderMembersRequest.Builder.() -> Unit): ListFolderMembersResponse = listFolderMembers(ListFolderMembersRequest.Builder().apply(block).build())

/**
 * Lists all folders in an account.
 */
public suspend inline fun QuickSightClient.listFolders(crossinline block: ListFoldersRequest.Builder.() -> Unit): ListFoldersResponse = listFolders(ListFoldersRequest.Builder().apply(block).build())

/**
 * Lists member users in a group.
 */
public suspend inline fun QuickSightClient.listGroupMemberships(crossinline block: ListGroupMembershipsRequest.Builder.() -> Unit): ListGroupMembershipsResponse = listGroupMemberships(ListGroupMembershipsRequest.Builder().apply(block).build())

/**
 * Lists all user groups in Amazon QuickSight.
 */
public suspend inline fun QuickSightClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Lists IAM policy assignments in the current Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.listIamPolicyAssignments(crossinline block: ListIamPolicyAssignmentsRequest.Builder.() -> Unit): ListIamPolicyAssignmentsResponse = listIamPolicyAssignments(ListIamPolicyAssignmentsRequest.Builder().apply(block).build())

/**
 * Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to the specified user and group or groups that the user belongs to.
 */
public suspend inline fun QuickSightClient.listIamPolicyAssignmentsForUser(crossinline block: ListIamPolicyAssignmentsForUserRequest.Builder.() -> Unit): ListIamPolicyAssignmentsForUserResponse = listIamPolicyAssignmentsForUser(ListIamPolicyAssignmentsForUserRequest.Builder().apply(block).build())

/**
 * Lists the history of SPICE ingestions for a dataset.
 */
public suspend inline fun QuickSightClient.listIngestions(crossinline block: ListIngestionsRequest.Builder.() -> Unit): ListIngestionsResponse = listIngestions(ListIngestionsRequest.Builder().apply(block).build())

/**
 * Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted namespaces.
 */
public suspend inline fun QuickSightClient.listNamespaces(crossinline block: ListNamespacesRequest.Builder.() -> Unit): ListNamespacesResponse = listNamespaces(ListNamespacesRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to a resource.
 */
public suspend inline fun QuickSightClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all the aliases of a template.
 */
public suspend inline fun QuickSightClient.listTemplateAliases(crossinline block: ListTemplateAliasesRequest.Builder.() -> Unit): ListTemplateAliasesResponse = listTemplateAliases(ListTemplateAliasesRequest.Builder().apply(block).build())

/**
 * Lists all the versions of the templates in the current Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.listTemplateVersions(crossinline block: ListTemplateVersionsRequest.Builder.() -> Unit): ListTemplateVersionsResponse = listTemplateVersions(ListTemplateVersionsRequest.Builder().apply(block).build())

/**
 * Lists all the templates in the current Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.listTemplates(crossinline block: ListTemplatesRequest.Builder.() -> Unit): ListTemplatesResponse = listTemplates(ListTemplatesRequest.Builder().apply(block).build())

/**
 * Lists all the aliases of a theme.
 */
public suspend inline fun QuickSightClient.listThemeAliases(crossinline block: ListThemeAliasesRequest.Builder.() -> Unit): ListThemeAliasesResponse = listThemeAliases(ListThemeAliasesRequest.Builder().apply(block).build())

/**
 * Lists all the versions of the themes in the current Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listThemeVersions(crossinline block: ListThemeVersionsRequest.Builder.() -> Unit): ListThemeVersionsResponse = listThemeVersions(ListThemeVersionsRequest.Builder().apply(block).build())

/**
 * Lists all the themes in the current Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listThemes(crossinline block: ListThemesRequest.Builder.() -> Unit): ListThemesResponse = listThemes(ListThemesRequest.Builder().apply(block).build())

/**
 * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
 */
public suspend inline fun QuickSightClient.listUserGroups(crossinline block: ListUserGroupsRequest.Builder.() -> Unit): ListUserGroupsResponse = listUserGroups(ListUserGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of all of the Amazon QuickSight users belonging to this account.
 */
public suspend inline fun QuickSightClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Creates an Amazon QuickSight user, whose identity is associated with the Identity and Access Management (IAM) identity or role specified in the request.
 */
public suspend inline fun QuickSightClient.registerUser(crossinline block: RegisterUserRequest.Builder.() -> Unit): RegisterUserResponse = registerUser(RegisterUserRequest.Builder().apply(block).build())

/**
 * Restores an analysis.
 */
public suspend inline fun QuickSightClient.restoreAnalysis(crossinline block: RestoreAnalysisRequest.Builder.() -> Unit): RestoreAnalysisResponse = restoreAnalysis(RestoreAnalysisRequest.Builder().apply(block).build())

/**
 * Searches for analyses that belong to the user specified in the filter.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun QuickSightClient.searchAnalyses(crossinline block: SearchAnalysesRequest.Builder.() -> Unit): SearchAnalysesResponse = searchAnalyses(SearchAnalysesRequest.Builder().apply(block).build())

/**
 * Searches for dashboards that belong to a user.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun QuickSightClient.searchDashboards(crossinline block: SearchDashboardsRequest.Builder.() -> Unit): SearchDashboardsResponse = searchDashboards(SearchDashboardsRequest.Builder().apply(block).build())

/**
 * Searches the subfolders in a folder.
 */
public suspend inline fun QuickSightClient.searchFolders(crossinline block: SearchFoldersRequest.Builder.() -> Unit): SearchFoldersResponse = searchFolders(SearchFoldersRequest.Builder().apply(block).build())

/**
 * Use the `SearchGroups` operation to search groups in a specified Amazon QuickSight namespace using the supplied filters.
 */
public suspend inline fun QuickSightClient.searchGroups(crossinline block: SearchGroupsRequest.Builder.() -> Unit): SearchGroupsResponse = searchGroups(SearchGroupsRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource.
 *
 * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the `TagResource` operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data source, dashboard, and template.
 *
 * Tagging for Amazon QuickSight works in a similar way to tagging for other Amazon Web Services services, except for the following:
 * + You can't use tags to track costs for Amazon QuickSight. This isn't possible because you can't tag the resources that Amazon QuickSight costs are based on, for example Amazon QuickSight storage capacity (SPICE), number of users, type of users, and usage metrics.
 * + Amazon QuickSight doesn't currently support the tag editor for Resource Groups.
 */
public suspend inline fun QuickSightClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag or tags from a resource.
 */
public suspend inline fun QuickSightClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, the only customization that you can use is a theme.
 *
 * You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
 */
public suspend inline fun QuickSightClient.updateAccountCustomization(crossinline block: UpdateAccountCustomizationRequest.Builder.() -> Unit): UpdateAccountCustomizationResponse = updateAccountCustomization(UpdateAccountCustomizationRequest.Builder().apply(block).build())

/**
 * Updates the Amazon QuickSight settings in your Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Updates an analysis in Amazon QuickSight
 */
public suspend inline fun QuickSightClient.updateAnalysis(crossinline block: UpdateAnalysisRequest.Builder.() -> Unit): UpdateAnalysisResponse = updateAnalysis(UpdateAnalysisRequest.Builder().apply(block).build())

/**
 * Updates the read and write permissions for an analysis.
 */
public suspend inline fun QuickSightClient.updateAnalysisPermissions(crossinline block: UpdateAnalysisPermissionsRequest.Builder.() -> Unit): UpdateAnalysisPermissionsResponse = updateAnalysisPermissions(UpdateAnalysisPermissionsRequest.Builder().apply(block).build())

/**
 * Updates a dashboard in an Amazon Web Services account.
 *
 * Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can update the published version of a dashboard by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html">UpdateDashboardPublishedVersion</a> ` API operation.
 */
public suspend inline fun QuickSightClient.updateDashboard(crossinline block: UpdateDashboardRequest.Builder.() -> Unit): UpdateDashboardResponse = updateDashboard(UpdateDashboardRequest.Builder().apply(block).build())

/**
 * Updates read and write permissions on a dashboard.
 */
public suspend inline fun QuickSightClient.updateDashboardPermissions(crossinline block: UpdateDashboardPermissionsRequest.Builder.() -> Unit): UpdateDashboardPermissionsResponse = updateDashboardPermissions(UpdateDashboardPermissionsRequest.Builder().apply(block).build())

/**
 * Updates the published version of a dashboard.
 */
public suspend inline fun QuickSightClient.updateDashboardPublishedVersion(crossinline block: UpdateDashboardPublishedVersionRequest.Builder.() -> Unit): UpdateDashboardPublishedVersionResponse = updateDashboardPublishedVersion(UpdateDashboardPublishedVersionRequest.Builder().apply(block).build())

/**
 * Updates a dataset. This operation doesn't support datasets that include uploaded files as a source.
 */
public suspend inline fun QuickSightClient.updateDataSet(crossinline block: UpdateDataSetRequest.Builder.() -> Unit): UpdateDataSetResponse = updateDataSet(UpdateDataSetRequest.Builder().apply(block).build())

/**
 * Updates the permissions on a dataset.
 *
 * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
 */
public suspend inline fun QuickSightClient.updateDataSetPermissions(crossinline block: UpdateDataSetPermissionsRequest.Builder.() -> Unit): UpdateDataSetPermissionsResponse = updateDataSetPermissions(UpdateDataSetPermissionsRequest.Builder().apply(block).build())

/**
 * Updates a data source.
 */
public suspend inline fun QuickSightClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates the permissions to a data source.
 */
public suspend inline fun QuickSightClient.updateDataSourcePermissions(crossinline block: UpdateDataSourcePermissionsRequest.Builder.() -> Unit): UpdateDataSourcePermissionsResponse = updateDataSourcePermissions(UpdateDataSourcePermissionsRequest.Builder().apply(block).build())

/**
 * Updates the name of a folder.
 */
public suspend inline fun QuickSightClient.updateFolder(crossinline block: UpdateFolderRequest.Builder.() -> Unit): UpdateFolderResponse = updateFolder(UpdateFolderRequest.Builder().apply(block).build())

/**
 * Updates permissions of a folder.
 */
public suspend inline fun QuickSightClient.updateFolderPermissions(crossinline block: UpdateFolderPermissionsRequest.Builder.() -> Unit): UpdateFolderPermissionsResponse = updateFolderPermissions(UpdateFolderPermissionsRequest.Builder().apply(block).build())

/**
 * Changes a group description.
 */
public suspend inline fun QuickSightClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in `Identities`.
 */
public suspend inline fun QuickSightClient.updateIamPolicyAssignment(crossinline block: UpdateIamPolicyAssignmentRequest.Builder.() -> Unit): UpdateIamPolicyAssignmentResponse = updateIamPolicyAssignment(UpdateIamPolicyAssignmentRequest.Builder().apply(block).build())

/**
 * Updates the content and status of IP rules. To use this operation, you need to provide the entire map of rules. You can use the `DescribeIpRestriction` operation to get the current rule map.
 */
public suspend inline fun QuickSightClient.updateIpRestriction(crossinline block: UpdateIpRestrictionRequest.Builder.() -> Unit): UpdateIpRestrictionResponse = updateIpRestriction(UpdateIpRestrictionRequest.Builder().apply(block).build())

/**
 * Use the `UpdatePublicSharingSettings` operation to turn on or turn off the public sharing settings of an Amazon QuickSight dashboard.
 *
 * To use this operation, turn on session capacity pricing for your Amazon QuickSight account.
 *
 * Before you can turn on public sharing on your account, make sure to give public sharing permissions to an administrative user in the Identity and Access Management (IAM) console. For more information on using IAM with Amazon QuickSight, see [Using Amazon QuickSight with IAM](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html) in the *Amazon QuickSight User Guide*.
 */
public suspend inline fun QuickSightClient.updatePublicSharingSettings(crossinline block: UpdatePublicSharingSettingsRequest.Builder.() -> Unit): UpdatePublicSharingSettingsResponse = updatePublicSharingSettings(UpdatePublicSharingSettingsRequest.Builder().apply(block).build())

/**
 * Updates a template from an existing Amazon QuickSight analysis or another template.
 */
public suspend inline fun QuickSightClient.updateTemplate(crossinline block: UpdateTemplateRequest.Builder.() -> Unit): UpdateTemplateResponse = updateTemplate(UpdateTemplateRequest.Builder().apply(block).build())

/**
 * Updates the template alias of a template.
 */
public suspend inline fun QuickSightClient.updateTemplateAlias(crossinline block: UpdateTemplateAliasRequest.Builder.() -> Unit): UpdateTemplateAliasResponse = updateTemplateAlias(UpdateTemplateAliasRequest.Builder().apply(block).build())

/**
 * Updates the resource permissions for a template.
 */
public suspend inline fun QuickSightClient.updateTemplatePermissions(crossinline block: UpdateTemplatePermissionsRequest.Builder.() -> Unit): UpdateTemplatePermissionsResponse = updateTemplatePermissions(UpdateTemplatePermissionsRequest.Builder().apply(block).build())

/**
 * Updates a theme.
 */
public suspend inline fun QuickSightClient.updateTheme(crossinline block: UpdateThemeRequest.Builder.() -> Unit): UpdateThemeResponse = updateTheme(UpdateThemeRequest.Builder().apply(block).build())

/**
 * Updates an alias of a theme.
 */
public suspend inline fun QuickSightClient.updateThemeAlias(crossinline block: UpdateThemeAliasRequest.Builder.() -> Unit): UpdateThemeAliasResponse = updateThemeAlias(UpdateThemeAliasRequest.Builder().apply(block).build())

/**
 * Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example `"quicksight:DescribeTheme"`.
 *
 * Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions:
 * + User
 *    + `"quicksight:DescribeTheme"`
 *    + `"quicksight:DescribeThemeAlias"`
 *    + `"quicksight:ListThemeAliases"`
 *    + `"quicksight:ListThemeVersions"`
 * + Owner
 *    + `"quicksight:DescribeTheme"`
 *    + `"quicksight:DescribeThemeAlias"`
 *    + `"quicksight:ListThemeAliases"`
 *    + `"quicksight:ListThemeVersions"`
 *    + `"quicksight:DeleteTheme"`
 *    + `"quicksight:UpdateTheme"`
 *    + `"quicksight:CreateThemeAlias"`
 *    + `"quicksight:DeleteThemeAlias"`
 *    + `"quicksight:UpdateThemeAlias"`
 *    + `"quicksight:UpdateThemePermissions"`
 *    + `"quicksight:DescribeThemePermissions"`
 * + To specify no permissions, omit the permissions list.
 */
public suspend inline fun QuickSightClient.updateThemePermissions(crossinline block: UpdateThemePermissionsRequest.Builder.() -> Unit): UpdateThemePermissionsResponse = updateThemePermissions(UpdateThemePermissionsRequest.Builder().apply(block).build())

/**
 * Updates an Amazon QuickSight user.
 */
public suspend inline fun QuickSightClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())
