// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



/**
 * A structure that contains the following account information elements:
 * + Your Amazon QuickSight account name.
 * + The edition of Amazon QuickSight that your account is using.
 * + The notification email address that is associated with the Amazon QuickSight account.
 * + The authentication type of the Amazon QuickSight account.
 * + The status of the Amazon QuickSight account's subscription.
 */
public class AccountInfo private constructor(builder: Builder) {
    /**
     * The account name that you provided for the Amazon QuickSight subscription in your Amazon Web Services account. You create this name when you sign up for Amazon QuickSight. It's unique over all of Amazon Web Services, and it appears only when users sign in.
     */
    public val accountName: kotlin.String? = builder.accountName
    /**
     * The status of your account subscription.
     */
    public val accountSubscriptionStatus: kotlin.String? = builder.accountSubscriptionStatus
    /**
     * The way that your Amazon QuickSight account is authenticated.
     */
    public val authenticationType: kotlin.String? = builder.authenticationType
    /**
     * The edition of your Amazon QuickSight account.
     */
    public val edition: aws.sdk.kotlin.services.quicksight.model.Edition? = builder.edition
    /**
     * The email address that will be used for Amazon QuickSight to send notifications regarding your Amazon Web Services account or Amazon QuickSight subscription.
     */
    public val notificationEmail: kotlin.String? = builder.notificationEmail

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.AccountInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountInfo(")
        append("accountName=$accountName,")
        append("accountSubscriptionStatus=$accountSubscriptionStatus,")
        append("authenticationType=$authenticationType,")
        append("edition=$edition,")
        append("notificationEmail=$notificationEmail)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountName?.hashCode() ?: 0
        result = 31 * result + (accountSubscriptionStatus?.hashCode() ?: 0)
        result = 31 * result + (authenticationType?.hashCode() ?: 0)
        result = 31 * result + (edition?.hashCode() ?: 0)
        result = 31 * result + (notificationEmail?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountInfo

        if (accountName != other.accountName) return false
        if (accountSubscriptionStatus != other.accountSubscriptionStatus) return false
        if (authenticationType != other.authenticationType) return false
        if (edition != other.edition) return false
        if (notificationEmail != other.notificationEmail) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.AccountInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The account name that you provided for the Amazon QuickSight subscription in your Amazon Web Services account. You create this name when you sign up for Amazon QuickSight. It's unique over all of Amazon Web Services, and it appears only when users sign in.
         */
        public var accountName: kotlin.String? = null
        /**
         * The status of your account subscription.
         */
        public var accountSubscriptionStatus: kotlin.String? = null
        /**
         * The way that your Amazon QuickSight account is authenticated.
         */
        public var authenticationType: kotlin.String? = null
        /**
         * The edition of your Amazon QuickSight account.
         */
        public var edition: aws.sdk.kotlin.services.quicksight.model.Edition? = null
        /**
         * The email address that will be used for Amazon QuickSight to send notifications regarding your Amazon Web Services account or Amazon QuickSight subscription.
         */
        public var notificationEmail: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.AccountInfo) : this() {
            this.accountName = x.accountName
            this.accountSubscriptionStatus = x.accountSubscriptionStatus
            this.authenticationType = x.authenticationType
            this.edition = x.edition
            this.notificationEmail = x.notificationEmail
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.AccountInfo = AccountInfo(this)
    }
}
