// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Metadata structure for an analysis in Amazon QuickSight
 */
public class Analysis private constructor(builder: Builder) {
    /**
     * The ID of the analysis.
     */
    public val analysisId: kotlin.String? = builder.analysisId
    /**
     * The Amazon Resource Name (ARN) of the analysis.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time that the analysis was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The ARNs of the datasets of the analysis.
     */
    public val dataSetArns: List<String>? = builder.dataSetArns
    /**
     * Errors associated with the analysis.
     */
    public val errors: List<AnalysisError>? = builder.errors
    /**
     * The time that the analysis was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The descriptive name of the analysis.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of the associated sheets with the unique identifier and name of each sheet.
     */
    public val sheets: List<Sheet>? = builder.sheets
    /**
     * Status associated with the analysis.
     */
    public val status: aws.sdk.kotlin.services.quicksight.model.ResourceStatus? = builder.status
    /**
     * The ARN of the theme of the analysis.
     */
    public val themeArn: kotlin.String? = builder.themeArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.Analysis = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Analysis(")
        append("analysisId=$analysisId,")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("dataSetArns=$dataSetArns,")
        append("errors=$errors,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("sheets=$sheets,")
        append("status=$status,")
        append("themeArn=$themeArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dataSetArns?.hashCode() ?: 0)
        result = 31 * result + (errors?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sheets?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (themeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Analysis

        if (analysisId != other.analysisId) return false
        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (dataSetArns != other.dataSetArns) return false
        if (errors != other.errors) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (sheets != other.sheets) return false
        if (status != other.status) return false
        if (themeArn != other.themeArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.Analysis = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the analysis.
         */
        public var analysisId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the analysis.
         */
        public var arn: kotlin.String? = null
        /**
         * The time that the analysis was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARNs of the datasets of the analysis.
         */
        public var dataSetArns: List<String>? = null
        /**
         * Errors associated with the analysis.
         */
        public var errors: List<AnalysisError>? = null
        /**
         * The time that the analysis was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The descriptive name of the analysis.
         */
        public var name: kotlin.String? = null
        /**
         * A list of the associated sheets with the unique identifier and name of each sheet.
         */
        public var sheets: List<Sheet>? = null
        /**
         * Status associated with the analysis.
         */
        public var status: aws.sdk.kotlin.services.quicksight.model.ResourceStatus? = null
        /**
         * The ARN of the theme of the analysis.
         */
        public var themeArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.Analysis) : this() {
            this.analysisId = x.analysisId
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.dataSetArns = x.dataSetArns
            this.errors = x.errors
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.sheets = x.sheets
            this.status = x.status
            this.themeArn = x.themeArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.Analysis = Analysis(this)
    }
}
