// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class CreateAccountSubscriptionRequest private constructor(builder: Builder) {
    /**
     * The name of your Amazon QuickSight account. This name is unique over all of Amazon Web Services, and it appears only when users sign in. You can't change `AccountName` value after the Amazon QuickSight account is created.
     */
    public val accountName: kotlin.String? = builder.accountName
    /**
     * The name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    public val activeDirectoryName: kotlin.String? = builder.activeDirectoryName
    /**
     * The admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
     */
    public val adminGroup: List<String>? = builder.adminGroup
    /**
     * The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, and `ACTIVE_DIRECTORY`.
     *
     * If you choose `ACTIVE_DIRECTORY`, provide an `ActiveDirectoryName` and an `AdminGroup` associated with your Active Directory.
     */
    public val authenticationMethod: aws.sdk.kotlin.services.quicksight.model.AuthenticationMethodOption? = builder.authenticationMethod
    /**
     * The author group associated with your Active Directory. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
     */
    public val authorGroup: List<String>? = builder.authorGroup
    /**
     * The Amazon Web Services account ID of the account that you're using to create your Amazon QuickSight account.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val contactNumber: kotlin.String? = builder.contactNumber
    /**
     * The ID of the Active Directory that is associated with your Amazon QuickSight account.
     */
    public val directoryId: kotlin.String? = builder.directoryId
    /**
     * The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `ENTERPRISE` or `ENTERPRISE_AND_Q`.
     *
     * If you choose `ENTERPRISE_AND_Q`, the following parameters are required:
     * + `FirstName`
     * + `LastName`
     * + `EmailAddress`
     * + `ContactNumber`
     */
    public val edition: aws.sdk.kotlin.services.quicksight.model.Edition? = builder.edition
    /**
     * The email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val emailAddress: kotlin.String? = builder.emailAddress
    /**
     * The first name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val firstName: kotlin.String? = builder.firstName
    /**
     * The last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
     */
    public val lastName: kotlin.String? = builder.lastName
    /**
     * The email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
     */
    public val notificationEmail: kotlin.String? = builder.notificationEmail
    /**
     * The reader group associated with your Active Direcrtory. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the *Amazon QuickSight User Guide*.
     */
    public val readerGroup: List<String>? = builder.readerGroup
    /**
     * The realm of the Active Directory that is associated with your Amazon QuickSight account. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
     */
    public val realm: kotlin.String? = builder.realm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccountSubscriptionRequest(")
        append("accountName=$accountName,")
        append("activeDirectoryName=$activeDirectoryName,")
        append("adminGroup=$adminGroup,")
        append("authenticationMethod=$authenticationMethod,")
        append("authorGroup=$authorGroup,")
        append("awsAccountId=$awsAccountId,")
        append("contactNumber=$contactNumber,")
        append("directoryId=$directoryId,")
        append("edition=$edition,")
        append("emailAddress=$emailAddress,")
        append("firstName=$firstName,")
        append("lastName=$lastName,")
        append("notificationEmail=$notificationEmail,")
        append("readerGroup=$readerGroup,")
        append("realm=$realm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountName?.hashCode() ?: 0
        result = 31 * result + (activeDirectoryName?.hashCode() ?: 0)
        result = 31 * result + (adminGroup?.hashCode() ?: 0)
        result = 31 * result + (authenticationMethod?.hashCode() ?: 0)
        result = 31 * result + (authorGroup?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (contactNumber?.hashCode() ?: 0)
        result = 31 * result + (directoryId?.hashCode() ?: 0)
        result = 31 * result + (edition?.hashCode() ?: 0)
        result = 31 * result + (emailAddress?.hashCode() ?: 0)
        result = 31 * result + (firstName?.hashCode() ?: 0)
        result = 31 * result + (lastName?.hashCode() ?: 0)
        result = 31 * result + (notificationEmail?.hashCode() ?: 0)
        result = 31 * result + (readerGroup?.hashCode() ?: 0)
        result = 31 * result + (realm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccountSubscriptionRequest

        if (accountName != other.accountName) return false
        if (activeDirectoryName != other.activeDirectoryName) return false
        if (adminGroup != other.adminGroup) return false
        if (authenticationMethod != other.authenticationMethod) return false
        if (authorGroup != other.authorGroup) return false
        if (awsAccountId != other.awsAccountId) return false
        if (contactNumber != other.contactNumber) return false
        if (directoryId != other.directoryId) return false
        if (edition != other.edition) return false
        if (emailAddress != other.emailAddress) return false
        if (firstName != other.firstName) return false
        if (lastName != other.lastName) return false
        if (notificationEmail != other.notificationEmail) return false
        if (readerGroup != other.readerGroup) return false
        if (realm != other.realm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of your Amazon QuickSight account. This name is unique over all of Amazon Web Services, and it appears only when users sign in. You can't change `AccountName` value after the Amazon QuickSight account is created.
         */
        public var accountName: kotlin.String? = null
        /**
         * The name of your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
         */
        public var activeDirectoryName: kotlin.String? = null
        /**
         * The admin group associated with your Active Directory. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
         */
        public var adminGroup: List<String>? = null
        /**
         * The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for this parameter are `IAM_AND_QUICKSIGHT`, `IAM_ONLY`, and `ACTIVE_DIRECTORY`.
         *
         * If you choose `ACTIVE_DIRECTORY`, provide an `ActiveDirectoryName` and an `AdminGroup` associated with your Active Directory.
         */
        public var authenticationMethod: aws.sdk.kotlin.services.quicksight.model.AuthenticationMethodOption? = null
        /**
         * The author group associated with your Active Directory. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the Amazon QuickSight User Guide.
         */
        public var authorGroup: List<String>? = null
        /**
         * The Amazon Web Services account ID of the account that you're using to create your Amazon QuickSight account.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
         */
        public var contactNumber: kotlin.String? = null
        /**
         * The ID of the Active Directory that is associated with your Amazon QuickSight account.
         */
        public var directoryId: kotlin.String? = null
        /**
         * The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from `ENTERPRISE` or `ENTERPRISE_AND_Q`.
         *
         * If you choose `ENTERPRISE_AND_Q`, the following parameters are required:
         * + `FirstName`
         * + `LastName`
         * + `EmailAddress`
         * + `ContactNumber`
         */
        public var edition: aws.sdk.kotlin.services.quicksight.model.Edition? = null
        /**
         * The email address of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
         */
        public var emailAddress: kotlin.String? = null
        /**
         * The first name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
         */
        public var firstName: kotlin.String? = null
        /**
         * The last name of the author of the Amazon QuickSight account to use for future communications. This field is required if `ENTERPPRISE_AND_Q` is the selected edition of the new Amazon QuickSight account.
         */
        public var lastName: kotlin.String? = null
        /**
         * The email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight account or Amazon QuickSight subscription.
         */
        public var notificationEmail: kotlin.String? = null
        /**
         * The reader group associated with your Active Direcrtory. For more information about using Active Directory in Amazon QuickSight, see [Using Active Directory with Amazon QuickSight Enterprise Edition](https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html) in the *Amazon QuickSight User Guide*.
         */
        public var readerGroup: List<String>? = null
        /**
         * The realm of the Active Directory that is associated with your Amazon QuickSight account. This field is required if `ACTIVE_DIRECTORY` is the selected authentication method of the new Amazon QuickSight account.
         */
        public var realm: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest) : this() {
            this.accountName = x.accountName
            this.activeDirectoryName = x.activeDirectoryName
            this.adminGroup = x.adminGroup
            this.authenticationMethod = x.authenticationMethod
            this.authorGroup = x.authorGroup
            this.awsAccountId = x.awsAccountId
            this.contactNumber = x.contactNumber
            this.directoryId = x.directoryId
            this.edition = x.edition
            this.emailAddress = x.emailAddress
            this.firstName = x.firstName
            this.lastName = x.lastName
            this.notificationEmail = x.notificationEmail
            this.readerGroup = x.readerGroup
            this.realm = x.realm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest = CreateAccountSubscriptionRequest(this)
    }
}
