// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class CreateAnalysisRequest private constructor(builder: Builder) {
    /**
     * The ID for the analysis that you're creating. This ID displays in the URL of the analysis.
     */
    public val analysisId: kotlin.String? = requireNotNull(builder.analysisId) { "A non-null value must be provided for analysisId" }
    /**
     * The ID of the Amazon Web Services account where you are creating an analysis.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * A descriptive name for the analysis that you're creating. This name displays for the analysis in the Amazon QuickSight console.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values.
     */
    public val parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = builder.parameters
    /**
     * A structure that describes the principals and the resource-level permissions on an analysis. You can use the `Permissions` structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
     *
     * To specify no permissions, omit `Permissions`.
     */
    public val permissions: List<ResourcePermission>? = builder.permissions
    /**
     * A source entity to use for the analysis that you're creating. This metadata structure contains details that describe a source template and one or more datasets.
     */
    public val sourceEntity: aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity? = builder.sourceEntity
    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ARN for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.
     */
    public val themeArn: kotlin.String? = builder.themeArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateAnalysisRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAnalysisRequest(")
        append("analysisId=$analysisId,")
        append("awsAccountId=$awsAccountId,")
        append("name=$name,")
        append("parameters=$parameters,")
        append("permissions=$permissions,")
        append("sourceEntity=$sourceEntity,")
        append("tags=$tags,")
        append("themeArn=$themeArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisId?.hashCode() ?: 0
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (sourceEntity?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (themeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAnalysisRequest

        if (analysisId != other.analysisId) return false
        if (awsAccountId != other.awsAccountId) return false
        if (name != other.name) return false
        if (parameters != other.parameters) return false
        if (permissions != other.permissions) return false
        if (sourceEntity != other.sourceEntity) return false
        if (tags != other.tags) return false
        if (themeArn != other.themeArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateAnalysisRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the analysis that you're creating. This ID displays in the URL of the analysis.
         */
        public var analysisId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account where you are creating an analysis.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * A descriptive name for the analysis that you're creating. This name displays for the analysis in the Amazon QuickSight console.
         */
        public var name: kotlin.String? = null
        /**
         * The parameter names and override values that you want to use. An analysis can have any parameter type, and some parameters might accept multiple values.
         */
        public var parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = null
        /**
         * A structure that describes the principals and the resource-level permissions on an analysis. You can use the `Permissions` structure to grant permissions by providing a list of Identity and Access Management (IAM) action information for each principal listed by Amazon Resource Name (ARN).
         *
         * To specify no permissions, omit `Permissions`.
         */
        public var permissions: List<ResourcePermission>? = null
        /**
         * A source entity to use for the analysis that you're creating. This metadata structure contains details that describe a source template and one or more datasets.
         */
        public var sourceEntity: aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity? = null
        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the analysis.
         */
        public var tags: List<Tag>? = null
        /**
         * The ARN for the theme to apply to the analysis that you're creating. To see the theme in the Amazon QuickSight console, make sure that you have access to it.
         */
        public var themeArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateAnalysisRequest) : this() {
            this.analysisId = x.analysisId
            this.awsAccountId = x.awsAccountId
            this.name = x.name
            this.parameters = x.parameters
            this.permissions = x.permissions
            this.sourceEntity = x.sourceEntity
            this.tags = x.tags
            this.themeArn = x.themeArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateAnalysisRequest = CreateAnalysisRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.Parameters] inside the given [block]
         */
        public fun parameters(block: aws.sdk.kotlin.services.quicksight.model.Parameters.Builder.() -> kotlin.Unit) {
            this.parameters = aws.sdk.kotlin.services.quicksight.model.Parameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity] inside the given [block]
         */
        public fun sourceEntity(block: aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity.Builder.() -> kotlin.Unit) {
            this.sourceEntity = aws.sdk.kotlin.services.quicksight.model.AnalysisSourceEntity.invoke(block)
        }
    }
}
