// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class CreateDataSourceRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.
     */
    public val credentials: aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials? = builder.credentials
    /**
     * An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
     */
    public val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * The parameters that Amazon QuickSight uses to connect to your underlying source.
     */
    public val dataSourceParameters: aws.sdk.kotlin.services.quicksight.model.DataSourceParameters? = builder.dataSourceParameters
    /**
     * A display name for the data source.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of resource permissions on the data source.
     */
    public val permissions: List<ResourcePermission>? = builder.permissions
    /**
     * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
     */
    public val sslProperties: aws.sdk.kotlin.services.quicksight.model.SslProperties? = builder.sslProperties
    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The type of the data source. To return a list of all data sources, use `ListDataSources`.
     *
     * Use `AMAZON_ELASTICSEARCH` for Amazon OpenSearch Service.
     */
    public val type: aws.sdk.kotlin.services.quicksight.model.DataSourceType? = builder.type
    /**
     * Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
     */
    public val vpcConnectionProperties: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties? = builder.vpcConnectionProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateDataSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataSourceRequest(")
        append("awsAccountId=$awsAccountId,")
        append("credentials=*** Sensitive Data Redacted ***,")
        append("dataSourceId=$dataSourceId,")
        append("dataSourceParameters=$dataSourceParameters,")
        append("name=$name,")
        append("permissions=$permissions,")
        append("sslProperties=$sslProperties,")
        append("tags=$tags,")
        append("type=$type,")
        append("vpcConnectionProperties=$vpcConnectionProperties)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (dataSourceParameters?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (sslProperties?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcConnectionProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataSourceRequest

        if (awsAccountId != other.awsAccountId) return false
        if (credentials != other.credentials) return false
        if (dataSourceId != other.dataSourceId) return false
        if (dataSourceParameters != other.dataSourceParameters) return false
        if (name != other.name) return false
        if (permissions != other.permissions) return false
        if (sslProperties != other.sslProperties) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (vpcConnectionProperties != other.vpcConnectionProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateDataSourceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The credentials Amazon QuickSight that uses to connect to your underlying source. Currently, only credentials based on user name and password are supported.
         */
        public var credentials: aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials? = null
        /**
         * An ID for the data source. This ID is unique per Amazon Web Services Region for each Amazon Web Services account.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The parameters that Amazon QuickSight uses to connect to your underlying source.
         */
        public var dataSourceParameters: aws.sdk.kotlin.services.quicksight.model.DataSourceParameters? = null
        /**
         * A display name for the data source.
         */
        public var name: kotlin.String? = null
        /**
         * A list of resource permissions on the data source.
         */
        public var permissions: List<ResourcePermission>? = null
        /**
         * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source.
         */
        public var sslProperties: aws.sdk.kotlin.services.quicksight.model.SslProperties? = null
        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
         */
        public var tags: List<Tag>? = null
        /**
         * The type of the data source. To return a list of all data sources, use `ListDataSources`.
         *
         * Use `AMAZON_ELASTICSEARCH` for Amazon OpenSearch Service.
         */
        public var type: aws.sdk.kotlin.services.quicksight.model.DataSourceType? = null
        /**
         * Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source.
         */
        public var vpcConnectionProperties: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateDataSourceRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.credentials = x.credentials
            this.dataSourceId = x.dataSourceId
            this.dataSourceParameters = x.dataSourceParameters
            this.name = x.name
            this.permissions = x.permissions
            this.sslProperties = x.sslProperties
            this.tags = x.tags
            this.type = x.type
            this.vpcConnectionProperties = x.vpcConnectionProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateDataSourceRequest = CreateDataSourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials] inside the given [block]
         */
        public fun credentials(block: aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SslProperties] inside the given [block]
         */
        public fun sslProperties(block: aws.sdk.kotlin.services.quicksight.model.SslProperties.Builder.() -> kotlin.Unit) {
            this.sslProperties = aws.sdk.kotlin.services.quicksight.model.SslProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties] inside the given [block]
         */
        public fun vpcConnectionProperties(block: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties.Builder.() -> kotlin.Unit) {
            this.vpcConnectionProperties = aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties.invoke(block)
        }
    }
}
