// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class CreateIamPolicyAssignmentRequest private constructor(builder: Builder) {
    /**
     * The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.
     */
    public val assignmentName: kotlin.String? = builder.assignmentName
    /**
     * The status of the assignment. Possible values are as follows:
     * + `ENABLED` - Anything specified in this assignment is used when creating the data source.
     * + `DISABLED` - This assignment isn't used when creating the data source.
     * + `DRAFT` - This assignment is an unfinished draft and isn't used when creating the data source.
     */
    public val assignmentStatus: aws.sdk.kotlin.services.quicksight.model.AssignmentStatus? = builder.assignmentStatus
    /**
     * The ID of the Amazon Web Services account where you want to assign an IAM policy to Amazon QuickSight users or groups.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The Amazon QuickSight users, groups, or both that you want to assign the policy to.
     */
    public val identities: Map<String, List<String>>? = builder.identities
    /**
     * The namespace that contains the assignment.
     */
    public val namespace: kotlin.String? = requireNotNull(builder.namespace) { "A non-null value must be provided for namespace" }
    /**
     * The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
     */
    public val policyArn: kotlin.String? = builder.policyArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateIamPolicyAssignmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIamPolicyAssignmentRequest(")
        append("assignmentName=$assignmentName,")
        append("assignmentStatus=$assignmentStatus,")
        append("awsAccountId=$awsAccountId,")
        append("identities=$identities,")
        append("namespace=$namespace,")
        append("policyArn=$policyArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assignmentName?.hashCode() ?: 0
        result = 31 * result + (assignmentStatus?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (identities?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIamPolicyAssignmentRequest

        if (assignmentName != other.assignmentName) return false
        if (assignmentStatus != other.assignmentStatus) return false
        if (awsAccountId != other.awsAccountId) return false
        if (identities != other.identities) return false
        if (namespace != other.namespace) return false
        if (policyArn != other.policyArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateIamPolicyAssignmentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account.
         */
        public var assignmentName: kotlin.String? = null
        /**
         * The status of the assignment. Possible values are as follows:
         * + `ENABLED` - Anything specified in this assignment is used when creating the data source.
         * + `DISABLED` - This assignment isn't used when creating the data source.
         * + `DRAFT` - This assignment is an unfinished draft and isn't used when creating the data source.
         */
        public var assignmentStatus: aws.sdk.kotlin.services.quicksight.model.AssignmentStatus? = null
        /**
         * The ID of the Amazon Web Services account where you want to assign an IAM policy to Amazon QuickSight users or groups.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon QuickSight users, groups, or both that you want to assign the policy to.
         */
        public var identities: Map<String, List<String>>? = null
        /**
         * The namespace that contains the assignment.
         */
        public var namespace: kotlin.String? = null
        /**
         * The ARN for the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
         */
        public var policyArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateIamPolicyAssignmentRequest) : this() {
            this.assignmentName = x.assignmentName
            this.assignmentStatus = x.assignmentStatus
            this.awsAccountId = x.awsAccountId
            this.identities = x.identities
            this.namespace = x.namespace
            this.policyArn = x.policyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateIamPolicyAssignmentRequest = CreateIamPolicyAssignmentRequest(this)
    }
}
