// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class CreateTemplateRequest private constructor(builder: Builder) {
    /**
     * The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * A display name for the template.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of resource permissions to be set on the template.
     */
    public val permissions: List<ResourcePermission>? = builder.permissions
    /**
     * The entity that you are using as a source when you create the template. In `SourceEntity`, you specify the type of object you're using as source: `SourceTemplate` for a template or `SourceAnalysis` for an analysis. Both of these require an Amazon Resource Name (ARN). For `SourceTemplate`, specify the ARN of the source template. For `SourceAnalysis`, specify the ARN of the source analysis. The `SourceTemplate` ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region.
     *
     * Use the `DataSetReferences` entity within `SourceTemplate` or `SourceAnalysis` to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     */
    public val sourceEntity: aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity? = builder.sourceEntity
    /**
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each Amazon Web Services account.
     */
    public val templateId: kotlin.String? = requireNotNull(builder.templateId) { "A non-null value must be provided for templateId" }
    /**
     * A description of the current template version being created. This API operation creates the first version of the template. Every time `UpdateTemplate` is called, a new version is created. Each version of the template maintains a description of the version in the `VersionDescription` field.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTemplateRequest(")
        append("awsAccountId=$awsAccountId,")
        append("name=$name,")
        append("permissions=$permissions,")
        append("sourceEntity=$sourceEntity,")
        append("tags=$tags,")
        append("templateId=$templateId,")
        append("versionDescription=$versionDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (sourceEntity?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateId?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTemplateRequest

        if (awsAccountId != other.awsAccountId) return false
        if (name != other.name) return false
        if (permissions != other.permissions) return false
        if (sourceEntity != other.sourceEntity) return false
        if (tags != other.tags) return false
        if (templateId != other.templateId) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateTemplateRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the Amazon Web Services account that the group is in. You use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * A display name for the template.
         */
        public var name: kotlin.String? = null
        /**
         * A list of resource permissions to be set on the template.
         */
        public var permissions: List<ResourcePermission>? = null
        /**
         * The entity that you are using as a source when you create the template. In `SourceEntity`, you specify the type of object you're using as source: `SourceTemplate` for a template or `SourceAnalysis` for an analysis. Both of these require an Amazon Resource Name (ARN). For `SourceTemplate`, specify the ARN of the source template. For `SourceAnalysis`, specify the ARN of the source analysis. The `SourceTemplate` ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region.
         *
         * Use the `DataSetReferences` entity within `SourceTemplate` or `SourceAnalysis` to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         */
        public var sourceEntity: aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity? = null
        /**
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * An ID for the template that you want to create. This template is unique per Amazon Web Services Region; in each Amazon Web Services account.
         */
        public var templateId: kotlin.String? = null
        /**
         * A description of the current template version being created. This API operation creates the first version of the template. Every time `UpdateTemplate` is called, a new version is created. Each version of the template maintains a description of the version in the `VersionDescription` field.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateTemplateRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.name = x.name
            this.permissions = x.permissions
            this.sourceEntity = x.sourceEntity
            this.tags = x.tags
            this.templateId = x.templateId
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateTemplateRequest = CreateTemplateRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity] inside the given [block]
         */
        public fun sourceEntity(block: aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity.Builder.() -> kotlin.Unit) {
            this.sourceEntity = aws.sdk.kotlin.services.quicksight.model.TemplateSourceEntity.invoke(block)
        }
    }
}
