// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class CreateThemeRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account where you want to store the new theme.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use `ListThemes` or choose **Themes** from within an analysis.
     */
    public val baseThemeId: kotlin.String? = builder.baseThemeId
    /**
     * The theme configuration, which contains the theme display properties.
     */
    public val configuration: aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration? = builder.configuration
    /**
     * A display name for the theme.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A valid grouping of resource permissions to apply to the new theme.
     */
    public val permissions: List<ResourcePermission>? = builder.permissions
    /**
     * A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in each Amazon Web Services account.
     */
    public val themeId: kotlin.String? = requireNotNull(builder.themeId) { "A non-null value must be provided for themeId" }
    /**
     * A description of the first version of the theme that you're creating. Every time `UpdateTheme` is called, a new version is created. Each version of the theme has a description of the version in the `VersionDescription` field.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.CreateThemeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateThemeRequest(")
        append("awsAccountId=$awsAccountId,")
        append("baseThemeId=$baseThemeId,")
        append("configuration=$configuration,")
        append("name=$name,")
        append("permissions=$permissions,")
        append("tags=$tags,")
        append("themeId=$themeId,")
        append("versionDescription=$versionDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (baseThemeId?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (themeId?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateThemeRequest

        if (awsAccountId != other.awsAccountId) return false
        if (baseThemeId != other.baseThemeId) return false
        if (configuration != other.configuration) return false
        if (name != other.name) return false
        if (permissions != other.permissions) return false
        if (tags != other.tags) return false
        if (themeId != other.themeId) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.CreateThemeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account where you want to store the new theme.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use `ListThemes` or choose **Themes** from within an analysis.
         */
        public var baseThemeId: kotlin.String? = null
        /**
         * The theme configuration, which contains the theme display properties.
         */
        public var configuration: aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration? = null
        /**
         * A display name for the theme.
         */
        public var name: kotlin.String? = null
        /**
         * A valid grouping of resource permissions to apply to the new theme.
         */
        public var permissions: List<ResourcePermission>? = null
        /**
         * A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * An ID for the theme that you want to create. The theme ID is unique per Amazon Web Services Region in each Amazon Web Services account.
         */
        public var themeId: kotlin.String? = null
        /**
         * A description of the first version of the theme that you're creating. Every time `UpdateTheme` is called, a new version is created. Each version of the theme has a description of the version in the `VersionDescription` field.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.CreateThemeRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.baseThemeId = x.baseThemeId
            this.configuration = x.configuration
            this.name = x.name
            this.permissions = x.permissions
            this.tags = x.tags
            this.themeId = x.themeId
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.CreateThemeRequest = CreateThemeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration.invoke(block)
        }
    }
}
