// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



/**
 * Data source credentials. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
 */
public class DataSourceCredentials private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use. When `CopySourceArn` is not null, the credential pair from the data source in the ARN is used as the credentials for the `DataSourceCredentials` structure.
     */
    public val copySourceArn: kotlin.String? = builder.copySourceArn
    /**
     * Credential pair. For more information, see ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html">CredentialPair</a> `.
     */
    public val credentialPair: aws.sdk.kotlin.services.quicksight.model.CredentialPair? = builder.credentialPair

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceCredentials(")
        append("copySourceArn=$copySourceArn,")
        append("credentialPair=$credentialPair)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copySourceArn?.hashCode() ?: 0
        result = 31 * result + (credentialPair?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceCredentials

        if (copySourceArn != other.copySourceArn) return false
        if (credentialPair != other.credentialPair) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a data source that has the credential pair that you want to use. When `CopySourceArn` is not null, the credential pair from the data source in the ARN is used as the credentials for the `DataSourceCredentials` structure.
         */
        public var copySourceArn: kotlin.String? = null
        /**
         * Credential pair. For more information, see ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CredentialPair.html">CredentialPair</a> `.
         */
        public var credentialPair: aws.sdk.kotlin.services.quicksight.model.CredentialPair? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials) : this() {
            this.copySourceArn = x.copySourceArn
            this.credentialPair = x.credentialPair
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.DataSourceCredentials = DataSourceCredentials(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.CredentialPair] inside the given [block]
         */
        public fun credentialPair(block: aws.sdk.kotlin.services.quicksight.model.CredentialPair.Builder.() -> kotlin.Unit) {
            this.credentialPair = aws.sdk.kotlin.services.quicksight.model.CredentialPair.invoke(block)
        }
    }
}
