// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class GenerateEmbedUrlForAnonymousUserRequest private constructor(builder: Builder) {
    /**
     * The domains that you want to add to the allow list for access to the generated URL that is then embedded. This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can list up to three domains or subdomains in each API call.
     *
     * To include all subdomains under a specific domain to the allow list, use `*`. For example, `https:/&#47;*.sapp.amazon.com` includes all subdomains under `https://sapp.amazon.com`.
     */
    public val allowedDomains: List<String>? = builder.allowedDomains
    /**
     * The Amazon Resource Names (ARNs) for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose `Dashboard` embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view. Currently, you can pass up to 25 dashboard ARNs in each API call.
     */
    public val authorizedResourceArns: List<String>? = builder.authorizedResourceArns
    /**
     * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The configuration of the experience that you are embedding.
     */
    public val experienceConfiguration: aws.sdk.kotlin.services.quicksight.model.AnonymousUserEmbeddingExperienceConfiguration? = builder.experienceConfiguration
    /**
     * The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to `default`.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * How many minutes the session is valid. The session lifetime must be in &#91;15-600&#93; minutes range.
     */
    public val sessionLifetimeInMinutes: kotlin.Long? = builder.sessionLifetimeInMinutes
    /**
     * The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the `DataSet$RowLevelPermissionTagConfiguration` parameter so that session tags can be used to provide row-level security.
     *
     * These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see [Using Row-Level Security (RLS) with Tags](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html)in the *Amazon QuickSight User Guide*.
     */
    public val sessionTags: List<SessionTag>? = builder.sessionTags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GenerateEmbedUrlForAnonymousUserRequest(")
        append("allowedDomains=$allowedDomains,")
        append("authorizedResourceArns=$authorizedResourceArns,")
        append("awsAccountId=$awsAccountId,")
        append("experienceConfiguration=$experienceConfiguration,")
        append("namespace=$namespace,")
        append("sessionLifetimeInMinutes=$sessionLifetimeInMinutes,")
        append("sessionTags=$sessionTags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedDomains?.hashCode() ?: 0
        result = 31 * result + (authorizedResourceArns?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (experienceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (sessionLifetimeInMinutes?.hashCode() ?: 0)
        result = 31 * result + (sessionTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GenerateEmbedUrlForAnonymousUserRequest

        if (allowedDomains != other.allowedDomains) return false
        if (authorizedResourceArns != other.authorizedResourceArns) return false
        if (awsAccountId != other.awsAccountId) return false
        if (experienceConfiguration != other.experienceConfiguration) return false
        if (namespace != other.namespace) return false
        if (sessionLifetimeInMinutes != other.sessionLifetimeInMinutes) return false
        if (sessionTags != other.sessionTags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The domains that you want to add to the allow list for access to the generated URL that is then embedded. This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can list up to three domains or subdomains in each API call.
         *
         * To include all subdomains under a specific domain to the allow list, use `*`. For example, `https:/&#47;*.sapp.amazon.com` includes all subdomains under `https://sapp.amazon.com`.
         */
        public var allowedDomains: List<String>? = null
        /**
         * The Amazon Resource Names (ARNs) for the Amazon QuickSight resources that the user is authorized to access during the lifetime of the session. If you choose `Dashboard` embedding experience, pass the list of dashboard ARNs in the account that you want the user to be able to view. Currently, you can pass up to 25 dashboard ARNs in each API call.
         */
        public var authorizedResourceArns: List<String>? = null
        /**
         * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The configuration of the experience that you are embedding.
         */
        public var experienceConfiguration: aws.sdk.kotlin.services.quicksight.model.AnonymousUserEmbeddingExperienceConfiguration? = null
        /**
         * The Amazon QuickSight namespace that the anonymous user virtually belongs to. If you are not using an Amazon QuickSight custom namespace, set this to `default`.
         */
        public var namespace: kotlin.String? = null
        /**
         * How many minutes the session is valid. The session lifetime must be in &#91;15-600&#93; minutes range.
         */
        public var sessionLifetimeInMinutes: kotlin.Long? = null
        /**
         * The session tags used for row-level security. Before you use this parameter, make sure that you have configured the relevant datasets using the `DataSet$RowLevelPermissionTagConfiguration` parameter so that session tags can be used to provide row-level security.
         *
         * These are not the tags used for the Amazon Web Services resource tagging feature. For more information, see [Using Row-Level Security (RLS) with Tags](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-rls-tags.html)in the *Amazon QuickSight User Guide*.
         */
        public var sessionTags: List<SessionTag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest) : this() {
            this.allowedDomains = x.allowedDomains
            this.authorizedResourceArns = x.authorizedResourceArns
            this.awsAccountId = x.awsAccountId
            this.experienceConfiguration = x.experienceConfiguration
            this.namespace = x.namespace
            this.sessionLifetimeInMinutes = x.sessionLifetimeInMinutes
            this.sessionTags = x.sessionTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest = GenerateEmbedUrlForAnonymousUserRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AnonymousUserEmbeddingExperienceConfiguration] inside the given [block]
         */
        public fun experienceConfiguration(block: aws.sdk.kotlin.services.quicksight.model.AnonymousUserEmbeddingExperienceConfiguration.Builder.() -> kotlin.Unit) {
            this.experienceConfiguration = aws.sdk.kotlin.services.quicksight.model.AnonymousUserEmbeddingExperienceConfiguration.invoke(block)
        }
    }
}
