// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class GetDashboardEmbedUrlRequest private constructor(builder: Builder) {
    /**
     * A list of one or more dashboard IDs that you want anonymous users to have tempporary access to. Currently, the `IdentityType` parameter must be set to `ANONYMOUS` because other identity types authenticate as Amazon QuickSight or IAM users. For example, if you set "`--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS`", the session can access all three dashboards.
     */
    public val additionalDashboardIds: List<String>? = builder.additionalDashboardIds
    /**
     * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.
     */
    public val dashboardId: kotlin.String? = requireNotNull(builder.dashboardId) { "A non-null value must be provided for dashboardId" }
    /**
     * The authentication method that the user uses to sign in.
     */
    public val identityType: aws.sdk.kotlin.services.quicksight.model.EmbeddingIdentityType? = builder.identityType
    /**
     * The Amazon QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom namespace, set `Namespace = default`.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.
     */
    public val resetDisabled: kotlin.Boolean = builder.resetDisabled
    /**
     * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
     */
    public val sessionLifetimeInMinutes: kotlin.Long? = builder.sessionLifetimeInMinutes
    /**
     * Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is set to `TRUE`, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is `FALSE`.
     */
    public val statePersistenceEnabled: kotlin.Boolean = builder.statePersistenceEnabled
    /**
     * Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.
     */
    public val undoRedoDisabled: kotlin.Boolean = builder.undoRedoDisabled
    /**
     * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with `QUICKSIGHT` identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:
     * + Active Directory (AD) users or group members
     * + Invited nonfederated users
     * + IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.
     *
     * Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
     */
    public val userArn: kotlin.String? = builder.userArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.GetDashboardEmbedUrlRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetDashboardEmbedUrlRequest(")
        append("additionalDashboardIds=$additionalDashboardIds,")
        append("awsAccountId=$awsAccountId,")
        append("dashboardId=$dashboardId,")
        append("identityType=$identityType,")
        append("namespace=$namespace,")
        append("resetDisabled=$resetDisabled,")
        append("sessionLifetimeInMinutes=$sessionLifetimeInMinutes,")
        append("statePersistenceEnabled=$statePersistenceEnabled,")
        append("undoRedoDisabled=$undoRedoDisabled,")
        append("userArn=$userArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalDashboardIds?.hashCode() ?: 0
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (dashboardId?.hashCode() ?: 0)
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (resetDisabled.hashCode())
        result = 31 * result + (sessionLifetimeInMinutes?.hashCode() ?: 0)
        result = 31 * result + (statePersistenceEnabled.hashCode())
        result = 31 * result + (undoRedoDisabled.hashCode())
        result = 31 * result + (userArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetDashboardEmbedUrlRequest

        if (additionalDashboardIds != other.additionalDashboardIds) return false
        if (awsAccountId != other.awsAccountId) return false
        if (dashboardId != other.dashboardId) return false
        if (identityType != other.identityType) return false
        if (namespace != other.namespace) return false
        if (resetDisabled != other.resetDisabled) return false
        if (sessionLifetimeInMinutes != other.sessionLifetimeInMinutes) return false
        if (statePersistenceEnabled != other.statePersistenceEnabled) return false
        if (undoRedoDisabled != other.undoRedoDisabled) return false
        if (userArn != other.userArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.GetDashboardEmbedUrlRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of one or more dashboard IDs that you want anonymous users to have tempporary access to. Currently, the `IdentityType` parameter must be set to `ANONYMOUS` because other identity types authenticate as Amazon QuickSight or IAM users. For example, if you set "`--dashboard-id dash_id1 --dashboard-id dash_id2 dash_id3 identity-type ANONYMOUS`", the session can access all three dashboards.
         */
        public var additionalDashboardIds: List<String>? = null
        /**
         * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The ID for the dashboard, also added to the Identity and Access Management (IAM) policy.
         */
        public var dashboardId: kotlin.String? = null
        /**
         * The authentication method that the user uses to sign in.
         */
        public var identityType: aws.sdk.kotlin.services.quicksight.model.EmbeddingIdentityType? = null
        /**
         * The Amazon QuickSight namespace that contains the dashboard IDs in this request. If you're not using a custom namespace, set `Namespace = default`.
         */
        public var namespace: kotlin.String? = null
        /**
         * Remove the reset button on the embedded dashboard. The default is FALSE, which enables the reset button.
         */
        public var resetDisabled: kotlin.Boolean = false
        /**
         * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
         */
        public var sessionLifetimeInMinutes: kotlin.Long? = null
        /**
         * Adds persistence of state for the user session in an embedded dashboard. Persistence applies to the sheet and the parameter settings. These are control settings that the dashboard subscriber (Amazon QuickSight reader) chooses while viewing the dashboard. If this is set to `TRUE`, the settings are the same when the subscriber reopens the same dashboard URL. The state is stored in Amazon QuickSight, not in a browser cookie. If this is set to FALSE, the state of the user session is not persisted. The default is `FALSE`.
         */
        public var statePersistenceEnabled: kotlin.Boolean = false
        /**
         * Remove the undo/redo button on the embedded dashboard. The default is FALSE, which enables the undo/redo button.
         */
        public var undoRedoDisabled: kotlin.Boolean = false
        /**
         * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with `QUICKSIGHT` identity type. You can use this for any Amazon QuickSight users in your account (readers, authors, or admins) authenticated as one of the following:
         * + Active Directory (AD) users or group members
         * + Invited nonfederated users
         * + IAM users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation.
         *
         * Omit this parameter for users in the third group – IAM users and IAM role-based sessions.
         */
        public var userArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.GetDashboardEmbedUrlRequest) : this() {
            this.additionalDashboardIds = x.additionalDashboardIds
            this.awsAccountId = x.awsAccountId
            this.dashboardId = x.dashboardId
            this.identityType = x.identityType
            this.namespace = x.namespace
            this.resetDisabled = x.resetDisabled
            this.sessionLifetimeInMinutes = x.sessionLifetimeInMinutes
            this.statePersistenceEnabled = x.statePersistenceEnabled
            this.undoRedoDisabled = x.undoRedoDisabled
            this.userArn = x.userArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.GetDashboardEmbedUrlRequest = GetDashboardEmbedUrlRequest(this)
    }
}
