// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class GetSessionEmbedUrlRequest private constructor(builder: Builder) {
    /**
     * The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The URL you use to access the embedded session. The entry point URL is constrained to the following paths:
     * + `/start`
     * + `/start/analyses`
     * + `/start/dashboards`
     * + `/start/favorites`
     * + `/dashboards/<i>DashboardId</i> ` - where `DashboardId` is the actual ID key from the Amazon QuickSight console URL of the dashboard
     * + `/analyses/<i>AnalysisId</i> ` - where `AnalysisId` is the actual ID key from the Amazon QuickSight console URL of the analysis
     */
    public val entryPoint: kotlin.String? = builder.entryPoint
    /**
     * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
     */
    public val sessionLifetimeInMinutes: kotlin.Long? = builder.sessionLifetimeInMinutes
    /**
     * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with `QUICKSIGHT` identity type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to be authenticated as one of the following:
     * + Active Directory (AD) users or group members
     * + Invited nonfederated users
     * + Identity and Access Management (IAM) users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation
     *
     * Omit this parameter for users in the third group, IAM users and IAM role-based sessions.
     */
    public val userArn: kotlin.String? = builder.userArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.GetSessionEmbedUrlRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSessionEmbedUrlRequest(")
        append("awsAccountId=$awsAccountId,")
        append("entryPoint=$entryPoint,")
        append("sessionLifetimeInMinutes=$sessionLifetimeInMinutes,")
        append("userArn=$userArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (entryPoint?.hashCode() ?: 0)
        result = 31 * result + (sessionLifetimeInMinutes?.hashCode() ?: 0)
        result = 31 * result + (userArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSessionEmbedUrlRequest

        if (awsAccountId != other.awsAccountId) return false
        if (entryPoint != other.entryPoint) return false
        if (sessionLifetimeInMinutes != other.sessionLifetimeInMinutes) return false
        if (userArn != other.userArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.GetSessionEmbedUrlRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the Amazon Web Services account associated with your Amazon QuickSight subscription.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The URL you use to access the embedded session. The entry point URL is constrained to the following paths:
         * + `/start`
         * + `/start/analyses`
         * + `/start/dashboards`
         * + `/start/favorites`
         * + `/dashboards/<i>DashboardId</i> ` - where `DashboardId` is the actual ID key from the Amazon QuickSight console URL of the dashboard
         * + `/analyses/<i>AnalysisId</i> ` - where `AnalysisId` is the actual ID key from the Amazon QuickSight console URL of the analysis
         */
        public var entryPoint: kotlin.String? = null
        /**
         * How many minutes the session is valid. The session lifetime must be 15-600 minutes.
         */
        public var sessionLifetimeInMinutes: kotlin.Long? = null
        /**
         * The Amazon QuickSight user's Amazon Resource Name (ARN), for use with `QUICKSIGHT` identity type. You can use this for any type of Amazon QuickSight users in your account (readers, authors, or admins). They need to be authenticated as one of the following:
         * + Active Directory (AD) users or group members
         * + Invited nonfederated users
         * + Identity and Access Management (IAM) users and IAM role-based sessions authenticated through Federated Single Sign-On using SAML, OpenID Connect, or IAM federation
         *
         * Omit this parameter for users in the third group, IAM users and IAM role-based sessions.
         */
        public var userArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.GetSessionEmbedUrlRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.entryPoint = x.entryPoint
            this.sessionLifetimeInMinutes = x.sessionLifetimeInMinutes
            this.userArn = x.userArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.GetSessionEmbedUrlRequest = GetSessionEmbedUrlRequest(this)
    }
}
