// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the SPICE ingestion for a dataset.
 */
public class Ingestion private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the resource.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time that this ingestion started.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * Error information for this ingestion.
     */
    public val errorInfo: aws.sdk.kotlin.services.quicksight.model.ErrorInfo? = builder.errorInfo
    /**
     * Ingestion ID.
     */
    public val ingestionId: kotlin.String? = builder.ingestionId
    /**
     * The size of the data ingested, in bytes.
     */
    public val ingestionSizeInBytes: kotlin.Long? = builder.ingestionSizeInBytes
    /**
     * Ingestion status.
     */
    public val ingestionStatus: aws.sdk.kotlin.services.quicksight.model.IngestionStatus? = builder.ingestionStatus
    /**
     * The time that this ingestion took, measured in seconds.
     */
    public val ingestionTimeInSeconds: kotlin.Long? = builder.ingestionTimeInSeconds
    /**
     * Information about a queued dataset SPICE ingestion.
     */
    public val queueInfo: aws.sdk.kotlin.services.quicksight.model.QueueInfo? = builder.queueInfo
    /**
     * Event source for this ingestion.
     */
    public val requestSource: aws.sdk.kotlin.services.quicksight.model.IngestionRequestSource? = builder.requestSource
    /**
     * Type of this ingestion.
     */
    public val requestType: aws.sdk.kotlin.services.quicksight.model.IngestionRequestType? = builder.requestType
    /**
     * Information about rows for a data set SPICE ingestion.
     */
    public val rowInfo: aws.sdk.kotlin.services.quicksight.model.RowInfo? = builder.rowInfo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.Ingestion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ingestion(")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("errorInfo=$errorInfo,")
        append("ingestionId=$ingestionId,")
        append("ingestionSizeInBytes=$ingestionSizeInBytes,")
        append("ingestionStatus=$ingestionStatus,")
        append("ingestionTimeInSeconds=$ingestionTimeInSeconds,")
        append("queueInfo=$queueInfo,")
        append("requestSource=$requestSource,")
        append("requestType=$requestType,")
        append("rowInfo=$rowInfo)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (errorInfo?.hashCode() ?: 0)
        result = 31 * result + (ingestionId?.hashCode() ?: 0)
        result = 31 * result + (ingestionSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (ingestionStatus?.hashCode() ?: 0)
        result = 31 * result + (ingestionTimeInSeconds?.hashCode() ?: 0)
        result = 31 * result + (queueInfo?.hashCode() ?: 0)
        result = 31 * result + (requestSource?.hashCode() ?: 0)
        result = 31 * result + (requestType?.hashCode() ?: 0)
        result = 31 * result + (rowInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ingestion

        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (errorInfo != other.errorInfo) return false
        if (ingestionId != other.ingestionId) return false
        if (ingestionSizeInBytes != other.ingestionSizeInBytes) return false
        if (ingestionStatus != other.ingestionStatus) return false
        if (ingestionTimeInSeconds != other.ingestionTimeInSeconds) return false
        if (queueInfo != other.queueInfo) return false
        if (requestSource != other.requestSource) return false
        if (requestType != other.requestType) return false
        if (rowInfo != other.rowInfo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.Ingestion = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the resource.
         */
        public var arn: kotlin.String? = null
        /**
         * The time that this ingestion started.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Error information for this ingestion.
         */
        public var errorInfo: aws.sdk.kotlin.services.quicksight.model.ErrorInfo? = null
        /**
         * Ingestion ID.
         */
        public var ingestionId: kotlin.String? = null
        /**
         * The size of the data ingested, in bytes.
         */
        public var ingestionSizeInBytes: kotlin.Long? = null
        /**
         * Ingestion status.
         */
        public var ingestionStatus: aws.sdk.kotlin.services.quicksight.model.IngestionStatus? = null
        /**
         * The time that this ingestion took, measured in seconds.
         */
        public var ingestionTimeInSeconds: kotlin.Long? = null
        /**
         * Information about a queued dataset SPICE ingestion.
         */
        public var queueInfo: aws.sdk.kotlin.services.quicksight.model.QueueInfo? = null
        /**
         * Event source for this ingestion.
         */
        public var requestSource: aws.sdk.kotlin.services.quicksight.model.IngestionRequestSource? = null
        /**
         * Type of this ingestion.
         */
        public var requestType: aws.sdk.kotlin.services.quicksight.model.IngestionRequestType? = null
        /**
         * Information about rows for a data set SPICE ingestion.
         */
        public var rowInfo: aws.sdk.kotlin.services.quicksight.model.RowInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.Ingestion) : this() {
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.errorInfo = x.errorInfo
            this.ingestionId = x.ingestionId
            this.ingestionSizeInBytes = x.ingestionSizeInBytes
            this.ingestionStatus = x.ingestionStatus
            this.ingestionTimeInSeconds = x.ingestionTimeInSeconds
            this.queueInfo = x.queueInfo
            this.requestSource = x.requestSource
            this.requestType = x.requestType
            this.rowInfo = x.rowInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.Ingestion = Ingestion(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.ErrorInfo] inside the given [block]
         */
        public fun errorInfo(block: aws.sdk.kotlin.services.quicksight.model.ErrorInfo.Builder.() -> kotlin.Unit) {
            this.errorInfo = aws.sdk.kotlin.services.quicksight.model.ErrorInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.QueueInfo] inside the given [block]
         */
        public fun queueInfo(block: aws.sdk.kotlin.services.quicksight.model.QueueInfo.Builder.() -> kotlin.Unit) {
            this.queueInfo = aws.sdk.kotlin.services.quicksight.model.QueueInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.RowInfo] inside the given [block]
         */
        public fun rowInfo(block: aws.sdk.kotlin.services.quicksight.model.RowInfo.Builder.() -> kotlin.Unit) {
            this.rowInfo = aws.sdk.kotlin.services.quicksight.model.RowInfo.invoke(block)
        }
    }
}
