// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class ListNamespacesRequest private constructor(builder: Builder) {
    /**
     * The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The maximum number of results to return.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * A unique pagination token that can be used in a subsequent request. You will receive a pagination token in the response body of a previous `ListNameSpaces` API call if there is more data that can be returned. To receive the data, make another `ListNamespaces` API call with the returned token to retrieve the next page of data. Each token is valid for 24 hours. If you try to make a `ListNamespaces` API call with an expired token, you will receive a `HTTP 400 InvalidNextTokenException` error.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.ListNamespacesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListNamespacesRequest(")
        append("awsAccountId=$awsAccountId,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListNamespacesRequest

        if (awsAccountId != other.awsAccountId) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.ListNamespacesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the Amazon Web Services account that contains the Amazon QuickSight namespaces that you want to list.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The maximum number of results to return.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * A unique pagination token that can be used in a subsequent request. You will receive a pagination token in the response body of a previous `ListNameSpaces` API call if there is more data that can be returned. To receive the data, make another `ListNamespaces` API call with the returned token to retrieve the next page of data. Each token is valid for 24 hours. If you try to make a `ListNamespaces` API call with an expired token, you will receive a `HTTP 400 InvalidNextTokenException` error.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.ListNamespacesRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.ListNamespacesRequest = ListNamespacesRequest(this)
    }
}
