// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class RegisterUserRequest private constructor(builder: Builder) {
    /**
     * The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when `ExternalLoginFederationProviderType` parameter is set to `CUSTOM_OIDC`.
     */
    public val customFederationProviderUrl: kotlin.String? = builder.customFederationProviderUrl
    /**
     * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:
     * + Create and update data sources
     * + Create and update datasets
     * + Create and update email reports
     * + Subscribe to email reports
     *
     * To add custom permissions to an existing user, use ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> ` instead.
     *
     * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the `RegisterUser` API operation to assign the named set of permissions to a Amazon QuickSight user.
     *
     * Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).
     *
     * This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
     */
    public val customPermissionsName: kotlin.String? = builder.customPermissionsName
    /**
     * The email address of the user that you want to register.
     */
    public val email: kotlin.String? = builder.email
    /**
     * The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.
     * + `COGNITO`: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the `COGNITO` provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.
     * + `CUSTOM_OIDC`: Custom OpenID Connect (OIDC) provider. When choosing `CUSTOM_OIDC` type, use the `CustomFederationProviderUrl` parameter to provide the custom OIDC provider URL.
     */
    public val externalLoginFederationProviderType: kotlin.String? = builder.externalLoginFederationProviderType
    /**
     * The identity ID for a user in the external login provider.
     */
    public val externalLoginId: kotlin.String? = builder.externalLoginId
    /**
     * The ARN of the IAM user or role that you are registering with Amazon QuickSight.
     */
    public val iamArn: kotlin.String? = builder.iamArn
    /**
     * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
     * + `IAM`: A user whose identity maps to an existing IAM user or role.
     * + `QUICKSIGHT`: A user whose identity is owned and managed internally by Amazon QuickSight.
     */
    public val identityType: aws.sdk.kotlin.services.quicksight.model.IdentityType? = builder.identityType
    /**
     * The namespace. Currently, you should set this to `default`.
     */
    public val namespace: kotlin.String? = requireNotNull(builder.namespace) { "A non-null value must be provided for namespace" }
    /**
     * You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see `assume-role`[](https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html) in the *CLI Reference.*
     */
    public val sessionName: kotlin.String? = builder.sessionName
    /**
     * The Amazon QuickSight user name that you want to create for the user you are registering.
     */
    public val userName: kotlin.String? = builder.userName
    /**
     * The Amazon QuickSight role for the user. The user role can be one of the following:
     * + `READER`: A user who has read-only access to dashboards.
     * + `AUTHOR`: A user who can create data sources, datasets, analyses, and dashboards.
     * + `ADMIN`: A user who is an author, who can also manage Amazon QuickSight settings.
     * + `RESTRICTED_READER`: This role isn't currently available for use.
     * + `RESTRICTED_AUTHOR`: This role isn't currently available for use.
     */
    public val userRole: aws.sdk.kotlin.services.quicksight.model.UserRole? = builder.userRole

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RegisterUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterUserRequest(")
        append("awsAccountId=$awsAccountId,")
        append("customFederationProviderUrl=$customFederationProviderUrl,")
        append("customPermissionsName=$customPermissionsName,")
        append("email=$email,")
        append("externalLoginFederationProviderType=$externalLoginFederationProviderType,")
        append("externalLoginId=$externalLoginId,")
        append("iamArn=$iamArn,")
        append("identityType=$identityType,")
        append("namespace=$namespace,")
        append("sessionName=$sessionName,")
        append("userName=$userName,")
        append("userRole=$userRole)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (customFederationProviderUrl?.hashCode() ?: 0)
        result = 31 * result + (customPermissionsName?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (externalLoginFederationProviderType?.hashCode() ?: 0)
        result = 31 * result + (externalLoginId?.hashCode() ?: 0)
        result = 31 * result + (iamArn?.hashCode() ?: 0)
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (sessionName?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        result = 31 * result + (userRole?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterUserRequest

        if (awsAccountId != other.awsAccountId) return false
        if (customFederationProviderUrl != other.customFederationProviderUrl) return false
        if (customPermissionsName != other.customPermissionsName) return false
        if (email != other.email) return false
        if (externalLoginFederationProviderType != other.externalLoginFederationProviderType) return false
        if (externalLoginId != other.externalLoginId) return false
        if (iamArn != other.iamArn) return false
        if (identityType != other.identityType) return false
        if (namespace != other.namespace) return false
        if (sessionName != other.sessionName) return false
        if (userName != other.userName) return false
        if (userRole != other.userRole) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RegisterUserRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when `ExternalLoginFederationProviderType` parameter is set to `CUSTOM_OIDC`.
         */
        public var customFederationProviderUrl: kotlin.String? = null
        /**
         * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:
         * + Create and update data sources
         * + Create and update datasets
         * + Create and update email reports
         * + Subscribe to email reports
         *
         * To add custom permissions to an existing user, use ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> ` instead.
         *
         * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the `RegisterUser` API operation to assign the named set of permissions to a Amazon QuickSight user.
         *
         * Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).
         *
         * This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
         */
        public var customPermissionsName: kotlin.String? = null
        /**
         * The email address of the user that you want to register.
         */
        public var email: kotlin.String? = null
        /**
         * The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.
         * + `COGNITO`: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the `COGNITO` provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.
         * + `CUSTOM_OIDC`: Custom OpenID Connect (OIDC) provider. When choosing `CUSTOM_OIDC` type, use the `CustomFederationProviderUrl` parameter to provide the custom OIDC provider URL.
         */
        public var externalLoginFederationProviderType: kotlin.String? = null
        /**
         * The identity ID for a user in the external login provider.
         */
        public var externalLoginId: kotlin.String? = null
        /**
         * The ARN of the IAM user or role that you are registering with Amazon QuickSight.
         */
        public var iamArn: kotlin.String? = null
        /**
         * Amazon QuickSight supports several ways of managing the identity of users. This parameter accepts two values:
         * + `IAM`: A user whose identity maps to an existing IAM user or role.
         * + `QUICKSIGHT`: A user whose identity is owned and managed internally by Amazon QuickSight.
         */
        public var identityType: aws.sdk.kotlin.services.quicksight.model.IdentityType? = null
        /**
         * The namespace. Currently, you should set this to `default`.
         */
        public var namespace: kotlin.String? = null
        /**
         * You need to use this parameter only when you register one or more users using an assumed IAM role. You don't need to provide the session name for other scenarios, for example when you are registering an IAM user or an Amazon QuickSight user. You can register multiple users using the same IAM role if each user has a different session name. For more information on assuming IAM roles, see `assume-role`[](https://docs.aws.amazon.com/cli/latest/reference/sts/assume-role.html) in the *CLI Reference.*
         */
        public var sessionName: kotlin.String? = null
        /**
         * The Amazon QuickSight user name that you want to create for the user you are registering.
         */
        public var userName: kotlin.String? = null
        /**
         * The Amazon QuickSight role for the user. The user role can be one of the following:
         * + `READER`: A user who has read-only access to dashboards.
         * + `AUTHOR`: A user who can create data sources, datasets, analyses, and dashboards.
         * + `ADMIN`: A user who is an author, who can also manage Amazon QuickSight settings.
         * + `RESTRICTED_READER`: This role isn't currently available for use.
         * + `RESTRICTED_AUTHOR`: This role isn't currently available for use.
         */
        public var userRole: aws.sdk.kotlin.services.quicksight.model.UserRole? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RegisterUserRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.customFederationProviderUrl = x.customFederationProviderUrl
            this.customPermissionsName = x.customPermissionsName
            this.email = x.email
            this.externalLoginFederationProviderType = x.externalLoginFederationProviderType
            this.externalLoginId = x.externalLoginId
            this.iamArn = x.iamArn
            this.identityType = x.identityType
            this.namespace = x.namespace
            this.sessionName = x.sessionName
            this.userName = x.userName
            this.userRole = x.userRole
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RegisterUserRequest = RegisterUserRequest(this)
    }
}
