// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



/**
 * Information about a dataset that contains permissions for row-level security (RLS). The permissions dataset maps fields to users or groups. For more information, see [Using Row-Level Security (RLS) to Restrict Access to a Dataset](https://docs.aws.amazon.com/quicksight/latest/user/restrict-access-to-a-data-set-using-row-level-security.html) in the *Amazon QuickSight User Guide*.
 *
 * The option to deny permissions by setting `PermissionPolicy` to `DENY_ACCESS` is not supported for new RLS datasets.
 */
public class RowLevelPermissionDataSet private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The user or group rules associated with the dataset that contains permissions for RLS.
     *
     * By default, `FormatVersion` is `VERSION_1`. When `FormatVersion` is `VERSION_1`, `UserName` and `GroupName` are required. When `FormatVersion` is `VERSION_2`, `UserARN` and `GroupARN` are required, and `Namespace` must not exist.
     */
    public val formatVersion: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionFormatVersion? = builder.formatVersion
    /**
     * The namespace associated with the dataset that contains permissions for RLS.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The type of permissions to use when interpreting the permissions for RLS. `DENY_ACCESS` is included for backward compatibility only.
     */
    public val permissionPolicy: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionPolicy? = builder.permissionPolicy
    /**
     * The status of the row-level security permission dataset. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
     */
    public val status: aws.sdk.kotlin.services.quicksight.model.Status? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RowLevelPermissionDataSet(")
        append("arn=$arn,")
        append("formatVersion=$formatVersion,")
        append("namespace=$namespace,")
        append("permissionPolicy=$permissionPolicy,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (formatVersion?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (permissionPolicy?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RowLevelPermissionDataSet

        if (arn != other.arn) return false
        if (formatVersion != other.formatVersion) return false
        if (namespace != other.namespace) return false
        if (permissionPolicy != other.permissionPolicy) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the dataset that contains permissions for RLS.
         */
        public var arn: kotlin.String? = null
        /**
         * The user or group rules associated with the dataset that contains permissions for RLS.
         *
         * By default, `FormatVersion` is `VERSION_1`. When `FormatVersion` is `VERSION_1`, `UserName` and `GroupName` are required. When `FormatVersion` is `VERSION_2`, `UserARN` and `GroupARN` are required, and `Namespace` must not exist.
         */
        public var formatVersion: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionFormatVersion? = null
        /**
         * The namespace associated with the dataset that contains permissions for RLS.
         */
        public var namespace: kotlin.String? = null
        /**
         * The type of permissions to use when interpreting the permissions for RLS. `DENY_ACCESS` is included for backward compatibility only.
         */
        public var permissionPolicy: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionPolicy? = null
        /**
         * The status of the row-level security permission dataset. If enabled, the status is `ENABLED`. If disabled, the status is `DISABLED`.
         */
        public var status: aws.sdk.kotlin.services.quicksight.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet) : this() {
            this.arn = x.arn
            this.formatVersion = x.formatVersion
            this.namespace = x.namespace
            this.permissionPolicy = x.permissionPolicy
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.RowLevelPermissionDataSet = RowLevelPermissionDataSet(this)
    }
}
