// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A template object. A *template* is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create a dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with an analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.
 *
 * You can share templates across Amazon Web Services accounts by allowing users in other Amazon Web Services accounts to create a template or a dashboard from an existing template.
 */
public class Template private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the template.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Time when this was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * Time when this was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The display name of the template.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ID for the template. This is unique per Amazon Web Services Region for each Amazon Web Services account.
     */
    public val templateId: kotlin.String? = builder.templateId
    /**
     * A structure describing the versions of the template.
     */
    public val version: aws.sdk.kotlin.services.quicksight.model.TemplateVersion? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.Template = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Template(")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("templateId=$templateId,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (templateId?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Template

        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (templateId != other.templateId) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.Template = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the template.
         */
        public var arn: kotlin.String? = null
        /**
         * Time when this was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Time when this was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The display name of the template.
         */
        public var name: kotlin.String? = null
        /**
         * The ID for the template. This is unique per Amazon Web Services Region for each Amazon Web Services account.
         */
        public var templateId: kotlin.String? = null
        /**
         * A structure describing the versions of the template.
         */
        public var version: aws.sdk.kotlin.services.quicksight.model.TemplateVersion? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.Template) : this() {
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.templateId = x.templateId
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.Template = Template(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.TemplateVersion] inside the given [block]
         */
        public fun version(block: aws.sdk.kotlin.services.quicksight.model.TemplateVersion.Builder.() -> kotlin.Unit) {
            this.version = aws.sdk.kotlin.services.quicksight.model.TemplateVersion.invoke(block)
        }
    }
}
