// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class UpdateDashboardRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that contains the dashboard that you're updating.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The ID for the dashboard.
     */
    public val dashboardId: kotlin.String? = requireNotNull(builder.dashboardId) { "A non-null value must be provided for dashboardId" }
    /**
     * Options for publishing the dashboard when you create it:
     * + `AvailabilityStatus` for `AdHocFilteringOption` - This status can be either `ENABLED` or `DISABLED`. When this is set to `DISABLED`, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is `ENABLED` by default.
     * + `AvailabilityStatus` for `ExportToCSVOption` - This status can be either `ENABLED` or `DISABLED`. The visual option to export data to .CSV format isn't enabled when this is set to `DISABLED`. This option is `ENABLED` by default.
     * + `VisibilityState` for `SheetControlsOption` - This visibility state can be either `COLLAPSED` or `EXPANDED`. This option is `COLLAPSED` by default.
     */
    public val dashboardPublishOptions: aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions? = builder.dashboardPublishOptions
    /**
     * The display name of the dashboard.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.
     */
    public val parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = builder.parameters
    /**
     * The entity that you are using as a source when you update the dashboard. In `SourceEntity`, you specify the type of object you're using as source. You can only update a dashboard from a template, so you use a `SourceTemplate` entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> ` API operation. For `SourceTemplate`, specify the Amazon Resource Name (ARN) of the source template. The `SourceTemplate` ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region.
     *
     * Use the `DataSetReferences` entity within `SourceTemplate` to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     */
    public val sourceEntity: aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity? = builder.sourceEntity
    /**
     * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.
     */
    public val themeArn: kotlin.String? = builder.themeArn
    /**
     * A description for the first version of the dashboard being created.
     */
    public val versionDescription: kotlin.String? = builder.versionDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.UpdateDashboardRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDashboardRequest(")
        append("awsAccountId=$awsAccountId,")
        append("dashboardId=$dashboardId,")
        append("dashboardPublishOptions=$dashboardPublishOptions,")
        append("name=$name,")
        append("parameters=$parameters,")
        append("sourceEntity=$sourceEntity,")
        append("themeArn=$themeArn,")
        append("versionDescription=$versionDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (dashboardId?.hashCode() ?: 0)
        result = 31 * result + (dashboardPublishOptions?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (sourceEntity?.hashCode() ?: 0)
        result = 31 * result + (themeArn?.hashCode() ?: 0)
        result = 31 * result + (versionDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDashboardRequest

        if (awsAccountId != other.awsAccountId) return false
        if (dashboardId != other.dashboardId) return false
        if (dashboardPublishOptions != other.dashboardPublishOptions) return false
        if (name != other.name) return false
        if (parameters != other.parameters) return false
        if (sourceEntity != other.sourceEntity) return false
        if (themeArn != other.themeArn) return false
        if (versionDescription != other.versionDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.UpdateDashboardRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account that contains the dashboard that you're updating.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The ID for the dashboard.
         */
        public var dashboardId: kotlin.String? = null
        /**
         * Options for publishing the dashboard when you create it:
         * + `AvailabilityStatus` for `AdHocFilteringOption` - This status can be either `ENABLED` or `DISABLED`. When this is set to `DISABLED`, Amazon QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This option is `ENABLED` by default.
         * + `AvailabilityStatus` for `ExportToCSVOption` - This status can be either `ENABLED` or `DISABLED`. The visual option to export data to .CSV format isn't enabled when this is set to `DISABLED`. This option is `ENABLED` by default.
         * + `VisibilityState` for `SheetControlsOption` - This visibility state can be either `COLLAPSED` or `EXPANDED`. This option is `COLLAPSED` by default.
         */
        public var dashboardPublishOptions: aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions? = null
        /**
         * The display name of the dashboard.
         */
        public var name: kotlin.String? = null
        /**
         * A structure that contains the parameters of the dashboard. These are parameter overrides for a dashboard. A dashboard can have any type of parameters, and some parameters might accept multiple values.
         */
        public var parameters: aws.sdk.kotlin.services.quicksight.model.Parameters? = null
        /**
         * The entity that you are using as a source when you update the dashboard. In `SourceEntity`, you specify the type of object you're using as source. You can only update a dashboard from a template, so you use a `SourceTemplate` entity. If you need to update a dashboard from an analysis, first convert the analysis to a template by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> ` API operation. For `SourceTemplate`, specify the Amazon Resource Name (ARN) of the source template. The `SourceTemplate` ARN can contain any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region.
         *
         * Use the `DataSetReferences` entity within `SourceTemplate` to list the replacement datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         */
        public var sourceEntity: aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity? = null
        /**
         * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this field, it overrides the value that was originally associated with the entity. The theme ARN must exist in the same Amazon Web Services account where you create the dashboard.
         */
        public var themeArn: kotlin.String? = null
        /**
         * A description for the first version of the dashboard being created.
         */
        public var versionDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.UpdateDashboardRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.dashboardId = x.dashboardId
            this.dashboardPublishOptions = x.dashboardPublishOptions
            this.name = x.name
            this.parameters = x.parameters
            this.sourceEntity = x.sourceEntity
            this.themeArn = x.themeArn
            this.versionDescription = x.versionDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.UpdateDashboardRequest = UpdateDashboardRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions] inside the given [block]
         */
        public fun dashboardPublishOptions(block: aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions.Builder.() -> kotlin.Unit) {
            this.dashboardPublishOptions = aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.Parameters] inside the given [block]
         */
        public fun parameters(block: aws.sdk.kotlin.services.quicksight.model.Parameters.Builder.() -> kotlin.Unit) {
            this.parameters = aws.sdk.kotlin.services.quicksight.model.Parameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity] inside the given [block]
         */
        public fun sourceEntity(block: aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity.Builder.() -> kotlin.Unit) {
            this.sourceEntity = aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity.invoke(block)
        }
    }
}
