// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



public class UpdateUserRequest private constructor(builder: Builder) {
    /**
     * The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.
     */
    public val awsAccountId: kotlin.String? = requireNotNull(builder.awsAccountId) { "A non-null value must be provided for awsAccountId" }
    /**
     * The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when `ExternalLoginFederationProviderType` parameter is set to `CUSTOM_OIDC`.
     */
    public val customFederationProviderUrl: kotlin.String? = builder.customFederationProviderUrl
    /**
     * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:
     * + Create and update data sources
     * + Create and update datasets
     * + Create and update email reports
     * + Subscribe to email reports
     *
     * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the `RegisterUser` API operation to assign the named set of permissions to a Amazon QuickSight user.
     *
     * Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).
     *
     * This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
     */
    public val customPermissionsName: kotlin.String? = builder.customPermissionsName
    /**
     * The email address of the user that you want to update.
     */
    public val email: kotlin.String? = builder.email
    /**
     * The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.
     * + `COGNITO`: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the `COGNITO` provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.
     * + `CUSTOM_OIDC`: Custom OpenID Connect (OIDC) provider. When choosing `CUSTOM_OIDC` type, use the `CustomFederationProviderUrl` parameter to provide the custom OIDC provider URL.
     * + `NONE`: This clears all the previously saved external login information for a user. Use the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> ` API operation to check the external login information.
     */
    public val externalLoginFederationProviderType: kotlin.String? = builder.externalLoginFederationProviderType
    /**
     * The identity ID for a user in the external login provider.
     */
    public val externalLoginId: kotlin.String? = builder.externalLoginId
    /**
     * The namespace. Currently, you should set this to `default`.
     */
    public val namespace: kotlin.String? = requireNotNull(builder.namespace) { "A non-null value must be provided for namespace" }
    /**
     * The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:
     * + `READER`: A user who has read-only access to dashboards.
     * + `AUTHOR`: A user who can create data sources, datasets, analyses, and dashboards.
     * + `ADMIN`: A user who is an author, who can also manage Amazon QuickSight settings.
     *
     * The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with permissions.
     */
    public val role: aws.sdk.kotlin.services.quicksight.model.UserRole? = builder.role
    /**
     * A flag that you use to indicate that you want to remove all custom permissions from this user. Using this parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter defaults to NULL and it doesn't accept any other value.
     */
    public val unapplyCustomPermissions: kotlin.Boolean = builder.unapplyCustomPermissions
    /**
     * The Amazon QuickSight user name that you want to update.
     */
    public val userName: kotlin.String? = requireNotNull(builder.userName) { "A non-null value must be provided for userName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.UpdateUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateUserRequest(")
        append("awsAccountId=$awsAccountId,")
        append("customFederationProviderUrl=$customFederationProviderUrl,")
        append("customPermissionsName=$customPermissionsName,")
        append("email=$email,")
        append("externalLoginFederationProviderType=$externalLoginFederationProviderType,")
        append("externalLoginId=$externalLoginId,")
        append("namespace=$namespace,")
        append("role=$role,")
        append("unapplyCustomPermissions=$unapplyCustomPermissions,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (customFederationProviderUrl?.hashCode() ?: 0)
        result = 31 * result + (customPermissionsName?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (externalLoginFederationProviderType?.hashCode() ?: 0)
        result = 31 * result + (externalLoginId?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (unapplyCustomPermissions.hashCode())
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateUserRequest

        if (awsAccountId != other.awsAccountId) return false
        if (customFederationProviderUrl != other.customFederationProviderUrl) return false
        if (customPermissionsName != other.customPermissionsName) return false
        if (email != other.email) return false
        if (externalLoginFederationProviderType != other.externalLoginFederationProviderType) return false
        if (externalLoginId != other.externalLoginId) return false
        if (namespace != other.namespace) return false
        if (role != other.role) return false
        if (unapplyCustomPermissions != other.unapplyCustomPermissions) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.UpdateUserRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID for the Amazon Web Services account that the user is in. Currently, you use the ID for the Amazon Web Services account that contains your Amazon QuickSight account.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The URL of the custom OpenID Connect (OIDC) provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. This parameter should only be used when `ExternalLoginFederationProviderType` parameter is set to `CUSTOM_OIDC`.
         */
        public var customFederationProviderUrl: kotlin.String? = null
        /**
         * (Enterprise edition only) The name of the custom permissions profile that you want to assign to this user. Customized permissions allows you to control a user's access by restricting access the following operations:
         * + Create and update data sources
         * + Create and update datasets
         * + Create and update email reports
         * + Subscribe to email reports
         *
         * A set of custom permissions includes any combination of these restrictions. Currently, you need to create the profile names for custom permission sets by using the Amazon QuickSight console. Then, you use the `RegisterUser` API operation to assign the named set of permissions to a Amazon QuickSight user.
         *
         * Amazon QuickSight custom permissions are applied through IAM policies. Therefore, they override the permissions typically granted by assigning Amazon QuickSight users to one of the default security cohorts in Amazon QuickSight (admin, author, reader).
         *
         * This feature is available only to Amazon QuickSight Enterprise edition subscriptions.
         */
        public var customPermissionsName: kotlin.String? = null
        /**
         * The email address of the user that you want to update.
         */
        public var email: kotlin.String? = null
        /**
         * The type of supported external login provider that provides identity to let a user federate into Amazon QuickSight with an associated Identity and Access Management(IAM) role. The type of supported external login provider can be one of the following.
         * + `COGNITO`: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com. When choosing the `COGNITO` provider type, don’t use the "CustomFederationProviderUrl" parameter which is only needed when the external provider is custom.
         * + `CUSTOM_OIDC`: Custom OpenID Connect (OIDC) provider. When choosing `CUSTOM_OIDC` type, use the `CustomFederationProviderUrl` parameter to provide the custom OIDC provider URL.
         * + `NONE`: This clears all the previously saved external login information for a user. Use the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeUser.html">DescribeUser</a> ` API operation to check the external login information.
         */
        public var externalLoginFederationProviderType: kotlin.String? = null
        /**
         * The identity ID for a user in the external login provider.
         */
        public var externalLoginId: kotlin.String? = null
        /**
         * The namespace. Currently, you should set this to `default`.
         */
        public var namespace: kotlin.String? = null
        /**
         * The Amazon QuickSight role of the user. The role can be one of the following default security cohorts:
         * + `READER`: A user who has read-only access to dashboards.
         * + `AUTHOR`: A user who can create data sources, datasets, analyses, and dashboards.
         * + `ADMIN`: A user who is an author, who can also manage Amazon QuickSight settings.
         *
         * The name of the Amazon QuickSight role is invisible to the user except for the console screens dealing with permissions.
         */
        public var role: aws.sdk.kotlin.services.quicksight.model.UserRole? = null
        /**
         * A flag that you use to indicate that you want to remove all custom permissions from this user. Using this parameter resets the user to the state it was in before a custom permissions profile was applied. This parameter defaults to NULL and it doesn't accept any other value.
         */
        public var unapplyCustomPermissions: kotlin.Boolean = false
        /**
         * The Amazon QuickSight user name that you want to update.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.UpdateUserRequest) : this() {
            this.awsAccountId = x.awsAccountId
            this.customFederationProviderUrl = x.customFederationProviderUrl
            this.customPermissionsName = x.customPermissionsName
            this.email = x.email
            this.externalLoginFederationProviderType = x.externalLoginFederationProviderType
            this.externalLoginId = x.externalLoginId
            this.namespace = x.namespace
            this.role = x.role
            this.unapplyCustomPermissions = x.unapplyCustomPermissions
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.UpdateUserRequest = UpdateUserRequest(this)
    }
}
