// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model



/**
 * A registered user of Amazon QuickSight.
 */
public class User private constructor(builder: Builder) {
    /**
     * The active status of user. When you create an Amazon QuickSight user that’s not an IAM user or an Active Directory user, that user is inactive until they sign in and provide a password.
     */
    public val active: kotlin.Boolean = builder.active
    /**
     * The Amazon Resource Name (ARN) for the user.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The custom permissions profile associated with this user.
     */
    public val customPermissionsName: kotlin.String? = builder.customPermissionsName
    /**
     * The user's email address.
     */
    public val email: kotlin.String? = builder.email
    /**
     * The type of supported external login provider that provides identity to let the user federate into Amazon QuickSight with an associated IAM role. The type can be one of the following.
     * + `COGNITO`: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.
     * + `CUSTOM_OIDC`: Custom OpenID Connect (OIDC) provider.
     */
    public val externalLoginFederationProviderType: kotlin.String? = builder.externalLoginFederationProviderType
    /**
     * The URL of the external login provider.
     */
    public val externalLoginFederationProviderUrl: kotlin.String? = builder.externalLoginFederationProviderUrl
    /**
     * The identity ID for the user in the external login provider.
     */
    public val externalLoginId: kotlin.String? = builder.externalLoginId
    /**
     * The type of identity authentication used by the user.
     */
    public val identityType: aws.sdk.kotlin.services.quicksight.model.IdentityType? = builder.identityType
    /**
     * The principal ID of the user.
     */
    public val principalId: kotlin.String? = builder.principalId
    /**
     * The Amazon QuickSight role for the user. The user role can be one of the following:.
     * + `READER`: A user who has read-only access to dashboards.
     * + `AUTHOR`: A user who can create data sources, datasets, analyses, and dashboards.
     * + `ADMIN`: A user who is an author, who can also manage Amazon Amazon QuickSight settings.
     * + `RESTRICTED_READER`: This role isn't currently available for use.
     * + `RESTRICTED_AUTHOR`: This role isn't currently available for use.
     */
    public val role: aws.sdk.kotlin.services.quicksight.model.UserRole? = builder.role
    /**
     * The user's user name. In the output, the value for `UserName` is `N/A` when the value for `IdentityType` is `IAM` and the corresponding IAM user is deleted.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.User = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("User(")
        append("active=$active,")
        append("arn=$arn,")
        append("customPermissionsName=$customPermissionsName,")
        append("email=$email,")
        append("externalLoginFederationProviderType=$externalLoginFederationProviderType,")
        append("externalLoginFederationProviderUrl=$externalLoginFederationProviderUrl,")
        append("externalLoginId=$externalLoginId,")
        append("identityType=$identityType,")
        append("principalId=$principalId,")
        append("role=$role,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = active.hashCode()
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (customPermissionsName?.hashCode() ?: 0)
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (externalLoginFederationProviderType?.hashCode() ?: 0)
        result = 31 * result + (externalLoginFederationProviderUrl?.hashCode() ?: 0)
        result = 31 * result + (externalLoginId?.hashCode() ?: 0)
        result = 31 * result + (identityType?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as User

        if (active != other.active) return false
        if (arn != other.arn) return false
        if (customPermissionsName != other.customPermissionsName) return false
        if (email != other.email) return false
        if (externalLoginFederationProviderType != other.externalLoginFederationProviderType) return false
        if (externalLoginFederationProviderUrl != other.externalLoginFederationProviderUrl) return false
        if (externalLoginId != other.externalLoginId) return false
        if (identityType != other.identityType) return false
        if (principalId != other.principalId) return false
        if (role != other.role) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.User = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The active status of user. When you create an Amazon QuickSight user that’s not an IAM user or an Active Directory user, that user is inactive until they sign in and provide a password.
         */
        public var active: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) for the user.
         */
        public var arn: kotlin.String? = null
        /**
         * The custom permissions profile associated with this user.
         */
        public var customPermissionsName: kotlin.String? = null
        /**
         * The user's email address.
         */
        public var email: kotlin.String? = null
        /**
         * The type of supported external login provider that provides identity to let the user federate into Amazon QuickSight with an associated IAM role. The type can be one of the following.
         * + `COGNITO`: Amazon Cognito. The provider URL is cognito-identity.amazonaws.com.
         * + `CUSTOM_OIDC`: Custom OpenID Connect (OIDC) provider.
         */
        public var externalLoginFederationProviderType: kotlin.String? = null
        /**
         * The URL of the external login provider.
         */
        public var externalLoginFederationProviderUrl: kotlin.String? = null
        /**
         * The identity ID for the user in the external login provider.
         */
        public var externalLoginId: kotlin.String? = null
        /**
         * The type of identity authentication used by the user.
         */
        public var identityType: aws.sdk.kotlin.services.quicksight.model.IdentityType? = null
        /**
         * The principal ID of the user.
         */
        public var principalId: kotlin.String? = null
        /**
         * The Amazon QuickSight role for the user. The user role can be one of the following:.
         * + `READER`: A user who has read-only access to dashboards.
         * + `AUTHOR`: A user who can create data sources, datasets, analyses, and dashboards.
         * + `ADMIN`: A user who is an author, who can also manage Amazon Amazon QuickSight settings.
         * + `RESTRICTED_READER`: This role isn't currently available for use.
         * + `RESTRICTED_AUTHOR`: This role isn't currently available for use.
         */
        public var role: aws.sdk.kotlin.services.quicksight.model.UserRole? = null
        /**
         * The user's user name. In the output, the value for `UserName` is `N/A` when the value for `IdentityType` is `IAM` and the corresponding IAM user is deleted.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.User) : this() {
            this.active = x.active
            this.arn = x.arn
            this.customPermissionsName = x.customPermissionsName
            this.email = x.email
            this.externalLoginFederationProviderType = x.externalLoginFederationProviderType
            this.externalLoginFederationProviderUrl = x.externalLoginFederationProviderUrl
            this.externalLoginId = x.externalLoginId
            this.identityType = x.identityType
            this.principalId = x.principalId
            this.role = x.role
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.User = User(this)
    }
}
