// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.paginators

import aws.sdk.kotlin.services.quicksight.QuickSightClient
import aws.sdk.kotlin.services.quicksight.model.AnalysisSummary
import aws.sdk.kotlin.services.quicksight.model.DashboardSummary
import aws.sdk.kotlin.services.quicksight.model.DashboardVersionSummary
import aws.sdk.kotlin.services.quicksight.model.DataSetSummary
import aws.sdk.kotlin.services.quicksight.model.DataSource
import aws.sdk.kotlin.services.quicksight.model.Ingestion
import aws.sdk.kotlin.services.quicksight.model.ListAnalysesRequest
import aws.sdk.kotlin.services.quicksight.model.ListAnalysesResponse
import aws.sdk.kotlin.services.quicksight.model.ListDashboardVersionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListDashboardVersionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDashboardsRequest
import aws.sdk.kotlin.services.quicksight.model.ListDashboardsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDataSetsRequest
import aws.sdk.kotlin.services.quicksight.model.ListDataSetsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.quicksight.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.quicksight.model.ListIngestionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListIngestionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListNamespacesRequest
import aws.sdk.kotlin.services.quicksight.model.ListNamespacesResponse
import aws.sdk.kotlin.services.quicksight.model.ListTemplateAliasesRequest
import aws.sdk.kotlin.services.quicksight.model.ListTemplateAliasesResponse
import aws.sdk.kotlin.services.quicksight.model.ListTemplateVersionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListTemplateVersionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListTemplatesRequest
import aws.sdk.kotlin.services.quicksight.model.ListTemplatesResponse
import aws.sdk.kotlin.services.quicksight.model.ListThemeVersionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListThemeVersionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListThemesRequest
import aws.sdk.kotlin.services.quicksight.model.ListThemesResponse
import aws.sdk.kotlin.services.quicksight.model.NamespaceInfoV2
import aws.sdk.kotlin.services.quicksight.model.SearchAnalysesRequest
import aws.sdk.kotlin.services.quicksight.model.SearchAnalysesResponse
import aws.sdk.kotlin.services.quicksight.model.SearchDashboardsRequest
import aws.sdk.kotlin.services.quicksight.model.SearchDashboardsResponse
import aws.sdk.kotlin.services.quicksight.model.TemplateAlias
import aws.sdk.kotlin.services.quicksight.model.TemplateSummary
import aws.sdk.kotlin.services.quicksight.model.TemplateVersionSummary
import aws.sdk.kotlin.services.quicksight.model.ThemeSummary
import aws.sdk.kotlin.services.quicksight.model.ThemeVersionSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAnalysesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAnalysesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnalysesResponse]
 */
public fun QuickSightClient.listAnalysesPaginated(initialRequest: ListAnalysesRequest): Flow<ListAnalysesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAnalysesPaginated.listAnalyses(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAnalysesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAnalysesResponse]
 */
public fun QuickSightClient.listAnalysesPaginated(block: ListAnalysesRequest.Builder.() -> Unit): Flow<ListAnalysesResponse> =
    listAnalysesPaginated(ListAnalysesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAnalysesPaginated]
 * to access the nested member [AnalysisSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AnalysisSummary]
 */
@JvmName("listAnalysesResponseAnalysisSummary")
public fun Flow<ListAnalysesResponse>.analysisSummaryList(): Flow<AnalysisSummary> =
    transform() { response ->
        response.analysisSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDashboardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDashboardsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDashboardsResponse]
 */
public fun QuickSightClient.listDashboardsPaginated(initialRequest: ListDashboardsRequest): Flow<ListDashboardsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDashboardsPaginated.listDashboards(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDashboardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDashboardsResponse]
 */
public fun QuickSightClient.listDashboardsPaginated(block: ListDashboardsRequest.Builder.() -> Unit): Flow<ListDashboardsResponse> =
    listDashboardsPaginated(ListDashboardsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDashboardsPaginated]
 * to access the nested member [DashboardSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DashboardSummary]
 */
@JvmName("listDashboardsResponseDashboardSummary")
public fun Flow<ListDashboardsResponse>.dashboardSummaryList(): Flow<DashboardSummary> =
    transform() { response ->
        response.dashboardSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDashboardVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDashboardVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDashboardVersionsResponse]
 */
public fun QuickSightClient.listDashboardVersionsPaginated(initialRequest: ListDashboardVersionsRequest): Flow<ListDashboardVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDashboardVersionsPaginated.listDashboardVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDashboardVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDashboardVersionsResponse]
 */
public fun QuickSightClient.listDashboardVersionsPaginated(block: ListDashboardVersionsRequest.Builder.() -> Unit): Flow<ListDashboardVersionsResponse> =
    listDashboardVersionsPaginated(ListDashboardVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDashboardVersionsPaginated]
 * to access the nested member [DashboardVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DashboardVersionSummary]
 */
@JvmName("listDashboardVersionsResponseDashboardVersionSummary")
public fun Flow<ListDashboardVersionsResponse>.dashboardVersionSummaryList(): Flow<DashboardVersionSummary> =
    transform() { response ->
        response.dashboardVersionSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetsResponse]
 */
public fun QuickSightClient.listDataSetsPaginated(initialRequest: ListDataSetsRequest): Flow<ListDataSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSetsPaginated.listDataSets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSetsResponse]
 */
public fun QuickSightClient.listDataSetsPaginated(block: ListDataSetsRequest.Builder.() -> Unit): Flow<ListDataSetsResponse> =
    listDataSetsPaginated(ListDataSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSetsPaginated]
 * to access the nested member [DataSetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSetSummary]
 */
@JvmName("listDataSetsResponseDataSetSummary")
public fun Flow<ListDataSetsResponse>.dataSetSummaries(): Flow<DataSetSummary> =
    transform() { response ->
        response.dataSetSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDataSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourcesResponse]
 */
public fun QuickSightClient.listDataSourcesPaginated(initialRequest: ListDataSourcesRequest): Flow<ListDataSourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDataSourcesPaginated.listDataSources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDataSourcesResponse]
 */
public fun QuickSightClient.listDataSourcesPaginated(block: ListDataSourcesRequest.Builder.() -> Unit): Flow<ListDataSourcesResponse> =
    listDataSourcesPaginated(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDataSourcesPaginated]
 * to access the nested member [DataSource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSource]
 */
@JvmName("listDataSourcesResponseDataSource")
public fun Flow<ListDataSourcesResponse>.dataSources(): Flow<DataSource> =
    transform() { response ->
        response.dataSources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIngestionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIngestionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIngestionsResponse]
 */
public fun QuickSightClient.listIngestionsPaginated(initialRequest: ListIngestionsRequest): Flow<ListIngestionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIngestionsPaginated.listIngestions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListIngestionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIngestionsResponse]
 */
public fun QuickSightClient.listIngestionsPaginated(block: ListIngestionsRequest.Builder.() -> Unit): Flow<ListIngestionsResponse> =
    listIngestionsPaginated(ListIngestionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIngestionsPaginated]
 * to access the nested member [Ingestion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Ingestion]
 */
@JvmName("listIngestionsResponseIngestion")
public fun Flow<ListIngestionsResponse>.ingestions(): Flow<Ingestion> =
    transform() { response ->
        response.ingestions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNamespacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNamespacesResponse]
 */
public fun QuickSightClient.listNamespacesPaginated(initialRequest: ListNamespacesRequest): Flow<ListNamespacesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNamespacesPaginated.listNamespaces(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNamespacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNamespacesResponse]
 */
public fun QuickSightClient.listNamespacesPaginated(block: ListNamespacesRequest.Builder.() -> Unit): Flow<ListNamespacesResponse> =
    listNamespacesPaginated(ListNamespacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listNamespacesPaginated]
 * to access the nested member [NamespaceInfoV2]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NamespaceInfoV2]
 */
@JvmName("listNamespacesResponseNamespaceInfoV2")
public fun Flow<ListNamespacesResponse>.namespaces(): Flow<NamespaceInfoV2> =
    transform() { response ->
        response.namespaces?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTemplateAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTemplateAliasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplateAliasesResponse]
 */
public fun QuickSightClient.listTemplateAliasesPaginated(initialRequest: ListTemplateAliasesRequest): Flow<ListTemplateAliasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTemplateAliasesPaginated.listTemplateAliases(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTemplateAliasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplateAliasesResponse]
 */
public fun QuickSightClient.listTemplateAliasesPaginated(block: ListTemplateAliasesRequest.Builder.() -> Unit): Flow<ListTemplateAliasesResponse> =
    listTemplateAliasesPaginated(ListTemplateAliasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTemplateAliasesPaginated]
 * to access the nested member [TemplateAlias]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TemplateAlias]
 */
@JvmName("listTemplateAliasesResponseTemplateAlias")
public fun Flow<ListTemplateAliasesResponse>.templateAliasList(): Flow<TemplateAlias> =
    transform() { response ->
        response.templateAliasList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplatesResponse]
 */
public fun QuickSightClient.listTemplatesPaginated(initialRequest: ListTemplatesRequest): Flow<ListTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTemplatesPaginated.listTemplates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplatesResponse]
 */
public fun QuickSightClient.listTemplatesPaginated(block: ListTemplatesRequest.Builder.() -> Unit): Flow<ListTemplatesResponse> =
    listTemplatesPaginated(ListTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTemplatesPaginated]
 * to access the nested member [TemplateSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TemplateSummary]
 */
@JvmName("listTemplatesResponseTemplateSummary")
public fun Flow<ListTemplatesResponse>.templateSummaryList(): Flow<TemplateSummary> =
    transform() { response ->
        response.templateSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTemplateVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTemplateVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplateVersionsResponse]
 */
public fun QuickSightClient.listTemplateVersionsPaginated(initialRequest: ListTemplateVersionsRequest): Flow<ListTemplateVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTemplateVersionsPaginated.listTemplateVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTemplateVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplateVersionsResponse]
 */
public fun QuickSightClient.listTemplateVersionsPaginated(block: ListTemplateVersionsRequest.Builder.() -> Unit): Flow<ListTemplateVersionsResponse> =
    listTemplateVersionsPaginated(ListTemplateVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTemplateVersionsPaginated]
 * to access the nested member [TemplateVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TemplateVersionSummary]
 */
@JvmName("listTemplateVersionsResponseTemplateVersionSummary")
public fun Flow<ListTemplateVersionsResponse>.templateVersionSummaryList(): Flow<TemplateVersionSummary> =
    transform() { response ->
        response.templateVersionSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListThemesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListThemesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListThemesResponse]
 */
public fun QuickSightClient.listThemesPaginated(initialRequest: ListThemesRequest): Flow<ListThemesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listThemesPaginated.listThemes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListThemesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListThemesResponse]
 */
public fun QuickSightClient.listThemesPaginated(block: ListThemesRequest.Builder.() -> Unit): Flow<ListThemesResponse> =
    listThemesPaginated(ListThemesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listThemesPaginated]
 * to access the nested member [ThemeSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ThemeSummary]
 */
@JvmName("listThemesResponseThemeSummary")
public fun Flow<ListThemesResponse>.themeSummaryList(): Flow<ThemeSummary> =
    transform() { response ->
        response.themeSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListThemeVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListThemeVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListThemeVersionsResponse]
 */
public fun QuickSightClient.listThemeVersionsPaginated(initialRequest: ListThemeVersionsRequest): Flow<ListThemeVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listThemeVersionsPaginated.listThemeVersions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListThemeVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListThemeVersionsResponse]
 */
public fun QuickSightClient.listThemeVersionsPaginated(block: ListThemeVersionsRequest.Builder.() -> Unit): Flow<ListThemeVersionsResponse> =
    listThemeVersionsPaginated(ListThemeVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listThemeVersionsPaginated]
 * to access the nested member [ThemeVersionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ThemeVersionSummary]
 */
@JvmName("listThemeVersionsResponseThemeVersionSummary")
public fun Flow<ListThemeVersionsResponse>.themeVersionSummaryList(): Flow<ThemeVersionSummary> =
    transform() { response ->
        response.themeVersionSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchAnalysesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchAnalysesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchAnalysesResponse]
 */
public fun QuickSightClient.searchAnalysesPaginated(initialRequest: SearchAnalysesRequest): Flow<SearchAnalysesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchAnalysesPaginated.searchAnalyses(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchAnalysesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchAnalysesResponse]
 */
public fun QuickSightClient.searchAnalysesPaginated(block: SearchAnalysesRequest.Builder.() -> Unit): Flow<SearchAnalysesResponse> =
    searchAnalysesPaginated(SearchAnalysesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchAnalysesPaginated]
 * to access the nested member [AnalysisSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AnalysisSummary]
 */
@JvmName("searchAnalysesResponseAnalysisSummary")
public fun Flow<SearchAnalysesResponse>.analysisSummaryList(): Flow<AnalysisSummary> =
    transform() { response ->
        response.analysisSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchDashboardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchDashboardsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchDashboardsResponse]
 */
public fun QuickSightClient.searchDashboardsPaginated(initialRequest: SearchDashboardsRequest): Flow<SearchDashboardsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchDashboardsPaginated.searchDashboards(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [SearchDashboardsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchDashboardsResponse]
 */
public fun QuickSightClient.searchDashboardsPaginated(block: SearchDashboardsRequest.Builder.() -> Unit): Flow<SearchDashboardsResponse> =
    searchDashboardsPaginated(SearchDashboardsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchDashboardsPaginated]
 * to access the nested member [DashboardSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DashboardSummary]
 */
@JvmName("searchDashboardsResponseDashboardSummary")
public fun Flow<SearchDashboardsResponse>.dashboardSummaryList(): Flow<DashboardSummary> =
    transform() { response ->
        response.dashboardSummaryList?.forEach {
            emit(it)
        }
    }
