// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.transform

import aws.sdk.kotlin.services.quicksight.model.AuthenticationMethodOption
import aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest
import aws.sdk.kotlin.services.quicksight.model.Edition
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateAccountSubscriptionOperationSerializer: HttpSerialize<CreateAccountSubscriptionRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateAccountSubscriptionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "account",
                "${input.awsAccountId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateAccountSubscriptionOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAccountSubscriptionOperationBody(context: ExecutionContext, input: CreateAccountSubscriptionRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCOUNTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccountName"))
    val ACTIVEDIRECTORYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ActiveDirectoryName"))
    val ADMINGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AdminGroup"))
    val AUTHENTICATIONMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AuthenticationMethod"))
    val AUTHORGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AuthorGroup"))
    val CONTACTNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactNumber"))
    val DIRECTORYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DirectoryId"))
    val EDITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Edition"))
    val EMAILADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EmailAddress"))
    val FIRSTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FirstName"))
    val LASTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LastName"))
    val NOTIFICATIONEMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NotificationEmail"))
    val READERGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ReaderGroup"))
    val REALM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Realm"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTNAME_DESCRIPTOR)
        field(ACTIVEDIRECTORYNAME_DESCRIPTOR)
        field(ADMINGROUP_DESCRIPTOR)
        field(AUTHENTICATIONMETHOD_DESCRIPTOR)
        field(AUTHORGROUP_DESCRIPTOR)
        field(CONTACTNUMBER_DESCRIPTOR)
        field(DIRECTORYID_DESCRIPTOR)
        field(EDITION_DESCRIPTOR)
        field(EMAILADDRESS_DESCRIPTOR)
        field(FIRSTNAME_DESCRIPTOR)
        field(LASTNAME_DESCRIPTOR)
        field(NOTIFICATIONEMAIL_DESCRIPTOR)
        field(READERGROUP_DESCRIPTOR)
        field(REALM_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accountName?.let { field(ACCOUNTNAME_DESCRIPTOR, it) }
        input.activeDirectoryName?.let { field(ACTIVEDIRECTORYNAME_DESCRIPTOR, it) }
        if (input.adminGroup != null) {
            listField(ADMINGROUP_DESCRIPTOR) {
                for (el0 in input.adminGroup) {
                    serializeString(el0)
                }
            }
        }
        input.authenticationMethod?.let { field(AUTHENTICATIONMETHOD_DESCRIPTOR, it.value) }
        if (input.authorGroup != null) {
            listField(AUTHORGROUP_DESCRIPTOR) {
                for (el0 in input.authorGroup) {
                    serializeString(el0)
                }
            }
        }
        input.contactNumber?.let { field(CONTACTNUMBER_DESCRIPTOR, it) }
        input.directoryId?.let { field(DIRECTORYID_DESCRIPTOR, it) }
        input.edition?.let { field(EDITION_DESCRIPTOR, it.value) }
        input.emailAddress?.let { field(EMAILADDRESS_DESCRIPTOR, it) }
        input.firstName?.let { field(FIRSTNAME_DESCRIPTOR, it) }
        input.lastName?.let { field(LASTNAME_DESCRIPTOR, it) }
        input.notificationEmail?.let { field(NOTIFICATIONEMAIL_DESCRIPTOR, it) }
        if (input.readerGroup != null) {
            listField(READERGROUP_DESCRIPTOR) {
                for (el0 in input.readerGroup) {
                    serializeString(el0)
                }
            }
        }
        input.realm?.let { field(REALM_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
