// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.quicksight.model.AssignmentStatus
import aws.sdk.kotlin.services.quicksight.model.CreateIamPolicyAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateIAMPolicyAssignmentOperationDeserializer: HttpDeserialize<CreateIamPolicyAssignmentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateIamPolicyAssignmentResponse {
        if (!response.status.isSuccess()) {
            throwCreateIamPolicyAssignmentError(context, response)
        }
        val builder = CreateIamPolicyAssignmentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateIAMPolicyAssignmentOperationBody(builder, payload)
        }
        builder.status = response.status.value
        return builder.build()
    }
}

private suspend fun throwCreateIamPolicyAssignmentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConcurrentUpdatingException" -> ConcurrentUpdatingExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceExistsException" -> ResourceExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateIAMPolicyAssignmentOperationBody(builder: CreateIamPolicyAssignmentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSIGNMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AssignmentId"))
    val ASSIGNMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AssignmentName"))
    val ASSIGNMENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AssignmentStatus"))
    val IDENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Identities"))
    val IDENTITIES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val POLICYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PolicyArn"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSIGNMENTID_DESCRIPTOR)
        field(ASSIGNMENTNAME_DESCRIPTOR)
        field(ASSIGNMENTSTATUS_DESCRIPTOR)
        field(IDENTITIES_DESCRIPTOR)
        field(POLICYARN_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSIGNMENTID_DESCRIPTOR.index -> builder.assignmentId = deserializeString()
                ASSIGNMENTNAME_DESCRIPTOR.index -> builder.assignmentName = deserializeString()
                ASSIGNMENTSTATUS_DESCRIPTOR.index -> builder.assignmentStatus = deserializeString().let { AssignmentStatus.fromValue(it) }
                IDENTITIES_DESCRIPTOR.index -> builder.identities =
                    deserializer.deserializeMap(IDENTITIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<String>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(IDENTITIES_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<String>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                POLICYARN_DESCRIPTOR.index -> builder.policyArn = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
