// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.transform

import aws.sdk.kotlin.services.quicksight.model.CreateThemeRequest
import aws.sdk.kotlin.services.quicksight.model.ResourcePermission
import aws.sdk.kotlin.services.quicksight.model.Tag
import aws.sdk.kotlin.services.quicksight.model.ThemeConfiguration
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateThemeOperationSerializer: HttpSerialize<CreateThemeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateThemeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "accounts",
                "${input.awsAccountId}".encodeLabel(),
                "themes",
                "${input.themeId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateThemeOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateThemeOperationBody(context: ExecutionContext, input: CreateThemeRequest): ByteArray {
    val serializer = JsonSerializer()
    val BASETHEMEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BaseThemeId"))
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Configuration"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Permissions"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val VERSIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASETHEMEID_DESCRIPTOR)
        field(CONFIGURATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PERMISSIONS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERSIONDESCRIPTION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.baseThemeId?.let { field(BASETHEMEID_DESCRIPTOR, it) }
        input.configuration?.let { field(CONFIGURATION_DESCRIPTOR, it, ::serializeThemeConfigurationDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        if (input.permissions != null) {
            listField(PERMISSIONS_DESCRIPTOR) {
                for (el0 in input.permissions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResourcePermissionDocument))
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.versionDescription?.let { field(VERSIONDESCRIPTION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
