// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.quicksight.model.DescribeGroupMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.GroupMember
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeGroupMembershipOperationDeserializer: HttpDeserialize<DescribeGroupMembershipResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeGroupMembershipResponse {
        if (!response.status.isSuccess()) {
            throwDescribeGroupMembershipError(context, response)
        }
        val builder = DescribeGroupMembershipResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeGroupMembershipOperationBody(builder, payload)
        }
        builder.status = response.status.value
        return builder.build()
    }
}

private suspend fun throwDescribeGroupMembershipError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "PreconditionNotMetException" -> PreconditionNotMetExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceUnavailableException" -> ResourceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeGroupMembershipOperationBody(builder: DescribeGroupMembershipResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val GROUPMEMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("GroupMember"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GROUPMEMBER_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GROUPMEMBER_DESCRIPTOR.index -> builder.groupMember = deserializeGroupMemberDocument(deserializer)
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
