// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.transform

import aws.sdk.kotlin.services.quicksight.model.AnonymousUserEmbeddingExperienceConfiguration
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest
import aws.sdk.kotlin.services.quicksight.model.SessionTag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GenerateEmbedUrlForAnonymousUserOperationSerializer: HttpSerialize<GenerateEmbedUrlForAnonymousUserRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GenerateEmbedUrlForAnonymousUserRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "accounts",
                "${input.awsAccountId}".encodeLabel(),
                "embed-url",
                "anonymous-user",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeGenerateEmbedUrlForAnonymousUserOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeGenerateEmbedUrlForAnonymousUserOperationBody(context: ExecutionContext, input: GenerateEmbedUrlForAnonymousUserRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALLOWEDDOMAINS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AllowedDomains"))
    val AUTHORIZEDRESOURCEARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AuthorizedResourceArns"))
    val EXPERIENCECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExperienceConfiguration"))
    val NAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Namespace"))
    val SESSIONLIFETIMEINMINUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("SessionLifetimeInMinutes"))
    val SESSIONTAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SessionTags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALLOWEDDOMAINS_DESCRIPTOR)
        field(AUTHORIZEDRESOURCEARNS_DESCRIPTOR)
        field(EXPERIENCECONFIGURATION_DESCRIPTOR)
        field(NAMESPACE_DESCRIPTOR)
        field(SESSIONLIFETIMEINMINUTES_DESCRIPTOR)
        field(SESSIONTAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.allowedDomains != null) {
            listField(ALLOWEDDOMAINS_DESCRIPTOR) {
                for (el0 in input.allowedDomains) {
                    serializeString(el0)
                }
            }
        }
        if (input.authorizedResourceArns != null) {
            listField(AUTHORIZEDRESOURCEARNS_DESCRIPTOR) {
                for (el0 in input.authorizedResourceArns) {
                    serializeString(el0)
                }
            }
        }
        input.experienceConfiguration?.let { field(EXPERIENCECONFIGURATION_DESCRIPTOR, it, ::serializeAnonymousUserEmbeddingExperienceConfigurationDocument) }
        input.namespace?.let { field(NAMESPACE_DESCRIPTOR, it) }
        input.sessionLifetimeInMinutes?.let { field(SESSIONLIFETIMEINMINUTES_DESCRIPTOR, it) }
        if (input.sessionTags != null) {
            listField(SESSIONTAGS_DESCRIPTOR) {
                for (el0 in input.sessionTags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSessionTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
