// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.transform

import aws.sdk.kotlin.services.quicksight.model.IdentityType
import aws.sdk.kotlin.services.quicksight.model.RegisterUserRequest
import aws.sdk.kotlin.services.quicksight.model.UserRole
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RegisterUserOperationSerializer: HttpSerialize<RegisterUserRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RegisterUserRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "accounts",
                "${input.awsAccountId}".encodeLabel(),
                "namespaces",
                "${input.namespace}".encodeLabel(),
                "users",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeRegisterUserOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeRegisterUserOperationBody(context: ExecutionContext, input: RegisterUserRequest): ByteArray {
    val serializer = JsonSerializer()
    val CUSTOMFEDERATIONPROVIDERURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomFederationProviderUrl"))
    val CUSTOMPERMISSIONSNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CustomPermissionsName"))
    val EMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Email"))
    val EXTERNALLOGINFEDERATIONPROVIDERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExternalLoginFederationProviderType"))
    val EXTERNALLOGINID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExternalLoginId"))
    val IAMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IamArn"))
    val IDENTITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdentityType"))
    val SESSIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SessionName"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserName"))
    val USERROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UserRole"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CUSTOMFEDERATIONPROVIDERURL_DESCRIPTOR)
        field(CUSTOMPERMISSIONSNAME_DESCRIPTOR)
        field(EMAIL_DESCRIPTOR)
        field(EXTERNALLOGINFEDERATIONPROVIDERTYPE_DESCRIPTOR)
        field(EXTERNALLOGINID_DESCRIPTOR)
        field(IAMARN_DESCRIPTOR)
        field(IDENTITYTYPE_DESCRIPTOR)
        field(SESSIONNAME_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
        field(USERROLE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.customFederationProviderUrl?.let { field(CUSTOMFEDERATIONPROVIDERURL_DESCRIPTOR, it) }
        input.customPermissionsName?.let { field(CUSTOMPERMISSIONSNAME_DESCRIPTOR, it) }
        input.email?.let { field(EMAIL_DESCRIPTOR, it) }
        input.externalLoginFederationProviderType?.let { field(EXTERNALLOGINFEDERATIONPROVIDERTYPE_DESCRIPTOR, it) }
        input.externalLoginId?.let { field(EXTERNALLOGINID_DESCRIPTOR, it) }
        input.iamArn?.let { field(IAMARN_DESCRIPTOR, it) }
        input.identityType?.let { field(IDENTITYTYPE_DESCRIPTOR, it.value) }
        input.sessionName?.let { field(SESSIONNAME_DESCRIPTOR, it) }
        input.userName?.let { field(USERNAME_DESCRIPTOR, it) }
        input.userRole?.let { field(USERROLE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
