// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.quicksight.model.QuickSightException
import aws.sdk.kotlin.services.quicksight.model.ResourceStatus
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDashboardOperationDeserializer: HttpDeserialize<UpdateDashboardResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDashboardResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDashboardError(context, response)
        }
        val builder = UpdateDashboardResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateDashboardOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateDashboardError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw QuickSightException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedUserEditionException" -> UnsupportedUserEditionExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> QuickSightException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDashboardOperationBody(builder: UpdateDashboardResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreationStatus"))
    val DASHBOARDID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DashboardId"))
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Status"))
    val VERSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATIONSTATUS_DESCRIPTOR)
        field(DASHBOARDID_DESCRIPTOR)
        field(REQUESTID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(VERSIONARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONSTATUS_DESCRIPTOR.index -> builder.creationStatus = deserializeString().let { ResourceStatus.fromValue(it) }
                DASHBOARDID_DESCRIPTOR.index -> builder.dashboardId = deserializeString()
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeInt()
                VERSIONARN_DESCRIPTOR.index -> builder.versionArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
