// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.transform

import aws.sdk.kotlin.services.quicksight.model.DashboardPublishOptions
import aws.sdk.kotlin.services.quicksight.model.DashboardSourceEntity
import aws.sdk.kotlin.services.quicksight.model.Parameters
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDashboardOperationSerializer: HttpSerialize<UpdateDashboardRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateDashboardRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf(
                "accounts",
                "${input.awsAccountId}".encodeLabel(),
                "dashboards",
                "${input.dashboardId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateDashboardOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateDashboardOperationBody(context: ExecutionContext, input: UpdateDashboardRequest): ByteArray {
    val serializer = JsonSerializer()
    val DASHBOARDPUBLISHOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DashboardPublishOptions"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Parameters"))
    val SOURCEENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SourceEntity"))
    val THEMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ThemeArn"))
    val VERSIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VersionDescription"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DASHBOARDPUBLISHOPTIONS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(SOURCEENTITY_DESCRIPTOR)
        field(THEMEARN_DESCRIPTOR)
        field(VERSIONDESCRIPTION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.dashboardPublishOptions?.let { field(DASHBOARDPUBLISHOPTIONS_DESCRIPTOR, it, ::serializeDashboardPublishOptionsDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.parameters?.let { field(PARAMETERS_DESCRIPTOR, it, ::serializeParametersDocument) }
        input.sourceEntity?.let { field(SOURCEENTITY_DESCRIPTOR, it, ::serializeDashboardSourceEntityDocument) }
        input.themeArn?.let { field(THEMEARN_DESCRIPTOR, it) }
        input.versionDescription?.let { field(VERSIONDESCRIPTION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
