// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rbin.model



public class CreateRuleRequest private constructor(builder: Builder) {
    /**
     * The retention rule description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of the specified resource type, that have one or more of the specified tag key and value pairs are retained. If a resource is deleted, but it does not have any of the specified tag key and value pairs, it is immediately deleted without being retained by the retention rule.
     *
     * You can add the same tag key and value pair to a maximum or five retention rules.
     *
     * To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have any resource tags specified. It retains all deleted resources of the specified resource type in the Region in which the rule is created, even if the resources are not tagged.
     */
    public val resourceTags: List<ResourceTag>? = builder.resourceTags
    /**
     * The resource type to be retained by the retention rule. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To retain snapshots, specify `EBS_SNAPSHOT`. To retain EBS-backed AMIs, specify `EC2_IMAGE`.
     */
    public val resourceType: aws.sdk.kotlin.services.rbin.model.ResourceType? = builder.resourceType
    /**
     * Information about the retention period for which the retention rule is to retain resources.
     */
    public val retentionPeriod: aws.sdk.kotlin.services.rbin.model.RetentionPeriod? = builder.retentionPeriod
    /**
     * Information about the tags to assign to the retention rule.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rbin.model.CreateRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRuleRequest(")
        append("description=$description,")
        append("resourceTags=$resourceTags,")
        append("resourceType=$resourceType,")
        append("retentionPeriod=$retentionPeriod,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (retentionPeriod?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRuleRequest

        if (description != other.description) return false
        if (resourceTags != other.resourceTags) return false
        if (resourceType != other.resourceType) return false
        if (retentionPeriod != other.retentionPeriod) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rbin.model.CreateRuleRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The retention rule description.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies the resource tags to use to identify resources that are to be retained by a tag-level retention rule. For tag-level retention rules, only deleted resources, of the specified resource type, that have one or more of the specified tag key and value pairs are retained. If a resource is deleted, but it does not have any of the specified tag key and value pairs, it is immediately deleted without being retained by the retention rule.
         *
         * You can add the same tag key and value pair to a maximum or five retention rules.
         *
         * To create a Region-level retention rule, omit this parameter. A Region-level retention rule does not have any resource tags specified. It retains all deleted resources of the specified resource type in the Region in which the rule is created, even if the resources are not tagged.
         */
        public var resourceTags: List<ResourceTag>? = null
        /**
         * The resource type to be retained by the retention rule. Currently, only Amazon EBS snapshots and EBS-backed AMIs are supported. To retain snapshots, specify `EBS_SNAPSHOT`. To retain EBS-backed AMIs, specify `EC2_IMAGE`.
         */
        public var resourceType: aws.sdk.kotlin.services.rbin.model.ResourceType? = null
        /**
         * Information about the retention period for which the retention rule is to retain resources.
         */
        public var retentionPeriod: aws.sdk.kotlin.services.rbin.model.RetentionPeriod? = null
        /**
         * Information about the tags to assign to the retention rule.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rbin.model.CreateRuleRequest) : this() {
            this.description = x.description
            this.resourceTags = x.resourceTags
            this.resourceType = x.resourceType
            this.retentionPeriod = x.retentionPeriod
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rbin.model.CreateRuleRequest = CreateRuleRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rbin.model.RetentionPeriod] inside the given [block]
         */
        public fun retentionPeriod(block: aws.sdk.kotlin.services.rbin.model.RetentionPeriod.Builder.() -> kotlin.Unit) {
            this.retentionPeriod = aws.sdk.kotlin.services.rbin.model.RetentionPeriod.invoke(block)
        }
    }
}
