// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rbin.paginators

import aws.sdk.kotlin.services.rbin.RbinClient
import aws.sdk.kotlin.services.rbin.model.ListRulesRequest
import aws.sdk.kotlin.services.rbin.model.ListRulesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesResponse]
 */
public fun RbinClient.listRulesPaginated(initialRequest: ListRulesRequest): Flow<ListRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRulesPaginated.listRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRulesResponse]
 */
public fun RbinClient.listRulesPaginated(block: ListRulesRequest.Builder.() -> Unit): Flow<ListRulesResponse> =
    listRulesPaginated(ListRulesRequest.Builder().apply(block).build())
