// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rbin.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.rbin.model.GetRuleResponse
import aws.sdk.kotlin.services.rbin.model.RbinException
import aws.sdk.kotlin.services.rbin.model.ResourceTag
import aws.sdk.kotlin.services.rbin.model.ResourceType
import aws.sdk.kotlin.services.rbin.model.RetentionPeriod
import aws.sdk.kotlin.services.rbin.model.RuleStatus
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRuleOperationDeserializer: HttpDeserialize<GetRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRuleResponse {
        if (!response.status.isSuccess()) {
            throwGetRuleError(context, response)
        }
        val builder = GetRuleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRuleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRuleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RbinException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RbinException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRuleOperationBody(builder: GetRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val IDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Identifier"))
    val RESOURCETAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourceTags"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceType"))
    val RETENTIONPERIOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RetentionPeriod"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(IDENTIFIER_DESCRIPTOR)
        field(RESOURCETAGS_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
        field(RETENTIONPERIOD_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                IDENTIFIER_DESCRIPTOR.index -> builder.identifier = deserializeString()
                RESOURCETAGS_DESCRIPTOR.index -> builder.resourceTags =
                    deserializer.deserializeList(RESOURCETAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<ResourceTag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOURCETYPE_DESCRIPTOR.index -> builder.resourceType = deserializeString().let { ResourceType.fromValue(it) }
                RETENTIONPERIOD_DESCRIPTOR.index -> builder.retentionPeriod = deserializeRetentionPeriodDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { RuleStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
