// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.rds.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.rds.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * <fullname>Amazon Relational Database Service</fullname>
 *
 * Amazon Relational Database Service (Amazon RDS) is a web service that makes it easier to set up, operate, and
 * scale a relational database in the cloud. It provides cost-efficient, resizeable capacity for an industry-standard relational
 * database and manages common database administration tasks, freeing up developers to focus on what makes their applications
 * and businesses unique.
 * Amazon RDS gives you access to the capabilities of a MySQL, MariaDB, PostgreSQL, Microsoft SQL Server,
 * Oracle, or Amazon Aurora database server. These capabilities mean that the code, applications, and tools
 * you already use today with your existing databases work with Amazon RDS without modification. Amazon RDS
 * automatically backs up your database and maintains the database software that powers your DB instance. Amazon RDS
 * is flexible: you can scale your DB instance's compute resources and storage capacity to meet your
 * application's demand. As with all Amazon Web Services, there are no up-front investments, and you pay only for
 * the resources you use.
 * This interface reference for Amazon RDS contains documentation for a programming or command line interface
 * you can use to manage Amazon RDS. Amazon RDS is asynchronous, which means that some interfaces might
 * require techniques such as polling or callback functions to determine when a command has been applied. In this
 * reference, the parameter descriptions indicate whether a command is applied immediately, on the next instance reboot,
 * or during the maintenance window. The reference structure is as follows, and we list following some related topics
 * from the user guide.
 *
 * Amazon RDS API Reference
 *
 *
 *
 * For the alphabetical list of API actions, see
 * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Operations.html">API Actions.
 *
 * For the alphabetical list of data types, see
 * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Types.html">Data Types.
 *
 * For a list of common query parameters, see
 * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonParameters.html">Common Parameters.
 *
 * For descriptions of the error codes, see
 * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonErrors.html">Common Errors.
 *
 *
 *
 * Amazon RDS User Guide
 *
 *
 *
 * For a summary of the Amazon RDS interfaces, see
 * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html#Welcome.Interfaces">Available RDS Interfaces.
 *
 * For more information about how to use the Query API, see
 * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Using_the_Query_API.html">Using the Query API.
 */
interface RdsClient : SdkClient {

    override val serviceName: String
        get() = "RDS"
    /**
     * RdsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): RdsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultRdsClient(config)
        }

        operator fun invoke(config: Config): RdsClient = DefaultRdsClient(config)

        /**
         * Construct a [RdsClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): RdsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultRdsClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an Identity and Access Management (IAM) role with a DB cluster.
     */
    suspend fun addRoleToDbCluster(input: AddRoleToDbClusterRequest): AddRoleToDbClusterResponse

    /**
     * Associates an Identity and Access Management (IAM) role with a DB cluster.
     */
    suspend fun addRoleToDbCluster(block: AddRoleToDbClusterRequest.Builder.() -> Unit) = addRoleToDbCluster(AddRoleToDbClusterRequest.Builder().apply(block).build())

    /**
     * Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
     *
     * To add a role to a DB instance, the status of the DB instance must be available.
     *
     * This command doesn't apply to RDS Custom.
     */
    suspend fun addRoleToDbInstance(input: AddRoleToDbInstanceRequest): AddRoleToDbInstanceResponse

    /**
     * Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
     *
     * To add a role to a DB instance, the status of the DB instance must be available.
     *
     * This command doesn't apply to RDS Custom.
     */
    suspend fun addRoleToDbInstance(block: AddRoleToDbInstanceRequest.Builder.() -> Unit) = addRoleToDbInstance(AddRoleToDbInstanceRequest.Builder().apply(block).build())

    /**
     * Adds a source identifier to an existing RDS event notification subscription.
     */
    suspend fun addSourceIdentifierToSubscription(input: AddSourceIdentifierToSubscriptionRequest): AddSourceIdentifierToSubscriptionResponse

    /**
     * Adds a source identifier to an existing RDS event notification subscription.
     */
    suspend fun addSourceIdentifierToSubscription(block: AddSourceIdentifierToSubscriptionRequest.Builder.() -> Unit) = addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest.Builder().apply(block).build())

    /**
     * Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
     * For an overview on tagging Amazon RDS resources,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources.
     */
    suspend fun addTagsToResource(input: AddTagsToResourceRequest): AddTagsToResourceResponse

    /**
     * Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
     * For an overview on tagging Amazon RDS resources,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources.
     */
    suspend fun addTagsToResource(block: AddTagsToResourceRequest.Builder.() -> Unit) = addTagsToResource(AddTagsToResourceRequest.Builder().apply(block).build())

    /**
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     */
    suspend fun applyPendingMaintenanceAction(input: ApplyPendingMaintenanceActionRequest): ApplyPendingMaintenanceActionResponse

    /**
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     */
    suspend fun applyPendingMaintenanceAction(block: ApplyPendingMaintenanceActionRequest.Builder.() -> Unit) = applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.Builder().apply(block).build())

    /**
     * Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security
     * groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC
     * instances. Second, IP ranges are available if the application accessing your database is running on the internet.
     * Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId
     * and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
     *
     * You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB instance in
     * another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB instance in another.
     *
     * For an overview of CIDR ranges, go to the
     * <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial.
     */
    suspend fun authorizeDbSecurityGroupIngress(input: AuthorizeDbSecurityGroupIngressRequest): AuthorizeDbSecurityGroupIngressResponse

    /**
     * Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security
     * groups can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC
     * instances. Second, IP ranges are available if the application accessing your database is running on the internet.
     * Required parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId
     * and either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
     *
     * You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB instance in
     * another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB instance in another.
     *
     * For an overview of CIDR ranges, go to the
     * <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial.
     */
    suspend fun authorizeDbSecurityGroupIngress(block: AuthorizeDbSecurityGroupIngressRequest.Builder.() -> Unit) = authorizeDbSecurityGroupIngress(AuthorizeDbSecurityGroupIngressRequest.Builder().apply(block).build())

    /**
     * Backtracks a DB cluster to a specific time, without creating a new DB cluster.
     * For more information on backtracking, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">
     * Backtracking an Aurora DB Cluster in the
     * Amazon Aurora User Guide.
     *
     * This action only applies to Aurora MySQL DB clusters.
     */
    suspend fun backtrackDbCluster(input: BacktrackDbClusterRequest): BacktrackDbClusterResponse

    /**
     * Backtracks a DB cluster to a specific time, without creating a new DB cluster.
     * For more information on backtracking, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">
     * Backtracking an Aurora DB Cluster in the
     * Amazon Aurora User Guide.
     *
     * This action only applies to Aurora MySQL DB clusters.
     */
    suspend fun backtrackDbCluster(block: BacktrackDbClusterRequest.Builder.() -> Unit) = backtrackDbCluster(BacktrackDbClusterRequest.Builder().apply(block).build())

    /**
     * Cancels an export task in progress that is exporting a snapshot to Amazon S3.
     * Any data that has already been written to the S3 bucket isn't removed.
     */
    suspend fun cancelExportTask(input: CancelExportTaskRequest): CancelExportTaskResponse

    /**
     * Cancels an export task in progress that is exporting a snapshot to Amazon S3.
     * Any data that has already been written to the S3 bucket isn't removed.
     */
    suspend fun cancelExportTask(block: CancelExportTaskRequest.Builder.() -> Unit) = cancelExportTask(CancelExportTaskRequest.Builder().apply(block).build())

    /**
     * Copies the specified DB cluster parameter group.
     */
    suspend fun copyDbClusterParameterGroup(input: CopyDbClusterParameterGroupRequest): CopyDbClusterParameterGroupResponse

    /**
     * Copies the specified DB cluster parameter group.
     */
    suspend fun copyDbClusterParameterGroup(block: CopyDbClusterParameterGroupRequest.Builder.() -> Unit) = copyDbClusterParameterGroup(CopyDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Copies a snapshot of a DB cluster.
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot, SourceDBClusterSnapshotIdentifier
     * must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.
     * You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon Web Services Region where you call the CopyDBClusterSnapshot action
     * is the destination Amazon Web Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot from another Amazon Web Services Region,
     * you must provide the following values:
     *
     *
     *
     * KmsKeyId - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key to use to
     * encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     *
     *
     * PreSignedUrl -  A URL that contains a Signature Version 4 signed request for the
     * CopyDBClusterSnapshot action to be called in the source Amazon Web Services Region where the DB cluster snapshot is copied from.
     * The pre-signed URL must be a valid request for the CopyDBClusterSnapshot API action that can be executed in the
     * source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied.
     * The pre-signed URL request must contain the following parameter values:
     *
     *
     *
     * KmsKeyId - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB
     * cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the CopyDBClusterSnapshot
     * action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.
     *
     *
     *
     * DestinationRegion - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.
     *
     *
     *
     * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example,
     * if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your SourceDBClusterSnapshotIdentifier
     * looks like the following example: arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115.
     *
     *
     * To learn how to generate a Signature Version 4 signed request, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">
     * Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4) and
     * <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">
     * Signature Version 4 Signing Process.
     *
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify SourceRegion (or --source-region for the CLI)
     * instead of specifying PreSignedUrl manually. Specifying SourceRegion autogenerates a pre-signed URL that is a valid
     * request for the operation that can be executed in the source Amazon Web Services Region.
     *
     *
     *
     * TargetDBClusterSnapshotIdentifier - The identifier for the new copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     *
     *
     * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied.
     * This identifier must be in the ARN format for the source Amazon Web Services Region and is the same value as the SourceDBClusterSnapshotIdentifier in the pre-signed URL.
     *
     *
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified
     * by TargetDBClusterSnapshotIdentifier while that DB cluster snapshot is in "copying" status.
     * For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region to another, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html">
     * Copying a Snapshot in the Amazon Aurora User Guide.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun copyDbClusterSnapshot(input: CopyDbClusterSnapshotRequest): CopyDbClusterSnapshotResponse

    /**
     * Copies a snapshot of a DB cluster.
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot, SourceDBClusterSnapshotIdentifier
     * must be the Amazon Resource Name (ARN) of the shared DB cluster snapshot.
     * You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon Web Services Region where you call the CopyDBClusterSnapshot action
     * is the destination Amazon Web Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot from another Amazon Web Services Region,
     * you must provide the following values:
     *
     *
     *
     * KmsKeyId - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier for the key to use to
     * encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     *
     *
     * PreSignedUrl -  A URL that contains a Signature Version 4 signed request for the
     * CopyDBClusterSnapshot action to be called in the source Amazon Web Services Region where the DB cluster snapshot is copied from.
     * The pre-signed URL must be a valid request for the CopyDBClusterSnapshot API action that can be executed in the
     * source Amazon Web Services Region that contains the encrypted DB cluster snapshot to be copied.
     * The pre-signed URL request must contain the following parameter values:
     *
     *
     *
     * KmsKeyId - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB
     * cluster snapshot in the destination Amazon Web Services Region. This is the same identifier for both the CopyDBClusterSnapshot
     * action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.
     *
     *
     *
     * DestinationRegion - The name of the Amazon Web Services Region that the DB cluster snapshot is to be created in.
     *
     *
     *
     * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example,
     * if you are copying an encrypted DB cluster snapshot from the us-west-2 Amazon Web Services Region, then your SourceDBClusterSnapshotIdentifier
     * looks like the following example: arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115.
     *
     *
     * To learn how to generate a Signature Version 4 signed request, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">
     * Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4) and
     * <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">
     * Signature Version 4 Signing Process.
     *
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify SourceRegion (or --source-region for the CLI)
     * instead of specifying PreSignedUrl manually. Specifying SourceRegion autogenerates a pre-signed URL that is a valid
     * request for the operation that can be executed in the source Amazon Web Services Region.
     *
     *
     *
     * TargetDBClusterSnapshotIdentifier - The identifier for the new copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     *
     *
     * SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied.
     * This identifier must be in the ARN format for the source Amazon Web Services Region and is the same value as the SourceDBClusterSnapshotIdentifier in the pre-signed URL.
     *
     *
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified
     * by TargetDBClusterSnapshotIdentifier while that DB cluster snapshot is in "copying" status.
     * For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region to another, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html">
     * Copying a Snapshot in the Amazon Aurora User Guide.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun copyDbClusterSnapshot(block: CopyDbClusterSnapshotRequest.Builder.() -> Unit) = copyDbClusterSnapshot(CopyDbClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Copies the specified DB parameter group.
     */
    suspend fun copyDbParameterGroup(input: CopyDbParameterGroupRequest): CopyDbParameterGroupResponse

    /**
     * Copies the specified DB parameter group.
     */
    suspend fun copyDbParameterGroup(block: CopyDbParameterGroupRequest.Builder.() -> Unit) = copyDbParameterGroup(CopyDbParameterGroupRequest.Builder().apply(block).build())

    /**
     * Copies the specified DB snapshot. The source DB snapshot must be in the available state.
     * You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services Region
     * where you call the CopyDBSnapshot action is the destination Amazon Web Services Region for the
     * DB snapshot copy.
     * This command doesn't apply to RDS Custom.
     * For more information about copying snapshots, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying a DB Snapshot in the Amazon RDS User Guide.
     */
    suspend fun copyDbSnapshot(input: CopyDbSnapshotRequest): CopyDbSnapshotResponse

    /**
     * Copies the specified DB snapshot. The source DB snapshot must be in the available state.
     * You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services Region
     * where you call the CopyDBSnapshot action is the destination Amazon Web Services Region for the
     * DB snapshot copy.
     * This command doesn't apply to RDS Custom.
     * For more information about copying snapshots, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying a DB Snapshot in the Amazon RDS User Guide.
     */
    suspend fun copyDbSnapshot(block: CopyDbSnapshotRequest.Builder.() -> Unit) = copyDbSnapshot(CopyDbSnapshotRequest.Builder().apply(block).build())

    /**
     * Copies the specified option group.
     */
    suspend fun copyOptionGroup(input: CopyOptionGroupRequest): CopyOptionGroupResponse

    /**
     * Copies the specified option group.
     */
    suspend fun copyOptionGroup(block: CopyOptionGroupRequest.Builder.() -> Unit) = copyOptionGroup(CopyOptionGroupRequest.Builder().apply(block).build())

    /**
     * Creates a custom DB engine version (CEV). A CEV is a binary volume snapshot of a database engine and specific
     * AMI. The supported engines are the following:
     *
     *
     * Oracle Database 12.1 Enterprise Edition with the January 2021 or later RU/RUR
     *
     * Oracle Database 19c Enterprise Edition with the January 2021 or later RU/RUR
     *
     *
     * Amazon RDS, which is a fully managed service, supplies the Amazon Machine Image (AMI) and database software.
     * The Amazon RDS database software is preinstalled, so you need only select a DB engine and version, and create
     * your database. With Amazon RDS Custom for Oracle, you upload your database installation files in Amazon S3.
     * When you create a custom engine version, you specify the files in a JSON document called a CEV manifest.
     * This document describes installation .zip files stored in Amazon S3. RDS Custom creates your CEV from
     * the installation files that you provided. This service model is called Bring Your Own Media (BYOM).
     * Creation takes approximately two hours. If creation fails, RDS Custom issues RDS-EVENT-0196 with
     * the message Creation failed for custom engine version, and includes details about the failure.
     * For example, the event prints missing files.
     * After you create the CEV, it is available for use. You can create multiple CEVs, and create multiple
     * RDS Custom instances from any CEV. You can also change the status of a CEV to make it available or
     * inactive.
     *
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with
     * Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * CreateCustomDbEngineVersion event aren't logged. However, you might see calls from the
     * API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for
     * the CreateCustomDbEngineVersion event.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.create">
     * Creating a CEV in the Amazon RDS User Guide.
     */
    suspend fun createCustomDbEngineVersion(input: CreateCustomDbEngineVersionRequest): CreateCustomDbEngineVersionResponse

    /**
     * Creates a custom DB engine version (CEV). A CEV is a binary volume snapshot of a database engine and specific
     * AMI. The supported engines are the following:
     *
     *
     * Oracle Database 12.1 Enterprise Edition with the January 2021 or later RU/RUR
     *
     * Oracle Database 19c Enterprise Edition with the January 2021 or later RU/RUR
     *
     *
     * Amazon RDS, which is a fully managed service, supplies the Amazon Machine Image (AMI) and database software.
     * The Amazon RDS database software is preinstalled, so you need only select a DB engine and version, and create
     * your database. With Amazon RDS Custom for Oracle, you upload your database installation files in Amazon S3.
     * When you create a custom engine version, you specify the files in a JSON document called a CEV manifest.
     * This document describes installation .zip files stored in Amazon S3. RDS Custom creates your CEV from
     * the installation files that you provided. This service model is called Bring Your Own Media (BYOM).
     * Creation takes approximately two hours. If creation fails, RDS Custom issues RDS-EVENT-0196 with
     * the message Creation failed for custom engine version, and includes details about the failure.
     * For example, the event prints missing files.
     * After you create the CEV, it is available for use. You can create multiple CEVs, and create multiple
     * RDS Custom instances from any CEV. You can also change the status of a CEV to make it available or
     * inactive.
     *
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with
     * Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * CreateCustomDbEngineVersion event aren't logged. However, you might see calls from the
     * API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for
     * the CreateCustomDbEngineVersion event.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.create">
     * Creating a CEV in the Amazon RDS User Guide.
     */
    suspend fun createCustomDbEngineVersion(block: CreateCustomDbEngineVersionRequest.Builder.() -> Unit) = createCustomDbEngineVersion(CreateCustomDbEngineVersionRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
     * You can use the ReplicationSourceIdentifier parameter to create an Amazon
     * Aurora DB cluster as a read replica of another DB cluster or Amazon RDS MySQL or
     * PostgreSQL DB instance. For cross-Region replication where the DB cluster identified by
     * ReplicationSourceIdentifier is encrypted, also specify the
     * PreSignedUrl parameter.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun createDbCluster(input: CreateDbClusterRequest): CreateDbClusterResponse

    /**
     * Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
     * You can use the ReplicationSourceIdentifier parameter to create an Amazon
     * Aurora DB cluster as a read replica of another DB cluster or Amazon RDS MySQL or
     * PostgreSQL DB instance. For cross-Region replication where the DB cluster identified by
     * ReplicationSourceIdentifier is encrypted, also specify the
     * PreSignedUrl parameter.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun createDbCluster(block: CreateDbClusterRequest.Builder.() -> Unit) = createDbCluster(CreateDbClusterRequest.Builder().apply(block).build())

    /**
     * Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun createDbClusterEndpoint(input: CreateDbClusterEndpointRequest): CreateDbClusterEndpointResponse

    /**
     * Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun createDbClusterEndpoint(block: CreateDbClusterEndpointRequest.Builder.() -> Unit) = createDbClusterEndpoint(CreateDbClusterEndpointRequest.Builder().apply(block).build())

    /**
     * Creates a new DB cluster parameter group.
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * A DB cluster parameter group is initially created with the default parameters for the
     * database engine used by instances in the DB cluster. To provide custom values for any of the
     * parameters, you must modify the group after creating it using
     * ModifyDBClusterParameterGroup. Once you've created a DB cluster parameter group, you need to
     * associate it with your DB cluster using ModifyDBCluster.
     * When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB
     * instances in the DB cluster without failover for the new DB cluster parameter group and
     * associated settings to take effect.
     * When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB
     * cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     *
     * After you create a DB cluster parameter group, you should wait at least 5 minutes
     * before creating your first DB cluster
     * that uses that DB cluster parameter group as the default parameter
     * group. This allows Amazon RDS to fully complete the create action before the DB cluster parameter
     * group is used as the default for a new DB cluster. This is especially important for parameters
     * that are critical when creating the default database for a DB cluster, such as the character set
     * for the default database defined by the character_set_database parameter. You can use the
     * Parameter Groups option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console or the
     * DescribeDBClusterParameters action to verify
     * that your DB cluster parameter group has been created or modified.
     *
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun createDbClusterParameterGroup(input: CreateDbClusterParameterGroupRequest): CreateDbClusterParameterGroupResponse

    /**
     * Creates a new DB cluster parameter group.
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * A DB cluster parameter group is initially created with the default parameters for the
     * database engine used by instances in the DB cluster. To provide custom values for any of the
     * parameters, you must modify the group after creating it using
     * ModifyDBClusterParameterGroup. Once you've created a DB cluster parameter group, you need to
     * associate it with your DB cluster using ModifyDBCluster.
     * When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB
     * instances in the DB cluster without failover for the new DB cluster parameter group and
     * associated settings to take effect.
     * When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB
     * cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     *
     * After you create a DB cluster parameter group, you should wait at least 5 minutes
     * before creating your first DB cluster
     * that uses that DB cluster parameter group as the default parameter
     * group. This allows Amazon RDS to fully complete the create action before the DB cluster parameter
     * group is used as the default for a new DB cluster. This is especially important for parameters
     * that are critical when creating the default database for a DB cluster, such as the character set
     * for the default database defined by the character_set_database parameter. You can use the
     * Parameter Groups option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console or the
     * DescribeDBClusterParameters action to verify
     * that your DB cluster parameter group has been created or modified.
     *
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun createDbClusterParameterGroup(block: CreateDbClusterParameterGroupRequest.Builder.() -> Unit) = createDbClusterParameterGroup(CreateDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Creates a snapshot of a DB cluster.
     * For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun createDbClusterSnapshot(input: CreateDbClusterSnapshotRequest): CreateDbClusterSnapshotResponse

    /**
     * Creates a snapshot of a DB cluster.
     * For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun createDbClusterSnapshot(block: CreateDbClusterSnapshotRequest.Builder.() -> Unit) = createDbClusterSnapshot(CreateDbClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * Creates a new DB instance.
     */
    suspend fun createDbInstance(input: CreateDbInstanceRequest): CreateDbInstanceResponse

    /**
     * Creates a new DB instance.
     */
    suspend fun createDbInstance(block: CreateDbInstanceRequest.Builder.() -> Unit) = createDbInstance(CreateDbInstanceRequest.Builder().apply(block).build())

    /**
     * Creates a new DB instance that acts as a read replica for an existing source DB
     * instance. You can create a read replica for a DB instance running MySQL, MariaDB,
     * Oracle, PostgreSQL, or SQL Server. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with Read
     * Replicas in the Amazon RDS User Guide.
     * Amazon Aurora doesn't support this action. Call the CreateDBInstance
     * action to create a DB instance for an Aurora DB cluster.
     * All read replica DB instances are created with backups disabled. All other DB
     * instance attributes (including DB security groups and DB parameter groups) are inherited
     * from the source DB instance, except as specified.
     *
     * Your source DB instance must have backup retention enabled.
     */
    suspend fun createDbInstanceReadReplica(input: CreateDbInstanceReadReplicaRequest): CreateDbInstanceReadReplicaResponse

    /**
     * Creates a new DB instance that acts as a read replica for an existing source DB
     * instance. You can create a read replica for a DB instance running MySQL, MariaDB,
     * Oracle, PostgreSQL, or SQL Server. For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with Read
     * Replicas in the Amazon RDS User Guide.
     * Amazon Aurora doesn't support this action. Call the CreateDBInstance
     * action to create a DB instance for an Aurora DB cluster.
     * All read replica DB instances are created with backups disabled. All other DB
     * instance attributes (including DB security groups and DB parameter groups) are inherited
     * from the source DB instance, except as specified.
     *
     * Your source DB instance must have backup retention enabled.
     */
    suspend fun createDbInstanceReadReplica(block: CreateDbInstanceReadReplicaRequest.Builder.() -> Unit) = createDbInstanceReadReplica(CreateDbInstanceReadReplicaRequest.Builder().apply(block).build())

    /**
     * Creates a new DB parameter group.
     * A DB parameter group is initially created with the default parameters for the
     * database engine used by the DB instance. To provide custom values for any of the
     * parameters, you must modify the group after creating it using
     * ModifyDBParameterGroup. Once you've created a DB parameter group, you need to
     * associate it with your DB instance using ModifyDBInstance. When you associate
     * a new DB parameter group with a running DB instance, you need to reboot the DB
     * instance without failover for the new DB parameter group and associated settings to take effect.
     * This command doesn't apply to RDS Custom.
     *
     * After you create a DB parameter group, you should wait at least 5 minutes
     * before creating your first DB instance that uses that DB parameter group as the default parameter
     * group. This allows Amazon RDS to fully complete the create action before the parameter
     * group is used as the default for a new DB instance. This is especially important for parameters
     * that are critical when creating the default database for a DB instance, such as the character set
     * for the default database defined by the character_set_database parameter. You can use the
     * Parameter Groups option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console or the
     * DescribeDBParameters command to verify
     * that your DB parameter group has been created or modified.
     */
    suspend fun createDbParameterGroup(input: CreateDbParameterGroupRequest): CreateDbParameterGroupResponse

    /**
     * Creates a new DB parameter group.
     * A DB parameter group is initially created with the default parameters for the
     * database engine used by the DB instance. To provide custom values for any of the
     * parameters, you must modify the group after creating it using
     * ModifyDBParameterGroup. Once you've created a DB parameter group, you need to
     * associate it with your DB instance using ModifyDBInstance. When you associate
     * a new DB parameter group with a running DB instance, you need to reboot the DB
     * instance without failover for the new DB parameter group and associated settings to take effect.
     * This command doesn't apply to RDS Custom.
     *
     * After you create a DB parameter group, you should wait at least 5 minutes
     * before creating your first DB instance that uses that DB parameter group as the default parameter
     * group. This allows Amazon RDS to fully complete the create action before the parameter
     * group is used as the default for a new DB instance. This is especially important for parameters
     * that are critical when creating the default database for a DB instance, such as the character set
     * for the default database defined by the character_set_database parameter. You can use the
     * Parameter Groups option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console or the
     * DescribeDBParameters command to verify
     * that your DB parameter group has been created or modified.
     */
    suspend fun createDbParameterGroup(block: CreateDbParameterGroupRequest.Builder.() -> Unit) = createDbParameterGroup(CreateDbParameterGroupRequest.Builder().apply(block).build())

    /**
     * Creates a new DB proxy.
     */
    suspend fun createDbProxy(input: CreateDbProxyRequest): CreateDbProxyResponse

    /**
     * Creates a new DB proxy.
     */
    suspend fun createDbProxy(block: CreateDbProxyRequest.Builder.() -> Unit) = createDbProxy(CreateDbProxyRequest.Builder().apply(block).build())

    /**
     * Creates a DBProxyEndpoint. Only applies to proxies that are associated with Aurora DB clusters.
     * You can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use
     * DB proxy endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
     */
    suspend fun createDbProxyEndpoint(input: CreateDbProxyEndpointRequest): CreateDbProxyEndpointResponse

    /**
     * Creates a DBProxyEndpoint. Only applies to proxies that are associated with Aurora DB clusters.
     * You can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use
     * DB proxy endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
     */
    suspend fun createDbProxyEndpoint(block: CreateDbProxyEndpointRequest.Builder.() -> Unit) = createDbProxyEndpoint(CreateDbProxyEndpointRequest.Builder().apply(block).build())

    /**
     * Creates a new DB security group. DB security groups control access to a DB instance.
     *
     * A DB security group controls access to EC2-Classic DB instances that are not in a VPC.
     */
    suspend fun createDbSecurityGroup(input: CreateDbSecurityGroupRequest): CreateDbSecurityGroupResponse

    /**
     * Creates a new DB security group. DB security groups control access to a DB instance.
     *
     * A DB security group controls access to EC2-Classic DB instances that are not in a VPC.
     */
    suspend fun createDbSecurityGroup(block: CreateDbSecurityGroupRequest.Builder.() -> Unit) = createDbSecurityGroup(CreateDbSecurityGroupRequest.Builder().apply(block).build())

    /**
     * Creates a snapshot of a DB instance. The source DB instance must be in the available or
     * storage-optimization state.
     */
    suspend fun createDbSnapshot(input: CreateDbSnapshotRequest): CreateDbSnapshotResponse

    /**
     * Creates a snapshot of a DB instance. The source DB instance must be in the available or
     * storage-optimization state.
     */
    suspend fun createDbSnapshot(block: CreateDbSnapshotRequest.Builder.() -> Unit) = createDbSnapshot(CreateDbSnapshotRequest.Builder().apply(block).build())

    /**
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.
     */
    suspend fun createDbSubnetGroup(input: CreateDbSubnetGroupRequest): CreateDbSubnetGroupResponse

    /**
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.
     */
    suspend fun createDbSubnetGroup(block: CreateDbSubnetGroupRequest.Builder.() -> Unit) = createDbSubnetGroup(CreateDbSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Creates an RDS event notification subscription. This action requires a topic Amazon
     * Resource Name (ARN) created by either the RDS console, the SNS console, or the SNS API.
     * To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the
     * topic. The ARN is displayed in the SNS console.
     * You can specify the type of source (SourceType) that you want to be
     * notified of and provide a list of RDS sources (SourceIds) that triggers the
     * events. You can also provide a list of event categories (EventCategories)
     * for events that you want to be notified of. For example, you can specify
     * SourceType = db-instance, SourceIds =
     * mydbinstance1, mydbinstance2 and
     * EventCategories = Availability,
     * Backup.
     * If you specify both the SourceType and SourceIds, such as SourceType = db-instance
     * and SourceIds = myDBInstance1, you are notified of all the db-instance events for
     * the specified source. If you specify a SourceType but do not specify SourceIds,
     * you receive notice of the events for that source type for all your RDS sources. If you
     * don't specify either the SourceType or the SourceIds, you are notified of events
     * generated from all RDS sources belonging to your customer account.
     *
     * RDS event notification is only available for unencrypted SNS topics. If you specify an
     * encrypted SNS topic, event notifications aren't sent for the topic.
     */
    suspend fun createEventSubscription(input: CreateEventSubscriptionRequest): CreateEventSubscriptionResponse

    /**
     * Creates an RDS event notification subscription. This action requires a topic Amazon
     * Resource Name (ARN) created by either the RDS console, the SNS console, or the SNS API.
     * To obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the
     * topic. The ARN is displayed in the SNS console.
     * You can specify the type of source (SourceType) that you want to be
     * notified of and provide a list of RDS sources (SourceIds) that triggers the
     * events. You can also provide a list of event categories (EventCategories)
     * for events that you want to be notified of. For example, you can specify
     * SourceType = db-instance, SourceIds =
     * mydbinstance1, mydbinstance2 and
     * EventCategories = Availability,
     * Backup.
     * If you specify both the SourceType and SourceIds, such as SourceType = db-instance
     * and SourceIds = myDBInstance1, you are notified of all the db-instance events for
     * the specified source. If you specify a SourceType but do not specify SourceIds,
     * you receive notice of the events for that source type for all your RDS sources. If you
     * don't specify either the SourceType or the SourceIds, you are notified of events
     * generated from all RDS sources belonging to your customer account.
     *
     * RDS event notification is only available for unencrypted SNS topics. If you specify an
     * encrypted SNS topic, event notifications aren't sent for the topic.
     */
    suspend fun createEventSubscription(block: CreateEventSubscriptionRequest.Builder.() -> Unit) = createEventSubscription(CreateEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Creates an Aurora global database
     * spread across multiple Amazon Web Services Regions. The global database
     * contains a single primary cluster with read-write capability,
     * and a read-only secondary cluster that receives
     * data from the primary cluster through high-speed replication
     * performed by the Aurora storage subsystem.
     * You can create a global database that is initially empty, and then
     * add a primary cluster and a secondary cluster to it.
     * Or you can specify an existing Aurora cluster during the create operation,
     * and this cluster becomes the primary cluster of the global database.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun createGlobalCluster(input: CreateGlobalClusterRequest): CreateGlobalClusterResponse

    /**
     * Creates an Aurora global database
     * spread across multiple Amazon Web Services Regions. The global database
     * contains a single primary cluster with read-write capability,
     * and a read-only secondary cluster that receives
     * data from the primary cluster through high-speed replication
     * performed by the Aurora storage subsystem.
     * You can create a global database that is initially empty, and then
     * add a primary cluster and a secondary cluster to it.
     * Or you can specify an existing Aurora cluster during the create operation,
     * and this cluster becomes the primary cluster of the global database.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun createGlobalCluster(block: CreateGlobalClusterRequest.Builder.() -> Unit) = createGlobalCluster(CreateGlobalClusterRequest.Builder().apply(block).build())

    /**
     * Creates a new option group. You can create up to 20 option groups.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun createOptionGroup(input: CreateOptionGroupRequest): CreateOptionGroupResponse

    /**
     * Creates a new option group. You can create up to 20 option groups.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun createOptionGroup(block: CreateOptionGroupRequest.Builder.() -> Unit) = createOptionGroup(CreateOptionGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
     *
     *
     * The CEV must not be the default for RDS Custom. If it is, change the default
     * before running this command.
     *
     * The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot,
     * or automated backup of your RDS Custom instance.
     *
     *
     * Typically, deletion takes a few minutes.
     *
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with
     * Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * DeleteCustomDbEngineVersion event aren't logged. However, you might see calls from the
     * API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for
     * the DeleteCustomDbEngineVersion event.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">
     * Deleting a CEV in the Amazon RDS User Guide.
     */
    suspend fun deleteCustomDbEngineVersion(input: DeleteCustomDbEngineVersionRequest): DeleteCustomDbEngineVersionResponse

    /**
     * Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
     *
     *
     * The CEV must not be the default for RDS Custom. If it is, change the default
     * before running this command.
     *
     * The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot,
     * or automated backup of your RDS Custom instance.
     *
     *
     * Typically, deletion takes a few minutes.
     *
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with
     * Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * DeleteCustomDbEngineVersion event aren't logged. However, you might see calls from the
     * API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for
     * the DeleteCustomDbEngineVersion event.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">
     * Deleting a CEV in the Amazon RDS User Guide.
     */
    suspend fun deleteCustomDbEngineVersion(block: DeleteCustomDbEngineVersionRequest.Builder.() -> Unit) = deleteCustomDbEngineVersion(DeleteCustomDbEngineVersionRequest.Builder().apply(block).build())

    /**
     * The DeleteDBCluster action deletes a previously provisioned DB cluster.
     * When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered.
     * Manual DB cluster snapshots of the specified DB cluster are not deleted.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun deleteDbCluster(input: DeleteDbClusterRequest): DeleteDbClusterResponse

    /**
     * The DeleteDBCluster action deletes a previously provisioned DB cluster.
     * When you delete a DB cluster, all automated backups for that DB cluster are deleted and can't be recovered.
     * Manual DB cluster snapshots of the specified DB cluster are not deleted.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun deleteDbCluster(block: DeleteDbClusterRequest.Builder.() -> Unit) = deleteDbCluster(DeleteDbClusterRequest.Builder().apply(block).build())

    /**
     * Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun deleteDbClusterEndpoint(input: DeleteDbClusterEndpointRequest): DeleteDbClusterEndpointResponse

    /**
     * Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun deleteDbClusterEndpoint(block: DeleteDbClusterEndpointRequest.Builder.() -> Unit) = deleteDbClusterEndpoint(DeleteDbClusterEndpointRequest.Builder().apply(block).build())

    /**
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun deleteDbClusterParameterGroup(input: DeleteDbClusterParameterGroupRequest): DeleteDbClusterParameterGroupResponse

    /**
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated with any DB clusters.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun deleteDbClusterParameterGroup(block: DeleteDbClusterParameterGroupRequest.Builder.() -> Unit) = deleteDbClusterParameterGroup(DeleteDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     *
     * The DB cluster snapshot must be in the available state to be
     * deleted.
     *
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun deleteDbClusterSnapshot(input: DeleteDbClusterSnapshotRequest): DeleteDbClusterSnapshotResponse

    /**
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     *
     * The DB cluster snapshot must be in the available state to be
     * deleted.
     *
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun deleteDbClusterSnapshot(block: DeleteDbClusterSnapshotRequest.Builder.() -> Unit) = deleteDbClusterSnapshot(DeleteDbClusterSnapshotRequest.Builder().apply(block).build())

    /**
     * The DeleteDBInstance action deletes a previously provisioned DB instance.
     * When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered.
     * Manual DB snapshots of the DB instance to be deleted by DeleteDBInstance are not deleted.
     * If you request a final DB snapshot
     * the status of the Amazon RDS DB instance is deleting until the DB snapshot is created. The API action DescribeDBInstance
     * is used to monitor the status of this operation. The action can't be canceled or reverted once submitted.
     * When a DB instance is in a failure state and has a status of failed, incompatible-restore,
     * or incompatible-network, you can only delete it when you skip creation of the final snapshot with the SkipFinalSnapshot parameter.
     * If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of the following
     * conditions are true:
     *
     *
     * The DB cluster is a read replica of another Amazon Aurora DB cluster.
     *
     * The DB instance is the only instance in the DB cluster.
     *
     *
     * To delete a DB instance in this case, first call the
     * PromoteReadReplicaDBCluster API action to promote the DB cluster so
     * it's no longer a read replica. After the promotion completes, then call the
     * DeleteDBInstance API action to delete the final instance in the DB
     * cluster.
     */
    suspend fun deleteDbInstance(input: DeleteDbInstanceRequest): DeleteDbInstanceResponse

    /**
     * The DeleteDBInstance action deletes a previously provisioned DB instance.
     * When you delete a DB instance, all automated backups for that instance are deleted and can't be recovered.
     * Manual DB snapshots of the DB instance to be deleted by DeleteDBInstance are not deleted.
     * If you request a final DB snapshot
     * the status of the Amazon RDS DB instance is deleting until the DB snapshot is created. The API action DescribeDBInstance
     * is used to monitor the status of this operation. The action can't be canceled or reverted once submitted.
     * When a DB instance is in a failure state and has a status of failed, incompatible-restore,
     * or incompatible-network, you can only delete it when you skip creation of the final snapshot with the SkipFinalSnapshot parameter.
     * If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of the following
     * conditions are true:
     *
     *
     * The DB cluster is a read replica of another Amazon Aurora DB cluster.
     *
     * The DB instance is the only instance in the DB cluster.
     *
     *
     * To delete a DB instance in this case, first call the
     * PromoteReadReplicaDBCluster API action to promote the DB cluster so
     * it's no longer a read replica. After the promotion completes, then call the
     * DeleteDBInstance API action to delete the final instance in the DB
     * cluster.
     */
    suspend fun deleteDbInstance(block: DeleteDbInstanceRequest.Builder.() -> Unit) = deleteDbInstance(DeleteDbInstanceRequest.Builder().apply(block).build())

    /**
     * Deletes automated backups using the DbiResourceId value of the source DB instance or the Amazon Resource Name (ARN) of the automated backups.
     */
    suspend fun deleteDbInstanceAutomatedBackup(input: DeleteDbInstanceAutomatedBackupRequest): DeleteDbInstanceAutomatedBackupResponse

    /**
     * Deletes automated backups using the DbiResourceId value of the source DB instance or the Amazon Resource Name (ARN) of the automated backups.
     */
    suspend fun deleteDbInstanceAutomatedBackup(block: DeleteDbInstanceAutomatedBackupRequest.Builder.() -> Unit) = deleteDbInstanceAutomatedBackup(DeleteDbInstanceAutomatedBackupRequest.Builder().apply(block).build())

    /**
     * Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB instances.
     */
    suspend fun deleteDbParameterGroup(input: DeleteDbParameterGroupRequest): DeleteDbParameterGroupResponse

    /**
     * Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB instances.
     */
    suspend fun deleteDbParameterGroup(block: DeleteDbParameterGroupRequest.Builder.() -> Unit) = deleteDbParameterGroup(DeleteDbParameterGroupRequest.Builder().apply(block).build())

    /**
     * Deletes an existing DB proxy.
     */
    suspend fun deleteDbProxy(input: DeleteDbProxyRequest): DeleteDbProxyResponse

    /**
     * Deletes an existing DB proxy.
     */
    suspend fun deleteDbProxy(block: DeleteDbProxyRequest.Builder.() -> Unit) = deleteDbProxy(DeleteDbProxyRequest.Builder().apply(block).build())

    /**
     * Deletes a DBProxyEndpoint. Doing so removes the ability to access the DB proxy using the
     * endpoint that you defined. The endpoint that you delete might have provided capabilities such as read/write
     * or read-only operations, or using a different VPC than the DB proxy's default VPC.
     */
    suspend fun deleteDbProxyEndpoint(input: DeleteDbProxyEndpointRequest): DeleteDbProxyEndpointResponse

    /**
     * Deletes a DBProxyEndpoint. Doing so removes the ability to access the DB proxy using the
     * endpoint that you defined. The endpoint that you delete might have provided capabilities such as read/write
     * or read-only operations, or using a different VPC than the DB proxy's default VPC.
     */
    suspend fun deleteDbProxyEndpoint(block: DeleteDbProxyEndpointRequest.Builder.() -> Unit) = deleteDbProxyEndpoint(DeleteDbProxyEndpointRequest.Builder().apply(block).build())

    /**
     * Deletes a DB security group.
     *
     * The specified DB security group must not be associated with any DB instances.
     */
    suspend fun deleteDbSecurityGroup(input: DeleteDbSecurityGroupRequest): DeleteDbSecurityGroupResponse

    /**
     * Deletes a DB security group.
     *
     * The specified DB security group must not be associated with any DB instances.
     */
    suspend fun deleteDbSecurityGroup(block: DeleteDbSecurityGroupRequest.Builder.() -> Unit) = deleteDbSecurityGroup(DeleteDbSecurityGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a DB snapshot. If the snapshot is being copied, the copy operation is
     * terminated.
     *
     * The DB snapshot must be in the available state to be deleted.
     */
    suspend fun deleteDbSnapshot(input: DeleteDbSnapshotRequest): DeleteDbSnapshotResponse

    /**
     * Deletes a DB snapshot. If the snapshot is being copied, the copy operation is
     * terminated.
     *
     * The DB snapshot must be in the available state to be deleted.
     */
    suspend fun deleteDbSnapshot(block: DeleteDbSnapshotRequest.Builder.() -> Unit) = deleteDbSnapshot(DeleteDbSnapshotRequest.Builder().apply(block).build())

    /**
     * Deletes a DB subnet group.
     *
     * The specified database subnet group must not be associated with any DB instances.
     */
    suspend fun deleteDbSubnetGroup(input: DeleteDbSubnetGroupRequest): DeleteDbSubnetGroupResponse

    /**
     * Deletes a DB subnet group.
     *
     * The specified database subnet group must not be associated with any DB instances.
     */
    suspend fun deleteDbSubnetGroup(block: DeleteDbSubnetGroupRequest.Builder.() -> Unit) = deleteDbSubnetGroup(DeleteDbSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Deletes an RDS event notification subscription.
     */
    suspend fun deleteEventSubscription(input: DeleteEventSubscriptionRequest): DeleteEventSubscriptionResponse

    /**
     * Deletes an RDS event notification subscription.
     */
    suspend fun deleteEventSubscription(block: DeleteEventSubscriptionRequest.Builder.() -> Unit) = deleteEventSubscription(DeleteEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Deletes a global database cluster. The primary and secondary clusters must already be detached or
     * destroyed first.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun deleteGlobalCluster(input: DeleteGlobalClusterRequest): DeleteGlobalClusterResponse

    /**
     * Deletes a global database cluster. The primary and secondary clusters must already be detached or
     * destroyed first.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun deleteGlobalCluster(block: DeleteGlobalClusterRequest.Builder.() -> Unit) = deleteGlobalCluster(DeleteGlobalClusterRequest.Builder().apply(block).build())

    /**
     * Deletes an existing option group.
     */
    suspend fun deleteOptionGroup(input: DeleteOptionGroupRequest): DeleteOptionGroupResponse

    /**
     * Deletes an existing option group.
     */
    suspend fun deleteOptionGroup(block: DeleteOptionGroupRequest.Builder.() -> Unit) = deleteOptionGroup(DeleteOptionGroupRequest.Builder().apply(block).build())

    /**
     * Remove the association between one or more DBProxyTarget data structures and a DBProxyTargetGroup.
     */
    suspend fun deregisterDbProxyTargets(input: DeregisterDbProxyTargetsRequest): DeregisterDbProxyTargetsResponse

    /**
     * Remove the association between one or more DBProxyTarget data structures and a DBProxyTargetGroup.
     */
    suspend fun deregisterDbProxyTargets(block: DeregisterDbProxyTargetsRequest.Builder.() -> Unit) = deregisterDbProxyTargets(DeregisterDbProxyTargetsRequest.Builder().apply(block).build())

    /**
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account, such as the number of DB instances allowed. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
     * This command doesn't take any parameters.
     */
    suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse

    /**
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account, such as the number of DB instances allowed. The description for a quota includes the quota name, current usage toward that quota, and the quota's maximum value.
     * This command doesn't take any parameters.
     */
    suspend fun describeAccountAttributes(block: DescribeAccountAttributesRequest.Builder.() -> Unit) = describeAccountAttributes(DescribeAccountAttributesRequest.Builder().apply(block).build())

    /**
     * Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.
     */
    suspend fun describeCertificates(input: DescribeCertificatesRequest): DescribeCertificatesResponse

    /**
     * Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.
     */
    suspend fun describeCertificates(block: DescribeCertificatesRequest.Builder.() -> Unit) = describeCertificates(DescribeCertificatesRequest.Builder().apply(block).build())

    /**
     * Returns information about backtracks for a DB cluster.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora MySQL DB clusters.
     */
    suspend fun describeDbClusterBacktracks(input: DescribeDbClusterBacktracksRequest): DescribeDbClusterBacktracksResponse

    /**
     * Returns information about backtracks for a DB cluster.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora MySQL DB clusters.
     */
    suspend fun describeDbClusterBacktracks(block: DescribeDbClusterBacktracksRequest.Builder.() -> Unit) = describeDbClusterBacktracks(DescribeDbClusterBacktracksRequest.Builder().apply(block).build())

    /**
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun describeDbClusterEndpoints(input: DescribeDbClusterEndpointsRequest): DescribeDbClusterEndpointsResponse

    /**
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun describeDbClusterEndpoints(block: DescribeDbClusterEndpointsRequest.Builder.() -> Unit) = describeDbClusterEndpoints(DescribeDbClusterEndpointsRequest.Builder().apply(block).build())

    /**
     * Returns a list of DBClusterParameterGroup descriptions. If a
     * DBClusterParameterGroupName parameter is specified,
     * the list will contain only the description of the specified DB cluster parameter group.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun describeDbClusterParameterGroups(input: DescribeDbClusterParameterGroupsRequest): DescribeDbClusterParameterGroupsResponse

    /**
     * Returns a list of DBClusterParameterGroup descriptions. If a
     * DBClusterParameterGroupName parameter is specified,
     * the list will contain only the description of the specified DB cluster parameter group.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun describeDbClusterParameterGroups(block: DescribeDbClusterParameterGroupsRequest.Builder.() -> Unit) = describeDbClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun describeDbClusterParameters(input: DescribeDbClusterParametersRequest): DescribeDbClusterParametersResponse

    /**
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun describeDbClusterParameters(block: DescribeDbClusterParametersRequest.Builder.() -> Unit) = describeDbClusterParameters(DescribeDbClusterParametersRequest.Builder().apply(block).build())

    /**
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * When sharing snapshots with other Amazon Web Services accounts, DescribeDBClusterSnapshotAttributes
     * returns the restore attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB cluster snapshot. If all is included in the list of
     * values for the restore attribute, then the manual DB cluster snapshot is public and
     * can be copied or restored by all Amazon Web Services accounts.
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to make the
     * manual DB cluster snapshot public or private, use the ModifyDBClusterSnapshotAttribute API action.
     */
    suspend fun describeDbClusterSnapshotAttributes(input: DescribeDbClusterSnapshotAttributesRequest): DescribeDbClusterSnapshotAttributesResponse

    /**
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * When sharing snapshots with other Amazon Web Services accounts, DescribeDBClusterSnapshotAttributes
     * returns the restore attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB cluster snapshot. If all is included in the list of
     * values for the restore attribute, then the manual DB cluster snapshot is public and
     * can be copied or restored by all Amazon Web Services accounts.
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to make the
     * manual DB cluster snapshot public or private, use the ModifyDBClusterSnapshotAttribute API action.
     */
    suspend fun describeDbClusterSnapshotAttributes(block: DescribeDbClusterSnapshotAttributesRequest.Builder.() -> Unit) = describeDbClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.Builder().apply(block).build())

    /**
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun describeDbClusterSnapshots(input: DescribeDbClusterSnapshotsRequest): DescribeDbClusterSnapshotsResponse

    /**
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun describeDbClusterSnapshots(block: DescribeDbClusterSnapshotsRequest.Builder.() -> Unit) = describeDbClusterSnapshots(DescribeDbClusterSnapshotsRequest.Builder().apply(block).build())

    /**
     * Returns information about Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     */
    suspend fun describeDbClusters(input: DescribeDbClustersRequest): DescribeDbClustersResponse

    /**
     * Returns information about Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     */
    suspend fun describeDbClusters(block: DescribeDbClustersRequest.Builder.() -> Unit) = describeDbClusters(DescribeDbClustersRequest.Builder().apply(block).build())

    /**
     * Returns a list of the available DB engines.
     */
    suspend fun describeDbEngineVersions(input: DescribeDbEngineVersionsRequest): DescribeDbEngineVersionsResponse

    /**
     * Returns a list of the available DB engines.
     */
    suspend fun describeDbEngineVersions(block: DescribeDbEngineVersionsRequest.Builder.() -> Unit) = describeDbEngineVersions(DescribeDbEngineVersionsRequest.Builder().apply(block).build())

    /**
     * Displays backups for both current and deleted
     * instances. For example, use this operation to
     * find details about automated backups for previously deleted instances. Current instances
     * with retention periods greater than zero (0) are returned for both the
     * DescribeDBInstanceAutomatedBackups and
     * DescribeDBInstances operations.
     * All parameters are optional.
     */
    suspend fun describeDbInstanceAutomatedBackups(input: DescribeDbInstanceAutomatedBackupsRequest): DescribeDbInstanceAutomatedBackupsResponse

    /**
     * Displays backups for both current and deleted
     * instances. For example, use this operation to
     * find details about automated backups for previously deleted instances. Current instances
     * with retention periods greater than zero (0) are returned for both the
     * DescribeDBInstanceAutomatedBackups and
     * DescribeDBInstances operations.
     * All parameters are optional.
     */
    suspend fun describeDbInstanceAutomatedBackups(block: DescribeDbInstanceAutomatedBackupsRequest.Builder.() -> Unit) = describeDbInstanceAutomatedBackups(DescribeDbInstanceAutomatedBackupsRequest.Builder().apply(block).build())

    /**
     * Returns information about provisioned RDS instances. This API supports pagination.
     *
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     */
    suspend fun describeDbInstances(input: DescribeDbInstancesRequest): DescribeDbInstancesResponse

    /**
     * Returns information about provisioned RDS instances. This API supports pagination.
     *
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     */
    suspend fun describeDbInstances(block: DescribeDbInstancesRequest.Builder.() -> Unit) = describeDbInstances(DescribeDbInstancesRequest.Builder().apply(block).build())

    /**
     * Returns a list of DB log files for the DB instance.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun describeDbLogFiles(input: DescribeDbLogFilesRequest): DescribeDbLogFilesResponse

    /**
     * Returns a list of DB log files for the DB instance.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun describeDbLogFiles(block: DescribeDbLogFilesRequest.Builder.() -> Unit) = describeDbLogFiles(DescribeDbLogFilesRequest.Builder().apply(block).build())

    /**
     * Returns a list of DBParameterGroup descriptions. If a DBParameterGroupName is specified,
     * the list will contain only the description of the specified DB parameter group.
     */
    suspend fun describeDbParameterGroups(input: DescribeDbParameterGroupsRequest): DescribeDbParameterGroupsResponse

    /**
     * Returns a list of DBParameterGroup descriptions. If a DBParameterGroupName is specified,
     * the list will contain only the description of the specified DB parameter group.
     */
    suspend fun describeDbParameterGroups(block: DescribeDbParameterGroupsRequest.Builder.() -> Unit) = describeDbParameterGroups(DescribeDbParameterGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the detailed parameter list for a particular DB parameter group.
     */
    suspend fun describeDbParameters(input: DescribeDbParametersRequest): DescribeDbParametersResponse

    /**
     * Returns the detailed parameter list for a particular DB parameter group.
     */
    suspend fun describeDbParameters(block: DescribeDbParametersRequest.Builder.() -> Unit) = describeDbParameters(DescribeDbParametersRequest.Builder().apply(block).build())

    /**
     * Returns information about DB proxies.
     */
    suspend fun describeDbProxies(input: DescribeDbProxiesRequest): DescribeDbProxiesResponse

    /**
     * Returns information about DB proxies.
     */
    suspend fun describeDbProxies(block: DescribeDbProxiesRequest.Builder.() -> Unit) = describeDbProxies(DescribeDbProxiesRequest.Builder().apply(block).build())

    /**
     * Returns information about DB proxy endpoints.
     */
    suspend fun describeDbProxyEndpoints(input: DescribeDbProxyEndpointsRequest): DescribeDbProxyEndpointsResponse

    /**
     * Returns information about DB proxy endpoints.
     */
    suspend fun describeDbProxyEndpoints(block: DescribeDbProxyEndpointsRequest.Builder.() -> Unit) = describeDbProxyEndpoints(DescribeDbProxyEndpointsRequest.Builder().apply(block).build())

    /**
     * Returns information about DB proxy target groups, represented by DBProxyTargetGroup data structures.
     */
    suspend fun describeDbProxyTargetGroups(input: DescribeDbProxyTargetGroupsRequest): DescribeDbProxyTargetGroupsResponse

    /**
     * Returns information about DB proxy target groups, represented by DBProxyTargetGroup data structures.
     */
    suspend fun describeDbProxyTargetGroups(block: DescribeDbProxyTargetGroupsRequest.Builder.() -> Unit) = describeDbProxyTargetGroups(DescribeDbProxyTargetGroupsRequest.Builder().apply(block).build())

    /**
     * Returns information about DBProxyTarget objects. This API supports pagination.
     */
    suspend fun describeDbProxyTargets(input: DescribeDbProxyTargetsRequest): DescribeDbProxyTargetsResponse

    /**
     * Returns information about DBProxyTarget objects. This API supports pagination.
     */
    suspend fun describeDbProxyTargets(block: DescribeDbProxyTargetsRequest.Builder.() -> Unit) = describeDbProxyTargets(DescribeDbProxyTargetsRequest.Builder().apply(block).build())

    /**
     * Returns a list of DBSecurityGroup descriptions. If a DBSecurityGroupName is specified,
     * the list will contain only the descriptions of the specified DB security group.
     */
    suspend fun describeDbSecurityGroups(input: DescribeDbSecurityGroupsRequest): DescribeDbSecurityGroupsResponse

    /**
     * Returns a list of DBSecurityGroup descriptions. If a DBSecurityGroupName is specified,
     * the list will contain only the descriptions of the specified DB security group.
     */
    suspend fun describeDbSecurityGroups(block: DescribeDbSecurityGroupsRequest.Builder.() -> Unit) = describeDbSecurityGroups(DescribeDbSecurityGroupsRequest.Builder().apply(block).build())

    /**
     * Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
     * When sharing snapshots with other Amazon Web Services accounts, DescribeDBSnapshotAttributes
     * returns the restore attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB snapshot. If all is included in the list of
     * values for the restore attribute, then the manual DB snapshot is public and
     * can be copied or restored by all Amazon Web Services accounts.
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make the
     * manual DB snapshot public or private, use the ModifyDBSnapshotAttribute API action.
     */
    suspend fun describeDbSnapshotAttributes(input: DescribeDbSnapshotAttributesRequest): DescribeDbSnapshotAttributesResponse

    /**
     * Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
     * When sharing snapshots with other Amazon Web Services accounts, DescribeDBSnapshotAttributes
     * returns the restore attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB snapshot. If all is included in the list of
     * values for the restore attribute, then the manual DB snapshot is public and
     * can be copied or restored by all Amazon Web Services accounts.
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make the
     * manual DB snapshot public or private, use the ModifyDBSnapshotAttribute API action.
     */
    suspend fun describeDbSnapshotAttributes(block: DescribeDbSnapshotAttributesRequest.Builder.() -> Unit) = describeDbSnapshotAttributes(DescribeDbSnapshotAttributesRequest.Builder().apply(block).build())

    /**
     * Returns information about DB snapshots. This API action supports pagination.
     */
    suspend fun describeDbSnapshots(input: DescribeDbSnapshotsRequest): DescribeDbSnapshotsResponse

    /**
     * Returns information about DB snapshots. This API action supports pagination.
     */
    suspend fun describeDbSnapshots(block: DescribeDbSnapshotsRequest.Builder.() -> Unit) = describeDbSnapshots(DescribeDbSnapshotsRequest.Builder().apply(block).build())

    /**
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
     * For an overview of CIDR ranges, go to the
     * <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial.
     */
    suspend fun describeDbSubnetGroups(input: DescribeDbSubnetGroupsRequest): DescribeDbSubnetGroupsResponse

    /**
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the descriptions of the specified DBSubnetGroup.
     * For an overview of CIDR ranges, go to the
     * <a href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial.
     */
    suspend fun describeDbSubnetGroups(block: DescribeDbSubnetGroupsRequest.Builder.() -> Unit) = describeDbSubnetGroups(DescribeDbSubnetGroupsRequest.Builder().apply(block).build())

    /**
     * Returns the default engine and system parameter information for the cluster database engine.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     */
    suspend fun describeEngineDefaultClusterParameters(input: DescribeEngineDefaultClusterParametersRequest): DescribeEngineDefaultClusterParametersResponse

    /**
     * Returns the default engine and system parameter information for the cluster database engine.
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     */
    suspend fun describeEngineDefaultClusterParameters(block: DescribeEngineDefaultClusterParametersRequest.Builder.() -> Unit) = describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.Builder().apply(block).build())

    /**
     * Returns the default engine and system parameter information for the specified database engine.
     */
    suspend fun describeEngineDefaultParameters(input: DescribeEngineDefaultParametersRequest): DescribeEngineDefaultParametersResponse

    /**
     * Returns the default engine and system parameter information for the specified database engine.
     */
    suspend fun describeEngineDefaultParameters(block: DescribeEngineDefaultParametersRequest.Builder.() -> Unit) = describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest.Builder().apply(block).build())

    /**
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * You can also see this list in the "Amazon RDS event categories and event messages" section of the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html">
     * Amazon RDS User Guide
     * or the
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html">
     * Amazon Aurora User Guide
     * .
     */
    suspend fun describeEventCategories(input: DescribeEventCategoriesRequest): DescribeEventCategoriesResponse

    /**
     * Displays a list of categories for all event source types, or, if specified, for a specified source type.
     * You can also see this list in the "Amazon RDS event categories and event messages" section of the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html">
     * Amazon RDS User Guide
     * or the
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html">
     * Amazon Aurora User Guide
     * .
     */
    suspend fun describeEventCategories(block: DescribeEventCategoriesRequest.Builder.() -> Unit) = describeEventCategories(DescribeEventCategoriesRequest.Builder().apply(block).build())

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * If you specify a SubscriptionName, lists the description for that subscription.
     */
    suspend fun describeEventSubscriptions(input: DescribeEventSubscriptionsRequest): DescribeEventSubscriptionsResponse

    /**
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID, CreationTime, and Status.
     * If you specify a SubscriptionName, lists the description for that subscription.
     */
    suspend fun describeEventSubscriptions(block: DescribeEventSubscriptionsRequest.Builder.() -> Unit) = describeEventSubscriptions(DescribeEventSubscriptionsRequest.Builder().apply(block).build())

    /**
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB cluster snapshots, and RDS Proxies for the past 14 days.
     * Events specific to a particular DB instance, DB cluster, DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be
     * obtained by providing the name as a parameter.
     *
     * By default, RDS returns events that were generated in the past hour.
     */
    suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse

    /**
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB cluster snapshots, and RDS Proxies for the past 14 days.
     * Events specific to a particular DB instance, DB cluster, DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be
     * obtained by providing the name as a parameter.
     *
     * By default, RDS returns events that were generated in the past hour.
     */
    suspend fun describeEvents(block: DescribeEventsRequest.Builder.() -> Unit) = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

    /**
     * Returns information about a snapshot export to Amazon S3. This API operation supports
     * pagination.
     */
    suspend fun describeExportTasks(input: DescribeExportTasksRequest): DescribeExportTasksResponse

    /**
     * Returns information about a snapshot export to Amazon S3. This API operation supports
     * pagination.
     */
    suspend fun describeExportTasks(block: DescribeExportTasksRequest.Builder.() -> Unit) = describeExportTasks(DescribeExportTasksRequest.Builder().apply(block).build())

    /**
     * Returns information about Aurora global database clusters. This API supports pagination.
     * For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora? in the
     * Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun describeGlobalClusters(input: DescribeGlobalClustersRequest): DescribeGlobalClustersResponse

    /**
     * Returns information about Aurora global database clusters. This API supports pagination.
     * For more information on Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora? in the
     * Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun describeGlobalClusters(block: DescribeGlobalClustersRequest.Builder.() -> Unit) = describeGlobalClusters(DescribeGlobalClustersRequest.Builder().apply(block).build())

    /**
     * Describes all available options.
     */
    suspend fun describeOptionGroupOptions(input: DescribeOptionGroupOptionsRequest): DescribeOptionGroupOptionsResponse

    /**
     * Describes all available options.
     */
    suspend fun describeOptionGroupOptions(block: DescribeOptionGroupOptionsRequest.Builder.() -> Unit) = describeOptionGroupOptions(DescribeOptionGroupOptionsRequest.Builder().apply(block).build())

    /**
     * Describes the available option groups.
     */
    suspend fun describeOptionGroups(input: DescribeOptionGroupsRequest): DescribeOptionGroupsResponse

    /**
     * Describes the available option groups.
     */
    suspend fun describeOptionGroups(block: DescribeOptionGroupsRequest.Builder.() -> Unit) = describeOptionGroups(DescribeOptionGroupsRequest.Builder().apply(block).build())

    /**
     * Returns a list of orderable DB instance options for the specified DB engine, DB engine version, and DB instance class.
     */
    suspend fun describeOrderableDbInstanceOptions(input: DescribeOrderableDbInstanceOptionsRequest): DescribeOrderableDbInstanceOptionsResponse

    /**
     * Returns a list of orderable DB instance options for the specified DB engine, DB engine version, and DB instance class.
     */
    suspend fun describeOrderableDbInstanceOptions(block: DescribeOrderableDbInstanceOptionsRequest.Builder.() -> Unit) = describeOrderableDbInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.Builder().apply(block).build())

    /**
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     */
    suspend fun describePendingMaintenanceActions(input: DescribePendingMaintenanceActionsRequest): DescribePendingMaintenanceActionsResponse

    /**
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     */
    suspend fun describePendingMaintenanceActions(block: DescribePendingMaintenanceActionsRequest.Builder.() -> Unit) = describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.Builder().apply(block).build())

    /**
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     */
    suspend fun describeReservedDbInstances(input: DescribeReservedDbInstancesRequest): DescribeReservedDbInstancesResponse

    /**
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     */
    suspend fun describeReservedDbInstances(block: DescribeReservedDbInstancesRequest.Builder.() -> Unit) = describeReservedDbInstances(DescribeReservedDbInstancesRequest.Builder().apply(block).build())

    /**
     * Lists available reserved DB instance offerings.
     */
    suspend fun describeReservedDbInstancesOfferings(input: DescribeReservedDbInstancesOfferingsRequest): DescribeReservedDbInstancesOfferingsResponse

    /**
     * Lists available reserved DB instance offerings.
     */
    suspend fun describeReservedDbInstancesOfferings(block: DescribeReservedDbInstancesOfferingsRequest.Builder.() -> Unit) = describeReservedDbInstancesOfferings(DescribeReservedDbInstancesOfferingsRequest.Builder().apply(block).build())

    /**
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create a read replica,
     * copy a DB snapshot from, or replicate automated backups from. This API action supports pagination.
     */
    suspend fun describeSourceRegions(input: DescribeSourceRegionsRequest): DescribeSourceRegionsResponse

    /**
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create a read replica,
     * copy a DB snapshot from, or replicate automated backups from. This API action supports pagination.
     */
    suspend fun describeSourceRegions(block: DescribeSourceRegionsRequest.Builder.() -> Unit) = describeSourceRegions(DescribeSourceRegionsRequest.Builder().apply(block).build())

    /**
     * You can call DescribeValidDBInstanceModifications to learn what modifications you can make to
     * your DB instance. You can use this information when you call ModifyDBInstance.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun describeValidDbInstanceModifications(input: DescribeValidDbInstanceModificationsRequest): DescribeValidDbInstanceModificationsResponse

    /**
     * You can call DescribeValidDBInstanceModifications to learn what modifications you can make to
     * your DB instance. You can use this information when you call ModifyDBInstance.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun describeValidDbInstanceModifications(block: DescribeValidDbInstanceModificationsRequest.Builder.() -> Unit) = describeValidDbInstanceModifications(DescribeValidDbInstanceModificationsRequest.Builder().apply(block).build())

    /**
     * Downloads all or a portion of the specified log file, up to 1 MB in size.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun downloadDbLogFilePortion(input: DownloadDbLogFilePortionRequest): DownloadDbLogFilePortionResponse

    /**
     * Downloads all or a portion of the specified log file, up to 1 MB in size.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun downloadDbLogFilePortion(block: DownloadDbLogFilePortionRequest.Builder.() -> Unit) = downloadDbLogFilePortion(DownloadDbLogFilePortionRequest.Builder().apply(block).build())

    /**
     * Forces a failover for a DB cluster.
     * For an Aurora DB cluster, failover for a DB cluster promotes one of the Aurora Replicas (read-only instances)
     * in the DB cluster to be the primary DB instance (the cluster writer).
     * For a Multi-AZ DB cluster, failover for a DB cluster promotes one of the readable standby DB instances (read-only instances)
     * in the DB cluster to be the primary DB instance (the cluster writer).
     * An Amazon Aurora DB cluster automatically fails over to an Aurora Replica, if one exists,
     * when the primary DB instance fails. A Multi-AZ DB cluster automatically fails over to a readbable standby
     * DB instance when the primary DB instance fails.
     * To simulate a failure of a primary instance for testing, you can force a failover.
     * Because each instance in a DB cluster has its own endpoint address, make sure to clean up and re-establish any existing
     * connections that use those endpoint addresses when the failover is complete.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun failoverDbCluster(input: FailoverDbClusterRequest): FailoverDbClusterResponse

    /**
     * Forces a failover for a DB cluster.
     * For an Aurora DB cluster, failover for a DB cluster promotes one of the Aurora Replicas (read-only instances)
     * in the DB cluster to be the primary DB instance (the cluster writer).
     * For a Multi-AZ DB cluster, failover for a DB cluster promotes one of the readable standby DB instances (read-only instances)
     * in the DB cluster to be the primary DB instance (the cluster writer).
     * An Amazon Aurora DB cluster automatically fails over to an Aurora Replica, if one exists,
     * when the primary DB instance fails. A Multi-AZ DB cluster automatically fails over to a readbable standby
     * DB instance when the primary DB instance fails.
     * To simulate a failure of a primary instance for testing, you can force a failover.
     * Because each instance in a DB cluster has its own endpoint address, make sure to clean up and re-establish any existing
     * connections that use those endpoint addresses when the failover is complete.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun failoverDbCluster(block: FailoverDbClusterRequest.Builder.() -> Unit) = failoverDbCluster(FailoverDbClusterRequest.Builder().apply(block).build())

    /**
     * Initiates the failover process for an Aurora global database (GlobalCluster).
     * A failover for an Aurora global database promotes one of secondary read-only DB clusters to be
     * the primary DB cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words,
     * the role of the current primary DB cluster and the selected (target) DB cluster are switched. The selected
     * secondary DB cluster assumes full read/write capabilities for the Aurora global database.
     * For more information about failing over an Amazon Aurora global database, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover">Managed planned failover for Amazon Aurora global
     * databases in the Amazon Aurora User Guide.
     *
     * This action applies to GlobalCluster (Aurora global databases) only. Use this action only on
     * healthy Aurora global databases with running Aurora DB clusters and no Region-wide outages, to test disaster recovery scenarios or to
     * reconfigure your Aurora global database topology.
     */
    suspend fun failoverGlobalCluster(input: FailoverGlobalClusterRequest): FailoverGlobalClusterResponse

    /**
     * Initiates the failover process for an Aurora global database (GlobalCluster).
     * A failover for an Aurora global database promotes one of secondary read-only DB clusters to be
     * the primary DB cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words,
     * the role of the current primary DB cluster and the selected (target) DB cluster are switched. The selected
     * secondary DB cluster assumes full read/write capabilities for the Aurora global database.
     * For more information about failing over an Amazon Aurora global database, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover">Managed planned failover for Amazon Aurora global
     * databases in the Amazon Aurora User Guide.
     *
     * This action applies to GlobalCluster (Aurora global databases) only. Use this action only on
     * healthy Aurora global databases with running Aurora DB clusters and no Region-wide outages, to test disaster recovery scenarios or to
     * reconfigure your Aurora global database topology.
     */
    suspend fun failoverGlobalCluster(block: FailoverGlobalClusterRequest.Builder.() -> Unit) = failoverGlobalCluster(FailoverGlobalClusterRequest.Builder().apply(block).build())

    /**
     * Lists all tags on an Amazon RDS resource.
     * For an overview on tagging an Amazon RDS resource,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources
     * in the Amazon RDS User Guide.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all tags on an Amazon RDS resource.
     * For an overview on tagging an Amazon RDS resource,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources
     * in the Amazon RDS User Guide.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS)
     * certificate for Amazon RDS for new DB instances, or remove the override.
     * By using this operation, you can specify an RDS-approved SSL/TLS certificate for new DB
     * instances that is different from the default certificate provided by RDS. You can also
     * use this operation to remove the override, so that new DB instances use the default
     * certificate provided by RDS.
     * You might need to override the default certificate in the following situations:
     *
     *
     * You already migrated your applications to support the latest certificate authority (CA) certificate, but the new CA certificate is not yet
     * the RDS default CA certificate for the specified Amazon Web Services Region.
     *
     * RDS has already moved to a new default CA certificate for the specified Amazon Web Services
     * Region, but you are still in the process of supporting the new CA certificate.
     * In this case, you temporarily need additional time to finish your application
     * changes.
     *
     *
     * For more information about rotating your SSL/TLS certificate for RDS DB engines, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate in the Amazon RDS User Guide.
     * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate in the Amazon Aurora User Guide.
     */
    suspend fun modifyCertificates(input: ModifyCertificatesRequest): ModifyCertificatesResponse

    /**
     * Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS)
     * certificate for Amazon RDS for new DB instances, or remove the override.
     * By using this operation, you can specify an RDS-approved SSL/TLS certificate for new DB
     * instances that is different from the default certificate provided by RDS. You can also
     * use this operation to remove the override, so that new DB instances use the default
     * certificate provided by RDS.
     * You might need to override the default certificate in the following situations:
     *
     *
     * You already migrated your applications to support the latest certificate authority (CA) certificate, but the new CA certificate is not yet
     * the RDS default CA certificate for the specified Amazon Web Services Region.
     *
     * RDS has already moved to a new default CA certificate for the specified Amazon Web Services
     * Region, but you are still in the process of supporting the new CA certificate.
     * In this case, you temporarily need additional time to finish your application
     * changes.
     *
     *
     * For more information about rotating your SSL/TLS certificate for RDS DB engines, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate in the Amazon RDS User Guide.
     * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate in the Amazon Aurora User Guide.
     */
    suspend fun modifyCertificates(block: ModifyCertificatesRequest.Builder.() -> Unit) = modifyCertificates(ModifyCertificatesRequest.Builder().apply(block).build())

    /**
     * Set the capacity of an Aurora Serverless v1 DB cluster to a specific value.
     * Aurora Serverless v1 scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might not scale
     * fast enough to meet a sudden change in workload, such as a large number of new transactions. Call ModifyCurrentDBClusterCapacity
     * to set the capacity explicitly.
     * After this call sets the DB cluster capacity, Aurora Serverless v1 can automatically scale
     * the DB cluster based on the cooldown period for scaling up and the cooldown period
     * for scaling down.
     * For more information about Aurora Serverless v1, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless v1 in the
     * Amazon Aurora User Guide.
     *
     * If you call ModifyCurrentDBClusterCapacity with the default TimeoutAction, connections that
     * prevent Aurora Serverless v1 from finding a scaling point might be dropped. For more information about scaling points,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling">
     * Autoscaling for Aurora Serverless v1 in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora Serverless v1 DB clusters.
     */
    suspend fun modifyCurrentDbClusterCapacity(input: ModifyCurrentDbClusterCapacityRequest): ModifyCurrentDbClusterCapacityResponse

    /**
     * Set the capacity of an Aurora Serverless v1 DB cluster to a specific value.
     * Aurora Serverless v1 scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might not scale
     * fast enough to meet a sudden change in workload, such as a large number of new transactions. Call ModifyCurrentDBClusterCapacity
     * to set the capacity explicitly.
     * After this call sets the DB cluster capacity, Aurora Serverless v1 can automatically scale
     * the DB cluster based on the cooldown period for scaling up and the cooldown period
     * for scaling down.
     * For more information about Aurora Serverless v1, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora Serverless v1 in the
     * Amazon Aurora User Guide.
     *
     * If you call ModifyCurrentDBClusterCapacity with the default TimeoutAction, connections that
     * prevent Aurora Serverless v1 from finding a scaling point might be dropped. For more information about scaling points,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling">
     * Autoscaling for Aurora Serverless v1 in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora Serverless v1 DB clusters.
     */
    suspend fun modifyCurrentDbClusterCapacity(block: ModifyCurrentDbClusterCapacityRequest.Builder.() -> Unit) = modifyCurrentDbClusterCapacity(ModifyCurrentDbClusterCapacityRequest.Builder().apply(block).build())

    /**
     * Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling
     * DescribeDBEngineVersions.
     *
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with
     * Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * ModifyCustomDbEngineVersion event aren't logged. However, you might see calls from the
     * API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for
     * the ModifyCustomDbEngineVersion event.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.modify">Modifying CEV status
     * in the Amazon RDS User Guide.
     */
    suspend fun modifyCustomDbEngineVersion(input: ModifyCustomDbEngineVersionRequest): ModifyCustomDbEngineVersionResponse

    /**
     * Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling
     * DescribeDBEngineVersions.
     *
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with
     * Amazon Web Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * ModifyCustomDbEngineVersion event aren't logged. However, you might see calls from the
     * API gateway that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for
     * the ModifyCustomDbEngineVersion event.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.modify">Modifying CEV status
     * in the Amazon RDS User Guide.
     */
    suspend fun modifyCustomDbEngineVersion(block: ModifyCustomDbEngineVersionRequest.Builder.() -> Unit) = modifyCustomDbEngineVersion(ModifyCustomDbEngineVersionRequest.Builder().apply(block).build())

    /**
     * Modify the settings for an Amazon Aurora DB cluster or a Multi-AZ DB cluster.
     * You can change one or more settings by specifying these parameters and the new values in the
     * request.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun modifyDbCluster(input: ModifyDbClusterRequest): ModifyDbClusterResponse

    /**
     * Modify the settings for an Amazon Aurora DB cluster or a Multi-AZ DB cluster.
     * You can change one or more settings by specifying these parameters and the new values in the
     * request.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun modifyDbCluster(block: ModifyDbClusterRequest.Builder.() -> Unit) = modifyDbCluster(ModifyDbClusterRequest.Builder().apply(block).build())

    /**
     * Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun modifyDbClusterEndpoint(input: ModifyDbClusterEndpointRequest): ModifyDbClusterEndpointResponse

    /**
     * Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun modifyDbClusterEndpoint(block: ModifyDbClusterEndpointRequest.Builder.() -> Unit) = modifyDbClusterEndpoint(ModifyDbClusterEndpointRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter,
     * submit a list of the following: ParameterName, ParameterValue,
     * and ApplyMethod. A maximum of 20
     * parameters can be modified in a single request.
     *
     * After you create a DB cluster parameter group, you should wait at least 5 minutes
     * before creating your first DB cluster that uses that DB cluster parameter group as the default parameter
     * group. This allows Amazon RDS to fully complete the create action before the parameter
     * group is used as the default for a new DB cluster. This is especially important for parameters
     * that are critical when creating the default database for a DB cluster, such as the character set
     * for the default database defined by the character_set_database parameter. You can use the
     * Parameter Groups option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console or the
     * DescribeDBClusterParameters action to verify
     * that your DB cluster parameter group has been created or modified.
     * If the modified DB cluster parameter group is used by an Aurora Serverless v1 cluster, Aurora
     * applies the update immediately. The cluster restart might interrupt your workload. In that case,
     * your application must reopen any connections and retry any transactions that were active
     * when the parameter changes took effect.
     *
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun modifyDbClusterParameterGroup(input: ModifyDbClusterParameterGroupRequest): ModifyDbClusterParameterGroupResponse

    /**
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter,
     * submit a list of the following: ParameterName, ParameterValue,
     * and ApplyMethod. A maximum of 20
     * parameters can be modified in a single request.
     *
     * After you create a DB cluster parameter group, you should wait at least 5 minutes
     * before creating your first DB cluster that uses that DB cluster parameter group as the default parameter
     * group. This allows Amazon RDS to fully complete the create action before the parameter
     * group is used as the default for a new DB cluster. This is especially important for parameters
     * that are critical when creating the default database for a DB cluster, such as the character set
     * for the default database defined by the character_set_database parameter. You can use the
     * Parameter Groups option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console or the
     * DescribeDBClusterParameters action to verify
     * that your DB cluster parameter group has been created or modified.
     * If the modified DB cluster parameter group is used by an Aurora Serverless v1 cluster, Aurora
     * applies the update immediately. The cluster restart might interrupt your workload. In that case,
     * your application must reopen any connections and retry any transactions that were active
     * when the parameter changes took effect.
     *
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun modifyDbClusterParameterGroup(block: ModifyDbClusterParameterGroupRequest.Builder.() -> Unit) = modifyDbClusterParameterGroup(ModifyDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * To share a manual DB cluster snapshot with other Amazon Web Services accounts, specify
     * restore as the AttributeName and use the
     * ValuesToAdd parameter to add a list of IDs of the Amazon Web Services accounts that are
     * authorized to restore the manual DB cluster snapshot. Use the value all to
     * make the manual DB cluster snapshot public, which means that it can be copied or
     * restored by all Amazon Web Services accounts.
     *
     * Don't add the all value for any manual DB cluster snapshots
     * that contain private information that you don't want available to all Amazon Web Services
     * accounts.
     *
     * If a manual DB cluster snapshot is encrypted, it can be shared, but only by
     * specifying a list of authorized Amazon Web Services account IDs for the ValuesToAdd
     * parameter. You can't use all as a value for that parameter in this
     * case.
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB cluster
     * snapshot, or whether a manual DB cluster snapshot is public or private, use the DescribeDBClusterSnapshotAttributes API action. The accounts are
     * returned as values for the restore attribute.
     */
    suspend fun modifyDbClusterSnapshotAttribute(input: ModifyDbClusterSnapshotAttributeRequest): ModifyDbClusterSnapshotAttributeResponse

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * To share a manual DB cluster snapshot with other Amazon Web Services accounts, specify
     * restore as the AttributeName and use the
     * ValuesToAdd parameter to add a list of IDs of the Amazon Web Services accounts that are
     * authorized to restore the manual DB cluster snapshot. Use the value all to
     * make the manual DB cluster snapshot public, which means that it can be copied or
     * restored by all Amazon Web Services accounts.
     *
     * Don't add the all value for any manual DB cluster snapshots
     * that contain private information that you don't want available to all Amazon Web Services
     * accounts.
     *
     * If a manual DB cluster snapshot is encrypted, it can be shared, but only by
     * specifying a list of authorized Amazon Web Services account IDs for the ValuesToAdd
     * parameter. You can't use all as a value for that parameter in this
     * case.
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB cluster
     * snapshot, or whether a manual DB cluster snapshot is public or private, use the DescribeDBClusterSnapshotAttributes API action. The accounts are
     * returned as values for the restore attribute.
     */
    suspend fun modifyDbClusterSnapshotAttribute(block: ModifyDbClusterSnapshotAttributeRequest.Builder.() -> Unit) = modifyDbClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest.Builder().apply(block).build())

    /**
     * Modifies settings for a DB instance.
     * You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     * To learn what modifications you can make to your DB instance,
     * call DescribeValidDBInstanceModifications
     * before you call ModifyDBInstance.
     */
    suspend fun modifyDbInstance(input: ModifyDbInstanceRequest): ModifyDbInstanceResponse

    /**
     * Modifies settings for a DB instance.
     * You can change one or more database configuration parameters by specifying these parameters and the new values in the request.
     * To learn what modifications you can make to your DB instance,
     * call DescribeValidDBInstanceModifications
     * before you call ModifyDBInstance.
     */
    suspend fun modifyDbInstance(block: ModifyDbInstanceRequest.Builder.() -> Unit) = modifyDbInstance(ModifyDbInstanceRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a DB parameter group. To modify more than one parameter,
     * submit a list of the following: ParameterName, ParameterValue, and
     * ApplyMethod. A maximum of 20 parameters can be modified in a single request.
     *
     * After you modify a DB parameter group, you should wait at least 5 minutes
     * before creating your first DB instance that uses that DB parameter group as the default parameter
     * group. This allows Amazon RDS to fully complete the modify action before the parameter
     * group is used as the default for a new DB instance. This is especially important for parameters
     * that are critical when creating the default database for a DB instance, such as the character set
     * for the default database defined by the character_set_database parameter. You can use the
     * Parameter Groups option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console or the
     * DescribeDBParameters command to verify
     * that your DB parameter group has been created or modified.
     */
    suspend fun modifyDbParameterGroup(input: ModifyDbParameterGroupRequest): ModifyDbParameterGroupResponse

    /**
     * Modifies the parameters of a DB parameter group. To modify more than one parameter,
     * submit a list of the following: ParameterName, ParameterValue, and
     * ApplyMethod. A maximum of 20 parameters can be modified in a single request.
     *
     * After you modify a DB parameter group, you should wait at least 5 minutes
     * before creating your first DB instance that uses that DB parameter group as the default parameter
     * group. This allows Amazon RDS to fully complete the modify action before the parameter
     * group is used as the default for a new DB instance. This is especially important for parameters
     * that are critical when creating the default database for a DB instance, such as the character set
     * for the default database defined by the character_set_database parameter. You can use the
     * Parameter Groups option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console or the
     * DescribeDBParameters command to verify
     * that your DB parameter group has been created or modified.
     */
    suspend fun modifyDbParameterGroup(block: ModifyDbParameterGroupRequest.Builder.() -> Unit) = modifyDbParameterGroup(ModifyDbParameterGroupRequest.Builder().apply(block).build())

    /**
     * Changes the settings for an existing DB proxy.
     */
    suspend fun modifyDbProxy(input: ModifyDbProxyRequest): ModifyDbProxyResponse

    /**
     * Changes the settings for an existing DB proxy.
     */
    suspend fun modifyDbProxy(block: ModifyDbProxyRequest.Builder.() -> Unit) = modifyDbProxy(ModifyDbProxyRequest.Builder().apply(block).build())

    /**
     * Changes the settings for an existing DB proxy endpoint.
     */
    suspend fun modifyDbProxyEndpoint(input: ModifyDbProxyEndpointRequest): ModifyDbProxyEndpointResponse

    /**
     * Changes the settings for an existing DB proxy endpoint.
     */
    suspend fun modifyDbProxyEndpoint(block: ModifyDbProxyEndpointRequest.Builder.() -> Unit) = modifyDbProxyEndpoint(ModifyDbProxyEndpointRequest.Builder().apply(block).build())

    /**
     * Modifies the properties of a DBProxyTargetGroup.
     */
    suspend fun modifyDbProxyTargetGroup(input: ModifyDbProxyTargetGroupRequest): ModifyDbProxyTargetGroupResponse

    /**
     * Modifies the properties of a DBProxyTargetGroup.
     */
    suspend fun modifyDbProxyTargetGroup(block: ModifyDbProxyTargetGroupRequest.Builder.() -> Unit) = modifyDbProxyTargetGroup(ModifyDbProxyTargetGroupRequest.Builder().apply(block).build())

    /**
     * Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted
     * or unencrypted, but not shared or public.
     *
     *
     * Amazon RDS supports upgrading DB snapshots for MySQL, PostgreSQL, and Oracle. This command
     * doesn't apply to RDS Custom.
     */
    suspend fun modifyDbSnapshot(input: ModifyDbSnapshotRequest): ModifyDbSnapshotResponse

    /**
     * Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted
     * or unencrypted, but not shared or public.
     *
     *
     * Amazon RDS supports upgrading DB snapshots for MySQL, PostgreSQL, and Oracle. This command
     * doesn't apply to RDS Custom.
     */
    suspend fun modifyDbSnapshot(block: ModifyDbSnapshotRequest.Builder.() -> Unit) = modifyDbSnapshot(ModifyDbSnapshotRequest.Builder().apply(block).build())

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.
     * To share a manual DB snapshot with other Amazon Web Services accounts, specify restore
     * as the AttributeName and use the ValuesToAdd parameter to add
     * a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual DB snapshot.
     * Uses the value all to make the manual DB snapshot public, which means it
     * can be copied or restored by all Amazon Web Services accounts.
     *
     * Don't add the all value for any manual DB snapshots that
     * contain private information that you don't want available to all Amazon Web Services
     * accounts.
     *
     * If the manual DB snapshot is encrypted, it can be shared, but only by specifying a
     * list of authorized Amazon Web Services account IDs for the ValuesToAdd parameter. You
     * can't use all as a value for that parameter in this case.
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB snapshot, or
     * whether a manual DB snapshot public or private, use the DescribeDBSnapshotAttributes API action. The accounts are returned as
     * values for the restore attribute.
     */
    suspend fun modifyDbSnapshotAttribute(input: ModifyDbSnapshotAttributeRequest): ModifyDbSnapshotAttributeResponse

    /**
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.
     * To share a manual DB snapshot with other Amazon Web Services accounts, specify restore
     * as the AttributeName and use the ValuesToAdd parameter to add
     * a list of IDs of the Amazon Web Services accounts that are authorized to restore the manual DB snapshot.
     * Uses the value all to make the manual DB snapshot public, which means it
     * can be copied or restored by all Amazon Web Services accounts.
     *
     * Don't add the all value for any manual DB snapshots that
     * contain private information that you don't want available to all Amazon Web Services
     * accounts.
     *
     * If the manual DB snapshot is encrypted, it can be shared, but only by specifying a
     * list of authorized Amazon Web Services account IDs for the ValuesToAdd parameter. You
     * can't use all as a value for that parameter in this case.
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB snapshot, or
     * whether a manual DB snapshot public or private, use the DescribeDBSnapshotAttributes API action. The accounts are returned as
     * values for the restore attribute.
     */
    suspend fun modifyDbSnapshotAttribute(block: ModifyDbSnapshotAttributeRequest.Builder.() -> Unit) = modifyDbSnapshotAttribute(ModifyDbSnapshotAttributeRequest.Builder().apply(block).build())

    /**
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.
     */
    suspend fun modifyDbSubnetGroup(input: ModifyDbSubnetGroupRequest): ModifyDbSubnetGroupResponse

    /**
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the Amazon Web Services Region.
     */
    suspend fun modifyDbSubnetGroup(block: ModifyDbSubnetGroupRequest.Builder.() -> Unit) = modifyDbSubnetGroup(ModifyDbSubnetGroupRequest.Builder().apply(block).build())

    /**
     * Modifies an existing RDS event notification subscription. You can't modify the source identifiers using this call. To change
     * source identifiers for a subscription, use the AddSourceIdentifierToSubscription and RemoveSourceIdentifierFromSubscription calls.
     * You can see a list of the event categories for a given source type (SourceType)
     * in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events in the Amazon RDS User Guide
     * or by using the DescribeEventCategories operation.
     */
    suspend fun modifyEventSubscription(input: ModifyEventSubscriptionRequest): ModifyEventSubscriptionResponse

    /**
     * Modifies an existing RDS event notification subscription. You can't modify the source identifiers using this call. To change
     * source identifiers for a subscription, use the AddSourceIdentifierToSubscription and RemoveSourceIdentifierFromSubscription calls.
     * You can see a list of the event categories for a given source type (SourceType)
     * in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events in the Amazon RDS User Guide
     * or by using the DescribeEventCategories operation.
     */
    suspend fun modifyEventSubscription(block: ModifyEventSubscriptionRequest.Builder.() -> Unit) = modifyEventSubscription(ModifyEventSubscriptionRequest.Builder().apply(block).build())

    /**
     * Modify a setting for an Amazon Aurora global cluster. You can change one or more database configuration
     * parameters by specifying these parameters and the new values in the request. For more information on
     * Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora? in the
     * Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun modifyGlobalCluster(input: ModifyGlobalClusterRequest): ModifyGlobalClusterResponse

    /**
     * Modify a setting for an Amazon Aurora global cluster. You can change one or more database configuration
     * parameters by specifying these parameters and the new values in the request. For more information on
     * Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon Aurora? in the
     * Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun modifyGlobalCluster(block: ModifyGlobalClusterRequest.Builder.() -> Unit) = modifyGlobalCluster(ModifyGlobalClusterRequest.Builder().apply(block).build())

    /**
     * Modifies an existing option group.
     */
    suspend fun modifyOptionGroup(input: ModifyOptionGroupRequest): ModifyOptionGroupResponse

    /**
     * Modifies an existing option group.
     */
    suspend fun modifyOptionGroup(block: ModifyOptionGroupRequest.Builder.() -> Unit) = modifyOptionGroup(ModifyOptionGroupRequest.Builder().apply(block).build())

    /**
     * Promotes a read replica DB instance to a standalone DB instance.
     *
     *
     *
     * Backup duration is a function of the amount of changes to the database since the previous
     * backup. If you plan to promote a read replica to a standalone instance, we
     * recommend that you enable backups and complete at least one backup prior to
     * promotion. In addition, a read replica cannot be promoted to a standalone
     * instance when it is in the backing-up status. If you have
     * enabled backups on your read replica, configure the automated backup window
     * so that daily backups do not interfere with read replica
     * promotion.
     *
     *
     * This command doesn't apply to Aurora MySQL, Aurora PostgreSQL, or RDS Custom.
     */
    suspend fun promoteReadReplica(input: PromoteReadReplicaRequest): PromoteReadReplicaResponse

    /**
     * Promotes a read replica DB instance to a standalone DB instance.
     *
     *
     *
     * Backup duration is a function of the amount of changes to the database since the previous
     * backup. If you plan to promote a read replica to a standalone instance, we
     * recommend that you enable backups and complete at least one backup prior to
     * promotion. In addition, a read replica cannot be promoted to a standalone
     * instance when it is in the backing-up status. If you have
     * enabled backups on your read replica, configure the automated backup window
     * so that daily backups do not interfere with read replica
     * promotion.
     *
     *
     * This command doesn't apply to Aurora MySQL, Aurora PostgreSQL, or RDS Custom.
     */
    suspend fun promoteReadReplica(block: PromoteReadReplicaRequest.Builder.() -> Unit) = promoteReadReplica(PromoteReadReplicaRequest.Builder().apply(block).build())

    /**
     * Promotes a read replica DB cluster to a standalone DB cluster.
     */
    suspend fun promoteReadReplicaDbCluster(input: PromoteReadReplicaDbClusterRequest): PromoteReadReplicaDbClusterResponse

    /**
     * Promotes a read replica DB cluster to a standalone DB cluster.
     */
    suspend fun promoteReadReplicaDbCluster(block: PromoteReadReplicaDbClusterRequest.Builder.() -> Unit) = promoteReadReplicaDbCluster(PromoteReadReplicaDbClusterRequest.Builder().apply(block).build())

    /**
     * Purchases a reserved DB instance offering.
     */
    suspend fun purchaseReservedDbInstancesOffering(input: PurchaseReservedDbInstancesOfferingRequest): PurchaseReservedDbInstancesOfferingResponse

    /**
     * Purchases a reserved DB instance offering.
     */
    suspend fun purchaseReservedDbInstancesOffering(block: PurchaseReservedDbInstancesOfferingRequest.Builder.() -> Unit) = purchaseReservedDbInstancesOffering(PurchaseReservedDbInstancesOfferingRequest.Builder().apply(block).build())

    /**
     * You might need to reboot your DB cluster, usually for maintenance reasons.
     * For example, if you make certain modifications,
     * or if you change the DB cluster parameter group associated with the DB cluster,
     * reboot the DB cluster for the changes to take effect.
     * Rebooting a DB cluster restarts the database engine service. Rebooting a DB
     * cluster results in a momentary outage, during which the DB cluster status is set to rebooting.
     * Use this operation only for a non-Aurora Multi-AZ DB cluster.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the
     * Amazon RDS User Guide.
     */
    suspend fun rebootDbCluster(input: RebootDbClusterRequest): RebootDbClusterResponse

    /**
     * You might need to reboot your DB cluster, usually for maintenance reasons.
     * For example, if you make certain modifications,
     * or if you change the DB cluster parameter group associated with the DB cluster,
     * reboot the DB cluster for the changes to take effect.
     * Rebooting a DB cluster restarts the database engine service. Rebooting a DB
     * cluster results in a momentary outage, during which the DB cluster status is set to rebooting.
     * Use this operation only for a non-Aurora Multi-AZ DB cluster.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the
     * Amazon RDS User Guide.
     */
    suspend fun rebootDbCluster(block: RebootDbClusterRequest.Builder.() -> Unit) = rebootDbCluster(RebootDbClusterRequest.Builder().apply(block).build())

    /**
     * You might need to reboot your DB instance, usually for maintenance reasons.
     * For example, if you make certain modifications,
     * or if you change the DB parameter group associated with the DB instance,
     * you must reboot the instance for the changes to take effect.
     * Rebooting a DB instance restarts the database engine service.
     * Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.
     * For more information about rebooting, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html">Rebooting a DB Instance in the Amazon RDS User Guide.
     *
     * This command doesn't apply to RDS Custom.
     */
    suspend fun rebootDbInstance(input: RebootDbInstanceRequest): RebootDbInstanceResponse

    /**
     * You might need to reboot your DB instance, usually for maintenance reasons.
     * For example, if you make certain modifications,
     * or if you change the DB parameter group associated with the DB instance,
     * you must reboot the instance for the changes to take effect.
     * Rebooting a DB instance restarts the database engine service.
     * Rebooting a DB instance results in a momentary outage, during which the DB instance status is set to rebooting.
     * For more information about rebooting, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html">Rebooting a DB Instance in the Amazon RDS User Guide.
     *
     * This command doesn't apply to RDS Custom.
     */
    suspend fun rebootDbInstance(block: RebootDbInstanceRequest.Builder.() -> Unit) = rebootDbInstance(RebootDbInstanceRequest.Builder().apply(block).build())

    /**
     * Associate one or more DBProxyTarget data structures with a DBProxyTargetGroup.
     */
    suspend fun registerDbProxyTargets(input: RegisterDbProxyTargetsRequest): RegisterDbProxyTargetsResponse

    /**
     * Associate one or more DBProxyTarget data structures with a DBProxyTargetGroup.
     */
    suspend fun registerDbProxyTargets(block: RegisterDbProxyTargetsRequest.Builder.() -> Unit) = registerDbProxyTargets(RegisterDbProxyTargetsRequest.Builder().apply(block).build())

    /**
     * Detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster becomes a
     * standalone cluster with read-write capability instead of being read-only and receiving data from a
     * primary cluster in a different Region.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun removeFromGlobalCluster(input: RemoveFromGlobalClusterRequest): RemoveFromGlobalClusterResponse

    /**
     * Detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster becomes a
     * standalone cluster with read-write capability instead of being read-only and receiving data from a
     * primary cluster in a different Region.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun removeFromGlobalCluster(block: RemoveFromGlobalClusterRequest.Builder.() -> Unit) = removeFromGlobalCluster(RemoveFromGlobalClusterRequest.Builder().apply(block).build())

    /**
     * Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM) role from a
     * DB cluster.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun removeRoleFromDbCluster(input: RemoveRoleFromDbClusterRequest): RemoveRoleFromDbClusterResponse

    /**
     * Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM) role from a
     * DB cluster.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun removeRoleFromDbCluster(block: RemoveRoleFromDbClusterRequest.Builder.() -> Unit) = removeRoleFromDbCluster(RemoveRoleFromDbClusterRequest.Builder().apply(block).build())

    /**
     * Disassociates an Amazon Web Services Identity and Access Management (IAM) role from a DB instance.
     */
    suspend fun removeRoleFromDbInstance(input: RemoveRoleFromDbInstanceRequest): RemoveRoleFromDbInstanceResponse

    /**
     * Disassociates an Amazon Web Services Identity and Access Management (IAM) role from a DB instance.
     */
    suspend fun removeRoleFromDbInstance(block: RemoveRoleFromDbInstanceRequest.Builder.() -> Unit) = removeRoleFromDbInstance(RemoveRoleFromDbInstanceRequest.Builder().apply(block).build())

    /**
     * Removes a source identifier from an existing RDS event notification subscription.
     */
    suspend fun removeSourceIdentifierFromSubscription(input: RemoveSourceIdentifierFromSubscriptionRequest): RemoveSourceIdentifierFromSubscriptionResponse

    /**
     * Removes a source identifier from an existing RDS event notification subscription.
     */
    suspend fun removeSourceIdentifierFromSubscription(block: RemoveSourceIdentifierFromSubscriptionRequest.Builder.() -> Unit) = removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest.Builder().apply(block).build())

    /**
     * Removes metadata tags from an Amazon RDS resource.
     * For an overview on tagging an Amazon RDS resource,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources
     * in the Amazon RDS User Guide.
     */
    suspend fun removeTagsFromResource(input: RemoveTagsFromResourceRequest): RemoveTagsFromResourceResponse

    /**
     * Removes metadata tags from an Amazon RDS resource.
     * For an overview on tagging an Amazon RDS resource,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS Resources
     * in the Amazon RDS User Guide.
     */
    suspend fun removeTagsFromResource(block: RemoveTagsFromResourceRequest.Builder.() -> Unit) = removeTagsFromResource(RemoveTagsFromResourceRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a DB cluster parameter group to the default value. To
     * reset specific parameters submit a list of the following: ParameterName
     * and ApplyMethod. To reset the
     * entire DB cluster parameter group, specify the DBClusterParameterGroupName
     * and ResetAllParameters parameters.
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters
     * are set to pending-reboot to take effect on the next DB instance restart
     * or RebootDBInstance request. You must call RebootDBInstance for every
     * DB instance in your DB cluster that you want the updated static parameter to apply to.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun resetDbClusterParameterGroup(input: ResetDbClusterParameterGroupRequest): ResetDbClusterParameterGroupResponse

    /**
     * Modifies the parameters of a DB cluster parameter group to the default value. To
     * reset specific parameters submit a list of the following: ParameterName
     * and ApplyMethod. To reset the
     * entire DB cluster parameter group, specify the DBClusterParameterGroupName
     * and ResetAllParameters parameters.
     * When resetting the entire group, dynamic parameters are updated immediately and static parameters
     * are set to pending-reboot to take effect on the next DB instance restart
     * or RebootDBInstance request. You must call RebootDBInstance for every
     * DB instance in your DB cluster that you want the updated static parameter to apply to.
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun resetDbClusterParameterGroup(block: ResetDbClusterParameterGroupRequest.Builder.() -> Unit) = resetDbClusterParameterGroup(ResetDbClusterParameterGroupRequest.Builder().apply(block).build())

    /**
     * Modifies the parameters of a DB parameter group to the engine/system default value.
     * To reset specific parameters, provide a list of the following:
     * ParameterName and ApplyMethod. To reset the entire DB
     * parameter group, specify the DBParameterGroup name and
     * ResetAllParameters parameters. When resetting the entire group, dynamic
     * parameters are updated immediately and static parameters are set to
     * pending-reboot to take effect on the next DB instance restart or
     * RebootDBInstance request.
     */
    suspend fun resetDbParameterGroup(input: ResetDbParameterGroupRequest): ResetDbParameterGroupResponse

    /**
     * Modifies the parameters of a DB parameter group to the engine/system default value.
     * To reset specific parameters, provide a list of the following:
     * ParameterName and ApplyMethod. To reset the entire DB
     * parameter group, specify the DBParameterGroup name and
     * ResetAllParameters parameters. When resetting the entire group, dynamic
     * parameters are updated immediately and static parameters are set to
     * pending-reboot to take effect on the next DB instance restart or
     * RebootDBInstance request.
     */
    suspend fun resetDbParameterGroup(block: ResetDbParameterGroupRequest.Builder.() -> Unit) = resetDbParameterGroup(ResetDbParameterGroupRequest.Builder().apply(block).build())

    /**
     * Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket.
     * Amazon RDS must be authorized to access the Amazon S3 bucket and the data must be
     * created using the Percona XtraBackup utility as described in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3"> Migrating Data from MySQL by Using an Amazon S3 Bucket in the
     * Amazon Aurora User Guide.
     *
     * This action only restores the DB cluster, not the DB instances for that DB
     * cluster. You must invoke the CreateDBInstance action to create DB
     * instances for the restored DB cluster, specifying the identifier of the restored DB
     * cluster in DBClusterIdentifier. You can create DB instances only after
     * the RestoreDBClusterFromS3 action has completed and the DB
     * cluster is available.
     *
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters. The source DB engine must be
     * MySQL.
     */
    suspend fun restoreDbClusterFromS3(input: RestoreDbClusterFromS3Request): RestoreDbClusterFromS3Response

    /**
     * Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket.
     * Amazon RDS must be authorized to access the Amazon S3 bucket and the data must be
     * created using the Percona XtraBackup utility as described in <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3"> Migrating Data from MySQL by Using an Amazon S3 Bucket in the
     * Amazon Aurora User Guide.
     *
     * This action only restores the DB cluster, not the DB instances for that DB
     * cluster. You must invoke the CreateDBInstance action to create DB
     * instances for the restored DB cluster, specifying the identifier of the restored DB
     * cluster in DBClusterIdentifier. You can create DB instances only after
     * the RestoreDBClusterFromS3 action has completed and the DB
     * cluster is available.
     *
     * For more information on Amazon Aurora, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters. The source DB engine must be
     * MySQL.
     */
    suspend fun restoreDbClusterFromS3(block: RestoreDbClusterFromS3Request.Builder.() -> Unit) = restoreDbClusterFromS3(RestoreDbClusterFromS3Request.Builder().apply(block).build())

    /**
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * The target DB cluster is created from the source snapshot with a default
     * configuration. If you don't specify a security group, the new DB cluster is
     * associated with the default security group.
     *
     * This action only restores the DB cluster, not the DB instances for that DB
     * cluster. You must invoke the CreateDBInstance action to create DB
     * instances for the restored DB cluster, specifying the identifier of the restored DB
     * cluster in DBClusterIdentifier. You can create DB instances only after
     * the RestoreDBClusterFromSnapshot action has completed and the DB
     * cluster is available.
     *
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun restoreDbClusterFromSnapshot(input: RestoreDbClusterFromSnapshotRequest): RestoreDbClusterFromSnapshotResponse

    /**
     * Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
     * The target DB cluster is created from the source snapshot with a default
     * configuration. If you don't specify a security group, the new DB cluster is
     * associated with the default security group.
     *
     * This action only restores the DB cluster, not the DB instances for that DB
     * cluster. You must invoke the CreateDBInstance action to create DB
     * instances for the restored DB cluster, specifying the identifier of the restored DB
     * cluster in DBClusterIdentifier. You can create DB instances only after
     * the RestoreDBClusterFromSnapshot action has completed and the DB
     * cluster is available.
     *
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun restoreDbClusterFromSnapshot(block: RestoreDbClusterFromSnapshotRequest.Builder.() -> Unit) = restoreDbClusterFromSnapshot(RestoreDbClusterFromSnapshotRequest.Builder().apply(block).build())

    /**
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point
     * in time before LatestRestorableTime for up to
     * BackupRetentionPeriod days. The target DB cluster is created from the
     * source DB cluster with the same configuration as the original DB cluster, except that
     * the new DB cluster is created with the default DB security group.
     *
     * For Aurora, this action only restores the DB cluster, not the DB instances for that DB
     * cluster. You must invoke the CreateDBInstance action to create DB
     * instances for the restored DB cluster, specifying the identifier of the restored DB
     * cluster in DBClusterIdentifier. You can create DB instances only after
     * the RestoreDBClusterToPointInTime action has completed and the DB
     * cluster is available.
     *
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun restoreDbClusterToPointInTime(input: RestoreDbClusterToPointInTimeRequest): RestoreDbClusterToPointInTimeResponse

    /**
     * Restores a DB cluster to an arbitrary point in time. Users can restore to any point
     * in time before LatestRestorableTime for up to
     * BackupRetentionPeriod days. The target DB cluster is created from the
     * source DB cluster with the same configuration as the original DB cluster, except that
     * the new DB cluster is created with the default DB security group.
     *
     * For Aurora, this action only restores the DB cluster, not the DB instances for that DB
     * cluster. You must invoke the CreateDBInstance action to create DB
     * instances for the restored DB cluster, specifying the identifier of the restored DB
     * cluster in DBClusterIdentifier. You can create DB instances only after
     * the RestoreDBClusterToPointInTime action has completed and the DB
     * cluster is available.
     *
     * For more information on Amazon Aurora DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">
     * What is Amazon Aurora? in the Amazon Aurora User Guide.
     * For more information on Multi-AZ DB clusters, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">
     * Multi-AZ deployments with two readable standby DB instances in the Amazon RDS User Guide.
     */
    suspend fun restoreDbClusterToPointInTime(block: RestoreDbClusterToPointInTimeRequest.Builder.() -> Unit) = restoreDbClusterToPointInTime(RestoreDbClusterToPointInTimeRequest.Builder().apply(block).build())

    /**
     * Creates a new DB instance from a DB snapshot. The target database is created from the source database restore point with most
     * of the source's original configuration, including the default security group and DB parameter group. By default, the new DB
     * instance is created as a Single-AZ deployment, except when the instance is a SQL Server instance that has an option group
     * associated with mirroring. In this case, the instance becomes a Multi-AZ deployment, not a Single-AZ deployment.
     * If you want to replace your original DB instance with the new, restored DB instance, then rename your original DB instance
     * before you call the RestoreDBInstanceFromDBSnapshot action. RDS doesn't allow two DB instances with the same name. After you
     * have renamed your original DB instance with a different identifier, then you can pass the original name of the DB instance as
     * the DBInstanceIdentifier in the call to the RestoreDBInstanceFromDBSnapshot action. The result is that you replace the original
     * DB instance with the DB instance created from the snapshot.
     * If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier
     * must be the ARN of the shared DB snapshot.
     *
     * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use RestoreDBClusterFromSnapshot.
     */
    suspend fun restoreDbInstanceFromDbSnapshot(input: RestoreDbInstanceFromDbSnapshotRequest): RestoreDbInstanceFromDbSnapshotResponse

    /**
     * Creates a new DB instance from a DB snapshot. The target database is created from the source database restore point with most
     * of the source's original configuration, including the default security group and DB parameter group. By default, the new DB
     * instance is created as a Single-AZ deployment, except when the instance is a SQL Server instance that has an option group
     * associated with mirroring. In this case, the instance becomes a Multi-AZ deployment, not a Single-AZ deployment.
     * If you want to replace your original DB instance with the new, restored DB instance, then rename your original DB instance
     * before you call the RestoreDBInstanceFromDBSnapshot action. RDS doesn't allow two DB instances with the same name. After you
     * have renamed your original DB instance with a different identifier, then you can pass the original name of the DB instance as
     * the DBInstanceIdentifier in the call to the RestoreDBInstanceFromDBSnapshot action. The result is that you replace the original
     * DB instance with the DB instance created from the snapshot.
     * If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier
     * must be the ARN of the shared DB snapshot.
     *
     * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use RestoreDBClusterFromSnapshot.
     */
    suspend fun restoreDbInstanceFromDbSnapshot(block: RestoreDbInstanceFromDbSnapshotRequest.Builder.() -> Unit) = restoreDbInstanceFromDbSnapshot(RestoreDbInstanceFromDbSnapshotRequest.Builder().apply(block).build())

    /**
     * Amazon Relational Database Service (Amazon RDS)
     * supports importing MySQL databases by using backup files.
     * You can create a backup of your on-premises database,
     * store it on Amazon Simple Storage Service (Amazon S3),
     * and then restore the backup file onto a new Amazon RDS DB instance running MySQL.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html">Importing Data into an Amazon RDS MySQL DB Instance
     * in the Amazon RDS User Guide.
     *
     * This command doesn't apply to RDS Custom.
     */
    suspend fun restoreDbInstanceFromS3(input: RestoreDbInstanceFromS3Request): RestoreDbInstanceFromS3Response

    /**
     * Amazon Relational Database Service (Amazon RDS)
     * supports importing MySQL databases by using backup files.
     * You can create a backup of your on-premises database,
     * store it on Amazon Simple Storage Service (Amazon S3),
     * and then restore the backup file onto a new Amazon RDS DB instance running MySQL.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html">Importing Data into an Amazon RDS MySQL DB Instance
     * in the Amazon RDS User Guide.
     *
     * This command doesn't apply to RDS Custom.
     */
    suspend fun restoreDbInstanceFromS3(block: RestoreDbInstanceFromS3Request.Builder.() -> Unit) = restoreDbInstanceFromS3(RestoreDbInstanceFromS3Request.Builder().apply(block).build())

    /**
     * Restores a DB instance to an arbitrary point in time. You can restore to any point in time before the time identified by the LatestRestorableTime property. You can restore to a point up to the number of days specified by the BackupRetentionPeriod property.
     * The target database is created with most of the original configuration, but in a
     * system-selected Availability Zone, with the default security group, the default subnet
     * group, and the default DB parameter group. By default, the new DB instance is created as
     * a single-AZ deployment except when the instance is a SQL Server instance that has an
     * option group that is associated with mirroring; in this case, the instance becomes a
     * mirrored deployment and not a single-AZ deployment.
     *
     * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use RestoreDBClusterToPointInTime.
     */
    suspend fun restoreDbInstanceToPointInTime(input: RestoreDbInstanceToPointInTimeRequest): RestoreDbInstanceToPointInTimeResponse

    /**
     * Restores a DB instance to an arbitrary point in time. You can restore to any point in time before the time identified by the LatestRestorableTime property. You can restore to a point up to the number of days specified by the BackupRetentionPeriod property.
     * The target database is created with most of the original configuration, but in a
     * system-selected Availability Zone, with the default security group, the default subnet
     * group, and the default DB parameter group. By default, the new DB instance is created as
     * a single-AZ deployment except when the instance is a SQL Server instance that has an
     * option group that is associated with mirroring; in this case, the instance becomes a
     * mirrored deployment and not a single-AZ deployment.
     *
     * This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For Aurora, use RestoreDBClusterToPointInTime.
     */
    suspend fun restoreDbInstanceToPointInTime(block: RestoreDbInstanceToPointInTimeRequest.Builder.() -> Unit) = restoreDbInstanceToPointInTime(RestoreDbInstanceToPointInTimeRequest.Builder().apply(block).build())

    /**
     * Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC security groups. Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId).
     */
    suspend fun revokeDbSecurityGroupIngress(input: RevokeDbSecurityGroupIngressRequest): RevokeDbSecurityGroupIngressResponse

    /**
     * Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC security groups. Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId).
     */
    suspend fun revokeDbSecurityGroupIngress(block: RevokeDbSecurityGroupIngressRequest.Builder.() -> Unit) = revokeDbSecurityGroupIngress(RevokeDbSecurityGroupIngressRequest.Builder().apply(block).build())

    /**
     * Starts a database activity stream to monitor activity on the database.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html">Database Activity Streams
     * in the Amazon Aurora User Guide.
     */
    suspend fun startActivityStream(input: StartActivityStreamRequest): StartActivityStreamResponse

    /**
     * Starts a database activity stream to monitor activity on the database.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html">Database Activity Streams
     * in the Amazon Aurora User Guide.
     */
    suspend fun startActivityStream(block: StartActivityStreamRequest.Builder.() -> Unit) = startActivityStream(StartActivityStreamRequest.Builder().apply(block).build())

    /**
     * Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web Services console, the stop-db-cluster
     * CLI command, or the StopDBCluster action.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html">
     * Stopping and Starting an Aurora Cluster in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun startDbCluster(input: StartDbClusterRequest): StartDbClusterResponse

    /**
     * Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web Services console, the stop-db-cluster
     * CLI command, or the StopDBCluster action.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html">
     * Stopping and Starting an Aurora Cluster in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun startDbCluster(block: StartDbClusterRequest.Builder.() -> Unit) = startDbCluster(StartDbClusterRequest.Builder().apply(block).build())

    /**
     * Starts an Amazon RDS DB instance that was stopped using the Amazon Web Services console, the stop-db-instance CLI command, or the StopDBInstance action.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StartInstance.html">
     * Starting an Amazon RDS DB instance That Was Previously Stopped in the
     * Amazon RDS User Guide.
     *
     *
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL.
     * For Aurora DB clusters, use StartDBCluster instead.
     */
    suspend fun startDbInstance(input: StartDbInstanceRequest): StartDbInstanceResponse

    /**
     * Starts an Amazon RDS DB instance that was stopped using the Amazon Web Services console, the stop-db-instance CLI command, or the StopDBInstance action.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StartInstance.html">
     * Starting an Amazon RDS DB instance That Was Previously Stopped in the
     * Amazon RDS User Guide.
     *
     *
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL.
     * For Aurora DB clusters, use StartDBCluster instead.
     */
    suspend fun startDbInstance(block: StartDbInstanceRequest.Builder.() -> Unit) = startDbInstance(StartDbInstanceRequest.Builder().apply(block).build())

    /**
     * Enables replication of automated backups to a different Amazon Web Services Region.
     * This command doesn't apply to RDS Custom.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html">
     * Replicating Automated Backups to Another Amazon Web Services Region in the Amazon RDS User Guide.
     */
    suspend fun startDbInstanceAutomatedBackupsReplication(input: StartDbInstanceAutomatedBackupsReplicationRequest): StartDbInstanceAutomatedBackupsReplicationResponse

    /**
     * Enables replication of automated backups to a different Amazon Web Services Region.
     * This command doesn't apply to RDS Custom.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html">
     * Replicating Automated Backups to Another Amazon Web Services Region in the Amazon RDS User Guide.
     */
    suspend fun startDbInstanceAutomatedBackupsReplication(block: StartDbInstanceAutomatedBackupsReplicationRequest.Builder.() -> Unit) = startDbInstanceAutomatedBackupsReplication(StartDbInstanceAutomatedBackupsReplicationRequest.Builder().apply(block).build())

    /**
     * Starts an export of a snapshot to Amazon S3.
     * The provided IAM role must have access to the S3 bucket.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun startExportTask(input: StartExportTaskRequest): StartExportTaskResponse

    /**
     * Starts an export of a snapshot to Amazon S3.
     * The provided IAM role must have access to the S3 bucket.
     * This command doesn't apply to RDS Custom.
     */
    suspend fun startExportTask(block: StartExportTaskRequest.Builder.() -> Unit) = startExportTask(StartExportTaskRequest.Builder().apply(block).build())

    /**
     * Stops a database activity stream that was started using the Amazon Web Services console,
     * the start-activity-stream CLI command, or the StartActivityStream action.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html">Database Activity Streams
     * in the Amazon Aurora User Guide.
     */
    suspend fun stopActivityStream(input: StopActivityStreamRequest): StopActivityStreamResponse

    /**
     * Stops a database activity stream that was started using the Amazon Web Services console,
     * the start-activity-stream CLI command, or the StartActivityStream action.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html">Database Activity Streams
     * in the Amazon Aurora User Guide.
     */
    suspend fun stopActivityStream(block: StopActivityStreamRequest.Builder.() -> Unit) = stopActivityStream(StopActivityStreamRequest.Builder().apply(block).build())

    /**
     * Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains the DB cluster's
     * metadata, including its endpoints and DB parameter groups. Aurora also
     * retains the transaction logs so you can do a point-in-time restore if necessary.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html">
     * Stopping and Starting an Aurora Cluster in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun stopDbCluster(input: StopDbClusterRequest): StopDbClusterResponse

    /**
     * Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains the DB cluster's
     * metadata, including its endpoints and DB parameter groups. Aurora also
     * retains the transaction logs so you can do a point-in-time restore if necessary.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html">
     * Stopping and Starting an Aurora Cluster in the Amazon Aurora User Guide.
     *
     * This action only applies to Aurora DB clusters.
     */
    suspend fun stopDbCluster(block: StopDbClusterRequest.Builder.() -> Unit) = stopDbCluster(StopDbClusterRequest.Builder().apply(block).build())

    /**
     * Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS retains the DB instance's metadata, including its endpoint,
     * DB parameter group, and option group membership. Amazon RDS also retains the transaction logs so you can do a point-in-time restore if
     * necessary.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html">
     * Stopping an Amazon RDS DB Instance Temporarily in the
     * Amazon RDS User Guide.
     *
     *
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL.
     * For Aurora clusters, use StopDBCluster instead.
     */
    suspend fun stopDbInstance(input: StopDbInstanceRequest): StopDbInstanceResponse

    /**
     * Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS retains the DB instance's metadata, including its endpoint,
     * DB parameter group, and option group membership. Amazon RDS also retains the transaction logs so you can do a point-in-time restore if
     * necessary.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html">
     * Stopping an Amazon RDS DB Instance Temporarily in the
     * Amazon RDS User Guide.
     *
     *
     * This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL.
     * For Aurora clusters, use StopDBCluster instead.
     */
    suspend fun stopDbInstance(block: StopDbInstanceRequest.Builder.() -> Unit) = stopDbInstance(StopDbInstanceRequest.Builder().apply(block).build())

    /**
     * Stops automated backup replication for a DB instance.
     * This command doesn't apply to RDS Custom.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html">
     * Replicating Automated Backups to Another Amazon Web Services Region in the Amazon RDS User Guide.
     */
    suspend fun stopDbInstanceAutomatedBackupsReplication(input: StopDbInstanceAutomatedBackupsReplicationRequest): StopDbInstanceAutomatedBackupsReplicationResponse

    /**
     * Stops automated backup replication for a DB instance.
     * This command doesn't apply to RDS Custom.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html">
     * Replicating Automated Backups to Another Amazon Web Services Region in the Amazon RDS User Guide.
     */
    suspend fun stopDbInstanceAutomatedBackupsReplication(block: StopDbInstanceAutomatedBackupsReplicationRequest.Builder.() -> Unit) = stopDbInstanceAutomatedBackupsReplication(StopDbInstanceAutomatedBackupsReplicationRequest.Builder().apply(block).build())
}
