// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
class CopyDbSnapshotRequest private constructor(builder: Builder) {
    /**
     * A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.
     */
    val copyTags: kotlin.Boolean? = builder.copyTags
    /**
     * The Amazon Web Services KMS key identifier for an encrypted DB snapshot.
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * If you copy an encrypted DB snapshot from your Amazon Web Services account,
     * you can specify a value for this parameter to encrypt the copy with a new KMS key.
     * If you don't specify a value for this parameter,
     * then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.
     * If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account,
     * then you must specify a value for this parameter.
     * If you specify this parameter when you copy an unencrypted snapshot,
     * the copy is encrypted.
     * If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify
     * an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region
     * that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another
     * Amazon Web Services Region.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The name of an option group to associate with the copy of the snapshot.
     * Specify this option if you are copying a snapshot from one Amazon Web Services Region to another,
     * and your DB instance uses a nondefault option group.
     * If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server,
     * you must specify this option when copying across Amazon Web Services Regions.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations in the Amazon RDS User Guide.
     */
    val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The URL that contains a Signature Version 4 signed request for the
     * CopyDBSnapshot API action in the source Amazon Web Services Region that contains the
     * source DB snapshot to copy.
     * You must specify this parameter when you copy an encrypted DB snapshot from another
     * Amazon Web Services Region by using the Amazon RDS API. Don't specify PreSignedUrl when you are
     * copying an encrypted DB snapshot in the same Amazon Web Services Region.
     * The presigned URL must be a valid request for the CopyDBSnapshot API action
     * that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied.
     * The presigned URL request must contain the following parameter values:
     *
     *
     *
     * DestinationRegion - The Amazon Web Services Region that the encrypted DB snapshot is copied to.
     * This Amazon Web Services Region is the same one where the CopyDBSnapshot action is called that contains this presigned URL.
     * For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region
     * to the us-east-1 Amazon Web Services Region, then you call the CopyDBSnapshot action in
     * the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the
     * CopyDBSnapshot action in the us-west-2 Amazon Web Services Region. For this
     * example, the DestinationRegion in the presigned URL must be set to
     * the us-east-1 Amazon Web Services Region.
     *
     *
     * KmsKeyId - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region.
     * This is the same identifier for both the CopyDBSnapshot action that is called in the destination Amazon Web Services Region,
     * and the action contained in the presigned URL.
     *
     *
     * SourceDBSnapshotIdentifier - The DB snapshot identifier for the encrypted snapshot to be copied.
     * This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region.
     * For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your SourceDBSnapshotIdentifier looks like
     * the following example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115.
     *
     *
     * To learn how to generate a Signature Version 4 signed request, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4) and
     * <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process.
     *
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify SourceRegion (or --source-region for the CLI)
     * instead of specifying PreSignedUrl manually. Specifying SourceRegion autogenerates a pre-signed URL that is a valid
     * request for the operation that can be executed in the source Amazon Web Services Region.
     */
    val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The identifier for the source DB snapshot.
     * If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB
     * snapshot identifier. For example, you might specify
     * rds:mysql-instance1-snapshot-20130805.
     * If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB
     * snapshot ARN. For example, you might specify
     * arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805.
     * If you are copying from a shared manual DB snapshot,
     * this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.
     * If you are copying an encrypted snapshot
     * this parameter must be in the ARN format for the source Amazon Web Services Region,
     * and must match the SourceDBSnapshotIdentifier in the PreSignedUrl parameter.
     * Constraints:
     *
     *
     * Must specify a valid system snapshot in the "available" state.
     *
     *
     * Example: rds:mydb-2012-04-02-00-01
     *
     * Example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805
     */
    val sourceDbSnapshotIdentifier: kotlin.String? = builder.sourceDbSnapshotIdentifier
    /**
     * A list of tags.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The external custom Availability Zone (CAZ) identifier for the target CAZ.
     * Example: rds-caz-aiqhTgQv.
     */
    val targetCustomAvailabilityZone: kotlin.String? = builder.targetCustomAvailabilityZone
    /**
     * The identifier for the copy of the snapshot.
     * Constraints:
     *
     *
     * Can't be null, empty, or blank
     *
     * Must contain from 1 to 255 letters, numbers, or hyphens
     *
     * First character must be a letter
     *
     * Can't end with a hyphen or contain two consecutive hyphens
     *
     *
     * Example: my-db-snapshot
     */
    val targetDbSnapshotIdentifier: kotlin.String? = builder.targetDbSnapshotIdentifier

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CopyDbSnapshotRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyDbSnapshotRequest(")
        append("copyTags=$copyTags,")
        append("kmsKeyId=$kmsKeyId,")
        append("optionGroupName=$optionGroupName,")
        append("preSignedUrl=$preSignedUrl,")
        append("sourceDbSnapshotIdentifier=$sourceDbSnapshotIdentifier,")
        append("tags=$tags,")
        append("targetCustomAvailabilityZone=$targetCustomAvailabilityZone,")
        append("targetDbSnapshotIdentifier=$targetDbSnapshotIdentifier)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyTags?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetCustomAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (targetDbSnapshotIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyDbSnapshotRequest

        if (copyTags != other.copyTags) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (optionGroupName != other.optionGroupName) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (sourceDbSnapshotIdentifier != other.sourceDbSnapshotIdentifier) return false
        if (tags != other.tags) return false
        if (targetCustomAvailabilityZone != other.targetCustomAvailabilityZone) return false
        if (targetDbSnapshotIdentifier != other.targetDbSnapshotIdentifier) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CopyDbSnapshotRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A value that indicates whether to copy all tags from the source DB snapshot to the target DB snapshot. By default, tags are not copied.
         */
        var copyTags: kotlin.Boolean? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted DB snapshot.
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * If you copy an encrypted DB snapshot from your Amazon Web Services account,
         * you can specify a value for this parameter to encrypt the copy with a new KMS key.
         * If you don't specify a value for this parameter,
         * then the copy of the DB snapshot is encrypted with the same Amazon Web Services KMS key as the source DB snapshot.
         * If you copy an encrypted DB snapshot that is shared from another Amazon Web Services account,
         * then you must specify a value for this parameter.
         * If you specify this parameter when you copy an unencrypted snapshot,
         * the copy is encrypted.
         * If you copy an encrypted snapshot to a different Amazon Web Services Region, then you must specify
         * an Amazon Web Services KMS key identifier for the destination Amazon Web Services Region. KMS keys are specific to the Amazon Web Services Region
         * that they are created in, and you can't use KMS keys from one Amazon Web Services Region in another
         * Amazon Web Services Region.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The name of an option group to associate with the copy of the snapshot.
         * Specify this option if you are copying a snapshot from one Amazon Web Services Region to another,
         * and your DB instance uses a nondefault option group.
         * If your source DB instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server,
         * you must specify this option when copying across Amazon Web Services Regions.
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options">Option group considerations in the Amazon RDS User Guide.
         */
        var optionGroupName: kotlin.String? = null
        /**
         * The URL that contains a Signature Version 4 signed request for the
         * CopyDBSnapshot API action in the source Amazon Web Services Region that contains the
         * source DB snapshot to copy.
         * You must specify this parameter when you copy an encrypted DB snapshot from another
         * Amazon Web Services Region by using the Amazon RDS API. Don't specify PreSignedUrl when you are
         * copying an encrypted DB snapshot in the same Amazon Web Services Region.
         * The presigned URL must be a valid request for the CopyDBSnapshot API action
         * that can be executed in the source Amazon Web Services Region that contains the encrypted DB snapshot to be copied.
         * The presigned URL request must contain the following parameter values:
         *
         *
         *
         * DestinationRegion - The Amazon Web Services Region that the encrypted DB snapshot is copied to.
         * This Amazon Web Services Region is the same one where the CopyDBSnapshot action is called that contains this presigned URL.
         * For example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region
         * to the us-east-1 Amazon Web Services Region, then you call the CopyDBSnapshot action in
         * the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call to the
         * CopyDBSnapshot action in the us-west-2 Amazon Web Services Region. For this
         * example, the DestinationRegion in the presigned URL must be set to
         * the us-east-1 Amazon Web Services Region.
         *
         *
         * KmsKeyId - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of the DB snapshot in the destination Amazon Web Services Region.
         * This is the same identifier for both the CopyDBSnapshot action that is called in the destination Amazon Web Services Region,
         * and the action contained in the presigned URL.
         *
         *
         * SourceDBSnapshotIdentifier - The DB snapshot identifier for the encrypted snapshot to be copied.
         * This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region.
         * For example, if you are copying an encrypted DB snapshot from the us-west-2 Amazon Web Services Region, then your SourceDBSnapshotIdentifier looks like
         * the following example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115.
         *
         *
         * To learn how to generate a Signature Version 4 signed request, see
         * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4) and
         * <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4 Signing Process.
         *
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify SourceRegion (or --source-region for the CLI)
         * instead of specifying PreSignedUrl manually. Specifying SourceRegion autogenerates a pre-signed URL that is a valid
         * request for the operation that can be executed in the source Amazon Web Services Region.
         */
        var preSignedUrl: kotlin.String? = null
        /**
         * The identifier for the source DB snapshot.
         * If the source snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB
         * snapshot identifier. For example, you might specify
         * rds:mysql-instance1-snapshot-20130805.
         * If the source snapshot is in a different Amazon Web Services Region than the copy, specify a valid DB
         * snapshot ARN. For example, you might specify
         * arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805.
         * If you are copying from a shared manual DB snapshot,
         * this parameter must be the Amazon Resource Name (ARN) of the shared DB snapshot.
         * If you are copying an encrypted snapshot
         * this parameter must be in the ARN format for the source Amazon Web Services Region,
         * and must match the SourceDBSnapshotIdentifier in the PreSignedUrl parameter.
         * Constraints:
         *
         *
         * Must specify a valid system snapshot in the "available" state.
         *
         *
         * Example: rds:mydb-2012-04-02-00-01
         *
         * Example: arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805
         */
        var sourceDbSnapshotIdentifier: kotlin.String? = null
        /**
         * A list of tags.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
         */
        var tags: List<Tag>? = null
        /**
         * The external custom Availability Zone (CAZ) identifier for the target CAZ.
         * Example: rds-caz-aiqhTgQv.
         */
        var targetCustomAvailabilityZone: kotlin.String? = null
        /**
         * The identifier for the copy of the snapshot.
         * Constraints:
         *
         *
         * Can't be null, empty, or blank
         *
         * Must contain from 1 to 255 letters, numbers, or hyphens
         *
         * First character must be a letter
         *
         * Can't end with a hyphen or contain two consecutive hyphens
         *
         *
         * Example: my-db-snapshot
         */
        var targetDbSnapshotIdentifier: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CopyDbSnapshotRequest) : this() {
            this.copyTags = x.copyTags
            this.kmsKeyId = x.kmsKeyId
            this.optionGroupName = x.optionGroupName
            this.preSignedUrl = x.preSignedUrl
            this.sourceDbSnapshotIdentifier = x.sourceDbSnapshotIdentifier
            this.tags = x.tags
            this.targetCustomAvailabilityZone = x.targetCustomAvailabilityZone
            this.targetDbSnapshotIdentifier = x.targetDbSnapshotIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CopyDbSnapshotRequest = CopyDbSnapshotRequest(this)
    }
}
