// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



class CreateCustomDbEngineVersionRequest private constructor(builder: Builder) {
    /**
     * The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid
     * bucket name is my-custom-installation-files.
     */
    val databaseInstallationFilesS3BucketName: kotlin.String? = builder.databaseInstallationFilesS3BucketName
    /**
     * The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid
     * bucket name is 123456789012/cev1. If this setting isn't specified, no prefix is assumed.
     */
    val databaseInstallationFilesS3Prefix: kotlin.String? = builder.databaseInstallationFilesS3Prefix
    /**
     * An optional description of your CEV.
     */
    val description: kotlin.String? = builder.description
    /**
     * The database engine to use for your custom engine version (CEV). The only supported value is
     * custom-oracle-ee.
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The name of your CEV. The name format is 19.customized_string
     * . For example,
     * a valid name is 19.my_cev1. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS.
     * The combination of Engine and EngineVersion is unique per customer per Region.
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric KMS key is required for
     * RDS Custom, but optional for Amazon RDS.
     * If you have an existing symmetric KMS key in your account, you can use it with RDS Custom.
     * No further action is necessary. If you don't already have a symmetric KMS key in your account,
     * follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk">
     * Creating symmetric KMS keys in the Amazon Web Services Key Management Service
     * Developer Guide.
     * You can choose the same symmetric key when you create a CEV and a DB instance, or choose different keys.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3.
     * Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which
     * they are listed.
     * The following JSON fields are valid:
     *
     * MediaImportTemplateVersion
     *
     * Version of the CEV manifest. The date is in the format YYYY-MM-DD.
     *
     * databaseInstallationFileNames
     *
     * Ordered list of installation files for the CEV.
     *
     * opatchFileNames
     *
     * Ordered list of OPatch installers used for the Oracle DB engine.
     *
     * psuRuPatchFileNames
     *
     * The PSU and RU patches for this CEV.
     *
     * OtherPatchFileNames
     *
     * The patches that are not in the list of PSU and RU patches.
     * Amazon RDS applies these patches after applying the PSU and RU patches.
     *
     *
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">
     * Creating the CEV manifest in the Amazon RDS User Guide.
     */
    val manifest: kotlin.String? = builder.manifest
    /**
     * A list of tags.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateCustomDbEngineVersionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomDbEngineVersionRequest(")
        append("databaseInstallationFilesS3BucketName=$databaseInstallationFilesS3BucketName,")
        append("databaseInstallationFilesS3Prefix=$databaseInstallationFilesS3Prefix,")
        append("description=$description,")
        append("engine=$engine,")
        append("engineVersion=$engineVersion,")
        append("kmsKeyId=$kmsKeyId,")
        append("manifest=$manifest,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseInstallationFilesS3BucketName?.hashCode() ?: 0
        result = 31 * result + (databaseInstallationFilesS3Prefix?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (manifest?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomDbEngineVersionRequest

        if (databaseInstallationFilesS3BucketName != other.databaseInstallationFilesS3BucketName) return false
        if (databaseInstallationFilesS3Prefix != other.databaseInstallationFilesS3Prefix) return false
        if (description != other.description) return false
        if (engine != other.engine) return false
        if (engineVersion != other.engineVersion) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (manifest != other.manifest) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateCustomDbEngineVersionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid
         * bucket name is my-custom-installation-files.
         */
        var databaseInstallationFilesS3BucketName: kotlin.String? = null
        /**
         * The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid
         * bucket name is 123456789012/cev1. If this setting isn't specified, no prefix is assumed.
         */
        var databaseInstallationFilesS3Prefix: kotlin.String? = null
        /**
         * An optional description of your CEV.
         */
        var description: kotlin.String? = null
        /**
         * The database engine to use for your custom engine version (CEV). The only supported value is
         * custom-oracle-ee.
         */
        var engine: kotlin.String? = null
        /**
         * The name of your CEV. The name format is 19.customized_string
         * . For example,
         * a valid name is 19.my_cev1. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS.
         * The combination of Engine and EngineVersion is unique per customer per Region.
         */
        var engineVersion: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric KMS key is required for
         * RDS Custom, but optional for Amazon RDS.
         * If you have an existing symmetric KMS key in your account, you can use it with RDS Custom.
         * No further action is necessary. If you don't already have a symmetric KMS key in your account,
         * follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk">
         * Creating symmetric KMS keys in the Amazon Web Services Key Management Service
         * Developer Guide.
         * You can choose the same symmetric key when you create a CEV and a DB instance, or choose different keys.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3.
         * Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which
         * they are listed.
         * The following JSON fields are valid:
         *
         * MediaImportTemplateVersion
         *
         * Version of the CEV manifest. The date is in the format YYYY-MM-DD.
         *
         * databaseInstallationFileNames
         *
         * Ordered list of installation files for the CEV.
         *
         * opatchFileNames
         *
         * Ordered list of OPatch installers used for the Oracle DB engine.
         *
         * psuRuPatchFileNames
         *
         * The PSU and RU patches for this CEV.
         *
         * OtherPatchFileNames
         *
         * The patches that are not in the list of PSU and RU patches.
         * Amazon RDS applies these patches after applying the PSU and RU patches.
         *
         *
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">
         * Creating the CEV manifest in the Amazon RDS User Guide.
         */
        var manifest: kotlin.String? = null
        /**
         * A list of tags.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources in the Amazon RDS User Guide.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateCustomDbEngineVersionRequest) : this() {
            this.databaseInstallationFilesS3BucketName = x.databaseInstallationFilesS3BucketName
            this.databaseInstallationFilesS3Prefix = x.databaseInstallationFilesS3Prefix
            this.description = x.description
            this.engine = x.engine
            this.engineVersion = x.engineVersion
            this.kmsKeyId = x.kmsKeyId
            this.manifest = x.manifest
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateCustomDbEngineVersionRequest = CreateCustomDbEngineVersionRequest(this)
    }
}
