// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



class CreateDbClusterEndpointRequest private constructor(builder: Builder) {
    /**
     * The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
     */
    val dbClusterEndpointIdentifier: kotlin.String? = builder.dbClusterEndpointIdentifier
    /**
     * The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
     * stored as a lowercase string.
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The type of the endpoint, one of: READER, WRITER, ANY.
     */
    val endpointType: kotlin.String? = builder.endpointType
    /**
     * List of DB instance identifiers that aren't part of the custom endpoint group.
     * All other eligible instances are reachable through the custom endpoint.
     * This parameter is relevant only if the list of static members is empty.
     */
    val excludedMembers: List<String>? = builder.excludedMembers
    /**
     * List of DB instance identifiers that are part of the custom endpoint group.
     */
    val staticMembers: List<String>? = builder.staticMembers
    /**
     * The tags to be assigned to the Amazon RDS resource.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbClusterEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbClusterEndpointRequest(")
        append("dbClusterEndpointIdentifier=$dbClusterEndpointIdentifier,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("endpointType=$endpointType,")
        append("excludedMembers=$excludedMembers,")
        append("staticMembers=$staticMembers,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbClusterEndpointIdentifier?.hashCode() ?: 0
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (excludedMembers?.hashCode() ?: 0)
        result = 31 * result + (staticMembers?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbClusterEndpointRequest

        if (dbClusterEndpointIdentifier != other.dbClusterEndpointIdentifier) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (endpointType != other.endpointType) return false
        if (excludedMembers != other.excludedMembers) return false
        if (staticMembers != other.staticMembers) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbClusterEndpointRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier to use for the new endpoint. This parameter is stored as a lowercase string.
         */
        var dbClusterEndpointIdentifier: kotlin.String? = null
        /**
         * The DB cluster identifier of the DB cluster associated with the endpoint. This parameter is
         * stored as a lowercase string.
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * The type of the endpoint, one of: READER, WRITER, ANY.
         */
        var endpointType: kotlin.String? = null
        /**
         * List of DB instance identifiers that aren't part of the custom endpoint group.
         * All other eligible instances are reachable through the custom endpoint.
         * This parameter is relevant only if the list of static members is empty.
         */
        var excludedMembers: List<String>? = null
        /**
         * List of DB instance identifiers that are part of the custom endpoint group.
         */
        var staticMembers: List<String>? = null
        /**
         * The tags to be assigned to the Amazon RDS resource.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbClusterEndpointRequest) : this() {
            this.dbClusterEndpointIdentifier = x.dbClusterEndpointIdentifier
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.endpointType = x.endpointType
            this.excludedMembers = x.excludedMembers
            this.staticMembers = x.staticMembers
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbClusterEndpointRequest = CreateDbClusterEndpointRequest(this)
    }
}
