// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
class CreateDbClusterRequest private constructor(builder: Builder) {
    /**
     * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
     * This setting is required to create a Multi-AZ DB cluster.
     * Valid for: Multi-AZ DB clusters only
     */
    val allocatedStorage: kotlin.Int? = builder.allocatedStorage
    /**
     * A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
     * By default, minor engine upgrades are applied automatically.
     * Valid for: Multi-AZ DB clusters only
     */
    val autoMinorVersionUpgrade: kotlin.Boolean? = builder.autoMinorVersionUpgrade
    /**
     * A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.
     * For information on Amazon Web Services Regions and Availability Zones, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and
     * Availability Zones in the Amazon Aurora User Guide.
     * Valid for: Aurora DB clusters only
     */
    val availabilityZones: List<String>? = builder.availabilityZones
    /**
     * The target backtrack window, in seconds. To disable backtracking, set this value to
     * 0.
     * Default: 0
     * Constraints:
     *
     *
     * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
     *
     *
     * Valid for: Aurora MySQL DB clusters only
     */
    val backtrackWindow: kotlin.Long? = builder.backtrackWindow
    /**
     * The number of days for which automated backups are retained.
     * Default: 1
     * Constraints:
     *
     *
     * Must be a value from 1 to 35
     *
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val backupRetentionPeriod: kotlin.Int? = builder.backupRetentionPeriod
    /**
     * A value that indicates that the DB cluster should be associated with the specified CharacterSet.
     * Valid for: Aurora DB clusters only
     */
    val characterSetName: kotlin.String? = builder.characterSetName
    /**
     * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
     * The default is not to copy them.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val copyTagsToSnapshot: kotlin.Boolean? = builder.copyTagsToSnapshot
    /**
     * The name for your database of up to 64 alphanumeric characters. If you do not
     * provide a name, Amazon RDS doesn't create a database in the DB cluster you are
     * creating.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val databaseName: kotlin.String? = builder.databaseName
    /**
     * The DB cluster identifier. This parameter is stored as a lowercase string.
     * Constraints:
     *
     *
     * Must contain from 1 to 63 letters, numbers, or hyphens.
     *
     * First character must be a letter.
     *
     * Can't end with a hyphen or contain two consecutive hyphens.
     *
     *
     * Example: my-cluster1
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val dbClusterIdentifier: kotlin.String? = builder.dbClusterIdentifier
    /**
     * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge.
     * Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
     * For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class in the Amazon RDS User Guide.
     * This setting is required to create a Multi-AZ DB cluster.
     * Valid for: Multi-AZ DB clusters only
     */
    val dbClusterInstanceClass: kotlin.String? = builder.dbClusterInstanceClass
    /**
     * The name of the DB cluster parameter group to associate
     * with this DB cluster. If you do not specify a value, then
     * the default DB cluster parameter group for the specified DB engine and version is used.
     * Constraints:
     *
     *
     * If supplied, must match the name of an existing DB cluster parameter group.
     *
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val dbClusterParameterGroupName: kotlin.String? = builder.dbClusterParameterGroupName
    /**
     * A DB subnet group to associate with this DB cluster.
     * This setting is required to create a Multi-AZ DB cluster.
     * Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.
     * Example: mydbsubnetgroup
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val dbSubnetGroupName: kotlin.String? = builder.dbSubnetGroupName
    /**
     * A value that indicates whether the DB cluster has deletion protection enabled.
     * The database can't be deleted when deletion protection is enabled. By default,
     * deletion protection isn't enabled.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The Active Directory directory ID to create the DB cluster in.
     * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication
     * in the Amazon Aurora User Guide.
     * Valid for: Aurora DB clusters only
     */
    val domain: kotlin.String? = builder.domain
    /**
     * Specify the name of the IAM role to be used when making API calls to the Directory Service.
     * Valid for: Aurora DB clusters only
     */
    val domainIamRoleName: kotlin.String? = builder.domainIamRoleName
    /**
     * The list of log types that need to be enabled for exporting to CloudWatch Logs. The values
     * in the list depend on the DB engine being used.
     *
     * RDS for MySQL
     *
     * Possible values are error, general, and slowquery.
     *
     * RDS for PostgreSQL
     *
     * Possible values are postgresql and upgrade.
     *
     * Aurora MySQL
     *
     * Possible values are audit, error, general, and slowquery.
     *
     * Aurora PostgreSQL
     *
     * Possible value is postgresql.
     * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide.
     * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val enableCloudwatchLogsExports: List<String>? = builder.enableCloudwatchLogsExports
    /**
     * A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an
     * Aurora global database (GlobalCluster). By default, write operations are not allowed on Aurora DB clusters that
     * are secondary clusters in an Aurora global database.
     * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter
     * enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to
     * this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the
     * primary is demoted by the FailoverGlobalCluster API operation, but it does nothing until then.
     * Valid for: Aurora DB clusters only
     */
    val enableGlobalWriteForwarding: kotlin.Boolean? = builder.enableGlobalWriteForwarding
    /**
     * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint
     * is disabled.
     * When enabled, the HTTP endpoint provides a connectionless web service API for running
     * SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database
     * from inside the RDS console with the query editor.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless v1 in the
     * Amazon Aurora User Guide.
     * Valid for: Aurora DB clusters only
     */
    val enableHttpEndpoint: kotlin.Boolean? = builder.enableHttpEndpoint
    /**
     * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
     * Management (IAM) accounts to database accounts. By default, mapping isn't
     * enabled.
     * For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">
     * IAM Database Authentication in the Amazon Aurora User Guide..
     * Valid for: Aurora DB clusters only
     */
    val enableIamDatabaseAuthentication: kotlin.Boolean? = builder.enableIamDatabaseAuthentication
    /**
     * A value that indicates whether to turn on Performance Insights for the DB cluster.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">
     * Using Amazon Performance Insights in the Amazon RDS User Guide.
     * Valid for: Multi-AZ DB clusters only
     */
    val enablePerformanceInsights: kotlin.Boolean? = builder.enablePerformanceInsights
    /**
     * The name of the database engine to be used for this DB cluster.
     * Valid Values:
     *
     *
     *
     * aurora (for MySQL 5.6-compatible Aurora)
     *
     *
     * aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
     *
     *
     * aurora-postgresql
     *
     *
     *
     * mysql
     *
     *
     *
     * postgres
     *
     *
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val engine: kotlin.String? = builder.engine
    /**
     * The DB engine mode of the DB cluster, either provisioned, serverless,
     * parallelquery, global, or multimaster.
     * The parallelquery engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions,
     * and version 2.09 and higher 2.x versions.
     * The global engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions,
     * and global engine mode isn't required for any 2.x versions.
     * The multimaster engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
     * For Aurora PostgreSQL, the global engine mode isn't required, and both the parallelquery
     * and the multimaster engine modes currently aren't supported.
     * Limitations and requirements apply to some DB engine modes. For more information, see the
     * following sections in the Amazon Aurora User Guide:
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">
     * Limitations of Aurora Serverless v1
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">
     * Limitations of Parallel Query
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">
     * Limitations of Aurora Global Databases
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">
     * Limitations of Multi-Master Clusters
     *
     *
     *
     * Valid for: Aurora DB clusters only
     */
    val engineMode: kotlin.String? = builder.engineMode
    /**
     * The version number of the database engine to use.
     * To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:
     *
     * aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions&#91;&#93;.EngineVersion"
     *
     * To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:
     *
     * aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions&#91;&#93;.EngineVersion"
     *
     * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
     *
     * aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions&#91;&#93;.EngineVersion"
     *
     * To list all of the available engine versions for RDS for MySQL, use the following command:
     *
     * aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions&#91;&#93;.EngineVersion"
     *
     * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
     *
     * aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions&#91;&#93;.EngineVersion"
     *
     *
     * Aurora MySQL
     *
     * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">MySQL on Amazon RDS Versions in the
     * Amazon Aurora User Guide.
     *
     * Aurora PostgreSQL
     *
     * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions in the
     * Amazon Aurora User Guide.
     *
     * MySQL
     *
     * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions in the
     * Amazon RDS User Guide.
     *
     * PostgreSQL
     *
     * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions in the
     * Amazon RDS User Guide.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val engineVersion: kotlin.String? = builder.engineVersion
    /**
     * The global cluster ID of an Aurora cluster that becomes the primary cluster
     * in the new global database cluster.
     * Valid for: Aurora DB clusters only
     */
    val globalClusterIdentifier: kotlin.String? = builder.globalClusterIdentifier
    /**
     * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated
     * for each DB instance in the Multi-AZ DB cluster.
     * For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance in the Amazon RDS User Guide.
     * This setting is required to create a Multi-AZ DB cluster.
     * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
     * Valid for: Multi-AZ DB clusters only
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The Amazon Web Services KMS key identifier for an encrypted DB cluster.
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
     * When a KMS key isn't specified in KmsKeyId:
     *
     *
     * If ReplicationSourceIdentifier identifies an encrypted
     * source, then Amazon RDS will use the KMS key used to encrypt the
     * source. Otherwise, Amazon RDS will use your default KMS key.
     *
     * If the StorageEncrypted parameter is enabled and
     * ReplicationSourceIdentifier isn't specified, then Amazon RDS
     * will use your default KMS key.
     *
     *
     * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
     * has a different default KMS key for each Amazon Web Services Region.
     * If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you
     * must set KmsKeyId to a KMS key identifier that is valid in the destination Amazon Web Services
     * Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".
     * Constraints: Must contain from 8 to 41 characters.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val masterUserPassword: kotlin.String? = builder.masterUserPassword
    /**
     * The name of the master user for the DB cluster.
     * Constraints:
     *
     *
     * Must be 1 to 16 letters or numbers.
     *
     * First character must be a letter.
     *
     * Can't be a reserved word for the chosen database engine.
     *
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val masterUsername: kotlin.String? = builder.masterUsername
    /**
     * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off
     * collecting Enhanced Monitoring metrics, specify 0. The default is 0.
     * If MonitoringRoleArn is specified, also set MonitoringInterval
     * to a value other than 0.
     * Valid Values: 0, 1, 5, 10, 15, 30, 60
     *
     * Valid for: Multi-AZ DB clusters only
     */
    val monitoringInterval: kotlin.Int? = builder.monitoringInterval
    /**
     * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
     * An example is arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role,
     * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting
     * up and enabling Enhanced Monitoring in the Amazon RDS User Guide.
     * If MonitoringInterval is set to a value other than 0, supply a MonitoringRoleArn value.
     * Valid for: Multi-AZ DB clusters only
     */
    val monitoringRoleArn: kotlin.String? = builder.monitoringRoleArn
    /**
     * A value that indicates that the DB cluster should be associated with the specified option group.
     * DB clusters are associated with a default option group that can't be modified.
     */
    val optionGroupName: kotlin.String? = builder.optionGroupName
    /**
     * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
     * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     * If you don't specify a value for PerformanceInsightsKMSKeyId, then Amazon RDS
     * uses your default KMS key. There is a default KMS key for your Amazon Web Services account.
     * Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
     * Valid for: Multi-AZ DB clusters only
     */
    val performanceInsightsKmsKeyId: kotlin.String? = builder.performanceInsightsKmsKeyId
    /**
     * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
     * Valid for: Multi-AZ DB clusters only
     */
    val performanceInsightsRetentionPeriod: kotlin.Int? = builder.performanceInsightsRetentionPeriod
    /**
     * The port number on which the instances in the DB cluster accept connections.
     *
     * RDS for MySQL and Aurora MySQL
     *
     * Default: 3306
     *
     * Valid values: 1150-65535
     *
     *
     * RDS for PostgreSQL and Aurora PostgreSQL
     *
     * Default: 5432
     *
     * Valid values: 1150-65535
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val port: kotlin.Int? = builder.port
    /**
     * A URL that contains a Signature Version 4 signed request for
     * the CreateDBCluster action to be called in the source Amazon Web Services Region where the DB cluster is replicated from.
     * Specify PreSignedUrl only when you are performing cross-Region replication from an encrypted DB cluster.
     * The pre-signed URL must be a valid request for the CreateDBCluster API action
     * that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.
     * The pre-signed URL request must contain the following parameter values:
     *
     *
     *
     * KmsKeyId - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of
     * the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the CreateDBCluster
     * action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.
     *
     *
     * DestinationRegion - The name of the Amazon Web Services Region that Aurora read replica will
     * be created in.
     *
     *
     * ReplicationSourceIdentifier - The DB cluster identifier for the encrypted DB cluster to be copied.
     * This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an
     * encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your ReplicationSourceIdentifier would look like
     * Example: arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1.
     *
     *
     * To learn how to generate a Signature Version 4 signed request, see
     * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">
     * Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4) and
     * <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">
     * Signature Version 4 Signing Process.
     *
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify SourceRegion (or --source-region for the CLI)
     * instead of specifying PreSignedUrl manually. Specifying SourceRegion autogenerates a pre-signed URL that is a valid
     * request for the operation that can be executed in the source Amazon Web Services Region.
     *
     * Valid for: Aurora DB clusters only
     */
    val preSignedUrl: kotlin.String? = builder.preSignedUrl
    /**
     * The daily time range during which automated backups are created
     * if automated backups are enabled
     * using the BackupRetentionPeriod parameter.
     * The default is a 30-minute window selected at random from an
     * 8-hour block of time for each Amazon Web Services Region.
     * To view the time blocks available, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">
     * Backup window in the Amazon Aurora User Guide.
     * Constraints:
     *
     *
     * Must be in the format hh24:mi-hh24:mi.
     *
     * Must be in Universal Coordinated Time (UTC).
     *
     * Must not conflict with the preferred maintenance window.
     *
     * Must be at least 30 minutes.
     *
     *
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val preferredBackupWindow: kotlin.String? = builder.preferredBackupWindow
    /**
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * Format: ddd:hh24:mi-ddd:hh24:mi
     *
     * The default is a 30-minute window selected at random from an
     * 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the
     * week. To see the time blocks available, see
     * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">
     * Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
     * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
     * Constraints: Minimum 30-minute window.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val preferredMaintenanceWindow: kotlin.String? = builder.preferredMaintenanceWindow
    /**
     * A value that indicates whether the DB cluster is publicly accessible.
     * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint
     * resolves to the private IP address from within the DB cluster's virtual private cloud
     * (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access
     * to the DB cluster is ultimately controlled by the security group it uses. That public
     * access isn't permitted if the security group assigned to the DB cluster doesn't permit
     * it.
     * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
     * Default: The default behavior varies depending on whether DBSubnetGroupName is specified.
     * If DBSubnetGroupName isn't specified, and PubliclyAccessible isn't specified, the following applies:
     *
     *
     * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
     *
     * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
     *
     *
     * If DBSubnetGroupName is specified, and PubliclyAccessible isn't specified, the following applies:
     *
     *
     * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
     *
     * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
     *
     *
     * Valid for: Multi-AZ DB clusters only
     */
    val publiclyAccessible: kotlin.Boolean? = builder.publiclyAccessible
    /**
     * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB
     * cluster is created as a read replica.
     * Valid for: Aurora DB clusters only
     */
    val replicationSourceIdentifier: kotlin.String? = builder.replicationSourceIdentifier
    /**
     * For DB clusters in serverless DB engine mode, the scaling properties of the DB cluster.
     * Valid for: Aurora DB clusters only
     */
    val scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = builder.scalingConfiguration
    /**
     * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2 in the
     * Amazon Aurora User Guide.
     */
    val serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = builder.serverlessV2ScalingConfiguration
    /**
     * A value that indicates whether the DB cluster is encrypted.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val storageEncrypted: kotlin.Boolean? = builder.storageEncrypted
    /**
     * Specifies the storage type to be associated with the DB cluster.
     * This setting is required to create a Multi-AZ DB cluster.
     * Valid values: io1
     *
     * When specified, a value for the Iops parameter is required.
     * Default: io1
     *
     * Valid for: Multi-AZ DB clusters only
     */
    val storageType: kotlin.String? = builder.storageType
    /**
     * Tags to assign to the DB cluster.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A list of EC2 VPC security groups to associate with this DB cluster.
     * Valid for: Aurora DB clusters and Multi-AZ DB clusters
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbClusterRequest(")
        append("allocatedStorage=$allocatedStorage,")
        append("autoMinorVersionUpgrade=$autoMinorVersionUpgrade,")
        append("availabilityZones=$availabilityZones,")
        append("backtrackWindow=$backtrackWindow,")
        append("backupRetentionPeriod=$backupRetentionPeriod,")
        append("characterSetName=$characterSetName,")
        append("copyTagsToSnapshot=$copyTagsToSnapshot,")
        append("databaseName=$databaseName,")
        append("dbClusterIdentifier=$dbClusterIdentifier,")
        append("dbClusterInstanceClass=$dbClusterInstanceClass,")
        append("dbClusterParameterGroupName=$dbClusterParameterGroupName,")
        append("dbSubnetGroupName=$dbSubnetGroupName,")
        append("deletionProtection=$deletionProtection,")
        append("domain=$domain,")
        append("domainIamRoleName=$domainIamRoleName,")
        append("enableCloudwatchLogsExports=$enableCloudwatchLogsExports,")
        append("enableGlobalWriteForwarding=$enableGlobalWriteForwarding,")
        append("enableHttpEndpoint=$enableHttpEndpoint,")
        append("enableIamDatabaseAuthentication=$enableIamDatabaseAuthentication,")
        append("enablePerformanceInsights=$enablePerformanceInsights,")
        append("engine=$engine,")
        append("engineMode=$engineMode,")
        append("engineVersion=$engineVersion,")
        append("globalClusterIdentifier=$globalClusterIdentifier,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("masterUserPassword=$masterUserPassword,")
        append("masterUsername=$masterUsername,")
        append("monitoringInterval=$monitoringInterval,")
        append("monitoringRoleArn=$monitoringRoleArn,")
        append("optionGroupName=$optionGroupName,")
        append("performanceInsightsKmsKeyId=$performanceInsightsKmsKeyId,")
        append("performanceInsightsRetentionPeriod=$performanceInsightsRetentionPeriod,")
        append("port=$port,")
        append("preSignedUrl=$preSignedUrl,")
        append("preferredBackupWindow=$preferredBackupWindow,")
        append("preferredMaintenanceWindow=$preferredMaintenanceWindow,")
        append("publiclyAccessible=$publiclyAccessible,")
        append("replicationSourceIdentifier=$replicationSourceIdentifier,")
        append("scalingConfiguration=$scalingConfiguration,")
        append("serverlessV2ScalingConfiguration=$serverlessV2ScalingConfiguration,")
        append("storageEncrypted=$storageEncrypted,")
        append("storageType=$storageType,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocatedStorage ?: 0
        result = 31 * result + (autoMinorVersionUpgrade?.hashCode() ?: 0)
        result = 31 * result + (availabilityZones?.hashCode() ?: 0)
        result = 31 * result + (backtrackWindow?.hashCode() ?: 0)
        result = 31 * result + (backupRetentionPeriod ?: 0)
        result = 31 * result + (characterSetName?.hashCode() ?: 0)
        result = 31 * result + (copyTagsToSnapshot?.hashCode() ?: 0)
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (dbClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbClusterInstanceClass?.hashCode() ?: 0)
        result = 31 * result + (dbClusterParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (dbSubnetGroupName?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (domainIamRoleName?.hashCode() ?: 0)
        result = 31 * result + (enableCloudwatchLogsExports?.hashCode() ?: 0)
        result = 31 * result + (enableGlobalWriteForwarding?.hashCode() ?: 0)
        result = 31 * result + (enableHttpEndpoint?.hashCode() ?: 0)
        result = 31 * result + (enableIamDatabaseAuthentication?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceInsights?.hashCode() ?: 0)
        result = 31 * result + (engine?.hashCode() ?: 0)
        result = 31 * result + (engineMode?.hashCode() ?: 0)
        result = 31 * result + (engineVersion?.hashCode() ?: 0)
        result = 31 * result + (globalClusterIdentifier?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (masterUserPassword?.hashCode() ?: 0)
        result = 31 * result + (masterUsername?.hashCode() ?: 0)
        result = 31 * result + (monitoringInterval ?: 0)
        result = 31 * result + (monitoringRoleArn?.hashCode() ?: 0)
        result = 31 * result + (optionGroupName?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceInsightsRetentionPeriod ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (preSignedUrl?.hashCode() ?: 0)
        result = 31 * result + (preferredBackupWindow?.hashCode() ?: 0)
        result = 31 * result + (preferredMaintenanceWindow?.hashCode() ?: 0)
        result = 31 * result + (publiclyAccessible?.hashCode() ?: 0)
        result = 31 * result + (replicationSourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (scalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serverlessV2ScalingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (storageEncrypted?.hashCode() ?: 0)
        result = 31 * result + (storageType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbClusterRequest

        if (allocatedStorage != other.allocatedStorage) return false
        if (autoMinorVersionUpgrade != other.autoMinorVersionUpgrade) return false
        if (availabilityZones != other.availabilityZones) return false
        if (backtrackWindow != other.backtrackWindow) return false
        if (backupRetentionPeriod != other.backupRetentionPeriod) return false
        if (characterSetName != other.characterSetName) return false
        if (copyTagsToSnapshot != other.copyTagsToSnapshot) return false
        if (databaseName != other.databaseName) return false
        if (dbClusterIdentifier != other.dbClusterIdentifier) return false
        if (dbClusterInstanceClass != other.dbClusterInstanceClass) return false
        if (dbClusterParameterGroupName != other.dbClusterParameterGroupName) return false
        if (dbSubnetGroupName != other.dbSubnetGroupName) return false
        if (deletionProtection != other.deletionProtection) return false
        if (domain != other.domain) return false
        if (domainIamRoleName != other.domainIamRoleName) return false
        if (enableCloudwatchLogsExports != other.enableCloudwatchLogsExports) return false
        if (enableGlobalWriteForwarding != other.enableGlobalWriteForwarding) return false
        if (enableHttpEndpoint != other.enableHttpEndpoint) return false
        if (enableIamDatabaseAuthentication != other.enableIamDatabaseAuthentication) return false
        if (enablePerformanceInsights != other.enablePerformanceInsights) return false
        if (engine != other.engine) return false
        if (engineMode != other.engineMode) return false
        if (engineVersion != other.engineVersion) return false
        if (globalClusterIdentifier != other.globalClusterIdentifier) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (masterUserPassword != other.masterUserPassword) return false
        if (masterUsername != other.masterUsername) return false
        if (monitoringInterval != other.monitoringInterval) return false
        if (monitoringRoleArn != other.monitoringRoleArn) return false
        if (optionGroupName != other.optionGroupName) return false
        if (performanceInsightsKmsKeyId != other.performanceInsightsKmsKeyId) return false
        if (performanceInsightsRetentionPeriod != other.performanceInsightsRetentionPeriod) return false
        if (port != other.port) return false
        if (preSignedUrl != other.preSignedUrl) return false
        if (preferredBackupWindow != other.preferredBackupWindow) return false
        if (preferredMaintenanceWindow != other.preferredMaintenanceWindow) return false
        if (publiclyAccessible != other.publiclyAccessible) return false
        if (replicationSourceIdentifier != other.replicationSourceIdentifier) return false
        if (scalingConfiguration != other.scalingConfiguration) return false
        if (serverlessV2ScalingConfiguration != other.serverlessV2ScalingConfiguration) return false
        if (storageEncrypted != other.storageEncrypted) return false
        if (storageType != other.storageType) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbClusterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The amount of storage in gibibytes (GiB) to allocate to each DB instance in the Multi-AZ DB cluster.
         * This setting is required to create a Multi-AZ DB cluster.
         * Valid for: Multi-AZ DB clusters only
         */
        var allocatedStorage: kotlin.Int? = null
        /**
         * A value that indicates whether minor engine upgrades are applied automatically to the DB cluster during the maintenance window.
         * By default, minor engine upgrades are applied automatically.
         * Valid for: Multi-AZ DB clusters only
         */
        var autoMinorVersionUpgrade: kotlin.Boolean? = null
        /**
         * A list of Availability Zones (AZs) where DB instances in the DB cluster can be created.
         * For information on Amazon Web Services Regions and Availability Zones, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html">Choosing the Regions and
         * Availability Zones in the Amazon Aurora User Guide.
         * Valid for: Aurora DB clusters only
         */
        var availabilityZones: List<String>? = null
        /**
         * The target backtrack window, in seconds. To disable backtracking, set this value to
         * 0.
         * Default: 0
         * Constraints:
         *
         *
         * If specified, this value must be set to a number from 0 to 259,200 (72 hours).
         *
         *
         * Valid for: Aurora MySQL DB clusters only
         */
        var backtrackWindow: kotlin.Long? = null
        /**
         * The number of days for which automated backups are retained.
         * Default: 1
         * Constraints:
         *
         *
         * Must be a value from 1 to 35
         *
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var backupRetentionPeriod: kotlin.Int? = null
        /**
         * A value that indicates that the DB cluster should be associated with the specified CharacterSet.
         * Valid for: Aurora DB clusters only
         */
        var characterSetName: kotlin.String? = null
        /**
         * A value that indicates whether to copy all tags from the DB cluster to snapshots of the DB cluster.
         * The default is not to copy them.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var copyTagsToSnapshot: kotlin.Boolean? = null
        /**
         * The name for your database of up to 64 alphanumeric characters. If you do not
         * provide a name, Amazon RDS doesn't create a database in the DB cluster you are
         * creating.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var databaseName: kotlin.String? = null
        /**
         * The DB cluster identifier. This parameter is stored as a lowercase string.
         * Constraints:
         *
         *
         * Must contain from 1 to 63 letters, numbers, or hyphens.
         *
         * First character must be a letter.
         *
         * Can't end with a hyphen or contain two consecutive hyphens.
         *
         *
         * Example: my-cluster1
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var dbClusterIdentifier: kotlin.String? = null
        /**
         * The compute and memory capacity of each DB instance in the Multi-AZ DB cluster, for example db.m6g.xlarge.
         * Not all DB instance classes are available in all Amazon Web Services Regions, or for all database engines.
         * For the full list of DB instance classes and availability for your engine, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html">DB instance class in the Amazon RDS User Guide.
         * This setting is required to create a Multi-AZ DB cluster.
         * Valid for: Multi-AZ DB clusters only
         */
        var dbClusterInstanceClass: kotlin.String? = null
        /**
         * The name of the DB cluster parameter group to associate
         * with this DB cluster. If you do not specify a value, then
         * the default DB cluster parameter group for the specified DB engine and version is used.
         * Constraints:
         *
         *
         * If supplied, must match the name of an existing DB cluster parameter group.
         *
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var dbClusterParameterGroupName: kotlin.String? = null
        /**
         * A DB subnet group to associate with this DB cluster.
         * This setting is required to create a Multi-AZ DB cluster.
         * Constraints: Must match the name of an existing DBSubnetGroup. Must not be default.
         * Example: mydbsubnetgroup
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var dbSubnetGroupName: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster has deletion protection enabled.
         * The database can't be deleted when deletion protection is enabled. By default,
         * deletion protection isn't enabled.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var deletionProtection: kotlin.Boolean? = null
        /**
         * The Active Directory directory ID to create the DB cluster in.
         * For Amazon Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that connect to the DB cluster.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/kerberos-authentication.html">Kerberos authentication
         * in the Amazon Aurora User Guide.
         * Valid for: Aurora DB clusters only
         */
        var domain: kotlin.String? = null
        /**
         * Specify the name of the IAM role to be used when making API calls to the Directory Service.
         * Valid for: Aurora DB clusters only
         */
        var domainIamRoleName: kotlin.String? = null
        /**
         * The list of log types that need to be enabled for exporting to CloudWatch Logs. The values
         * in the list depend on the DB engine being used.
         *
         * RDS for MySQL
         *
         * Possible values are error, general, and slowquery.
         *
         * RDS for PostgreSQL
         *
         * Possible values are postgresql and upgrade.
         *
         * Aurora MySQL
         *
         * Possible values are audit, error, general, and slowquery.
         *
         * Aurora PostgreSQL
         *
         * Possible value is postgresql.
         * For more information about exporting CloudWatch Logs for Amazon RDS, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide.
         * For more information about exporting CloudWatch Logs for Amazon Aurora, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch">Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var enableCloudwatchLogsExports: List<String>? = null
        /**
         * A value that indicates whether to enable this DB cluster to forward write operations to the primary cluster of an
         * Aurora global database (GlobalCluster). By default, write operations are not allowed on Aurora DB clusters that
         * are secondary clusters in an Aurora global database.
         * You can set this value only on Aurora DB clusters that are members of an Aurora global database. With this parameter
         * enabled, a secondary cluster can forward writes to the current primary cluster and the resulting changes are replicated back to
         * this cluster. For the primary DB cluster of an Aurora global database, this value is used immediately if the
         * primary is demoted by the FailoverGlobalCluster API operation, but it does nothing until then.
         * Valid for: Aurora DB clusters only
         */
        var enableGlobalWriteForwarding: kotlin.Boolean? = null
        /**
         * A value that indicates whether to enable the HTTP endpoint for an Aurora Serverless v1 DB cluster. By default, the HTTP endpoint
         * is disabled.
         * When enabled, the HTTP endpoint provides a connectionless web service API for running
         * SQL queries on the Aurora Serverless v1 DB cluster. You can also query your database
         * from inside the RDS console with the query editor.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API for Aurora Serverless v1 in the
         * Amazon Aurora User Guide.
         * Valid for: Aurora DB clusters only
         */
        var enableHttpEndpoint: kotlin.Boolean? = null
        /**
         * A value that indicates whether to enable mapping of Amazon Web Services Identity and Access
         * Management (IAM) accounts to database accounts. By default, mapping isn't
         * enabled.
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.IAMDBAuth.html">
         * IAM Database Authentication in the Amazon Aurora User Guide..
         * Valid for: Aurora DB clusters only
         */
        var enableIamDatabaseAuthentication: kotlin.Boolean? = null
        /**
         * A value that indicates whether to turn on Performance Insights for the DB cluster.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html">
         * Using Amazon Performance Insights in the Amazon RDS User Guide.
         * Valid for: Multi-AZ DB clusters only
         */
        var enablePerformanceInsights: kotlin.Boolean? = null
        /**
         * The name of the database engine to be used for this DB cluster.
         * Valid Values:
         *
         *
         *
         * aurora (for MySQL 5.6-compatible Aurora)
         *
         *
         * aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
         *
         *
         * aurora-postgresql
         *
         *
         *
         * mysql
         *
         *
         *
         * postgres
         *
         *
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var engine: kotlin.String? = null
        /**
         * The DB engine mode of the DB cluster, either provisioned, serverless,
         * parallelquery, global, or multimaster.
         * The parallelquery engine mode isn't required for Aurora MySQL version 1.23 and higher 1.x versions,
         * and version 2.09 and higher 2.x versions.
         * The global engine mode isn't required for Aurora MySQL version 1.22 and higher 1.x versions,
         * and global engine mode isn't required for any 2.x versions.
         * The multimaster engine mode only applies for DB clusters created with Aurora MySQL version 5.6.10a.
         * For Aurora PostgreSQL, the global engine mode isn't required, and both the parallelquery
         * and the multimaster engine modes currently aren't supported.
         * Limitations and requirements apply to some DB engine modes. For more information, see the
         * following sections in the Amazon Aurora User Guide:
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html#aurora-serverless.limitations">
         * Limitations of Aurora Serverless v1
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-mysql-parallel-query.html#aurora-mysql-parallel-query-limitations">
         * Limitations of Parallel Query
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database.limitations">
         * Limitations of Aurora Global Databases
         *
         *
         *
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-multi-master.html#aurora-multi-master-limitations">
         * Limitations of Multi-Master Clusters
         *
         *
         *
         * Valid for: Aurora DB clusters only
         */
        var engineMode: kotlin.String? = null
        /**
         * The version number of the database engine to use.
         * To list all of the available engine versions for MySQL 5.6-compatible Aurora, use the following command:
         *
         * aws rds describe-db-engine-versions --engine aurora --query "DBEngineVersions&#91;&#93;.EngineVersion"
         *
         * To list all of the available engine versions for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora, use the following command:
         *
         * aws rds describe-db-engine-versions --engine aurora-mysql --query "DBEngineVersions&#91;&#93;.EngineVersion"
         *
         * To list all of the available engine versions for Aurora PostgreSQL, use the following command:
         *
         * aws rds describe-db-engine-versions --engine aurora-postgresql --query "DBEngineVersions&#91;&#93;.EngineVersion"
         *
         * To list all of the available engine versions for RDS for MySQL, use the following command:
         *
         * aws rds describe-db-engine-versions --engine mysql --query "DBEngineVersions&#91;&#93;.EngineVersion"
         *
         * To list all of the available engine versions for RDS for PostgreSQL, use the following command:
         *
         * aws rds describe-db-engine-versions --engine postgres --query "DBEngineVersions&#91;&#93;.EngineVersion"
         *
         *
         * Aurora MySQL
         *
         * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Updates.html">MySQL on Amazon RDS Versions in the
         * Amazon Aurora User Guide.
         *
         * Aurora PostgreSQL
         *
         * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraPostgreSQL.Updates.20180305.html">Amazon Aurora PostgreSQL releases and engine versions in the
         * Amazon Aurora User Guide.
         *
         * MySQL
         *
         * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt">MySQL on Amazon RDS Versions in the
         * Amazon RDS User Guide.
         *
         * PostgreSQL
         *
         * For information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts">Amazon RDS for PostgreSQL versions and extensions in the
         * Amazon RDS User Guide.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var engineVersion: kotlin.String? = null
        /**
         * The global cluster ID of an Aurora cluster that becomes the primary cluster
         * in the new global database cluster.
         * Valid for: Aurora DB clusters only
         */
        var globalClusterIdentifier: kotlin.String? = null
        /**
         * The amount of Provisioned IOPS (input/output operations per second) to be initially allocated
         * for each DB instance in the Multi-AZ DB cluster.
         * For information about valid Iops values, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS">Amazon RDS Provisioned IOPS storage to improve performance in the Amazon RDS User Guide.
         * This setting is required to create a Multi-AZ DB cluster.
         * Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB cluster.
         * Valid for: Multi-AZ DB clusters only
         */
        var iops: kotlin.Int? = null
        /**
         * The Amazon Web Services KMS key identifier for an encrypted DB cluster.
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * To use a KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN.
         * When a KMS key isn't specified in KmsKeyId:
         *
         *
         * If ReplicationSourceIdentifier identifies an encrypted
         * source, then Amazon RDS will use the KMS key used to encrypt the
         * source. Otherwise, Amazon RDS will use your default KMS key.
         *
         * If the StorageEncrypted parameter is enabled and
         * ReplicationSourceIdentifier isn't specified, then Amazon RDS
         * will use your default KMS key.
         *
         *
         * There is a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default KMS key for each Amazon Web Services Region.
         * If you create a read replica of an encrypted DB cluster in another Amazon Web Services Region, you
         * must set KmsKeyId to a KMS key identifier that is valid in the destination Amazon Web Services
         * Region. This KMS key is used to encrypt the read replica in that Amazon Web Services Region.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The password for the master database user. This password can contain any printable ASCII character except "/", """, or "@".
         * Constraints: Must contain from 8 to 41 characters.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var masterUserPassword: kotlin.String? = null
        /**
         * The name of the master user for the DB cluster.
         * Constraints:
         *
         *
         * Must be 1 to 16 letters or numbers.
         *
         * First character must be a letter.
         *
         * Can't be a reserved word for the chosen database engine.
         *
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var masterUsername: kotlin.String? = null
        /**
         * The interval, in seconds, between points when Enhanced Monitoring metrics are collected for the DB cluster. To turn off
         * collecting Enhanced Monitoring metrics, specify 0. The default is 0.
         * If MonitoringRoleArn is specified, also set MonitoringInterval
         * to a value other than 0.
         * Valid Values: 0, 1, 5, 10, 15, 30, 60
         *
         * Valid for: Multi-AZ DB clusters only
         */
        var monitoringInterval: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the IAM role that permits RDS to send Enhanced Monitoring metrics to Amazon CloudWatch Logs.
         * An example is arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role,
         * see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling">Setting
         * up and enabling Enhanced Monitoring in the Amazon RDS User Guide.
         * If MonitoringInterval is set to a value other than 0, supply a MonitoringRoleArn value.
         * Valid for: Multi-AZ DB clusters only
         */
        var monitoringRoleArn: kotlin.String? = null
        /**
         * A value that indicates that the DB cluster should be associated with the specified option group.
         * DB clusters are associated with a default option group that can't be modified.
         */
        var optionGroupName: kotlin.String? = null
        /**
         * The Amazon Web Services KMS key identifier for encryption of Performance Insights data.
         * The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
         * If you don't specify a value for PerformanceInsightsKMSKeyId, then Amazon RDS
         * uses your default KMS key. There is a default KMS key for your Amazon Web Services account.
         * Your Amazon Web Services account has a different default KMS key for each Amazon Web Services Region.
         * Valid for: Multi-AZ DB clusters only
         */
        var performanceInsightsKmsKeyId: kotlin.String? = null
        /**
         * The amount of time, in days, to retain Performance Insights data. Valid values are 7 or 731 (2 years).
         * Valid for: Multi-AZ DB clusters only
         */
        var performanceInsightsRetentionPeriod: kotlin.Int? = null
        /**
         * The port number on which the instances in the DB cluster accept connections.
         *
         * RDS for MySQL and Aurora MySQL
         *
         * Default: 3306
         *
         * Valid values: 1150-65535
         *
         *
         * RDS for PostgreSQL and Aurora PostgreSQL
         *
         * Default: 5432
         *
         * Valid values: 1150-65535
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var port: kotlin.Int? = null
        /**
         * A URL that contains a Signature Version 4 signed request for
         * the CreateDBCluster action to be called in the source Amazon Web Services Region where the DB cluster is replicated from.
         * Specify PreSignedUrl only when you are performing cross-Region replication from an encrypted DB cluster.
         * The pre-signed URL must be a valid request for the CreateDBCluster API action
         * that can be executed in the source Amazon Web Services Region that contains the encrypted DB cluster to be copied.
         * The pre-signed URL request must contain the following parameter values:
         *
         *
         *
         * KmsKeyId - The Amazon Web Services KMS key identifier for the KMS key to use to encrypt the copy of
         * the DB cluster in the destination Amazon Web Services Region. This should refer to the same KMS key for both the CreateDBCluster
         * action that is called in the destination Amazon Web Services Region, and the action contained in the pre-signed URL.
         *
         *
         * DestinationRegion - The name of the Amazon Web Services Region that Aurora read replica will
         * be created in.
         *
         *
         * ReplicationSourceIdentifier - The DB cluster identifier for the encrypted DB cluster to be copied.
         * This identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you are copying an
         * encrypted DB cluster from the us-west-2 Amazon Web Services Region, then your ReplicationSourceIdentifier would look like
         * Example: arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1.
         *
         *
         * To learn how to generate a Signature Version 4 signed request, see
         * <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">
         * Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4) and
         * <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">
         * Signature Version 4 Signing Process.
         *
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify SourceRegion (or --source-region for the CLI)
         * instead of specifying PreSignedUrl manually. Specifying SourceRegion autogenerates a pre-signed URL that is a valid
         * request for the operation that can be executed in the source Amazon Web Services Region.
         *
         * Valid for: Aurora DB clusters only
         */
        var preSignedUrl: kotlin.String? = null
        /**
         * The daily time range during which automated backups are created
         * if automated backups are enabled
         * using the BackupRetentionPeriod parameter.
         * The default is a 30-minute window selected at random from an
         * 8-hour block of time for each Amazon Web Services Region.
         * To view the time blocks available, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.Backups.BackupWindow">
         * Backup window in the Amazon Aurora User Guide.
         * Constraints:
         *
         *
         * Must be in the format hh24:mi-hh24:mi.
         *
         * Must be in Universal Coordinated Time (UTC).
         *
         * Must not conflict with the preferred maintenance window.
         *
         * Must be at least 30 minutes.
         *
         *
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var preferredBackupWindow: kotlin.String? = null
        /**
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * Format: ddd:hh24:mi-ddd:hh24:mi
         *
         * The default is a 30-minute window selected at random from an
         * 8-hour block of time for each Amazon Web Services Region, occurring on a random day of the
         * week. To see the time blocks available, see
         * <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora">
         * Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
         * Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
         * Constraints: Minimum 30-minute window.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var preferredMaintenanceWindow: kotlin.String? = null
        /**
         * A value that indicates whether the DB cluster is publicly accessible.
         * When the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint
         * resolves to the private IP address from within the DB cluster's virtual private cloud
         * (VPC). It resolves to the public IP address from outside of the DB cluster's VPC. Access
         * to the DB cluster is ultimately controlled by the security group it uses. That public
         * access isn't permitted if the security group assigned to the DB cluster doesn't permit
         * it.
         * When the DB cluster isn't publicly accessible, it is an internal DB cluster with a DNS name that resolves to a private IP address.
         * Default: The default behavior varies depending on whether DBSubnetGroupName is specified.
         * If DBSubnetGroupName isn't specified, and PubliclyAccessible isn't specified, the following applies:
         *
         *
         * If the default VPC in the target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
         *
         * If the default VPC in the target Region has an internet gateway attached to it, the DB cluster is public.
         *
         *
         * If DBSubnetGroupName is specified, and PubliclyAccessible isn't specified, the following applies:
         *
         *
         * If the subnets are part of a VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.
         *
         * If the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster is public.
         *
         *
         * Valid for: Multi-AZ DB clusters only
         */
        var publiclyAccessible: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the source DB instance or DB cluster if this DB
         * cluster is created as a read replica.
         * Valid for: Aurora DB clusters only
         */
        var replicationSourceIdentifier: kotlin.String? = null
        /**
         * For DB clusters in serverless DB engine mode, the scaling properties of the DB cluster.
         * Valid for: Aurora DB clusters only
         */
        var scalingConfiguration: aws.sdk.kotlin.services.rds.model.ScalingConfiguration? = null
        /**
         * Contains the scaling configuration of an Aurora Serverless v2 DB cluster.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v2.html">Using Amazon Aurora Serverless v2 in the
         * Amazon Aurora User Guide.
         */
        var serverlessV2ScalingConfiguration: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration? = null
        /**
         * A value that indicates whether the DB cluster is encrypted.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var storageEncrypted: kotlin.Boolean? = null
        /**
         * Specifies the storage type to be associated with the DB cluster.
         * This setting is required to create a Multi-AZ DB cluster.
         * Valid values: io1
         *
         * When specified, a value for the Iops parameter is required.
         * Default: io1
         *
         * Valid for: Multi-AZ DB clusters only
         */
        var storageType: kotlin.String? = null
        /**
         * Tags to assign to the DB cluster.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var tags: List<Tag>? = null
        /**
         * A list of EC2 VPC security groups to associate with this DB cluster.
         * Valid for: Aurora DB clusters and Multi-AZ DB clusters
         */
        var vpcSecurityGroupIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbClusterRequest) : this() {
            this.allocatedStorage = x.allocatedStorage
            this.autoMinorVersionUpgrade = x.autoMinorVersionUpgrade
            this.availabilityZones = x.availabilityZones
            this.backtrackWindow = x.backtrackWindow
            this.backupRetentionPeriod = x.backupRetentionPeriod
            this.characterSetName = x.characterSetName
            this.copyTagsToSnapshot = x.copyTagsToSnapshot
            this.databaseName = x.databaseName
            this.dbClusterIdentifier = x.dbClusterIdentifier
            this.dbClusterInstanceClass = x.dbClusterInstanceClass
            this.dbClusterParameterGroupName = x.dbClusterParameterGroupName
            this.dbSubnetGroupName = x.dbSubnetGroupName
            this.deletionProtection = x.deletionProtection
            this.domain = x.domain
            this.domainIamRoleName = x.domainIamRoleName
            this.enableCloudwatchLogsExports = x.enableCloudwatchLogsExports
            this.enableGlobalWriteForwarding = x.enableGlobalWriteForwarding
            this.enableHttpEndpoint = x.enableHttpEndpoint
            this.enableIamDatabaseAuthentication = x.enableIamDatabaseAuthentication
            this.enablePerformanceInsights = x.enablePerformanceInsights
            this.engine = x.engine
            this.engineMode = x.engineMode
            this.engineVersion = x.engineVersion
            this.globalClusterIdentifier = x.globalClusterIdentifier
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.masterUserPassword = x.masterUserPassword
            this.masterUsername = x.masterUsername
            this.monitoringInterval = x.monitoringInterval
            this.monitoringRoleArn = x.monitoringRoleArn
            this.optionGroupName = x.optionGroupName
            this.performanceInsightsKmsKeyId = x.performanceInsightsKmsKeyId
            this.performanceInsightsRetentionPeriod = x.performanceInsightsRetentionPeriod
            this.port = x.port
            this.preSignedUrl = x.preSignedUrl
            this.preferredBackupWindow = x.preferredBackupWindow
            this.preferredMaintenanceWindow = x.preferredMaintenanceWindow
            this.publiclyAccessible = x.publiclyAccessible
            this.replicationSourceIdentifier = x.replicationSourceIdentifier
            this.scalingConfiguration = x.scalingConfiguration
            this.serverlessV2ScalingConfiguration = x.serverlessV2ScalingConfiguration
            this.storageEncrypted = x.storageEncrypted
            this.storageType = x.storageType
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbClusterRequest = CreateDbClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ScalingConfiguration] inside the given [block]
         */
        fun scalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.scalingConfiguration = aws.sdk.kotlin.services.rds.model.ScalingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration] inside the given [block]
         */
        fun serverlessV2ScalingConfiguration(block: aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.Builder.() -> kotlin.Unit) {
            this.serverlessV2ScalingConfiguration = aws.sdk.kotlin.services.rds.model.ServerlessV2ScalingConfiguration.invoke(block)
        }
    }
}
