// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
class CreateDbParameterGroupRequest private constructor(builder: Builder) {
    /**
     * The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.
     * To list all of the available parameter group families for a DB engine, use the following command:
     *
     * aws rds describe-db-engine-versions --query "DBEngineVersions&#91;&#93;.DBParameterGroupFamily" --engine <engine>
     *
     * For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:
     *
     * aws rds describe-db-engine-versions --query "DBEngineVersions&#91;&#93;.DBParameterGroupFamily" --engine mysql
     *
     *
     * The output contains duplicates.
     *
     * The following are the valid DB engine values:
     *
     *
     *
     * aurora (for MySQL 5.6-compatible Aurora)
     *
     *
     * aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
     *
     *
     * aurora-postgresql
     *
     *
     *
     * mariadb
     *
     *
     *
     * mysql
     *
     *
     *
     * oracle-ee
     *
     *
     *
     * oracle-ee-cdb
     *
     *
     *
     * oracle-se2
     *
     *
     *
     * oracle-se2-cdb
     *
     *
     *
     * postgres
     *
     *
     *
     * sqlserver-ee
     *
     *
     *
     * sqlserver-se
     *
     *
     *
     * sqlserver-ex
     *
     *
     *
     * sqlserver-web
     */
    val dbParameterGroupFamily: kotlin.String? = builder.dbParameterGroupFamily
    /**
     * The name of the DB parameter group.
     * Constraints:
     *
     *
     * Must be 1 to 255 letters, numbers, or hyphens.
     *
     * First character must be a letter
     *
     * Can't end with a hyphen or contain two consecutive hyphens
     *
     *
     *
     * This value is stored as a lowercase string.
     */
    val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * The description for the DB parameter group.
     */
    val description: kotlin.String? = builder.description
    /**
     * Tags to assign to the DB parameter group.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbParameterGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbParameterGroupRequest(")
        append("dbParameterGroupFamily=$dbParameterGroupFamily,")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("description=$description,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbParameterGroupFamily?.hashCode() ?: 0
        result = 31 * result + (dbParameterGroupName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbParameterGroupRequest

        if (dbParameterGroupFamily != other.dbParameterGroupFamily) return false
        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (description != other.description) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbParameterGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The DB parameter group family name. A DB parameter group can be associated with one and only one DB parameter group family, and can be applied only to a DB instance running a database engine and engine version compatible with that DB parameter group family.
         * To list all of the available parameter group families for a DB engine, use the following command:
         *
         * aws rds describe-db-engine-versions --query "DBEngineVersions&#91;&#93;.DBParameterGroupFamily" --engine <engine>
         *
         * For example, to list all of the available parameter group families for the MySQL DB engine, use the following command:
         *
         * aws rds describe-db-engine-versions --query "DBEngineVersions&#91;&#93;.DBParameterGroupFamily" --engine mysql
         *
         *
         * The output contains duplicates.
         *
         * The following are the valid DB engine values:
         *
         *
         *
         * aurora (for MySQL 5.6-compatible Aurora)
         *
         *
         * aurora-mysql (for MySQL 5.7-compatible and MySQL 8.0-compatible Aurora)
         *
         *
         * aurora-postgresql
         *
         *
         *
         * mariadb
         *
         *
         *
         * mysql
         *
         *
         *
         * oracle-ee
         *
         *
         *
         * oracle-ee-cdb
         *
         *
         *
         * oracle-se2
         *
         *
         *
         * oracle-se2-cdb
         *
         *
         *
         * postgres
         *
         *
         *
         * sqlserver-ee
         *
         *
         *
         * sqlserver-se
         *
         *
         *
         * sqlserver-ex
         *
         *
         *
         * sqlserver-web
         */
        var dbParameterGroupFamily: kotlin.String? = null
        /**
         * The name of the DB parameter group.
         * Constraints:
         *
         *
         * Must be 1 to 255 letters, numbers, or hyphens.
         *
         * First character must be a letter
         *
         * Can't end with a hyphen or contain two consecutive hyphens
         *
         *
         *
         * This value is stored as a lowercase string.
         */
        var dbParameterGroupName: kotlin.String? = null
        /**
         * The description for the DB parameter group.
         */
        var description: kotlin.String? = null
        /**
         * Tags to assign to the DB parameter group.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbParameterGroupRequest) : this() {
            this.dbParameterGroupFamily = x.dbParameterGroupFamily
            this.dbParameterGroupName = x.dbParameterGroupName
            this.description = x.description
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbParameterGroupRequest = CreateDbParameterGroupRequest(this)
    }
}
