// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



class CreateDbProxyRequest private constructor(builder: Builder) {
    /**
     * The authorization mechanism that the proxy uses.
     */
    val auth: List<UserAuthConfig>? = builder.auth
    /**
     * The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    val dbProxyName: kotlin.String? = builder.dbProxyName
    /**
     * Whether the proxy includes detailed information about SQL statements in its logs.
     * This information helps you to debug issues involving SQL behavior or the performance
     * and scalability of the proxy connections. The debug information includes the text of
     * SQL statements that you submit through the proxy. Thus, only enable this setting
     * when needed for debugging, and only when you have security measures in place to
     * safeguard any sensitive information that appears in the logs.
     */
    val debugLogging: kotlin.Boolean = builder.debugLogging
    /**
     * The kinds of databases that the proxy can connect to.
     * This value determines which database network protocol the proxy recognizes when it interprets
     * network traffic to and from the database.
     * The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.
     */
    val engineFamily: aws.sdk.kotlin.services.rds.model.EngineFamily? = builder.engineFamily
    /**
     * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this
     * value higher or lower than the connection timeout limit for the associated database.
     */
    val idleClientTimeout: kotlin.Int? = builder.idleClientTimeout
    /**
     * A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
     * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    val requireTls: kotlin.Boolean = builder.requireTls
    /**
     * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * One or more VPC security group IDs to associate with the new proxy.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds
    /**
     * One or more VPC subnet IDs to associate with the new proxy.
     */
    val vpcSubnetIds: List<String>? = builder.vpcSubnetIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.CreateDbProxyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDbProxyRequest(")
        append("auth=$auth,")
        append("dbProxyName=$dbProxyName,")
        append("debugLogging=$debugLogging,")
        append("engineFamily=$engineFamily,")
        append("idleClientTimeout=$idleClientTimeout,")
        append("requireTls=$requireTls,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds,")
        append("vpcSubnetIds=$vpcSubnetIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = auth?.hashCode() ?: 0
        result = 31 * result + (dbProxyName?.hashCode() ?: 0)
        result = 31 * result + (debugLogging.hashCode())
        result = 31 * result + (engineFamily?.hashCode() ?: 0)
        result = 31 * result + (idleClientTimeout ?: 0)
        result = 31 * result + (requireTls.hashCode())
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (vpcSubnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDbProxyRequest

        if (auth != other.auth) return false
        if (dbProxyName != other.dbProxyName) return false
        if (debugLogging != other.debugLogging) return false
        if (engineFamily != other.engineFamily) return false
        if (idleClientTimeout != other.idleClientTimeout) return false
        if (requireTls != other.requireTls) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false
        if (vpcSubnetIds != other.vpcSubnetIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.CreateDbProxyRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The authorization mechanism that the proxy uses.
         */
        var auth: List<UserAuthConfig>? = null
        /**
         * The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
         */
        var dbProxyName: kotlin.String? = null
        /**
         * Whether the proxy includes detailed information about SQL statements in its logs.
         * This information helps you to debug issues involving SQL behavior or the performance
         * and scalability of the proxy connections. The debug information includes the text of
         * SQL statements that you submit through the proxy. Thus, only enable this setting
         * when needed for debugging, and only when you have security measures in place to
         * safeguard any sensitive information that appears in the logs.
         */
        var debugLogging: kotlin.Boolean = false
        /**
         * The kinds of databases that the proxy can connect to.
         * This value determines which database network protocol the proxy recognizes when it interprets
         * network traffic to and from the database.
         * The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.
         */
        var engineFamily: aws.sdk.kotlin.services.rds.model.EngineFamily? = null
        /**
         * The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this
         * value higher or lower than the connection timeout limit for the associated database.
         */
        var idleClientTimeout: kotlin.Int? = null
        /**
         * A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
         * By enabling this setting, you can enforce encrypted TLS connections to the proxy.
         */
        var requireTls: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in Amazon Web Services Secrets Manager.
         */
        var roleArn: kotlin.String? = null
        /**
         * An optional set of key-value pairs to associate arbitrary data of your choosing with the proxy.
         */
        var tags: List<Tag>? = null
        /**
         * One or more VPC security group IDs to associate with the new proxy.
         */
        var vpcSecurityGroupIds: List<String>? = null
        /**
         * One or more VPC subnet IDs to associate with the new proxy.
         */
        var vpcSubnetIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.CreateDbProxyRequest) : this() {
            this.auth = x.auth
            this.dbProxyName = x.dbProxyName
            this.debugLogging = x.debugLogging
            this.engineFamily = x.engineFamily
            this.idleClientTimeout = x.idleClientTimeout
            this.requireTls = x.requireTls
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
            this.vpcSubnetIds = x.vpcSubnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.CreateDbProxyRequest = CreateDbProxyRequest(this)
    }
}
