// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The data structure representing a proxy managed by the RDS Proxy.
 * This data type is used as a response element in the DescribeDBProxies action.
 */
class DbProxy private constructor(builder: Builder) {
    /**
     * One or more data structures specifying the authorization mechanism to connect to the associated RDS DB instance
     * or Aurora DB cluster.
     */
    val auth: List<UserAuthConfigInfo>? = builder.auth
    /**
     * The date and time when the proxy was first created.
     */
    val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The Amazon Resource Name (ARN) for the proxy.
     */
    val dbProxyArn: kotlin.String? = builder.dbProxyArn
    /**
     * The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.
     */
    val dbProxyName: kotlin.String? = builder.dbProxyName
    /**
     * Whether the proxy includes detailed information about SQL statements in its logs.
     * This information helps you to debug issues involving SQL behavior or the performance
     * and scalability of the proxy connections. The debug information includes the text of
     * SQL statements that you submit through the proxy. Thus, only enable this setting
     * when needed for debugging, and only when you have security measures in place to
     * safeguard any sensitive information that appears in the logs.
     */
    val debugLogging: kotlin.Boolean = builder.debugLogging
    /**
     * The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the
     * connection string for a database client application.
     */
    val endpoint: kotlin.String? = builder.endpoint
    /**
     * The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.
     */
    val engineFamily: kotlin.String? = builder.engineFamily
    /**
     * The number of seconds a connection to the proxy can have no activity before the proxy drops the client connection.
     * The proxy keeps the underlying database connection open and puts it back into the connection pool for reuse by
     * later connection requests.
     * Default: 1800 (30 minutes)
     * Constraints: 1 to 28,800
     */
    val idleClientTimeout: kotlin.Int = builder.idleClientTimeout
    /**
     * Indicates whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
     */
    val requireTls: kotlin.Boolean = builder.requireTls
    /**
     * The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access Amazon Secrets Manager.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The current status of this proxy. A status of available means the
     * proxy is ready to handle requests. Other values indicate that you must wait for
     * the proxy to be ready, or take some action to resolve an issue.
     */
    val status: aws.sdk.kotlin.services.rds.model.DbProxyStatus? = builder.status
    /**
     * The date and time when the proxy was last updated.
     */
    val updatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedDate
    /**
     * Provides the VPC ID of the DB proxy.
     */
    val vpcId: kotlin.String? = builder.vpcId
    /**
     * Provides a list of VPC security groups that the proxy belongs to.
     */
    val vpcSecurityGroupIds: List<String>? = builder.vpcSecurityGroupIds
    /**
     * The EC2 subnet IDs for the proxy.
     */
    val vpcSubnetIds: List<String>? = builder.vpcSubnetIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbProxy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbProxy(")
        append("auth=$auth,")
        append("createdDate=$createdDate,")
        append("dbProxyArn=$dbProxyArn,")
        append("dbProxyName=$dbProxyName,")
        append("debugLogging=$debugLogging,")
        append("endpoint=$endpoint,")
        append("engineFamily=$engineFamily,")
        append("idleClientTimeout=$idleClientTimeout,")
        append("requireTls=$requireTls,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("updatedDate=$updatedDate,")
        append("vpcId=$vpcId,")
        append("vpcSecurityGroupIds=$vpcSecurityGroupIds,")
        append("vpcSubnetIds=$vpcSubnetIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = auth?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (dbProxyArn?.hashCode() ?: 0)
        result = 31 * result + (dbProxyName?.hashCode() ?: 0)
        result = 31 * result + (debugLogging.hashCode())
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (engineFamily?.hashCode() ?: 0)
        result = 31 * result + (idleClientTimeout)
        result = 31 * result + (requireTls.hashCode())
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (updatedDate?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (vpcSubnetIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbProxy

        if (auth != other.auth) return false
        if (createdDate != other.createdDate) return false
        if (dbProxyArn != other.dbProxyArn) return false
        if (dbProxyName != other.dbProxyName) return false
        if (debugLogging != other.debugLogging) return false
        if (endpoint != other.endpoint) return false
        if (engineFamily != other.engineFamily) return false
        if (idleClientTimeout != other.idleClientTimeout) return false
        if (requireTls != other.requireTls) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (updatedDate != other.updatedDate) return false
        if (vpcId != other.vpcId) return false
        if (vpcSecurityGroupIds != other.vpcSecurityGroupIds) return false
        if (vpcSubnetIds != other.vpcSubnetIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbProxy = Builder(this).apply(block).build()

    class Builder {
        /**
         * One or more data structures specifying the authorization mechanism to connect to the associated RDS DB instance
         * or Aurora DB cluster.
         */
        var auth: List<UserAuthConfigInfo>? = null
        /**
         * The date and time when the proxy was first created.
         */
        var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the proxy.
         */
        var dbProxyArn: kotlin.String? = null
        /**
         * The identifier for the proxy. This name must be unique for all proxies owned by your Amazon Web Services account in the specified Amazon Web Services Region.
         */
        var dbProxyName: kotlin.String? = null
        /**
         * Whether the proxy includes detailed information about SQL statements in its logs.
         * This information helps you to debug issues involving SQL behavior or the performance
         * and scalability of the proxy connections. The debug information includes the text of
         * SQL statements that you submit through the proxy. Thus, only enable this setting
         * when needed for debugging, and only when you have security measures in place to
         * safeguard any sensitive information that appears in the logs.
         */
        var debugLogging: kotlin.Boolean = false
        /**
         * The endpoint that you can use to connect to the DB proxy. You include the endpoint value in the
         * connection string for a database client application.
         */
        var endpoint: kotlin.String? = null
        /**
         * The engine family applies to MySQL and PostgreSQL for both RDS and Aurora.
         */
        var engineFamily: kotlin.String? = null
        /**
         * The number of seconds a connection to the proxy can have no activity before the proxy drops the client connection.
         * The proxy keeps the underlying database connection open and puts it back into the connection pool for reuse by
         * later connection requests.
         * Default: 1800 (30 minutes)
         * Constraints: 1 to 28,800
         */
        var idleClientTimeout: kotlin.Int = 0
        /**
         * Indicates whether Transport Layer Security (TLS) encryption is required for connections to the proxy.
         */
        var requireTls: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access Amazon Secrets Manager.
         */
        var roleArn: kotlin.String? = null
        /**
         * The current status of this proxy. A status of available means the
         * proxy is ready to handle requests. Other values indicate that you must wait for
         * the proxy to be ready, or take some action to resolve an issue.
         */
        var status: aws.sdk.kotlin.services.rds.model.DbProxyStatus? = null
        /**
         * The date and time when the proxy was last updated.
         */
        var updatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Provides the VPC ID of the DB proxy.
         */
        var vpcId: kotlin.String? = null
        /**
         * Provides a list of VPC security groups that the proxy belongs to.
         */
        var vpcSecurityGroupIds: List<String>? = null
        /**
         * The EC2 subnet IDs for the proxy.
         */
        var vpcSubnetIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbProxy) : this() {
            this.auth = x.auth
            this.createdDate = x.createdDate
            this.dbProxyArn = x.dbProxyArn
            this.dbProxyName = x.dbProxyName
            this.debugLogging = x.debugLogging
            this.endpoint = x.endpoint
            this.engineFamily = x.engineFamily
            this.idleClientTimeout = x.idleClientTimeout
            this.requireTls = x.requireTls
            this.roleArn = x.roleArn
            this.status = x.status
            this.updatedDate = x.updatedDate
            this.vpcId = x.vpcId
            this.vpcSecurityGroupIds = x.vpcSecurityGroupIds
            this.vpcSubnetIds = x.vpcSubnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbProxy = DbProxy(this)
    }
}
