// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the details for an RDS Proxy target. It represents an RDS DB instance or Aurora DB cluster
 * that the proxy can connect to. One or more targets are associated with an RDS Proxy target group.
 * This data type is used as a response element in the DescribeDBProxyTargets action.
 */
class DbProxyTarget private constructor(builder: Builder) {
    /**
     * The writer endpoint for the RDS DB instance or Aurora DB cluster.
     */
    val endpoint: kotlin.String? = builder.endpoint
    /**
     * The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.
     */
    val port: kotlin.Int = builder.port
    /**
     * The identifier representing the target. It can be the instance identifier for an RDS DB instance,
     * or the cluster identifier for an Aurora DB cluster.
     */
    val rdsResourceId: kotlin.String? = builder.rdsResourceId
    /**
     * A value that indicates whether the target of the proxy can be used for read/write or read-only operations.
     */
    val role: aws.sdk.kotlin.services.rds.model.TargetRole? = builder.role
    /**
     * The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.
     */
    val targetArn: kotlin.String? = builder.targetArn
    /**
     * Information about the connection health of the RDS Proxy target.
     */
    val targetHealth: aws.sdk.kotlin.services.rds.model.TargetHealth? = builder.targetHealth
    /**
     * The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the target represents an RDS DB instance.
     */
    val trackedClusterId: kotlin.String? = builder.trackedClusterId
    /**
     * Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.
     */
    val type: aws.sdk.kotlin.services.rds.model.TargetType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbProxyTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbProxyTarget(")
        append("endpoint=$endpoint,")
        append("port=$port,")
        append("rdsResourceId=$rdsResourceId,")
        append("role=$role,")
        append("targetArn=$targetArn,")
        append("targetHealth=$targetHealth,")
        append("trackedClusterId=$trackedClusterId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpoint?.hashCode() ?: 0
        result = 31 * result + (port)
        result = 31 * result + (rdsResourceId?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        result = 31 * result + (targetHealth?.hashCode() ?: 0)
        result = 31 * result + (trackedClusterId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbProxyTarget

        if (endpoint != other.endpoint) return false
        if (port != other.port) return false
        if (rdsResourceId != other.rdsResourceId) return false
        if (role != other.role) return false
        if (targetArn != other.targetArn) return false
        if (targetHealth != other.targetHealth) return false
        if (trackedClusterId != other.trackedClusterId) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbProxyTarget = Builder(this).apply(block).build()

    class Builder {
        /**
         * The writer endpoint for the RDS DB instance or Aurora DB cluster.
         */
        var endpoint: kotlin.String? = null
        /**
         * The port that the RDS Proxy uses to connect to the target RDS DB instance or Aurora DB cluster.
         */
        var port: kotlin.Int = 0
        /**
         * The identifier representing the target. It can be the instance identifier for an RDS DB instance,
         * or the cluster identifier for an Aurora DB cluster.
         */
        var rdsResourceId: kotlin.String? = null
        /**
         * A value that indicates whether the target of the proxy can be used for read/write or read-only operations.
         */
        var role: aws.sdk.kotlin.services.rds.model.TargetRole? = null
        /**
         * The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.
         */
        var targetArn: kotlin.String? = null
        /**
         * Information about the connection health of the RDS Proxy target.
         */
        var targetHealth: aws.sdk.kotlin.services.rds.model.TargetHealth? = null
        /**
         * The DB cluster identifier when the target represents an Aurora DB cluster. This field is blank when the target represents an RDS DB instance.
         */
        var trackedClusterId: kotlin.String? = null
        /**
         * Specifies the kind of database, such as an RDS DB instance or an Aurora DB cluster, that the target represents.
         */
        var type: aws.sdk.kotlin.services.rds.model.TargetType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbProxyTarget) : this() {
            this.endpoint = x.endpoint
            this.port = x.port
            this.rdsResourceId = x.rdsResourceId
            this.role = x.role
            this.targetArn = x.targetArn
            this.targetHealth = x.targetHealth
            this.trackedClusterId = x.trackedClusterId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbProxyTarget = DbProxyTarget(this)

        /**
         * construct an [aws.sdk.kotlin.services.rds.model.TargetHealth] inside the given [block]
         */
        fun targetHealth(block: aws.sdk.kotlin.services.rds.model.TargetHealth.Builder.() -> kotlin.Unit) {
            this.targetHealth = aws.sdk.kotlin.services.rds.model.TargetHealth.invoke(block)
        }
    }
}
