// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the name and values of a manual DB snapshot attribute
 * Manual DB snapshot attributes are used to authorize other Amazon Web Services accounts
 * to restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
 * API.
 */
class DbSnapshotAttribute private constructor(builder: Builder) {
    /**
     * The name of the manual DB snapshot attribute.
     * The attribute named restore refers to the list of Amazon Web Services accounts that
     * have permission to copy or restore the manual DB cluster snapshot. For more information,
     * see the ModifyDBSnapshotAttribute
     * API action.
     */
    val attributeName: kotlin.String? = builder.attributeName
    /**
     * The value or values for the manual DB snapshot attribute.
     * If the AttributeName field is set to restore, then this element
     * returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual
     * DB snapshot. If a value of all is in the list, then the manual DB snapshot
     * is public and available for any Amazon Web Services account to copy or restore.
     */
    val attributeValues: List<String>? = builder.attributeValues

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DbSnapshotAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DbSnapshotAttribute(")
        append("attributeName=$attributeName,")
        append("attributeValues=$attributeValues)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeName?.hashCode() ?: 0
        result = 31 * result + (attributeValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DbSnapshotAttribute

        if (attributeName != other.attributeName) return false
        if (attributeValues != other.attributeValues) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DbSnapshotAttribute = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the manual DB snapshot attribute.
         * The attribute named restore refers to the list of Amazon Web Services accounts that
         * have permission to copy or restore the manual DB cluster snapshot. For more information,
         * see the ModifyDBSnapshotAttribute
         * API action.
         */
        var attributeName: kotlin.String? = null
        /**
         * The value or values for the manual DB snapshot attribute.
         * If the AttributeName field is set to restore, then this element
         * returns a list of IDs of the Amazon Web Services accounts that are authorized to copy or restore the manual
         * DB snapshot. If a value of all is in the list, then the manual DB snapshot
         * is public and available for any Amazon Web Services account to copy or restore.
         */
        var attributeValues: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DbSnapshotAttribute) : this() {
            this.attributeName = x.attributeName
            this.attributeValues = x.attributeValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DbSnapshotAttribute = DbSnapshotAttribute(this)
    }
}
