// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
class DeleteDbInstanceRequest private constructor(builder: Builder) {
    /**
     * The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.
     * Constraints:
     *
     *
     * Must match the name of an existing DB instance.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * A value that indicates whether to remove automated backups immediately after the DB
     * instance is deleted. This parameter isn't case-sensitive. The default is to remove
     * automated backups immediately after the DB instance is deleted.
     */
    val deleteAutomatedBackups: kotlin.Boolean? = builder.deleteAutomatedBackups
    /**
     * The DBSnapshotIdentifier of the new DBSnapshot created when the SkipFinalSnapshot
     * parameter is disabled.
     *
     * If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.
     *
     * This setting doesn't apply to RDS Custom.
     * Constraints:
     *
     *
     * Must be 1 to 255 letters or numbers.
     *
     * First character must be a letter.
     *
     * Can't end with a hyphen or contain two consecutive hyphens.
     *
     * Can't be specified when deleting a read replica.
     */
    val finalDbSnapshotIdentifier: kotlin.String? = builder.finalDbSnapshotIdentifier
    /**
     * A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance.
     * If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter,
     * RDS creates a DB snapshot before the DB instance is deleted. By default, skip isn't enabled,
     * and the DB snapshot is created.
     *
     * If you don't enable this parameter, you must specify the FinalDBSnapshotIdentifier parameter.
     *
     * When a DB instance is in a failure state and has a status of failed, incompatible-restore,
     * or incompatible-network, RDS can delete the instance only if you enable this parameter.
     * If you delete a read replica or an RDS Custom instance, you must enable this setting.
     * This setting is required for RDS Custom.
     */
    val skipFinalSnapshot: kotlin.Boolean = builder.skipFinalSnapshot

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DeleteDbInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteDbInstanceRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("deleteAutomatedBackups=$deleteAutomatedBackups,")
        append("finalDbSnapshotIdentifier=$finalDbSnapshotIdentifier,")
        append("skipFinalSnapshot=$skipFinalSnapshot)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (deleteAutomatedBackups?.hashCode() ?: 0)
        result = 31 * result + (finalDbSnapshotIdentifier?.hashCode() ?: 0)
        result = 31 * result + (skipFinalSnapshot.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteDbInstanceRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (deleteAutomatedBackups != other.deleteAutomatedBackups) return false
        if (finalDbSnapshotIdentifier != other.finalDbSnapshotIdentifier) return false
        if (skipFinalSnapshot != other.skipFinalSnapshot) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DeleteDbInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The DB instance identifier for the DB instance to be deleted. This parameter isn't case-sensitive.
         * Constraints:
         *
         *
         * Must match the name of an existing DB instance.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * A value that indicates whether to remove automated backups immediately after the DB
         * instance is deleted. This parameter isn't case-sensitive. The default is to remove
         * automated backups immediately after the DB instance is deleted.
         */
        var deleteAutomatedBackups: kotlin.Boolean? = null
        /**
         * The DBSnapshotIdentifier of the new DBSnapshot created when the SkipFinalSnapshot
         * parameter is disabled.
         *
         * If you enable this parameter and also enable SkipFinalShapshot, the command results in an error.
         *
         * This setting doesn't apply to RDS Custom.
         * Constraints:
         *
         *
         * Must be 1 to 255 letters or numbers.
         *
         * First character must be a letter.
         *
         * Can't end with a hyphen or contain two consecutive hyphens.
         *
         * Can't be specified when deleting a read replica.
         */
        var finalDbSnapshotIdentifier: kotlin.String? = null
        /**
         * A value that indicates whether to skip the creation of a final DB snapshot before deleting the instance.
         * If you enable this parameter, RDS doesn't create a DB snapshot. If you don't enable this parameter,
         * RDS creates a DB snapshot before the DB instance is deleted. By default, skip isn't enabled,
         * and the DB snapshot is created.
         *
         * If you don't enable this parameter, you must specify the FinalDBSnapshotIdentifier parameter.
         *
         * When a DB instance is in a failure state and has a status of failed, incompatible-restore,
         * or incompatible-network, RDS can delete the instance only if you enable this parameter.
         * If you delete a read replica or an RDS Custom instance, you must enable this setting.
         * This setting is required for RDS Custom.
         */
        var skipFinalSnapshot: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DeleteDbInstanceRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.deleteAutomatedBackups = x.deleteAutomatedBackups
            this.finalDbSnapshotIdentifier = x.finalDbSnapshotIdentifier
            this.skipFinalSnapshot = x.skipFinalSnapshot
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DeleteDbInstanceRequest = DeleteDbInstanceRequest(this)
    }
}
