// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Parameter input for DescribeDBInstanceAutomatedBackups.
 */
class DescribeDbInstanceAutomatedBackupsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the replicated automated backups, for example,
     * arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE.
     * This setting doesn't apply to RDS Custom.
     */
    val dbInstanceAutomatedBackupsArn: kotlin.String? = builder.dbInstanceAutomatedBackupsArn
    /**
     * (Optional) The user-supplied instance identifier. If this parameter is specified, it must
     * match the identifier of an existing DB instance. It returns information from the
     * specific DB instance' automated backup. This parameter isn't case-sensitive.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The resource ID of the DB instance that is the source of
     * the automated backup. This parameter isn't case-sensitive.
     */
    val dbiResourceId: kotlin.String? = builder.dbiResourceId
    /**
     * A filter that specifies which resources to return based on status.
     * Supported filters are the following:
     *
     *
     *
     * status
     *
     *
     *
     *
     * active - automated backups for current instances
     *
     *
     *
     * retained - automated backups for deleted instances and after backup replication is stopped
     *
     *
     *
     * creating - automated backups that are waiting for the first automated snapshot to be available
     *
     *
     *
     *
     * db-instance-id - Accepts DB instance identifiers and Amazon Resource Names (ARNs).
     * The results list includes only information about the DB instance automated backups identified by these ARNs.
     *
     *
     * dbi-resource-id - Accepts DB resource identifiers and Amazon Resource Names (ARNs).
     * The results list includes only information about the DB instance resources identified by these ARNs.
     *
     *
     * Returns all resources by default. The status for each resource is specified in the response.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The pagination token provided in the previous request. If this parameter is specified the response
     * includes only records beyond the marker, up to MaxRecords.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the specified
     * MaxRecords value, a pagination token called a marker is included in the response so that
     * you can retrieve the remaining results.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbInstanceAutomatedBackupsRequest(")
        append("dbInstanceAutomatedBackupsArn=$dbInstanceAutomatedBackupsArn,")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("dbiResourceId=$dbiResourceId,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceAutomatedBackupsArn?.hashCode() ?: 0
        result = 31 * result + (dbInstanceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (dbiResourceId?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbInstanceAutomatedBackupsRequest

        if (dbInstanceAutomatedBackupsArn != other.dbInstanceAutomatedBackupsArn) return false
        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (dbiResourceId != other.dbiResourceId) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the replicated automated backups, for example,
         * arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE.
         * This setting doesn't apply to RDS Custom.
         */
        var dbInstanceAutomatedBackupsArn: kotlin.String? = null
        /**
         * (Optional) The user-supplied instance identifier. If this parameter is specified, it must
         * match the identifier of an existing DB instance. It returns information from the
         * specific DB instance' automated backup. This parameter isn't case-sensitive.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The resource ID of the DB instance that is the source of
         * the automated backup. This parameter isn't case-sensitive.
         */
        var dbiResourceId: kotlin.String? = null
        /**
         * A filter that specifies which resources to return based on status.
         * Supported filters are the following:
         *
         *
         *
         * status
         *
         *
         *
         *
         * active - automated backups for current instances
         *
         *
         *
         * retained - automated backups for deleted instances and after backup replication is stopped
         *
         *
         *
         * creating - automated backups that are waiting for the first automated snapshot to be available
         *
         *
         *
         *
         * db-instance-id - Accepts DB instance identifiers and Amazon Resource Names (ARNs).
         * The results list includes only information about the DB instance automated backups identified by these ARNs.
         *
         *
         * dbi-resource-id - Accepts DB resource identifiers and Amazon Resource Names (ARNs).
         * The results list includes only information about the DB instance resources identified by these ARNs.
         *
         *
         * Returns all resources by default. The status for each resource is specified in the response.
         */
        var filters: List<Filter>? = null
        /**
         * The pagination token provided in the previous request. If this parameter is specified the response
         * includes only records beyond the marker, up to MaxRecords.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified
         * MaxRecords value, a pagination token called a marker is included in the response so that
         * you can retrieve the remaining results.
         */
        var maxRecords: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest) : this() {
            this.dbInstanceAutomatedBackupsArn = x.dbInstanceAutomatedBackupsArn
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.dbiResourceId = x.dbiResourceId
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest = DescribeDbInstanceAutomatedBackupsRequest(this)
    }
}
