// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



class DescribeDbParametersRequest private constructor(builder: Builder) {
    /**
     * The name of a specific DB parameter group to return details for.
     * Constraints:
     *
     *
     * If supplied, must match the name of an existing DBParameterGroup.
     */
    val dbParameterGroupName: kotlin.String? = builder.dbParameterGroupName
    /**
     * This parameter isn't currently supported.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous
     * DescribeDBParameters request.
     * If this parameter is specified, the response includes
     * only records beyond the marker,
     * up to the value specified by MaxRecords.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response.
     * If more records exist than the specified MaxRecords value,
     * a pagination token called a marker is included in the response so that
     * you can retrieve the remaining results.
     * Default: 100
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The parameter types to return.
     * Default: All parameter types returned
     * Valid Values: user | system | engine-default
     */
    val source: kotlin.String? = builder.source

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeDbParametersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeDbParametersRequest(")
        append("dbParameterGroupName=$dbParameterGroupName,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("source=$source)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbParameterGroupName?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeDbParametersRequest

        if (dbParameterGroupName != other.dbParameterGroupName) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (source != other.source) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeDbParametersRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of a specific DB parameter group to return details for.
         * Constraints:
         *
         *
         * If supplied, must match the name of an existing DBParameterGroup.
         */
        var dbParameterGroupName: kotlin.String? = null
        /**
         * This parameter isn't currently supported.
         */
        var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous
         * DescribeDBParameters request.
         * If this parameter is specified, the response includes
         * only records beyond the marker,
         * up to the value specified by MaxRecords.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response.
         * If more records exist than the specified MaxRecords value,
         * a pagination token called a marker is included in the response so that
         * you can retrieve the remaining results.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * The parameter types to return.
         * Default: All parameter types returned
         * Valid Values: user | system | engine-default
         */
        var source: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeDbParametersRequest) : this() {
            this.dbParameterGroupName = x.dbParameterGroupName
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.source = x.source
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeDbParametersRequest = DescribeDbParametersRequest(this)
    }
}
