// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



class DescribeExportTasksRequest private constructor(builder: Builder) {
    /**
     * The identifier of the snapshot export task to be described.
     */
    val exportTaskIdentifier: kotlin.String? = builder.exportTaskIdentifier
    /**
     * Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that define what to
     * include in the output. Filter names and values are case-sensitive.
     * Supported filters include the following:
     *
     *
     *
     * export-task-identifier - An identifier for the snapshot export task.
     *
     *
     * s3-bucket - The Amazon S3 bucket the snapshot is exported to.
     *
     *
     * source-arn - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3
     *
     *
     * status - The status of the export task. Must be lowercase. Valid statuses are the following:
     *
     *
     *
     * canceled
     *
     *
     *
     *
     * canceling
     *
     *
     *
     *
     * complete
     *
     *
     *
     *
     * failed
     *
     *
     *
     *
     * in_progress
     *
     *
     *
     *
     * starting
     */
    val filters: List<Filter>? = builder.filters
    /**
     * An optional pagination token provided by a previous DescribeExportTasks request.
     * If you specify this parameter, the response includes only records beyond the marker,
     * up to the value specified by the MaxRecords parameter.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The maximum number of records to include in the response. If more records exist than the
     * specified value, a pagination token called a marker is included in the response.
     * You can use the marker in a later DescribeExportTasks request
     * to retrieve the remaining results.
     * Default: 100
     * Constraints: Minimum 20, maximum 100.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
     */
    val sourceArn: kotlin.String? = builder.sourceArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DescribeExportTasksRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeExportTasksRequest(")
        append("exportTaskIdentifier=$exportTaskIdentifier,")
        append("filters=$filters,")
        append("marker=$marker,")
        append("maxRecords=$maxRecords,")
        append("sourceArn=$sourceArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = exportTaskIdentifier?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeExportTasksRequest

        if (exportTaskIdentifier != other.exportTaskIdentifier) return false
        if (filters != other.filters) return false
        if (marker != other.marker) return false
        if (maxRecords != other.maxRecords) return false
        if (sourceArn != other.sourceArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DescribeExportTasksRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifier of the snapshot export task to be described.
         */
        var exportTaskIdentifier: kotlin.String? = null
        /**
         * Filters specify one or more snapshot exports to describe. The filters are specified as name-value pairs that define what to
         * include in the output. Filter names and values are case-sensitive.
         * Supported filters include the following:
         *
         *
         *
         * export-task-identifier - An identifier for the snapshot export task.
         *
         *
         * s3-bucket - The Amazon S3 bucket the snapshot is exported to.
         *
         *
         * source-arn - The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3
         *
         *
         * status - The status of the export task. Must be lowercase. Valid statuses are the following:
         *
         *
         *
         * canceled
         *
         *
         *
         *
         * canceling
         *
         *
         *
         *
         * complete
         *
         *
         *
         *
         * failed
         *
         *
         *
         *
         * in_progress
         *
         *
         *
         *
         * starting
         */
        var filters: List<Filter>? = null
        /**
         * An optional pagination token provided by a previous DescribeExportTasks request.
         * If you specify this parameter, the response includes only records beyond the marker,
         * up to the value specified by the MaxRecords parameter.
         */
        var marker: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the
         * specified value, a pagination token called a marker is included in the response.
         * You can use the marker in a later DescribeExportTasks request
         * to retrieve the remaining results.
         * Default: 100
         * Constraints: Minimum 20, maximum 100.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the snapshot exported to Amazon S3.
         */
        var sourceArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DescribeExportTasksRequest) : this() {
            this.exportTaskIdentifier = x.exportTaskIdentifier
            this.filters = x.filters
            this.marker = x.marker
            this.maxRecords = x.maxRecords
            this.sourceArn = x.sourceArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DescribeExportTasksRequest = DescribeExportTasksRequest(this)
    }
}
