// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 *
 */
class DownloadDbLogFilePortionRequest private constructor(builder: Builder) {
    /**
     * The customer-assigned name of the DB instance that contains the log files you want to list.
     * Constraints:
     *
     *
     * Must match the identifier of an existing DBInstance.
     */
    val dbInstanceIdentifier: kotlin.String? = builder.dbInstanceIdentifier
    /**
     * The name of the log file to be downloaded.
     */
    val logFileName: kotlin.String? = builder.logFileName
    /**
     * The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines.
     */
    val marker: kotlin.String? = builder.marker
    /**
     * The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file is truncated at 1 MB in size.
     * If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning
     * or the end of the log file, depending on the value of the Marker parameter.
     *
     *
     * If neither Marker or NumberOfLines are specified, the entire log file is returned up to a
     * maximum of 10000 lines, starting with the most recent log entries first.
     *
     * If
     * NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end
     * of the log file are returned.
     *
     * If Marker is specified as "0", then the specified
     * number of lines from the beginning of the log file are returned.
     *
     * You can
     * download the log file in blocks of lines by specifying the size of the block using
     * the NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your
     * first request. Include the Marker value returned in the response as the Marker value for the next
     * request, continuing until the AdditionalDataPending response element returns false.
     */
    val numberOfLines: kotlin.Int = builder.numberOfLines

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.DownloadDbLogFilePortionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DownloadDbLogFilePortionRequest(")
        append("dbInstanceIdentifier=$dbInstanceIdentifier,")
        append("logFileName=$logFileName,")
        append("marker=$marker,")
        append("numberOfLines=$numberOfLines)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dbInstanceIdentifier?.hashCode() ?: 0
        result = 31 * result + (logFileName?.hashCode() ?: 0)
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (numberOfLines)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DownloadDbLogFilePortionRequest

        if (dbInstanceIdentifier != other.dbInstanceIdentifier) return false
        if (logFileName != other.logFileName) return false
        if (marker != other.marker) return false
        if (numberOfLines != other.numberOfLines) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.DownloadDbLogFilePortionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The customer-assigned name of the DB instance that contains the log files you want to list.
         * Constraints:
         *
         *
         * Must match the identifier of an existing DBInstance.
         */
        var dbInstanceIdentifier: kotlin.String? = null
        /**
         * The name of the log file to be downloaded.
         */
        var logFileName: kotlin.String? = null
        /**
         * The pagination token provided in the previous request or "0". If the Marker parameter is specified the response includes only records beyond the marker until the end of the file or up to NumberOfLines.
         */
        var marker: kotlin.String? = null
        /**
         * The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file is truncated at 1 MB in size.
         * If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning
         * or the end of the log file, depending on the value of the Marker parameter.
         *
         *
         * If neither Marker or NumberOfLines are specified, the entire log file is returned up to a
         * maximum of 10000 lines, starting with the most recent log entries first.
         *
         * If
         * NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end
         * of the log file are returned.
         *
         * If Marker is specified as "0", then the specified
         * number of lines from the beginning of the log file are returned.
         *
         * You can
         * download the log file in blocks of lines by specifying the size of the block using
         * the NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your
         * first request. Include the Marker value returned in the response as the Marker value for the next
         * request, continuing until the AdditionalDataPending response element returns false.
         */
        var numberOfLines: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.DownloadDbLogFilePortionRequest) : this() {
            this.dbInstanceIdentifier = x.dbInstanceIdentifier
            this.logFileName = x.logFileName
            this.marker = x.marker
            this.numberOfLines = x.numberOfLines
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.DownloadDbLogFilePortionRequest = DownloadDbLogFilePortionRequest(this)
    }
}
