// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.rds.model



/**
 * Contains the state of scheduled or in-process failover operations on an
 * Aurora global database (GlobalCluster). This Data type is empty unless a failover
 * operation is scheduled or is currently underway on the Aurora global database.
 */
class FailoverState private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this
     * state.
     */
    val fromDbClusterArn: kotlin.String? = builder.fromDbClusterArn
    /**
     * The current status of the Aurora global database (GlobalCluster). Possible values are as follows:
     *
     *
     * pending  A request to fail over the Aurora global database (GlobalCluster) has been received by the service. The
     * GlobalCluster's primary DB cluster and the specified secondary DB cluster are being verified before the failover
     * process can start.
     *
     * failing-over  This status covers the range of Aurora internal operations that take place during the failover process, such
     * as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and synchronizing replicas.
     *
     * cancelling  The request to fail over the Aurora global database (GlobalCluster) was cancelled and the primary
     * Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states.
     */
    val status: aws.sdk.kotlin.services.rds.model.FailoverStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated
     * with this state.
     */
    val toDbClusterArn: kotlin.String? = builder.toDbClusterArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.rds.model.FailoverState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailoverState(")
        append("fromDbClusterArn=$fromDbClusterArn,")
        append("status=$status,")
        append("toDbClusterArn=$toDbClusterArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fromDbClusterArn?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (toDbClusterArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailoverState

        if (fromDbClusterArn != other.fromDbClusterArn) return false
        if (status != other.status) return false
        if (toDbClusterArn != other.toDbClusterArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.rds.model.FailoverState = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being demoted, and which is associated with this
         * state.
         */
        var fromDbClusterArn: kotlin.String? = null
        /**
         * The current status of the Aurora global database (GlobalCluster). Possible values are as follows:
         *
         *
         * pending  A request to fail over the Aurora global database (GlobalCluster) has been received by the service. The
         * GlobalCluster's primary DB cluster and the specified secondary DB cluster are being verified before the failover
         * process can start.
         *
         * failing-over  This status covers the range of Aurora internal operations that take place during the failover process, such
         * as demoting the primary Aurora DB cluster, promoting the secondary Aurora DB, and synchronizing replicas.
         *
         * cancelling  The request to fail over the Aurora global database (GlobalCluster) was cancelled and the primary
         * Aurora DB cluster and the selected secondary Aurora DB cluster are returning to their previous states.
         */
        var status: aws.sdk.kotlin.services.rds.model.FailoverStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the Aurora DB cluster that is currently being promoted, and which is associated
         * with this state.
         */
        var toDbClusterArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.rds.model.FailoverState) : this() {
            this.fromDbClusterArn = x.fromDbClusterArn
            this.status = x.status
            this.toDbClusterArn = x.toDbClusterArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.rds.model.FailoverState = FailoverState(this)
    }
}
